var NAVTREE =
[
  [ "Distributed Multihead X", "index.html", [
    [ "Main Page", "index.html", null ],
    [ "Data Structures", "annotated.html", [
      [ "_dmxArg", "struct__dmxArg.html", null ],
      [ "_dmxColormapPriv", "struct__dmxColormapPriv.html", null ],
      [ "_DMXConfigComment", "struct__DMXConfigComment.html", null ],
      [ "_DMXConfigDisplay", "struct__DMXConfigDisplay.html", null ],
      [ "_DMXConfigEntry", "struct__DMXConfigEntry.html", null ],
      [ "_DMXConfigFullDim", "struct__DMXConfigFullDim.html", null ],
      [ "_DMXConfigNumber", "struct__DMXConfigNumber.html", null ],
      [ "_DMXConfigOption", "struct__DMXConfigOption.html", null ],
      [ "_DMXConfigPair", "struct__DMXConfigPair.html", null ],
      [ "_DMXConfigParam", "struct__DMXConfigParam.html", null ],
      [ "_DMXConfigPartDim", "struct__DMXConfigPartDim.html", null ],
      [ "_DMXConfigString", "struct__DMXConfigString.html", null ],
      [ "_DMXConfigSub", "struct__DMXConfigSub.html", null ],
      [ "_DMXConfigToken", "struct__DMXConfigToken.html", null ],
      [ "_DMXConfigVirtual", "struct__DMXConfigVirtual.html", null ],
      [ "_DMXConfigWall", "struct__DMXConfigWall.html", null ],
      [ "_dmxCursorPriv", "struct__dmxCursorPriv.html", null ],
      [ "_DMXEventMap", "struct__DMXEventMap.html", null ],
      [ "_dmxFontPriv", "struct__dmxFontPriv.html", null ],
      [ "_dmxGCPriv", "struct__dmxGCPriv.html", null ],
      [ "_dmxGlyphPriv", "struct__dmxGlyphPriv.html", null ],
      [ "_DMXInputInfo", "struct__DMXInputInfo.html", null ],
      [ "_DMXLocalInitInfo", "struct__DMXLocalInitInfo.html", null ],
      [ "_DMXLocalInputInfo", "struct__DMXLocalInputInfo.html", null ],
      [ "_dmxPictPriv", "struct__dmxPictPriv.html", null ],
      [ "_dmxPixPriv", "struct__dmxPixPriv.html", null ],
      [ "_DMXScreenInfo", "struct__DMXScreenInfo.html", null ],
      [ "_DMXStatAvg", "struct__DMXStatAvg.html", null ],
      [ "_DMXStatInfo", "struct__DMXStatInfo.html", null ],
      [ "_dmxWinPriv", "struct__dmxWinPriv.html", null ],
      [ "_myPrivate", "struct__myPrivate.html", null ],
      [ "DMXConfigCmdStruct", "structDMXConfigCmdStruct.html", null ],
      [ "DMXConfigListStruct", "structDMXConfigListStruct.html", null ],
      [ "DMXDesktopAttributesRec", "structDMXDesktopAttributesRec.html", null ],
      [ "dmxGlxVisualPrivate", "structdmxGlxVisualPrivate.html", null ],
      [ "DMXInputAttributesRec", "structDMXInputAttributesRec.html", null ],
      [ "DMXScreenAttributesRec", "structDMXScreenAttributesRec.html", null ],
      [ "DMXWindowAttributesRec", "structDMXWindowAttributesRec.html", null ],
      [ "stack", "structstack.html", null ]
    ] ],
    [ "Data Structure Index", "classes.html", null ],
    [ "Data Fields", "functions.html", null ],
    [ "File List", "files.html", [
      [ "ChkNotMaskEv.c", "ChkNotMaskEv_8c.html", null ],
      [ "ChkNotMaskEv.h", "ChkNotMaskEv_8h.html", null ],
      [ "dmx-config.h", "dmx-config_8h.html", null ],
      [ "dmx.c", "dmx_8c.html", null ],
      [ "dmx.h", "dmx_8h.html", null ],
      [ "dmx_glxvisuals.c", "dmx__glxvisuals_8c.html", null ],
      [ "dmx_glxvisuals.h", "dmx__glxvisuals_8h.html", null ],
      [ "dmxarg.c", "dmxarg_8c.html", null ],
      [ "dmxarg.h", "dmxarg_8h.html", null ],
      [ "dmxbackend.c", "dmxbackend_8c.html", null ],
      [ "dmxbackend.h", "dmxbackend_8h.html", null ],
      [ "dmxcb.c", "dmxcb_8c.html", null ],
      [ "dmxcb.h", "dmxcb_8h.html", null ],
      [ "dmxclient.h", "dmxclient_8h.html", null ],
      [ "dmxcmap.c", "dmxcmap_8c.html", null ],
      [ "dmxcmap.h", "dmxcmap_8h.html", null ],
      [ "dmxcommon.c", "dmxcommon_8c.html", null ],
      [ "dmxcommon.h", "dmxcommon_8h.html", null ],
      [ "dmxcompat.c", "dmxcompat_8c.html", null ],
      [ "dmxcompat.h", "dmxcompat_8h.html", null ],
      [ "dmxconfig.c", "dmxconfig_8c.html", null ],
      [ "dmxconfig.h", "dmxconfig_8h.html", null ],
      [ "dmxconsole.c", "dmxconsole_8c.html", null ],
      [ "dmxconsole.h", "dmxconsole_8h.html", null ],
      [ "dmxcursor.c", "dmxcursor_8c.html", null ],
      [ "dmxcursor.h", "dmxcursor_8h.html", null ],
      [ "dmxdetach.c", "dmxdetach_8c.html", null ],
      [ "dmxdpms.c", "dmxdpms_8c.html", null ],
      [ "dmxdpms.h", "dmxdpms_8h.html", null ],
      [ "dmxdummy.c", "dmxdummy_8c.html", null ],
      [ "dmxdummy.h", "dmxdummy_8h.html", null ],
      [ "dmxevents.c", "dmxevents_8c.html", null ],
      [ "dmxevents.h", "dmxevents_8h.html", null ],
      [ "dmxextension.c", "dmxextension_8c.html", null ],
      [ "dmxextension.h", "dmxextension_8h.html", null ],
      [ "dmxfont.c", "dmxfont_8c.html", null ],
      [ "dmxfont.h", "dmxfont_8h.html", null ],
      [ "dmxgc.c", "dmxgc_8c.html", null ],
      [ "dmxgc.h", "dmxgc_8h.html", null ],
      [ "dmxgcops.c", "dmxgcops_8c.html", null ],
      [ "dmxgcops.h", "dmxgcops_8h.html", null ],
      [ "dmxinit.c", "dmxinit_8c.html", null ],
      [ "dmxinit.h", "dmxinit_8h.html", null ],
      [ "dmxinput.c", "dmxinput_8c.html", null ],
      [ "dmxinput.h", "dmxinput_8h.html", null ],
      [ "dmxinputinit.c", "dmxinputinit_8c.html", null ],
      [ "dmxinputinit.h", "dmxinputinit_8h.html", null ],
      [ "dmxlog.c", "dmxlog_8c.html", null ],
      [ "dmxlog.h", "dmxlog_8h.html", null ],
      [ "dmxmap.c", "dmxmap_8c.html", null ],
      [ "dmxmap.h", "dmxmap_8h.html", null ],
      [ "dmxmotion.c", "dmxmotion_8c.html", null ],
      [ "dmxmotion.h", "dmxmotion_8h.html", null ],
      [ "dmxparse.c", "dmxparse_8c.html", null ],
      [ "dmxparse.h", "dmxparse_8h.html", null ],
      [ "dmxpict.c", "dmxpict_8c.html", null ],
      [ "dmxpict.h", "dmxpict_8h.html", null ],
      [ "dmxpixmap.c", "dmxpixmap_8c.html", null ],
      [ "dmxpixmap.h", "dmxpixmap_8h.html", null ],
      [ "dmxprint.c", "dmxprint_8c.html", null ],
      [ "dmxprint.h", "dmxprint_8h.html", null ],
      [ "dmxprop.c", "dmxprop_8c.html", null ],
      [ "dmxprop.h", "dmxprop_8h.html", null ],
      [ "dmxscrinit.c", "dmxscrinit_8c.html", null ],
      [ "dmxscrinit.h", "dmxscrinit_8h.html", null ],
      [ "dmxshadow.c", "dmxshadow_8c.html", null ],
      [ "dmxshadow.h", "dmxshadow_8h.html", null ],
      [ "dmxsigio.c", "dmxsigio_8c.html", null ],
      [ "dmxsigio.h", "dmxsigio_8h.html", null ],
      [ "dmxstat.c", "dmxstat_8c.html", null ],
      [ "dmxstat.h", "dmxstat_8h.html", null ],
      [ "dmxsync.c", "dmxsync_8c.html", null ],
      [ "dmxsync.h", "dmxsync_8h.html", null ],
      [ "dmxtodmx.c", "dmxtodmx_8c.html", null ],
      [ "dmxvisual.c", "dmxvisual_8c.html", null ],
      [ "dmxvisual.h", "dmxvisual_8h.html", null ],
      [ "dmxwindow.c", "dmxwindow_8c.html", null ],
      [ "dmxwindow.h", "dmxwindow_8h.html", null ],
      [ "dmxxinput.c", "dmxxinput_8c.html", null ],
      [ "lnx-keyboard.c", "lnx-keyboard_8c.html", null ],
      [ "lnx-keyboard.h", "lnx-keyboard_8h.html", null ],
      [ "lnx-ms.c", "lnx-ms_8c.html", null ],
      [ "lnx-ms.h", "lnx-ms_8h.html", null ],
      [ "lnx-ps2.c", "lnx-ps2_8c.html", null ],
      [ "lnx-ps2.h", "lnx-ps2_8h.html", null ],
      [ "usb-common.c", "usb-common_8c.html", null ],
      [ "usb-common.h", "usb-common_8h.html", null ],
      [ "usb-keyboard.c", "usb-keyboard_8c.html", null ],
      [ "usb-keyboard.h", "usb-keyboard_8h.html", null ],
      [ "usb-mouse.c", "usb-mouse_8c.html", null ],
      [ "usb-mouse.h", "usb-mouse_8h.html", null ],
      [ "usb-other.c", "usb-other_8c.html", null ],
      [ "usb-other.h", "usb-other_8h.html", null ],
      [ "usb-private.h", "usb-private_8h.html", null ],
      [ "vdltodmx.c", "vdltodmx_8c.html", null ],
      [ "xdmxconfig.c", "xdmxconfig_8c.html", null ]
    ] ],
    [ "Globals", "globals.html", null ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

