/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XLookupColor(display, colormap, color_name, exact_def_return, screen_def_return)
 *   Display *display;
 *   Colormap colormap;
 *   char *color_name;
 *   XColor *exact_def_return;
 *   XColor *screen_def_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XLookupColor	1
char    *TestName = "XLookupColor";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XLookupColor function
 */
static Display *display;
static Colormap colormap;
static char *color_name;
static XColor *exact_def_return;
static XColor *screen_def_return;


static int 	StatusReturn;

XColor dummycol;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(display, DefaultScreen(display));
	color_name = "";
	exact_def_return = &dummycol;
	screen_def_return = &dummycol;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo *vp;
Status status;
XColor exactcol, screencol, testcol;
unsigned long vmask;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XLookupColor-1.(A)");
	report_assertion("A call to XLookupColor obtains the exact and closest");
	report_assertion("available RGB values for the colormap argument to those");
	report_assertion("specified for the colour named color_name in the database,");
	report_assertion("and stores the exact values in the red, green and blue");
	report_assertion("components of the XColor structure named by the");
	report_assertion("exact_def_return argument, and stores the closest available");
	report_assertion("values in the red, green and blue components of the XColor");
	report_assertion("structure named by the screen_def_return argument.");

	report_strategy("For each visual class:");
	report_strategy("  Create a colourmap with alloc set to AllocNone.");
	report_strategy("  Lookup the exact and closest supported rgb values ");
	report_strategy("    for colour XT_GOOD_COLORNAME with XLookupColor.");
	report_strategy("  Verify that the function returned non-zero.");
	report_strategy("  Allocate a read/only cell using returned RGB values with XAllocColor ");
	report_strategy("    (which is assumed to return correct RGB values) .");
	report_strategy("  Verify that the RBG values from both calls are identical.");
	report_strategy("    (so XLookupColor previously returned correct RGB values)");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	}

	if( (color_name = tet_getvar("XT_GOOD_COLORNAME")) == (char *) 0) {
		delete("XT_GOOD_COLORNAME is not defined.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		colormap = makecolmap(display, vp->visual, AllocNone);
		exact_def_return = &exactcol;
		screen_def_return = &screencol;
		startcall(display);
		if (isdeleted())
			return;
		status = XLookupColor(display, colormap, color_name, exact_def_return, screen_def_return);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if( status == (Status) 0) {
			report("%s failed to return non-zero.", TestName);
			FAIL;
			continue;
		} else
			CHECK;

		testcol = screencol;
		trace("Screen: r %u g %u b %u", screencol.red, screencol.green, screencol.blue);
		trace("Exact : r %u g %u b %u", exactcol.red, exactcol.green, exactcol.blue);
		trace("Test : r %u g %u b %u", testcol.red, testcol.green, testcol.blue);

		status = XAllocColor(display, colormap, &testcol);
		if(status == (Status) 0) {
			report("XAllocColor() failed to return non-zero.");
			FAIL;
			continue;
		} else
			CHECK;

		trace("Exact : r %u g %u b %u", exactcol.red, exactcol.green, exactcol.blue);

		if((screencol.red != testcol.red) ||
		   (screencol.green != testcol.green) ||
	 	   (screencol.blue != testcol.blue) ) {
			report("%s return RGB values r %u g %u b %u instead of r %u g %u b %u.", TestName,
				screencol.red, screencol.green, screencol.blue,
				testcol.red, testcol.green, testcol.blue);
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(3 * nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
char *cp, *goodname, *casename;
Status status;
XColor screencol, exactcol, alscreencol, alexactcol;
unsigned long vmask;
int i;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XLookupColor-2.(A)");
	report_assertion("Upper and lower case characters in the color_name argument");
	report_assertion("refer to the same colour.");

	report_strategy("For each supported visual type:");
	report_strategy("  Create a colomap with alloc set to AllocNone.");
	report_strategy("  Look up the rgb value of the colour name XT_GOOD_COLORNAME ");
	report_strategy("    in the database with XLookupNamedColor.");
	report_strategy("  Look up the rbg value of the colour name XT_GOOD_COLORNAME, ");
	report_strategy("    with alternating characters in alternating case,");
	report_strategy("    in the colourmap with XAllocNamedColor.");
	report_strategy("  Verify that the function returned non-zero.");
	report_strategy("  Verify that the exact and closest supported rbg values from both calls ");
	report_strategy("    are identical.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	}

	if( ( goodname = tet_getvar("XT_GOOD_COLORNAME")) == (char *) 0) {
		delete("XT_GOOD_COLORNAME is not defined.");
		return;
	}

	casename = (char *) malloc( strlen(goodname) + 1);
	strcpy(casename, goodname);

	for(i=0, cp=casename; *cp; i++, cp++)
		if(i&1)
			*cp = tolower(*cp);
		else
			*cp = toupper(*cp);


	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		colormap = makecolmap(display, vp -> visual, AllocNone);
		color_name = goodname;
		screen_def_return = &screencol;
		exact_def_return = &exactcol;
		startcall(display);
		if (isdeleted())
			return;
		status = XLookupColor(display, colormap, color_name, exact_def_return, screen_def_return);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if( status == (Status) 0) {
			report("%s failed to return non-zero with color %s.", 
				TestName, goodname);
			FAIL;
			continue;
		} else
			CHECK;
			
		color_name = casename;
		trace("Testing colourname %s", color_name);
		screen_def_return = &alscreencol;
		exact_def_return = &alexactcol;
		startcall(display);
		if (isdeleted())
			return;
		status = XLookupColor(display, colormap, color_name, exact_def_return, screen_def_return);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if( status == (Status) 0) {
			report("%s failed to return non-zero with color %s.", 
				TestName, casename);
			FAIL;
			continue;
		} else 
			CHECK;

		if((exactcol.red != alexactcol.red) ||
		   (exactcol.green != alexactcol.green) ||
		   (exactcol.blue != alexactcol.blue)) {
			report("%s for name %s", TestName, casename);
			report("returned exact RGB values r %u g %u b %u",
			  alexactcol.red, alexactcol.green, alexactcol.blue);
			report("%s for name %s", TestName, goodname);
			report("returned exact RGB values r %u g %u b %u",
			  exactcol.red, exactcol.green, exactcol.blue);
			FAIL;
		} else
			CHECK;

		if((screencol.red != alscreencol.red) ||
		   (screencol.green != alscreencol.green) ||
		   (screencol.blue != alscreencol.blue)) {
			report("%s for name %s", TestName, casename);
			report("returned closest RGB values r %u g %u b %u",
			  alscreencol.red, alscreencol.green, alscreencol.blue);
			report("%s for name %s", TestName, goodname);
			report("returned closest RGB values r %u g %u b %u",
			  screencol.red, screencol.green, screencol.blue);
			FAIL;
		} else
			CHECK;
	}

	free(casename);
	CHECKPASS(4 * nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo *vp;
Status status;
char *goodname;
XColor exactcol, screencol;
unsigned long vmask;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XLookupColor-3.(A)");
	report_assertion("When the color_name argument refers to a colour in the");
	report_assertion("colour database, then XLookupColor returns non-zero.");

	report_strategy("For each supported visual class:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Lookup the rgb values for XT_GOOD_COLOR_NAME with XLookupColor.");
	report_strategy("  Verify that the function returned non-zero.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	}

	if( (goodname = tet_getvar("XT_GOOD_COLORNAME")) == (char *) 0) {
		delete("XT_GOOD_COLORNAME is not defined.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		
		colormap = makecolmap(display, vp->visual, AllocNone);
		color_name = goodname;
		exact_def_return = &exactcol;
		screen_def_return = &screencol;
		startcall(display);
		if (isdeleted())
			return;
		status = XLookupColor(display, colormap, color_name, exact_def_return, screen_def_return);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if( status == (Status) 0) {
			report("%s failed to return non-zero with color %s.", 
				TestName, goodname);
			FAIL;
		} else 
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo *vp;
char *badname;
Status status;
XColor exactcol, screencol;
unsigned long vmask;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XLookupColor-4.(A)");
	report_assertion("When the color_name argument does not refer to a colour in");
	report_assertion("the colour database, then XLookupColor returns zero.");

	report_strategy("For each supported visual class:");
	report_strategy("  Create a colormap with XCreateColormap.");
	report_strategy("  Lookup the rgb values for XT_BAD_COLORNAME with XLookupColor.");
	report_strategy("  Verify that the function returned zero.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, 0L)) == 0L) {
		delete("No visuals reported as valid.");
		return;
	}

	if( (badname = tet_getvar("XT_BAD_COLORNAME")) == (char *) 0) {
		delete("XT_BAD_COLORNAME is not defined.");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		
		colormap = makecolmap(display, vp->visual, AllocNone);
		color_name = badname;
		exact_def_return = &exactcol;
		screen_def_return = &screencol;
		startcall(display);
		if (isdeleted())
			return;
		status = XLookupColor(display, colormap, color_name, exact_def_return, screen_def_return);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if( status != (Status) 0) {
			report("%s failed to return zero with color %s.", 
				TestName, badname);
			FAIL;
		} else 
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
