/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_KeymapNotify	1
char    *TestName = "KeymapNotify";



#define	EVENT		KeymapNotify
#define	MASK		KeymapStateMask

int 	tet_thistest;

static void t001(){

int	i;
Display	*display = Dsp;
Winh	*winhs[5];
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion KeymapNotify-1.(A)");
	report_assertion("When a EnterNotify event is generated, then a KeymapNotify");
	report_assertion("event is generated immediately afterwards.");

	report_strategy("Move pointer to known location.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Select for EnterNotify and KeymapNotify events on window hierarchy.");
	report_strategy("Move cursor into hierarchy window.");
	report_strategy("Get events from event queue.");
	report_strategy("Verify that EnterNotify events are delivered.");
	report_strategy("Verify that a KeymapNotify event follows each of these EnterNotify events.");
	report_strategy("Repeat.");

	tpstartup();
#ifdef	OTHERMASK
#undef	OTHERMASK
#endif
#define	OTHERMASK	EnterWindowMask
#ifdef	OTHEREVENT
#undef	OTHEREVENT
#endif
#define	OTHEREVENT	EnterNotify
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Build and create window hierarchy. */
	if (winh(display, 3, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
	/*
	 * Initialize all members to null.  Then check for null members
	 * in main for-loop as a sign of inconsistency between array
	 * size and the initialization of array members below.
	 */
	for (i=0; i<NELEM(winhs); i++)
		winhs[i] = (Winh *) NULL;
	winhs[0] = guardian->firstchild;
	winhs[1] = winhs[0]->nextsibling;
	winhs[2] = winhs[1]->nextsibling;
	winhs[3] = winhs[0]->firstchild->firstchild;
	winhs[4] = winhs[1]->firstchild->firstchild;
/* Select for EnterNotify and KeymapNotify events on window hierarchy. */
	if (winh_selectinput(display, (Winh *) NULL, MASK|OTHERMASK))
		return;
	else
		CHECK;
	for (i=0; i<NELEM(winhs); i++) {
		int	once;
		Winhe	*ptr;

		if (winhs[i] == (Winh *) NULL) {
			delete("Unexpected NULL window hierarchy member");
			return;
		}
		else
			CHECK;
/* Move cursor into hierarchy window. */
		XSync(display, True);
		XWarpPointer(display, None, winhs[i]->window, 0, 0, 0, 0, 2, 2);
		XSync(display, False);
/* Get events from event queue. */
		if (winh_plant((Winh *) NULL, (XEvent *) NULL, NoEventMask, WINH_NOMASK)) {
			/* already deleted */
			report("Could not initialize event data structures");
			return;
		}
		else
			CHECK;
		if (winh_harvest(display, (Winh *) NULL)) {
			report("Could not harvest events");
			return;
		}
		else
			CHECK;
		ptr = winh_qdel;
		if (ptr == (Winhe *) NULL) {
			report("No events received.");
			FAIL;
			continue;
		}
		else
			CHECK;
/* Verify that EnterNotify events are delivered. */
/* Verify that a KeymapNotify event follows each of these EnterNotify events. */
		for (once=1; ptr != (Winhe *) NULL; ptr = ptr->next) {
			if (once) {
				CHECK;
				once = 0;
			}
			if (ptr->event->type != OTHEREVENT) {
				report("Got %s, expected %s",
					eventname(ptr->event->type),
					eventname(OTHEREVENT));
				FAIL;
				break;
			}
			ptr = ptr->next;
			if (ptr == (Winhe *) NULL) {
				report("Missing %s event", EVENT);
				FAIL;
				break;
			}
			if (ptr->event->type != EVENT) {
				report("Got %s, expected %s",
					eventname(ptr->event->type),
					eventname(EVENT));
				FAIL;
				break;
			}
		}
/* Repeat. */
	}
	CHECKPASS(3 + (NELEM(winhs)*5));
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	i;
Display	*display = Dsp;
Winh	*winhs[5];
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion KeymapNotify-2.(A)");
	report_assertion("When a FocusIn event is generated, then a KeymapNotify");
	report_assertion("event is generated immediately afterwards.");

	report_strategy("Move pointer to known location.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Select for FocusIn and KeymapNotify events on window hierarchy.");
	report_strategy("Generate FocusIn event.");
	report_strategy("Get events from event queue.");
	report_strategy("Verify that FocusIn events are delivered.");
	report_strategy("Verify that a KeymapNotify event follows each of these FocusIn events.");
	report_strategy("Repeat.");

	tpstartup();
#ifdef	OTHERMASK
#undef	OTHERMASK
#endif
#define	OTHERMASK	FocusChangeMask
#ifdef	OTHEREVENT
#undef	OTHEREVENT
#endif
#define	OTHEREVENT	FocusIn
#ifdef	IGNOREEVENT
#undef	IGNOREEVENT
#endif
#define	IGNOREEVENT	FocusOut

/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Build and create window hierarchy. */
	if (winh(display, 3, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
	/*
	 * Initialize all members to null.  Then check for null members
	 * in main for-loop as a sign of inconsistency between array
	 * size and the initialization of array members below.
	 */
	for (i=0; i<NELEM(winhs); i++)
		winhs[i] = (Winh *) NULL;
	winhs[0] = guardian->firstchild;
	winhs[1] = winhs[0]->nextsibling;
	winhs[2] = winhs[1]->nextsibling;
	winhs[3] = winhs[0]->firstchild->firstchild;
	winhs[4] = winhs[1]->firstchild->firstchild;
/* Select for FocusIn and KeymapNotify events on window hierarchy. */
	if (winh_selectinput(display, (Winh *) NULL, MASK|OTHERMASK))
		return;
	else
		CHECK;
	for (i=0; i<NELEM(winhs); i++) {
		int	once;
		Winhe	*ptr;

		if (winhs[i] == (Winh *) NULL) {
			delete("Unexpected NULL window hierarchy member");
			return;
		}
		else
			CHECK;
/* Generate FocusIn event. */
		XSync(display, True);
		XSetInputFocus(display, winhs[i]->window, RevertToNone, CurrentTime);
		XSync(display, False);
/* Get events from event queue. */
		if (winh_plant((Winh *) NULL, (XEvent *) NULL, NoEventMask, WINH_NOMASK)) {
			/* already deleted */
			report("Could not initialize event data structures");
			return;
		}
		else
			CHECK;
		if (winh_harvest(display, (Winh *) NULL)) {
			report("Could not harvest events");
			return;
		}
		else
			CHECK;
		ptr = winh_qdel;
		if (ptr == (Winhe *) NULL) {
			report("No events received.");
			FAIL;
			continue;
		}
		else
			CHECK;
/* Verify that FocusIn events are delivered. */
/* Verify that a KeymapNotify event follows each of these FocusIn events. */
		for (once=1; ptr != (Winhe *) NULL; ptr = ptr->next) {
			if (once) {
				CHECK;
				once = 0;
			}
			if (ptr->event->type == IGNOREEVENT)
				continue;
			if (ptr->event->type != OTHEREVENT) {
				report("Got %s, expected %s",
					eventname(ptr->event->type),
					eventname(OTHEREVENT));
				FAIL;
				break;
			}
			ptr = ptr->next;
			if (ptr == (Winhe *) NULL) {
				report("Missing %s event", EVENT);
				FAIL;
				break;
			}
			if (ptr->event->type != EVENT) {
				report("Got %s, expected %s",
					eventname(ptr->event->type),
					eventname(EVENT));
				FAIL;
				break;
			}
		}
/* Repeat. */
	}
	CHECKPASS(3 + (NELEM(winhs)*5));
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display	*display = Dsp;
Display	*client2, *client3;
Winh	*eventw;
int	status;
XEvent	good;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion KeymapNotify-3.(A)");
	report_assertion("When a KeymapNotify event is generated, then all clients");
	report_assertion("having set KeymapStateMask event mask bits on the event");
	report_assertion("window are delivered a KeymapNotify event.");

	report_strategy("Move pointer to known location.");
	report_strategy("Create clients client2 and client3.");
	report_strategy("Build and create window hierarchy.");
	report_strategy("Select for KeymapNotify and EnterNotify events on eventw.");
	report_strategy("Select for KeymapNotify and EnterNotify events on eventw with client2.");
	report_strategy("Select for no events on eventw with client3.");
	report_strategy("Generate KeymapNotify event.");
	report_strategy("Initialize for expected events.");
	report_strategy("Harvest events from each clients event queue.");
	report_strategy("Verify that KeymapNotify event was received.");
	report_strategy("Verify that KeymapNotify event was received by client2.");
	report_strategy("Verify that no event was received by client3.");

	tpstartup();
#ifdef	OTHERMASK
#undef	OTHERMASK
#endif
#define	OTHERMASK	EnterWindowMask
#ifdef	OTHEREVENT
#undef	OTHEREVENT
#endif
#define	OTHEREVENT	EnterNotify

/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Build and create window hierarchy. */
	if (winh(display, 1, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
	eventw = guardian->firstchild;
/* Select for KeymapNotify and EnterNotify events on eventw. */
	/*
	 * necessary so that winh routines know which window
	 * to associate the event with
	 */
	if (winh_selectinput(display, eventw, MASK|OTHERMASK))
		return;
	else
		CHECK;
/* Select for KeymapNotify and EnterNotify events on eventw with client2. */
	/*
	 * necessary so that winh routines know which window
	 * to associate the event with
	 */
	if (winh_selectinput(client2, eventw, MASK|OTHERMASK))
		return;
	else
		CHECK;
/* Select for no events on eventw with client3. */
	if (winh_selectinput(client3, eventw, NoEventMask))
		return;
	else
		CHECK;
/* Generate KeymapNotify event. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XWarpPointer(display, None, eventw->window, 0, 0, 0, 0, 2, 2);
	XSync(display, False);
	XSync(client2, False);
	XSync(client3, False);
/* Initialize for expected events. */
	good.xany.type = EVENT;
	good.xany.window = eventw->window;
	good.xany.display = display;
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK)) {
		/* already deleted */
		report("Could not initialize event data structures (1)");
		return;
	}
	else
		CHECK;
/* Harvest events from each clients event queue. */
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_harvest(client2, (Winh *) NULL)) {
		report("Could not harvest events for client2");
		return;
	}
	else
		CHECK;
	if (winh_harvest(client3, (Winh *) NULL)) {
		report("Could not harvest events for client3");
		return;
	}
	else
		CHECK;
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		report("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
/* Verify that KeymapNotify event was received. */
/* Verify that KeymapNotify event was received by client2. */
/* Verify that no event was received by client3. */
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		report("display: 0x%x, client2: 0x%x, client2: 0x%x",
			display, client2, client3);
		FAIL;
	}
	else
		CHECK;
	
	CHECKPASS(13);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion KeymapNotify-4.(-)");
	report_assertion("When a KeymapNotify event is generated, then clients not");
	report_assertion("having set KeymapStateMask event mask bits on the event");
	report_assertion("window are not delivered a KeymapNotify event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
