/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_FocusOut	1
char    *TestName = "FocusOut";



#define	EVENT		FocusOut
#define	OTHEREVENT	FocusIn
#define	MASK		FocusChangeMask

static	Display	*_display_;
static	int	_detail_;
static	long	_event_mask_;
static	XEvent	good;

static	int
selectinput(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
#ifdef	lint
	winh_free(start);
	winh_free(stop);
	winh_free(previous);
#endif
	return(winh_selectinput(_display_, current, _event_mask_));
}

static	int
plant(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
#ifdef	lint
	winh_free(start);
	winh_free(stop);
	winh_free(previous);
#endif
	good.xany.window = current->window;
	return(winh_plant(current, &good, NoEventMask, WINH_NOMASK));
}

static	Bool	increasing;	/* event sequence increases as we climb */

static	int
checksequence(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
	Winhe	*d;
	int	current_sequence;
	int	status;
	static	int	last_sequence;

#ifdef	lint
	winh_free(start);
	winh_free(stop);
#endif
	/* look for desired event type */
	for (d = current->delivered; d != (Winhe *) NULL; d = d->next) {
		if (d->event->type == good.type) {
			current_sequence = d->sequence;
			break;
		}
	}
	if (d == (Winhe *) NULL) {
		report("%s event not delivered", eventname(good.type));
		delete("Missing event");
		return(-1);
	}
	if (previous == (Winh *) NULL)
		status = 0;	/* first call, no previous sequence value */
	else {
		/* assume sequence numbers are not the same */
		status = (current_sequence < last_sequence);
		if (increasing)
			status = (status ? 0 : 1);
		if (status)
			report("Ordering problem between 0x%x (%d) and 0x%x (%d)",
				current->window, current_sequence,
				previous->window, last_sequence);
	}
	last_sequence = current_sequence;
	return(status);
}

static	int
checkdetail(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
	Winhe	*d;

#ifdef	lint
	winh_free(start);
	winh_free(stop);
	winh_free(previous);
#endif
	/* look for desired event type */
	for (d = current->delivered; d != (Winhe *) NULL; d = d->next)
		if (d->event->type == good.type)
			break;
	if (d == (Winhe *) NULL) {
		report("%s event not delivered to window 0x%x",
			eventname(good.type), current->window);
		delete("Missing event");
		return(-1);
	}
	/* check detail */
	if (_detail_ != d->event->xfocus.detail) {
		report("Expected detail of %d, got %d on window 0x%x",
			_detail_, d->event->xfocus.detail, current->window);
		return(1);
	}
	return(0);
}

int 	tet_thistest;

static void t001(){

Display	*display;
Winh	*winh;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion FocusOut-1.(A)");
	report_assertion("When a FocusOut event is generated by a window unmap, then");
	report_assertion("the FocusOut event is generated after the corresponding");
	report_assertion("UnmapNotify event.");

	report_strategy("Create client.");
	report_strategy("Create window hierarchy.");
	report_strategy("Select for FocusOut and UnmapNotify events on window.");
	report_strategy("Set focus to window.");
	report_strategy("Generate events by unmapping window.");
	report_strategy("Verify that a UnmapNotify event was delivered.");
	report_strategy("Verify that a FocusOut event was delivered.");
	report_strategy("Verify that the FocusOut event was delivered after the UnmapNotify event.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Create window hierarchy. */
	winh = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, (Winhg *) NULL, WINH_NOMASK);
	if (winh == (Winh *) NULL)
		return;
	else
		CHECK;
	if (winh_create(display, (Winh *) NULL, WINH_MAP))
		return;
	else
		CHECK;
/* Select for xname and UnmapNotify events on window. */
	if (winh_selectinput(display, winh, MASK|StructureNotifyMask))
		return;
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	good.xany.window = winh->window;
	if (winh_plant(winh, &good, MASK, WINH_NOMASK)) {
		report("Could not plant %s events", eventname(good.type));
		return;
	}
	else
		CHECK;
	good.type = UnmapNotify;
	if (winh_plant(winh, &good, StructureNotifyMask, WINH_NOMASK)) {
		report("Could not plant %s events", eventname(good.type));
		return;
	}
	else
		CHECK;
/* Set focus to window. */
	XSetInputFocus(display, winh->window, RevertToNone, CurrentTime);
/* Generate events by unmapping window. */
	XSync(display, True);
	XUnmapWindow(display, winh->window);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that a UnmapNotify event was delivered. */
/* Verify that a xname event was delivered. */
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that the xname event was delivered after the UnmapNotify event. */
		status = winh_ordercheck(UnmapNotify, EVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(8);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	i;
Display	*display;
Display	*client2, *client3;
Window	w;
XEvent	event;
XFocusChangeEvent	good;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion FocusOut-2.(A)");
	report_assertion("When a FocusOut event is generated, then all clients having");
	report_assertion("set FocusChangeMask event mask bits on the event window are");
	report_assertion("delivered a FocusOut event.");

	report_strategy("Create client.");
	report_strategy("Create clients client2 and client3.");
	report_strategy("Create window.");
	report_strategy("Select for FocusOut events on window.");
	report_strategy("Select for FocusOut events on window with client2.");
	report_strategy("Select for no events on window with client3.");
	report_strategy("Set focus to window.");
	report_strategy("Generate FocusOut event by changing focus from w to None.");
	report_strategy("Verify that FocusOut event was delivered.");
	report_strategy("Verify members in delivered FocusOut event structure.");
	report_strategy("Verify that FocusOut event was delivered to client2.");
	report_strategy("Verify members in delivered FocusOut event structure.");
	report_strategy("Verify that no events were delivered to client3.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, True);
/* Select for xname events on window. */
	XSelectInput(display, w, MASK);
/* Select for xname events on window with client2. */
	XSelectInput(client2, w, MASK);
/* Select for no events on window with client3. */
	XSelectInput(client3, w, NoEventMask);
/* Set focus to window. */
	XSetInputFocus(display, w, RevertToNone, CurrentTime);
/* Generate xname event by changing focus from w to None. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XSetInputFocus(display, None, RevertToNone, CurrentTime);
	XSync(display, False);
	XSync(client2, False);
	XSync(client3, False);
/* Verify that xname event was delivered. */
	if (XPending(display) < 1) {
		report("Expected %s event not delivered.", eventname(EVENT));
		FAIL;
		return;
	}
	else
		CHECK;
/* Verify members in delivered xname event structure. */
	XNextEvent(display, &event);
	good = event.xfocus;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.mode = NotifyNormal;
	good.detail = NotifyNonlinear;
	if (checkevent((XEvent*)&good, &event)) {
		report("Unexpected event structure member value(s)");
		FAIL;
	}
	else
		CHECK;
	if ((i = XPending(display)) > 0) {
		report("Expected 1 event, got %d", i+1);
		FAIL;
	}
	else
		CHECK;
/* Verify that xname event was delivered to client2. */
	if (XPending(client2) < 1) {
		report("Expected %s event not delivered to client2.", eventname(EVENT));
		FAIL;
		return;
	}
	else
		CHECK;
/* Verify members in delivered xname event structure. */
	XNextEvent(client2, &event);
	good = event.xfocus;
	good.type = EVENT;
	good.send_event = False;
	good.display = client2;
	good.window = w;
	good.mode = NotifyNormal;
	good.detail = NotifyNonlinear;
	if (checkevent((XEvent*)&good, &event)) {
		report("Unexpected event structure member value(s) for client2");
		FAIL;
	}
	else
		CHECK;
	if ((i = XPending(client2)) > 0) {
		report("Expected 1 event, got %d for client2", i+1);
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were delivered to client3. */
	if ((i = XPending(client3)) > 0) {
		report("Expected 0 events, got %d for client3", i);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){


 	report_purpose(3);

	report_assertion("Assertion FocusOut-3.(-)");
	report_assertion("When a FocusOut event is generated, then clients not having");
	report_assertion("set FocusChangeMask event mask bits on the event window are");
	report_assertion("not delivered a FocusOut event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion FocusOut-4.(-)");
	report_assertion("All FocusOut events are delivered before any related");
	report_assertion("FocusIn are delivered.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t005(){

Display	*display;
int	depth = 4;
Winh	*A, *B;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion FocusOut-5.(A)");
	report_assertion("When the input focus moves from window A to window B and");
	report_assertion("window A is an inferior of window B and the pointer is in");
	report_assertion("window P, then a FocusOut event is generated on window A,");
	report_assertion("with detail set to NotifyAncestor and then on each window");
	report_assertion("between window A and window B, exclusive, with detail set to");
	report_assertion("NotifyVirtual.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window B.");
	report_strategy("Set window A to inferior of window B.");
	report_strategy("Set input focus to window A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to B.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to window A with detail set to NotifyAncestor.");
	report_strategy("Verify that event delivered on each window");
	report_strategy("between window A and window B, exclusive,");
	report_strategy("with detail set to NotifyVirtual.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window B. */
	B = guardian->firstchild;
/* Set window A to inferior of window B. */
	A = B->firstchild->firstchild->firstchild;
/* Set input focus to window A. */
	XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_climb(A, B, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(A, B->firstchild, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Generate xname event by changing focus from A to B. */
	XSync(display, True);
	XSetInputFocus(display, B->window, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event(B, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to window A with detail set to NotifyAncestor. */
		_detail_ = NotifyAncestor;
		if (winh_climb(A, A, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that event delivered on each window */
/* between window A and window B, exclusive, */
/* with detail set to NotifyVirtual. */
		_detail_ = NotifyVirtual;
		if (winh_climb(A->parent, B->firstchild, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display	*display;
int	depth = 4;
Winh	*A, *B, *P, *Pancestor;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion FocusOut-6.(A)");
	report_assertion("When the input focus moves from window A to window B and");
	report_assertion("window B is an inferior of window A and the pointer is in");
	report_assertion("window P and window P is an inferior of window A and window");
	report_assertion("P is not an inferior of window B and window P is not an");
	report_assertion("ancestor of window B, then a FocusOut event is generated on");
	report_assertion("each window from window P up to but not including window A,");
	report_assertion("with detail set to NotifyPointer.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window A.");
	report_strategy("Set window B to inferior of window A.");
	report_strategy("Set window P to inferior of sibling of window B.");
	report_strategy("Move pointer to window P.");
	report_strategy("Set input focus to window A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to B.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to each window from window P");
	report_strategy("up to but not including window A,");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify order of FocusOut event delivery.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window A. */
	A = guardian->firstchild;
/* Set window B to inferior of window A. */
	B = A->firstchild;
/* Set window P to inferior of sibling of window B. */
	Pancestor = A->firstchild->nextsibling;
	P = Pancestor->firstchild->firstchild;
/* Move pointer to window P. */
	XWarpPointer(display, None, P->window, 0, 0, 0, 0, 0, 0);
/* Set input focus to window A. */
	XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_climb(P, Pancestor, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	if (winh_climb(B, A->firstchild, selectinput)) {
		report("Could not select for events between B and A");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(P, Pancestor, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Generate xname event by changing focus from A to B. */
	XSync(display, True);
	XSetInputFocus(display, B->window, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to each window from window P */
/* up to but not including window A, */
/* with detail set to NotifyPointer. */
		_detail_ = NotifyPointer;
		if (winh_climb(P, Pancestor, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify order of xname event delivery. */
		increasing = False;
		if (winh_climb(P, Pancestor, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(11);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Display	*display;
int	depth = 4;
Winh	*A, *B, *P, *Pancestor;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion FocusOut-7.(A)");
	report_assertion("When the input focus moves from window A to window B and");
	report_assertion("window B is an inferior of window A and the pointer is in");
	report_assertion("window P, then, after any related FocusOut events are");
	report_assertion("generated with detail set to NotifyPointer, a FocusOut");
	report_assertion("event is generated on window A, with detail set to");
	report_assertion("NotifyInferior.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window A.");
	report_strategy("Set window B to inferior of window A.");
	report_strategy("Set window P to inferior of sibling of window B.");
	report_strategy("Move pointer to window P.");
	report_strategy("Set input focus to window A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to B.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to each window from window P");
	report_strategy("up to but not including window A,");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify that event delivered on window A");
	report_strategy("with detail set to NotifyInferior.");
	report_strategy("Verify order of FocusOut event delivery.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window A. */
	A = guardian->firstchild;
/* Set window B to inferior of window A. */
	B = A->firstchild;
/* Set window P to inferior of sibling of window B. */
	Pancestor = A->firstchild->nextsibling;
	P = Pancestor->firstchild->firstchild;
/* Move pointer to window P. */
	XWarpPointer(display, None, P->window, 0, 0, 0, 0, 0, 0);
/* Set input focus to window A. */
	XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_climb(P, A, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	if (winh_climb(B, A->firstchild, selectinput)) {
		report("Could not select for events between B and A");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(P, A, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Generate xname event by changing focus from A to B. */
	XSync(display, True);
	XSetInputFocus(display, B->window, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to each window from window P */
/* up to but not including window A, */
/* with detail set to NotifyPointer. */
		_detail_ = NotifyPointer;
		if (winh_climb(P, Pancestor, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that event delivered on window A */
/* with detail set to NotifyInferior. */
		_detail_ = NotifyInferior;
		if (winh_climb(A, A, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify order of xname event delivery. */
		increasing = False;
		if (winh_climb(P, A, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(12);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Display	*display;
int	depth = 5;
Winh	*A, *B, *C, *P;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion FocusOut-8.(A)");
	report_assertion("When the input focus moves from window A to window B and");
	report_assertion("window C is their least common ancestor and the pointer is");
	report_assertion("in window P and window P is an inferior of window A, then a");
	report_assertion("FocusOut event is generated on each window from window P up");
	report_assertion("to but not including window A, with detail set to");
	report_assertion("NotifyPointer.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window C.");
	report_strategy("Set window A to inferior of window C.");
	report_strategy("Set window P to inferior of window A.");
	report_strategy("Set window B to inferior of window C.");
	report_strategy("Move pointer to window P.");
	report_strategy("Set input focus to window A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to B.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to windows from window P");
	report_strategy("up to but not including window A,");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify order of FocusOut event delivery.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window C. */
	C = guardian->firstchild;
/* Set window A to inferior of window C. */
	A = C->firstchild;
/* Set window P to inferior of window A. */
	P = A->firstchild->firstchild->firstchild;
/* Set window B to inferior of window C. */
	B = C->firstchild->nextsibling->firstchild;
/* Move pointer to window P. */
	XWarpPointer(display, None, P->window, 0, 0, 0, 0, 0, 0);
/* Set input focus to window A. */
	XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_climb(P, A->firstchild, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	/* This gets us a FocusIn event. */
	if (winh_climb(B, B, selectinput)) {
		report("Could not select for events on B");
		return;
	}
	else
		CHECK;
	if (winh_climb(P, A->firstchild, selectinput)) {
		report("Could not select for events below A to P");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(P, A->firstchild, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Generate xname event by changing focus from A to B. */
	XSync(display, True);
	XSetInputFocus(display, B->window, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to windows from window P */
/* up to but not including window A, */
/* with detail set to NotifyPointer. */
		_detail_ = NotifyPointer;
		if (winh_climb(P, A->firstchild, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify order of xname event delivery. */
		increasing = False;
		if (winh_climb(P, A->firstchild, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(12);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Display	*display;
int	depth = 5;
Winh	*A, *B, *C, *P;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion FocusOut-9.(A)");
	report_assertion("When the input focus moves from window A to window B and");
	report_assertion("window C is their least common ancestor and the pointer is");
	report_assertion("in window P, then, after any related FocusOut events are");
	report_assertion("generated with detail set to NotifyPointer, a FocusOut");
	report_assertion("event is generated on window A, with detail set to");
	report_assertion("NotifyNonlinear and then on each window between window A and");
	report_assertion("window C, exclusive, with detail set to");
	report_assertion("NotifyNonlinearVirtual.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window C.");
	report_strategy("Set window A to inferior of window C.");
	report_strategy("Set window P to inferior of window A.");
	report_strategy("Set window B to inferior of window C.");
	report_strategy("Move pointer to window P.");
	report_strategy("Set input focus to window A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to B.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to windows from window P");
	report_strategy("up to but not including window A,");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify that event delivered to window A");
	report_strategy("with detail set to NotifyNonlinear.");
	report_strategy("Verify that event delivered between window A and window C, exclusive,");
	report_strategy("with detail set to NotifyNonlinearVirtual.");
	report_strategy("Verify order of FocusOut event delivery.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window C. */
	C = guardian->firstchild;
/* Set window A to inferior of window C. */
	A = C->firstchild->firstchild->firstchild;
/* Set window P to inferior of window A. */
	P = A->firstchild;
/* Set window B to inferior of window C. */
	B = C->firstchild->nextsibling->firstchild;
/* Move pointer to window P. */
	XWarpPointer(display, None, P->window, 0, 0, 0, 0, 0, 0);
/* Set input focus to window A. */
	XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_climb(P, A, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	if (winh_climb(A->parent, C->firstchild, selectinput)) {
		report("Could not select for events between A to C");
		return;
	}
	else
		CHECK;
	/* This gets us a FocusIn event. */
	if (winh_climb(B, B, selectinput)) {
		report("Could not select for events on B");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(P, A, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
	if (winh_climb(A->parent, C->firstchild, plant)) {
		report("Could not plant events between A and C");
		return;
	}
	else
		CHECK;
/* Generate xname event by changing focus from A to B. */
	XSync(display, True);
	XSetInputFocus(display, B->window, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to windows from window P */
/* up to but not including window A, */
/* with detail set to NotifyPointer. */
		_detail_ = NotifyPointer;
		if (winh_climb(P, A->firstchild, checkdetail)) {
			report("Incorrect detail from P up to A");
			FAIL;
		}
		else
			CHECK;
/* Verify that event delivered to window A */
/* with detail set to NotifyNonlinear. */
		_detail_ = NotifyNonlinear;
		if (winh_climb(A, A, checkdetail)) {
			report("Incorrect detail for A");
			FAIL;
		}
		else
			CHECK;
/* Verify that event delivered between window A and window C, exclusive, */
/* with detail set to NotifyNonlinearVirtual. */
		_detail_ = NotifyNonlinearVirtual;
		if (winh_climb(A->parent, C->firstchild, checkdetail)) {
			report("Incorrect detail between A and C");
			FAIL;
		}
		else
			CHECK;
/* Verify order of xname event delivery. */
		increasing = False;
		if (winh_climb(P, A, checksequence))
			FAIL;
		else
			CHECK;
		increasing = False;
		if (winh_climb(A, C->firstchild, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(16);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Display	*display;
int	depth = 4;
Winh	*A, *B, *Broot, *P, *Pancestor;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion FocusOut-10.(C)");
	report_assertion("If the implementation supports multiple screens: When the");
	report_assertion("input focus moves from window A to window B and window A and");
	report_assertion("window B are not on the same screens and the pointer is in");
	report_assertion("window P and window P is an inferior of window A, then a");
	report_assertion("FocusOut event is generated on each window from window P up");
	report_assertion("to but not including window A, with detail set to");
	report_assertion("NotifyPointer.");

	report_strategy("Check to see if multiple screens are supported.");
	report_strategy("Create client.");
	report_strategy("Build window hierarchy on all supported screens.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window A.");
	report_strategy("Set window B to an inferior of the root window on a different screen than A.");
	report_strategy("Set window P.");
	report_strategy("Move pointer to window P.");
	report_strategy("Set input focus to window A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to B.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to each window from window P");
	report_strategy("up to but not including window A,");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify order of FocusOut event delivery.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Check to see if multiple screens are supported. */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	}
	else
		CHECK;
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy on all supported screens. */
	if (winh(display, depth, WINH_MAP|WINH_BOTH_SCREENS)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window A. */
	A = guardian->firstchild;
/* Set window B to an inferior of the root window on a different screen than A. */
	Broot = guardian->nextsibling;
	B = Broot->firstchild->firstchild;
/* Set window P. */
	Pancestor = A->firstchild;
	P = Pancestor->firstchild->firstchild;
/* Move pointer to window P. */
	XWarpPointer(display, None, P->window, 0, 0, 0, 0, 0, 0);
/* Set input focus to window A. */
	XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_climb(P, Pancestor, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	if (winh_climb(B, Broot, selectinput)) {
		report("Could not select for events on windows B and above");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(P, Pancestor, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Generate xname event by changing focus from A to B. */
	XSync(display, True);
	XSetInputFocus(display, B->window, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to each window from window P */
/* up to but not including window A, */
/* with detail set to NotifyPointer. */
		_detail_ = NotifyPointer;
		if (winh_climb(P, Pancestor, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify order of xname event delivery. */
		increasing = False;
		if (winh_climb(P, Pancestor, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(12);
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

Display	*display;
int	depth = 4;
Winh	*A, *B, *Broot, *P, *Pancestor;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion FocusOut-11.(C)");
	report_assertion("If the implementation supports multiple screens: When the");
	report_assertion("input focus moves from window A to window B and window A and");
	report_assertion("window B are not on the same screens and the pointer is in");
	report_assertion("window P, then, after any related FocusOut events are");
	report_assertion("generated with detail set to NotifyPointer, a FocusOut");
	report_assertion("event is generated on window A, with detail set to");
	report_assertion("NotifyNonlinear.");

	report_strategy("Check to see if multiple screens are supported.");
	report_strategy("Create client.");
	report_strategy("Build window hierarchy on all supported screens.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window A to a root window.");
	report_strategy("Set window B to an inferior of the root window on a different screen than A.");
	report_strategy("Set window P.");
	report_strategy("Move pointer to window P.");
	report_strategy("Set input focus to window A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to B.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to each window from window P");
	report_strategy("up to but not including window A,");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify that event delivered to window A");
	report_strategy("with detail set to NotifyNonlinear.");
	report_strategy("Verify order of FocusOut event delivery.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Check to see if multiple screens are supported. */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	}
	else
		CHECK;
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy on all supported screens. */
	if (winh(display, depth, WINH_MAP|WINH_BOTH_SCREENS)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window A to a root window. */
	A = guardian;
/* Set window B to an inferior of the root window on a different screen than A. */
	Broot = guardian->nextsibling;
	B = Broot->firstchild->firstchild;
/* Set window P. */
	Pancestor = A->firstchild;
	P = Pancestor->firstchild->firstchild;
/* Move pointer to window P. */
	XWarpPointer(display, None, P->window, 0, 0, 0, 0, 0, 0);
/* Set input focus to window A. */
	XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_climb(P, A, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	if (winh_climb(B, Broot, selectinput)) {
		report("Could not select for events on windows B and above");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(P, A, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Generate xname event by changing focus from A to B. */
	XSync(display, True);
	XSetInputFocus(display, B->window, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to each window from window P */
/* up to but not including window A, */
/* with detail set to NotifyPointer. */
		_detail_ = NotifyPointer;
		if (winh_climb(P, Pancestor, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that event delivered to window A */
/* with detail set to NotifyNonlinear. */
		_detail_ = NotifyNonlinear;
		if (winh_climb(A, A, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify order of xname event delivery. */
		increasing = False;
		if (winh_climb(P, A, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(13);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

Display	*display;
int	depth = 4;
Winh	*A, *Aroot, *B, *Broot;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion FocusOut-12.(C)");
	report_assertion("If the implementation supports multiple screens: When the");
	report_assertion("input focus moves from window A to window B and window A and");
	report_assertion("window B are not on the same screens and the pointer is in");
	report_assertion("window P and window A is not a root window, then, after the");
	report_assertion("related FocusOut event is generated with detail set to");
	report_assertion("NotifyNonlinear, a FocusOut event is generated on each");
	report_assertion("window above window A up to and including its root, with");
	report_assertion("detail set to NotifyNonlinearVirtual.");

	report_strategy("Check to see if multiple screens are supported.");
	report_strategy("Create client.");
	report_strategy("Build window hierarchy on all supported screens.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window A to a non-root window.");
	report_strategy("Set window B to an inferior of the root window on a different screen than A.");
	report_strategy("Move pointer to window B.");
	report_strategy("Set input focus to window A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to B.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to window A");
	report_strategy("with detail set to NotifyNonlinear.");
	report_strategy("Verify that event delivered on each window above window A");
	report_strategy("up to and including its root,");
	report_strategy("with detail set to NotifyNonlinearVirtual.");
	report_strategy("Verify order of FocusOut event delivery.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Check to see if multiple screens are supported. */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	}
	else
		CHECK;
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy on all supported screens. */
	if (winh(display, depth, WINH_MAP|WINH_BOTH_SCREENS)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window A to a non-root window. */
	Aroot = guardian;
	A = Aroot->firstchild->firstchild->firstchild;
/* Set window B to an inferior of the root window on a different screen than A. */
	Broot = guardian->nextsibling;
	B = Broot->firstchild->firstchild;
/* Move pointer to window B. */
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
/* Set input focus to window A. */
	XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_climb(A, Aroot, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	if (winh_climb(B, Broot, selectinput)) {
		report("Could not select for events on windows B and above");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(A, Aroot, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Generate xname event by changing focus from A to B. */
	XSync(display, True);
	XSetInputFocus(display, B->window, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to window A */
/* with detail set to NotifyNonlinear. */
		_detail_ = NotifyNonlinear;
		if (winh_climb(A, A, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that event delivered on each window above window A */
/* up to and including its root, */
/* with detail set to NotifyNonlinearVirtual. */
		_detail_ = NotifyNonlinearVirtual;
		if (winh_climb(A->parent, Aroot, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify order of xname event delivery. */
		increasing = False;
		if (winh_climb(A, Aroot, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(13);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

Display	*display;
int	depth = 4;
Winh	*A, *P, *Pancestor;
int	status;
int	i;
static	Window	focuses[] = {
	(Window) PointerRoot,
	(Window) None
};
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion FocusOut-13.(A)");
	report_assertion("When the focus moves from window A to PointerRoot (events");
	report_assertion("sent to the window under the pointer) or when the focus");
	report_assertion("moves from window A to None (discard) and the pointer is in");
	report_assertion("window P and window P is an inferior of window A, then a");
	report_assertion("FocusOut event is generated on each window from window P up");
	report_assertion("to but not including window A, with detail set to");
	report_assertion("NotifyPointer.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Set window A to a root window.");
	report_strategy("Set P to inferior of A.");
	report_strategy("Move pointer to P.");
	report_strategy("Set input focus to A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to PointerRoot.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered on each window from window P up to");
	report_strategy("but not including window A");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify that these events occurred in the correct order.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");
	report_strategy("Repeat with final focus set to None.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Set window A to a root window. */
	A = guardian;
/* Set P to inferior of A. */
	Pancestor = A->firstchild;
	P = Pancestor->firstchild->firstchild;
/* Move pointer to P. */
	if (warppointer(display, P->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
	for (i = 0; i < NELEM(focuses); i++) {
/* Set input focus to A. */
		XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
		if (winh_selectinput(display, (Winh *) NULL, MASK)) {
			report("Could not select for events");
			return;
		}
		else
			CHECK;
		good.type = EVENT;
		good.xany.display = display;
		/*
		 * Select on A as well because we are selecting for events
		 * on all windows.
		 */
		if (winh_climb(P, A, plant)) {
			report("Could not plant events");
			return;
		}
		else
			CHECK;
/* Generate xname event by changing focus from A to PointerRoot. */
		XSync(display, True);
		XSetInputFocus(display, focuses[i], RevertToNone, CurrentTime);
		XSync(display, False);
		if (winh_harvest(display, (Winh *) NULL)) {
			report("Could not harvest events");
			return;
		}
		else
			CHECK;
/* Verify that the expected events were delivered. */
		if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
			delete("Could not ignore %s events", eventname(OTHEREVENT));
			return;
		}
		else
			CHECK;
		status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
		if (status < 0)
			return;
		else if (status > 0) {
			report("Event delivery was not as expected");
			FAIL;
		}
		else {
/* Verify that event delivered on each window from window P up to */
/* but not including window A */
/* with detail set to NotifyPointer. */
			_detail_ = NotifyPointer;
			if (winh_climb(P, Pancestor, checkdetail))
				FAIL;
			else
				CHECK;
/* Verify that these events occurred in the correct order. */
			increasing = False;
			if (winh_climb(P, Pancestor, checksequence))
				FAIL;
			else
				CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
			status = winh_ordercheck(EVENT, OTHEREVENT);
			if (status == -1)
				return;
			else if (status)
				FAIL;
			else
				CHECK;
		}
/* Repeat with final focus set to None. */
	}
	CHECKPASS(3 + (7*NELEM(focuses)));
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

Display	*display;
int	depth = 4;
Winh	*A, *P, *Pancestor;
int	status;
int	i;
static	Window	focuses[] = {
	(Window) PointerRoot,
	(Window) None
};
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion FocusOut-14.(A)");
	report_assertion("When the focus moves from window A to PointerRoot (events");
	report_assertion("sent to the window under the pointer) or when the focus");
	report_assertion("moves from window A to None (discard) and the pointer is in");
	report_assertion("window P, then, after any related FocusOut events are");
	report_assertion("generated with detail set to NotifyPointer, a FocusOut");
	report_assertion("event is generated on window A, with detail set to");
	report_assertion("NotifyNonlinear.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Set window A to a root window.");
	report_strategy("Set P to inferior of A.");
	report_strategy("Move pointer to P.");
	report_strategy("Set input focus to A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to PointerRoot.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered on each window from window P up to");
	report_strategy("but not including window A");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify that event delivered on window A");
	report_strategy("with detail set to NotifyNonlinear.");
	report_strategy("Verify that these events occurred in the correct order.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");
	report_strategy("Repeat with final focus set to None.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Set window A to a root window. */
	A = guardian;
/* Set P to inferior of A. */
	Pancestor = A->firstchild;
	P = Pancestor->firstchild->firstchild;
/* Move pointer to P. */
	if (warppointer(display, P->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
	for (i = 0; i < NELEM(focuses); i++) {
/* Set input focus to A. */
		XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
		if (winh_selectinput(display, (Winh *) NULL, MASK)) {
			report("Could not select for events");
			return;
		}
		else
			CHECK;
		good.type = EVENT;
		good.xany.display = display;
		/*
		 * Select on A as well because we are selecting for events
		 * on all windows.
		 */
		if (winh_climb(P, A, plant)) {
			report("Could not plant events");
			return;
		}
		else
			CHECK;
/* Generate xname event by changing focus from A to PointerRoot. */
		XSync(display, True);
		XSetInputFocus(display, focuses[i], RevertToNone, CurrentTime);
		XSync(display, False);
		if (winh_harvest(display, (Winh *) NULL)) {
			report("Could not harvest events");
			return;
		}
		else
			CHECK;
/* Verify that the expected events were delivered. */
		if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
			delete("Could not ignore %s events", eventname(OTHEREVENT));
			return;
		}
		else
			CHECK;
		status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
		if (status < 0)
			return;
		else if (status > 0) {
			report("Event delivery was not as expected");
			FAIL;
		}
		else {
/* Verify that event delivered on each window from window P up to */
/* but not including window A */
/* with detail set to NotifyPointer. */
			_detail_ = NotifyPointer;
			if (winh_climb(P, Pancestor, checkdetail))
				FAIL;
			else
				CHECK;
/* Verify that event delivered on window A */
/* with detail set to NotifyNonlinear. */
			_detail_ = NotifyNonlinear;
			if (winh_climb(A, A, checkdetail))
				FAIL;
			else
				CHECK;
/* Verify that these events occurred in the correct order. */
			increasing = False;
			if (winh_climb(P, A, checksequence))
				FAIL;
			else
				CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
			status = winh_ordercheck(EVENT, OTHEREVENT);
			if (status == -1)
				return;
			else if (status)
				FAIL;
			else
				CHECK;
		}
/* Repeat with final focus set to None. */
	}
	CHECKPASS(3 + (8*NELEM(focuses)));
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

Display	*display;
int	depth = 4;
Winh	*A, *Aroot, *P;
int	status;
int	i;
static	Window	focuses[] = {
	(Window) PointerRoot,
	(Window) None
};
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion FocusOut-15.(A)");
	report_assertion("When the focus moves from window A to PointerRoot (events");
	report_assertion("sent to the window under the pointer) or when the focus");
	report_assertion("moves from window A to None (discard) and the pointer is in");
	report_assertion("window P and window A is not a root window, then, after the");
	report_assertion("related FocusOut event is generated with detail set to");
	report_assertion("NotifyNonlinear, a FocusOut event is generated on each");
	report_assertion("window above window A up to and including its root, with");
	report_assertion("detail set to NotifyNonlinearVirtual.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Set window A to a non-root window.");
	report_strategy("Set P to root window.");
	report_strategy("Move pointer to P.");
	report_strategy("Set input focus to A.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from A to PointerRoot.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered on window A");
	report_strategy("with detail set to NotifyNonlinear.");
	report_strategy("Verify that event delivered on each window above window A up to");
	report_strategy("and including its root,");
	report_strategy("with detail set to NotifyNonlinearVirtual.");
	report_strategy("Verify that these events occurred in the correct order.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");
	report_strategy("Repeat with final focus set to None.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Set window A to a non-root window. */
	Aroot = guardian;
	A = Aroot->firstchild->firstchild->firstchild;
/* Set P to root window. */
	P = guardian;
/* Move pointer to P. */
	if (warppointer(display, P->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
	for (i = 0; i < NELEM(focuses); i++) {
/* Set input focus to A. */
		XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
		if (winh_selectinput(display, (Winh *) NULL, MASK)) {
			report("Could not select for events");
			return;
		}
		else
			CHECK;
		good.type = EVENT;
		good.xany.display = display;
		if (winh_climb(A, Aroot, plant)) {
			report("Could not plant events");
			return;
		}
		else
			CHECK;
/* Generate xname event by changing focus from A to PointerRoot. */
		XSync(display, True);
		XSetInputFocus(display, focuses[i], RevertToNone, CurrentTime);
		XSync(display, False);
		if (winh_harvest(display, (Winh *) NULL)) {
			report("Could not harvest events");
			return;
		}
		else
			CHECK;
/* Verify that the expected events were delivered. */
		if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
			delete("Could not ignore %s events", eventname(OTHEREVENT));
			return;
		}
		else
			CHECK;
		status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
		if (status < 0)
			return;
		else if (status > 0) {
			report("Event delivery was not as expected");
			FAIL;
		}
		else {
/* Verify that event delivered on window A */
/* with detail set to NotifyNonlinear. */
			_detail_ = NotifyNonlinear;
			if (winh_climb(A, A, checkdetail))
				FAIL;
			else
				CHECK;
/* Verify that event delivered on each window above window A up to */
/* and including its root, */
/* with detail set to NotifyNonlinearVirtual. */
			_detail_ = NotifyNonlinearVirtual;
			if (winh_climb(A->parent, Aroot, checkdetail))
				FAIL;
			else
				CHECK;
/* Verify that these events occurred in the correct order. */
			increasing = False;
			if (winh_climb(A, Aroot, checksequence))
				FAIL;
			else
				CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
			status = winh_ordercheck(EVENT, OTHEREVENT);
			if (status == -1)
				return;
			else if (status)
				FAIL;
			else
				CHECK;
		}
/* Repeat with final focus set to None. */
	}
	CHECKPASS(3 + (8*NELEM(focuses)));
	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){


 	report_purpose(16);

	report_assertion("Assertion FocusOut-16.(-)");
	report_assertion("When the focus moves from PointerRoot (events sent to the");
	report_assertion("window under the pointer) to window A and the pointer is in");
	report_assertion("window P, then a FocusOut event is generated on each window");
	report_assertion("from window P up to and including window P's root, with");
	report_assertion("detail set to NotifyPointer.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t017(){

Display	*display;
int	depth = 4;
Winh	*A, *P, *Proot, *root;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion FocusOut-17.(A)");
	report_assertion("When the focus moves from PointerRoot (events sent to the");
	report_assertion("window under the pointer) to window A and the pointer is in");
	report_assertion("window P, then, after any related FocusOut events are");
	report_assertion("generated with detail set to NotifyPointer, a FocusOut");
	report_assertion("event is generated on the root window of all screens, with");
	report_assertion("detail set to NotifyPointerRoot.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy on all supported screens.");
	report_strategy("Set window A.");
	report_strategy("Set window P.");
	report_strategy("Move pointer to window P.");
	report_strategy("Set input focus to PointerRoot.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from PointerRoot to A.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to windows above window P");
	report_strategy("up to and including window P's root,");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify that event delivered to the root window of all screens");
	report_strategy("with detail set to NotifyPointerRoot.");
	report_strategy("Verify that these events are delivered after the NotifyPointer events.");
	report_strategy("Verify order of FocusOut event delivery from P to Proot.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy on all supported screens. */
	if (winh(display, depth, WINH_MAP|WINH_BOTH_SCREENS)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Set window A. */
	A = guardian->firstchild->firstchild->firstchild;
/* Set window P. */
	Proot = guardian;
	P = Proot->firstchild->nextsibling->firstchild->firstchild;
/* Move pointer to window P. */
	if (warppointer(display, P->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set input focus to PointerRoot. */
	XSetInputFocus(display, PointerRoot, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_selectinput(display, (Winh *) NULL, MASK)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(P, Proot, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
	/* root window of all screens */
	for (root = guardian; root != (Winh *) NULL; root = root->nextsibling) {
		if (root == guardian)
			CHECK;
		good.xany.window = root->window;
		if (winh_plant(root, &good, MASK, WINH_NOMASK)) {
			report("Could not plant events");
			return;
		}
	}
/* Generate xname event by changing focus from PointerRoot to A. */
	XSync(display, True);
	XSetInputFocus(display, A->window, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
		Winhe	*winhe;

/* Verify that event delivered to windows above window P */
/* up to and including window P's root, */
/* with detail set to NotifyPointer. */
		_detail_ = NotifyPointer;
		if (winh_climb(P, Proot, checkdetail)) {
			report("Incorrect detail from P up to P's root");
			FAIL;
		}
		else
			CHECK;
		/*
		 * Determine sequence number of first FocusOut event
		 * delivered to Proot.
		 */
		for (winhe = Proot->delivered; winhe != (Winhe *) NULL; winhe = winhe->next) {

			if (winhe == Proot->delivered)
				CHECK;
			if (winhe->event->type == EVENT)
				break;
		}
/* Verify that event delivered to the root window of all screens */
/* with detail set to NotifyPointerRoot. */
/* Verify that these events are delivered after the NotifyPointer events. */
		_detail_ = NotifyPointerRoot;
		for (root = guardian; root != (Winh *) NULL; root = root->nextsibling) {
			Winhe	*ptr;

			if (root == guardian)
				CHECK;
			/*
			 * skip to first FocusOut-type event
			 */
			for (ptr = root->delivered; ptr != (Winhe *) NULL; ptr = ptr->next) {
				if (ptr->event->type == EVENT) {
					static	int	first = 1;

					/*
					 * The first FocusOut event on Proot is
					 * already claimed.
					 */
					if (root == Proot && first) {
						first = 0;
						continue;
					}
					else
						break;
				}
			}
			if (ptr == (Winhe *) NULL) {
				delete("Lost %s event in delivered list",
					eventname(EVENT));
				return;
			}
			if (ptr->event->xfocus.detail != _detail_) {
				report("Got detail %d, expected %d on window 0x%x",
					ptr->event->xfocus.detail,
					_detail_, root->window);
				FAIL;
				continue;
			}
			if (ptr->sequence < winhe->sequence) {
				report("Got NotifyPointerRoot-type event on 0x%x prior to all NotifyPointer events", root->window);
				FAIL;
			}
		}
/* Verify order of xname event delivery from P to Proot. */
		increasing = False;
		if (winh_climb(P, Proot, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(13);
	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

Display	*display;
int	depth = 4;
Winh	*P, *Proot, *root;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion FocusOut-18.(A)");
	report_assertion("When the focus moves from None (discard) to window A and");
	report_assertion("the pointer is in window P, then a FocusOut event is");
	report_assertion("generated on the root window of all screens, with detail set");
	report_assertion("to NotifyDetailNone.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy on all supported screens.");
	report_strategy("Set window P.");
	report_strategy("Move pointer to window P.");
	report_strategy("Set input focus to PointerRoot.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from PointerRoot to None.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to windows above window P");
	report_strategy("up to and including window P's root,");
	report_strategy("with detail set to NotifyPointer.");
	report_strategy("Verify that event delivered to the root window of all screens");
	report_strategy("with detail set to NotifyPointerRoot.");
	report_strategy("Verify that these events are delivered after the NotifyPointer events.");
	report_strategy("Verify order of FocusOut event delivery from P to Proot.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy on all supported screens. */
	if (winh(display, depth, WINH_MAP|WINH_BOTH_SCREENS)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Set window P. */
	Proot = guardian;
	P = Proot->firstchild->nextsibling->firstchild->firstchild;
/* Move pointer to window P. */
	if (warppointer(display, P->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set input focus to PointerRoot. */
	XSetInputFocus(display, PointerRoot, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_selectinput(display, (Winh *) NULL, MASK)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(P, Proot, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
	/* root window of all screens */
	for (root = guardian; root != (Winh *) NULL; root = root->nextsibling) {
		if (root == guardian)
			CHECK;
		good.xany.window = root->window;
		if (winh_plant(root, &good, MASK, WINH_NOMASK)) {
			report("Could not plant events");
			return;
		}
	}
/* Generate xname event by changing focus from PointerRoot to None. */
	XSync(display, True);
	XSetInputFocus(display, None, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
		Winhe	*winhe;

/* Verify that event delivered to windows above window P */
/* up to and including window P's root, */
/* with detail set to NotifyPointer. */
		_detail_ = NotifyPointer;
		if (winh_climb(P, Proot, checkdetail)) {
			report("Incorrect detail from P up to P's root");
			FAIL;
		}
		else
			CHECK;
		/*
		 * Determine sequence number of first FocusOut event
		 * delivered to Proot.
		 */
		for (winhe = Proot->delivered; winhe != (Winhe *) NULL; winhe = winhe->next) {

			if (winhe == Proot->delivered)
				CHECK;
			if (winhe->event->type == EVENT)
				break;
		}
/* Verify that event delivered to the root window of all screens */
/* with detail set to NotifyPointerRoot. */
/* Verify that these events are delivered after the NotifyPointer events. */
		_detail_ = NotifyPointerRoot;
		for (root = guardian; root != (Winh *) NULL; root = root->nextsibling) {
			Winhe	*ptr;

			if (root == guardian)
				CHECK;
			/*
			 * skip to first FocusOut-type event
			 */
			for (ptr = root->delivered; ptr != (Winhe *) NULL; ptr = ptr->next) {
				if (ptr->event->type == EVENT) {
					static	int	first = 1;

					/*
					 * The first FocusOut event on Proot is
					 * already claimed.
					 */
					if (root == Proot && first) {
						first = 0;
						continue;
					}
					else
						break;
				}
			}
			if (ptr == (Winhe *) NULL) {
				delete("Lost %s event in delivered list",
					eventname(EVENT));
				return;
			}
			if (ptr->event->xfocus.detail != _detail_) {
				report("Got detail %d, expected %d on window 0x%x",
					ptr->event->xfocus.detail,
					_detail_, root->window);
				FAIL;
				continue;
			}
			if (ptr->sequence < winhe->sequence) {
				report("Got NotifyPointerRoot-type event on 0x%x prior to all NotifyPointer events", root->window);
				FAIL;
			}
		}
/* Verify order of xname event delivery from P to Proot. */
		increasing = False;
		if (winh_climb(P, Proot, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(13);
	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

Display	*display;
int	depth = 1;
Winh	*root;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion FocusOut-19.(A)");
	report_assertion("When the focus moves from None to PointerRoot and the");
	report_assertion("pointer is in window P, then a FocusOut event is generated");
	report_assertion("on the root window of all screens, with detail set to");
	report_assertion("NotifyDetailNone.");

	report_strategy("Create client.");
	report_strategy("Build window hierarchy on all supported screens.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set input focus to None.");
	report_strategy("Select for Focus events on windows.");
	report_strategy("Generate FocusOut event by changing focus from None to PointerRoot.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to the root window of all screens");
	report_strategy("with detail set to NotifyDetailNone.");
	report_strategy("Verify that all FocusOut events are delivered before all");
	report_strategy("FocusIn events.");

	tpstartup();
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy on all supported screens. */
	if (winh(display, depth, WINH_MAP|WINH_BOTH_SCREENS)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set input focus to None. */
	XSetInputFocus(display, None, RevertToNone, CurrentTime);
/* Select for Focus events on windows. */
	_event_mask_ = MASK;
	_display_ = display;
	if (winh_selectinput(display, (Winh *) NULL, MASK)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	/* root window of all screens */
	for (root = guardian; root != (Winh *) NULL; root = root->nextsibling) {
		if (root == guardian)
			CHECK;
		good.xany.window = root->window;
		if (winh_plant(root, &good, MASK, WINH_NOMASK)) {
			report("Could not plant events");
			return;
		}
	}
/* Generate xname event by changing focus from None to PointerRoot. */
	XSync(display, True);
	XSetInputFocus(display, PointerRoot, RevertToNone, CurrentTime);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to the root window of all screens */
/* with detail set to NotifyDetailNone. */
		_detail_ = NotifyDetailNone;
		for (root = guardian; root != (Winh *) NULL; root = root->nextsibling) {
			Winhe	*ptr;

			if (root == guardian)
				CHECK;
			/*
			 * skip to first FocusOut-type event
			 */
			for (ptr = root->delivered; ptr != (Winhe *) NULL; ptr = ptr->next) {
				if (ptr->event->type == EVENT)
						break;
			}
			if (ptr == (Winhe *) NULL) {
				delete("Lost %s event in delivered list",
					eventname(EVENT));
				return;
			}
			if (ptr->event->xfocus.detail != _detail_) {
				report("Got detail %d, expected %d on window 0x%x",
					ptr->event->xfocus.detail,
					_detail_, root->window);
				FAIL;
				continue;
			}
		}
/* Verify that all xname events are delivered before all */
/* FocusIn events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(9);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = focusstartup;
void	(*tet_cleanup)() = focuscleanup;
