/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>
#include <X11/ShellP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;
ShellWidget menuw;

void cpcp(w)
Widget w;
{
	avs_set_event(2,1);
}

/*timeout callback*/
void XtTI1_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	tet_infoline("TEST: Shell is popped-up");
	if (menuw->shell.popped_up == False) {
		tet_infoline("ERROR: Shell is not popped up");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: spring_loaded is False");
	if (menuw->shell.spring_loaded != False) {
		tet_infoline("ERROR: spring_loaded is not False");
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Grab is none");
	if (menuw->shell.grab_kind != XtGrabNone) {
		sprintf(ebuf, "ERROR: Expected XtGrabNone(%d), grab type = %d", XtGrabNone, menuw->shell.grab_kind);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}
void XtCB1_Proc(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	tet_infoline("TEST: Call_data points to XtGrabNone");
	if (*(int *)call_data != XtGrabNone) {
		sprintf(ebuf, "ERROR: expected call_data to point to value of %d, points to %d", XtGrabNone, *(int *)call_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	avs_set_event(1,1);
}


#define T_XtCallbackNone	1
char    *TestName = "XtCallbackNone";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
int status;
Widget labelw_good;
Widget pushb_good, rowcolw_good;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCallbackNone-1.(A)");
	report_assertion("A successful invocation of void XtCallbackNone(w,");
	report_assertion("client_data, call_data) shall map the window of the pop-up");
	report_assertion("shell widget client_data.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalbknon1", "XtCallbackNone");
	tet_infoline("PREP: Create labelw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create a popup shell");
	menuw = (ShellWidget)XtCreatePopupShell("menuw", overrideShellWidgetClass, labelw_good, NULL, 0);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget( "ApTest", rowcolw_good);
	tet_infoline("PREP: Register callback function XtCallbackNone");
	XtAddCallback(labelw_good, XtNdestroyCallback, XtCallbackNone, menuw);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTI1_Proc, topLevel);
	tet_infoline("PREP: Invoke callback function XtCallbackNone().");
	XtCallCallbacks(labelw_good, XtNdestroyCallback, (XtPointer)NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11221 */
/* End of included file Mdefcode.tmc.11221 */

static void t002(){

Widget labelw_good;
Widget pushb_good, rowcolw_good;
XtCallbackStatus status;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCallbackNone-2.(A)");
	report_assertion("A successful invocation of void XtCallbackNone(w,");
	report_assertion("client_data, call_data) shall make the widget w insensitive.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	avs_xt_hier("Tcalbknon2", "XtCallbackNone");
	tet_infoline("PREP: Create labelw_good widget");
	labelw_good = (Widget) CreateLabelWidget("ApTest", boxw1);
	tet_infoline("PREP: Create a popup shell");
	menuw = (ShellWidget)XtCreatePopupShell("menuw",
			 overrideShellWidgetClass,
			 labelw_good, NULL, 0);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget(
				"Hello",
				rowcolw_good);
	tet_infoline("PREP: Register XtCallbackNone");
	XtAddCallback(labelw_good,
			XtNdestroyCallback,
			XtCallbackNone,
			menuw
			);
	tet_infoline("PREP: Invoke XtCallbackNone().");
	XtCallCallbacks(labelw_good, XtNdestroyCallback, (XtPointer) NULL );
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Labelw_good widget is insensitive.");
	status = XtIsSensitive(labelw_good);
	check_dec(False, status, "XtIsSensitive return value");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11221 */
/* End of included file Mdefcode.tmc.11221 */

static void t003(){


 	report_purpose(3);

	report_assertion("Assertion XtCallbackNone-3.(-)");
	report_assertion("A successful invocation of void XtCallbackNone(w,");
	report_assertion("client_data, call_data) shall make the widget client_data a");
	report_assertion("modeless pop-up.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t004(){

pid_t pid2;
int status;
Widget labelw_good;
Widget pushb_good, rowcolw_good;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtCallbackNone-4.(A)");
	report_assertion("A successful invocation of void XtCallbackNone(w,");
	report_assertion("client_data, call_data) shall call the callback procedures");
	report_assertion("on the popup_callback list of the widget client_data passing");
	report_assertion("to them a pointer to grab_kind as the call_data argument.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalbknon1", "XtCallbackNone");
	tet_infoline("PREP: Create labelw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create a popup shell");
	menuw = (ShellWidget)XtCreatePopupShell("menuw", overrideShellWidgetClass, labelw_good, NULL, 0);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget( "ApTest", rowcolw_good);
	tet_infoline("PREP: Register callback function XtCallbackNone");
	XtAddCallback(labelw_good, XtNdestroyCallback, XtCallbackNone, menuw);
	tet_infoline("PREP: Add callback to shell for popup");
	XtAddCallback((Widget)menuw, XtNpopupCallback, XtCB1_Proc, NULL);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTI1_Proc, topLevel);
	tet_infoline("PREP: Invoke callback function XtCallbackNone().");
	XtCallCallbacks(labelw_good, XtNdestroyCallback, (XtPointer)NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: Callback is called");
	status = avs_get_event(1);
	check_dec(1, status, "count of invokations of callback");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11221 */
/* End of included file Mdefcode.tmc.11221 */

static void t005(){

pid_t pid2;
int status;
Widget labelw_good;
Widget pushb_good, rowcolw_good;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtCallbackNone-5.(A)");
	report_assertion("A successful invocation of void XtCallbackNone(w,");
	report_assertion("client_data, call_data) shall set the popped_up field in the");
	report_assertion("widget instance structure of client_data to True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalbknon1", "XtCallbackNone");
	tet_infoline("PREP: Create labelw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create a popup shell");
	menuw = (ShellWidget)XtCreatePopupShell("menuw", overrideShellWidgetClass, labelw_good, NULL, 0);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget( "ApTest", rowcolw_good);
	tet_infoline("PREP: Register callback function XtCallbackNone");
	XtAddCallback(labelw_good, XtNdestroyCallback, XtCallbackNone, menuw);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTI1_Proc, topLevel);
	tet_infoline("PREP: Invoke callback function XtCallbackNone().");
	XtCallCallbacks(labelw_good, XtNdestroyCallback, (XtPointer)NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11221 */
/* End of included file Mdefcode.tmc.11221 */

static void t006(){

pid_t pid2;
int status;
Widget labelw_good;
Widget pushb_good, rowcolw_good;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtCallbackNone-6.(A)");
	report_assertion("A successful invocation of void XtCallbackNone(w,");
	report_assertion("client_data, call_data) shall set the spring_loaded field in");
	report_assertion("the widget instance structure of client_data to False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalbknon1", "XtCallbackNone");
	tet_infoline("PREP: Create labelw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create a popup shell");
	menuw = (ShellWidget)XtCreatePopupShell("menuw", overrideShellWidgetClass, labelw_good, NULL, 0);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget( "ApTest", rowcolw_good);
	tet_infoline("PREP: Register callback function XtCallbackNone");
	XtAddCallback(labelw_good, XtNdestroyCallback, XtCallbackNone, menuw);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTI1_Proc, topLevel);
	tet_infoline("PREP: Invoke callback function XtCallbackNone().");
	XtCallCallbacks(labelw_good, XtNdestroyCallback, (XtPointer)NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11221 */
/* End of included file Mdefcode.tmc.11221 */

static void t007(){

pid_t pid2;
int status;
Widget labelw_good;
Widget pushb_good, rowcolw_good;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtCallbackNone-7.(A)");
	report_assertion("A successful invocation of void XtCallbackNone(w,");
	report_assertion("client_data, call_data) shall set the grab_kind field in the");
	report_assertion("widget instance structure of client_data to XtGrabNone.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalbknon1", "XtCallbackNone");
	tet_infoline("PREP: Create labelw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create a popup shell");
	menuw = (ShellWidget)XtCreatePopupShell("menuw", overrideShellWidgetClass, labelw_good, NULL, 0);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget( "ApTest", rowcolw_good);
	tet_infoline("PREP: Register callback function XtCallbackNone");
	XtAddCallback(labelw_good, XtNdestroyCallback, XtCallbackNone, menuw);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTI1_Proc, topLevel);
	tet_infoline("PREP: Invoke callback function XtCallbackNone().");
	XtCallCallbacks(labelw_good, XtNdestroyCallback, (XtPointer)NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11221 */
/* End of included file Mdefcode.tmc.11221 */

static void t008(){

pid_t pid2;
int status;
Widget labelw_good;
Widget pushb_good, rowcolw_good;
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtCallbackNone-8.(A)");
	report_assertion("A successful invocation of void XtCallbackNone(w,");
	report_assertion("client_data, call_data) when the create_popup_child_proc");
	report_assertion("field in the widget instance structure of client_data is");
	report_assertion("non-NULL shall call the procedure specified by that field.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tcalbknon1", "XtCallbackNone");
	tet_infoline("PREP: Create labelw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello", boxw1);
	tet_infoline("PREP: Create a popup shell");
	menuw = (ShellWidget)XtCreatePopupShell("menuw", overrideShellWidgetClass, labelw_good, NULL, 0);
	tet_infoline("PREP: Create a rowcolw_good widget");
	rowcolw_good = (Widget) CreateRowColWidget((Widget)menuw);
	tet_infoline("PREP: Create pushb_good button in rowcolw_good widget");
	pushb_good = (Widget) CreatePushButtonGadget( "ApTest", rowcolw_good);
	tet_infoline("PREP: Register callback function XtCallbackNone");
	XtAddCallback(labelw_good, XtNdestroyCallback, XtCallbackNone, menuw);
	tet_infoline("PREP: Register timeout");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTI1_Proc, topLevel);
	tet_infoline("PREP: Set create_popup_child_proc procedure");
	menuw->shell.create_popup_child_proc = cpcp;
	tet_infoline("PREP: Invoke callback function XtCallbackNone().");
	XtCallCallbacks(labelw_good, XtNdestroyCallback, (XtPointer)NULL);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	tet_infoline("TEST: Procedure is called");
	status = avs_get_event(2);
	check_dec(1, status, "count of invokations of procedure");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11221 */
/* End of included file Mdefcode.tmc.11221 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
