/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   KeySym
 *   XtGetKeysymTable()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtGetKeysymTable	1
char    *TestName = "XtGetKeysymTable";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display;
KeyCode min_keycode_return;
KeySym *keysym_return, *keysym_good;
int keysyms_per_keycode_return;
int keysyms_per_keycode_good;
int min_keycode, max_keycode;
int i , key_count;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtGetKeysymTable-1.(A)");
	report_assertion("A successful call to KeySym *XtGetKeysymTable(display,");
	report_assertion("min_keycode_return, keysyms_per_keycode_return) shall return");
	report_assertion("a pointer to the KeySym-to-KeyCode mapping table for the");
	report_assertion("display display.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtkytbl1", "XtGetKeysymTable");
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get range of legal keycode for a server");
	XDisplayKeycodes(display, &min_keycode, &max_keycode);
	tet_infoline("PREP: Get KeySym table");
	keysym_return = XtGetKeysymTable(display, &min_keycode_return,
			 &keysyms_per_keycode_return);
	tet_infoline("PREP: Get keyboard mapping");
	key_count = max_keycode - min_keycode - 2;
	keysym_good = XGetKeyboardMapping(display, min_keycode,
			 key_count,
			 (int *)&keysyms_per_keycode_good);
	tet_infoline("TEST: Keysym values");
	for (i = min_keycode; i <= max_keycode; i++ )
		check_dec(keysym_good[i], keysym_return[i], "keysym");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11900 */
/* End of included file Mdefcode.tmc.11900 */

static void t002(){

Display *display;
KeyCode min_keycode_return;
KeySym *keysym_return, *keysym_good;
int keysyms_per_keycode_return;
int keysyms_per_keycode_good;
int min_keycode, max_keycode;
int i , key_count;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtGetKeysymTable-2.(A)");
	report_assertion("A successful call to KeySym *XtGetKeysymTable(display,");
	report_assertion("min_keycode_return, keysyms_per_keycode_return) shall return");
	report_assertion("the minimum KeyCode valid for the specified display in");
	report_assertion("min_keycode_return.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtkytbl1", "XtGetKeysymTable");
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get range of legal keycode for a server");
	XDisplayKeycodes(display, &min_keycode, &max_keycode);
	tet_infoline("PREP: Get KeySym table");
	keysym_return = XtGetKeysymTable(display, &min_keycode_return,
			 &keysyms_per_keycode_return);
	tet_infoline("TEST: min_keycode_return");
	check_dec(min_keycode, min_keycode_return, "min_keycode_return");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11900 */
/* End of included file Mdefcode.tmc.11900 */

static void t003(){

Display *display;
KeyCode min_keycode_return;
KeySym *keysym_return, *keysym_good;
int keysyms_per_keycode_return;
int keysyms_per_keycode_good;
int min_keycode, max_keycode;
int i , key_count;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtGetKeysymTable-3.(A)");
	report_assertion("A successful call to KeySym *XtGetKeysymTable(display,");
	report_assertion("min_keycode_return, keysyms_per_keycode_return) shall return");
	report_assertion("the number of KeySyms stored for each KeyCode in the");
	report_assertion("KeySym-to-KeyCode table for the specified display in");
	report_assertion("keysyms_per_keycode_return.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tgtkytbl1", "XtGetKeysymTable");
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get range of legal keycode for a server");
	XDisplayKeycodes(display, &min_keycode, &max_keycode);
	tet_infoline("PREP: Get KeySym table");
	keysym_return = XtGetKeysymTable(display, &min_keycode_return,
			 &keysyms_per_keycode_return);
	tet_infoline("PREP: Get keyboard mapping");
	key_count = max_keycode - min_keycode - 2;
	keysym_good = XGetKeyboardMapping(display, min_keycode,
			 key_count,
			 (int *)&keysyms_per_keycode_good);
	tet_infoline("TEST: keysyms_per_keycode_return");
	check_dec(keysyms_per_keycode_good, keysyms_per_keycode_return,
			"keysyms_per_keycode_return");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11900 */
/* End of included file Mdefcode.tmc.11900 */

static void t004(){

Display *display;
KeyCode min_keycode_return;
KeySym *keysym_return, *keysym_good;
int keysyms_per_keycode_return;
int keysyms_per_keycode_good;
int min_keycode, max_keycode;
int i , key_count;
pid_t pid2;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtGetKeysymTable-4.(A)");
	report_assertion("On a call to KeySym *XtGetKeysymTable(display,");
	report_assertion("min_keycode_return, keysyms_per_keycode_return) the");
	report_assertion("KeySym-to-KeyCode table returned shall contain the value");
	report_assertion("NoSymbol for those KeyCodes that have no associated KeySyms.");
	FORK(pid);
	initconfig();

/*we can't control the table so the best that can be done is to compare what
Xlib returns to what Xt returns*/
	FORK(pid2);
	avs_xt_hier("Tgtkytbl1", "XtGetKeysymTable");
	tet_infoline("PREP: Get display");
	display = XtDisplay(topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Get range of legal keycode for a server");
	XDisplayKeycodes(display, &min_keycode, &max_keycode);
	tet_infoline("PREP: Get KeySym table");
	keysym_return = XtGetKeysymTable(display, &min_keycode_return,
			 &keysyms_per_keycode_return);
	tet_infoline("PREP: Get keyboard mapping");
	key_count = max_keycode - min_keycode - 2;
	keysym_good = XGetKeyboardMapping(display, min_keycode,
			 key_count,
			 (int *)&keysyms_per_keycode_good);
	tet_infoline("TEST: Values set to NoSymbol where no associated keysym");
	for (i = min_keycode; i <= max_keycode; i++ ) {
		if (keysym_good[i] == NoSymbol) {
			if (keysym_return[i] != NoSymbol) {
				sprintf(ebuf, "ERROR: min_keycode + %d should be NoSymbol, is %ld", (long)keysym_return[i]);
				tet_infoline(ebuf);
				tet_result(TET_FAIL);
			}
		}
	}
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.11900 */
/* End of included file Mdefcode.tmc.11900 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
