/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtCallConverter()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

/*conversion results go here*/
unsigned char tochar;

XtAppContext app_ctext, app_ctext2;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

pid_t pid2;
Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
Boolean status;
char fromdata[128];
void init_args()
{
pid_t	thepid;

	display_good = XtDisplay(topLevel);
	strcpy(fromdata, "Hello");
	thepid = getpid();
	sprintf(&fromdata[strlen(fromdata)], "%d", thepid);
	from.addr = (XPointer) fromdata;
	from.size = strlen(from.addr) + 1;
	to_in_out.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer)&tochar;
	tochar = 0;
	invoked = 0;
}

#ifndef XavsRChar
#define XavsRChar "Char"
#endif
Boolean XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XPointer) &i;
	i = *str;
	avs_set_event(1, avs_get_event(1)+1);
	return True;
}
#define XavsRUnknown "UnknownRes"
Boolean XtCVT2_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	avs_set_event(1, avs_get_event(1)+1);
	/* Force false value as if conversion failed */
	return (False);
}
Boolean XtCVT3_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{

	return (XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT4_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	return (XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT1a_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	return (XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT2a_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	return (XtCVT2_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT3a_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{

	return (XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT4a_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	return (XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT1b_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	return (XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT2b_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	return (XtCVT2_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT3b_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{

	return (XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT4b_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	return (XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}
Boolean XtCVT1c_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	return (XtCVT1_StringToChar(display, args, num_args, from_val, to_val, converter_data));
}


#define T_XtCallConverter	1
char    *TestName = "XtCallConverter";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCallConverter-1.(A)");
	report_assertion("When the converter converter has been registered with the");
	report_assertion("conversion cache type specified as XtCacheNone a call to");
	report_assertion("Boolean XtCallConverter(display, converter, conversion_args,");
	report_assertion("num_args, from, to_in_out, cache_ref_return) shall call the");
	report_assertion("converter, store the converted value returned into the");
	report_assertion("location specified by to_in_out->addr, and return what the");
	report_assertion("converter returns.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr13", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register resource converter XtCVT1c_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT1c_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheNone|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Invoke resource converter XtCVT1c_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT1c_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT1c_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT1c_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	tet_infoline("TEST: Re-Invoke resource converter with same values");
	display_good = XtDisplay(topLevel);
	init_args();
	status = XtCallConverter(display_good,
		XtCVT1c_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT1c_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(2, invoked, "XtCVT1c_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCallConverter-2.(A)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("conversion cache type specified as XtCacheAll and the");
	report_assertion("converter has not been previously called with the specified");
	report_assertion("arguments a call to Boolean XtCallConverter(display,");
	report_assertion("converter, args, num_args, from, to_in_out,");
	report_assertion("cache_ref_return) shall call the converter, enter the result");
	report_assertion("into the conversion cache, store the converted value into");
	report_assertion("the location specified by to_in_out->addr, and return what");
	report_assertion("the converter returns.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr1", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register resource converter XtCVT1_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT1_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Invoke resource converter XtCVT1_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT1_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT1_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT1_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	tet_infoline("TEST: Re-Invoke resource converter with same values");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT1_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT1_StringToChar was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT1_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtCallConverter-3.(A)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("conversion cache type specified as XtCacheAll, the converter");
	report_assertion("has been previously called with the specified arguments, and");
	report_assertion("the conversion failed a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall return False immediately.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr2", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT2_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRUnknown,
		 XtCVT2_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Invoke resource converter XtCVT2_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT2_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value was false");
	check_dec(False, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT2_StringToChar invoked count");
	tet_infoline("TEST: Re-Invoke resource converter with same values");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT2_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value was false");
	check_dec(False, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT2_StringToChar invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtCallConverter-4.(A)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("conversion cache type specified as XtCacheAll, the converter");
	report_assertion("has been previously called with the specified arguments, the");
	report_assertion("conversion succeeded, and the size specified by the");
	report_assertion("to_in_out argument is greater than or equal to the size");
	report_assertion("stored in the conversion cache a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall copy the information");
	report_assertion("stored in the conversion cache into the location specified");
	report_assertion("by to_in_out->addr, copy the size specified in the");
	report_assertion("conversion cache into to_in_out->size, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr3", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT3_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT3_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Invoke resource converter XtCVT3_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT3_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Procedure XtCVT3_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT3_StringToChar invoked count");
	tet_infoline("TEST: Result returned first time");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr,
		"Character");
	tet_infoline("TEST: Re-invoke with same arguments");
	init_args();
	to_in_out.size = sizeof(unsigned char)+1;
	status = XtCallConverter(display_good,
		XtCVT3_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was not invoked");
	invoked = avs_get_event(1);
	tet_infoline("TEST: Result returned second time");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtCallConverter-5.(A)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("conversion cache type specified as XtCacheAll, the converter");
	report_assertion("has been previously called with the specified arguments, the");
	report_assertion("conversion succeeded, and the size specified by the");
	report_assertion("to_in_out argument is less than the size stored in the");
	report_assertion("conversion cache a call to Boolean XtCallConverter(display,");
	report_assertion("converter, args, num_args, from, to_in_out,");
	report_assertion("cache_ref_return) shall copy the size specified in the");
	report_assertion("conversion cache into to_in_out->size and return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr4", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT4_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT4_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Invoke resource converter XtCVT4_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT4_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Procedure XtCVT4_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT4_StringToChar invoked count");
	tet_infoline("TEST: Result returned first time");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr,
		"Character");
	tet_infoline("TEST: Re-invoke with short size");
	init_args();
	to_in_out.size = 0;
	status = XtCallConverter(display_good,
		XtCVT4_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(False, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was not invoked");
	invoked = avs_get_event(1);
	tet_infoline("TEST: Size returned");
	check_dec((long)sizeof(unsigned char), (long)to_in_out.size, "to_in_out.size");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtCallConverter-6.(A)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("conversion cache type specified as XtCacheByDisplay and the");
	report_assertion("converter has not been previously called with the specified");
	report_assertion("arguments a call to Boolean XtCallConverter(display,");
	report_assertion("converter, args, num_args, from, to_in_out,");
	report_assertion("cache_ref_return) shall call the converter, enter the result");
	report_assertion("into the conversion cache, store the converted value into");
	report_assertion("the location specified by to_in_out->addr, and return what");
	report_assertion("the converter returns.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr9", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register resource converter XtCVT1b_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT1b_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Invoke resource converter XtCVT1b_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT1b_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT1b_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT1b_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	tet_infoline("TEST: Re-Invoke resource converter with same values");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT1b_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT1b_StringToChar was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT1b_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);


	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtCallConverter-7.(A)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("conversion cache type specified as XtCacheByDisplay, the");
	report_assertion("converter has been previously called with the specified");
	report_assertion("arguments, and the conversion failed a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall return False immediately.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr10", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT2b_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRUnknown,
		 XtCVT2b_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Invoke resource converter XtCVT2b_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT2b_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value was false");
	check_dec(False, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT2b_StringToChar invoked count");
	tet_infoline("TEST: Re-Invoke resource converter with same values");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT2b_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value was false");
	check_dec(False, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT2b_StringToChar invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t008(){

pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtCallConverter-8.(A)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("conversion cache type specified as XtCacheByDisplay, the");
	report_assertion("converter has been previously called with the specified");
	report_assertion("arguments, the conversion succeeded, and the size specified");
	report_assertion("by the to_in_out argument is greater than or equal to the");
	report_assertion("size stored in the conversion cache a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall copy the information");
	report_assertion("stored in the conversion cache into the location specified");
	report_assertion("by to_in_out->addr, copy the size specified in the");
	report_assertion("conversion cache into to_in_out->size, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr11", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT3b_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT3b_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Invoke resource converter XtCVT3b_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT3b_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Procedure XtCVT3b_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT3b_StringToChar invoked count");
	tet_infoline("TEST: Result returned first time");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr,
		"Character");
	tet_infoline("TEST: Re-invoke with same arguments");
	init_args();
	to_in_out.size = sizeof(unsigned char) +1;
	status = XtCallConverter(display_good,
		XtCVT3b_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was not invoked");
	invoked = avs_get_event(1);
	tet_infoline("TEST: Result returned second time");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t009(){

pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtCallConverter-9.(A)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("conversion cache type specified as XtCacheByDisplay, the");
	report_assertion("converter has been previously called with the specified");
	report_assertion("arguments, the conversion succeeded, and the size specified");
	report_assertion("by the to_in_out argument is less than the size stored in");
	report_assertion("the conversion cache a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall copy the size specified");
	report_assertion("in the conversion cache into to_in_out->size and return");
	report_assertion("False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr12", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT4b_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT4b_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Invoke resource converter XtCVT4b_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT4b_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Procedure XtCVT4b_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT4b_StringToChar invoked count");
	tet_infoline("TEST: Result returned first time");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr,
		"Character");
	tet_infoline("TEST: Re-invoke with short size");
	init_args();
	to_in_out.size = 0;
	status = XtCallConverter(display_good,
		XtCVT4b_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(False, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was not invoked");
	invoked = avs_get_event(1);
	tet_infoline("TEST: Size returned");
	check_dec((long)sizeof(unsigned char), (long)to_in_out.size, "to_in_out.size");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t010(){

pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtCallConverter-10.(A)");
	report_assertion("When the type converter converter has not been registered");
	report_assertion("for the application context associated with display and the");
	report_assertion("converter has not been previously called with the specified");
	report_assertion("arguments a call to Boolean XtCallConverter(display,");
	report_assertion("converter, args, num_args, from, to_in_out,");
	report_assertion("cache_ref_return) shall call the converter, enter the result");
	report_assertion("into the conversion cache, store the converted value into");
	report_assertion("the location specified by to_in_out->addr, and return what");
	report_assertion("the converter returns.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr5", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Invoke resource converter XtCVT1a_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT1a_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT1a_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT1a_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	tet_infoline("TEST: Re-Invoke resource converter with same values");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT1a_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT1a_StringToChar was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT1a_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t011(){

pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtCallConverter-11.(A)");
	report_assertion("When the type converter converter has not been registered");
	report_assertion("for the application context associated with display, the");
	report_assertion("converter has been previously called with the specified");
	report_assertion("arguments, and the conversion failed a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall return False immediately.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr6", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Invoke resource converter XtCVT2a_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT2a_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value was false");
	check_dec(False, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT2a_StringToChar invoked count");
	tet_infoline("TEST: Re-Invoke resource converter with same values");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT2a_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value was false");
	check_dec(False, status, "XtCallConverter return value");
	tet_infoline("TEST: Convertor was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT2a_StringToChar invoked count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t012(){

pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtCallConverter-12.(A)");
	report_assertion("When the type converter converter has not been registered");
	report_assertion("for the application context associated with display, the");
	report_assertion("converter has been previously called with the specified");
	report_assertion("arguments, the conversion succeeded, and the size specified");
	report_assertion("by the to_in_out argument is greater than or equal to the");
	report_assertion("size stored in the conversion cache a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall copy the information");
	report_assertion("stored in the conversion cache into the location specified");
	report_assertion("by to_in_out->addr, copy the size specified in the");
	report_assertion("conversion cache into to_in_out->size, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr7", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Invoke resource converter XtCVT3a_StringToChar");
	display_good = XtDisplay(topLevel);
	init_args();
	status = XtCallConverter(display_good,
		XtCVT3a_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT3a_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT3a_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	tet_infoline("TEST: Re-Invoke resource converter with same values");
	init_args();
	to_in_out.size = sizeof(unsigned char) +1;
	status = XtCallConverter(display_good,
		XtCVT3a_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT3a_StringToChar was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT3a_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	tet_infoline("TEST: Size returned");
	check_dec((long)sizeof(unsigned char), (long)to_in_out.size, "to_in_out.size");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

static void t013(){

pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtCallConverter-13.(A)");
	report_assertion("When the type converter converter has not been registered");
	report_assertion("for the application context associated with display, the");
	report_assertion("converter has been previously called with the specified");
	report_assertion("arguments, the conversion succeeded, and the size specified");
	report_assertion("by the to_in_out argument is less than the size stored in");
	report_assertion("the conversion cache a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall copy the size specified");
	report_assertion("in the conversion cache into to_in_out->size and return");
	report_assertion("False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcalcnvtr8", "XtCallConverter");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Invoke resource converter XtCVT4a_StringToChar");
	init_args();
	status = XtCallConverter(display_good,
		XtCVT4a_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(True, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT4a_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT4a_StringToChar invoked count");
	tet_infoline("TEST: Result returned");
	check_dec((long) 'H', (long) *(unsigned char*)to_in_out.addr, "Character");
	tet_infoline("TEST: Re-Invoke resource converter with short size");
	init_args();
	to_in_out.size = 0;
	status = XtCallConverter(display_good,
		XtCVT4a_StringToChar,
		(XrmValuePtr)NULL,
		(Cardinal)0,
		&from,
		&to_in_out,
		&cache_ref_return
		);
	tet_infoline("TEST: Return value");
	check_dec(False, status, "XtCallConverter return value");
	tet_infoline("TEST: Procedure XtCVT4a_StringToChar was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT4a_StringToChar invoked count");
	tet_infoline("TEST: Size returned");
	check_dec((long)sizeof(unsigned char), (long)to_in_out.size, "to_in_out.size");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11619 */
/* End of included file Mdefcode.tmc.11619 */

/* Including from file Mdefcode.tmc.11619 */
static void t014(){

pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtCallConverter-14.(B)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("cache type set to XtCacheAll and XtCacheRefCount and");
	report_assertion("cache_ref_return is not NULL a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall store a conversion cache");
	report_assertion("id into the location specified by cache_ref_return.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11619 */

/* Including from file Mdefcode.tmc.11619 */
static void t015(){

pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtCallConverter-15.(B)");
	report_assertion("When the type converter converter has been registered for");
	report_assertion("the application context associated with display with the");
	report_assertion("cache type set to XtCacheByDisplay and XtCacheRefCount and");
	report_assertion("cache_ref_return is not NULL a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall store a conversion cache");
	report_assertion("id into the location specified by cache_ref_return.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11619 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
