/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Bool
 *   XQueryPointer(display, w, root_return, child_return, root_x_return, root_y_return, win_x_return, win_y_return, mask_return)
 *   Display *display;
 *   Window w;
 *   Window *root_return;
 *   Window *child_return;
 *   int *root_x_return;
 *   int *root_y_return;
 *   int *win_x_return;
 *   int *win_y_return;
 *   unsigned int *mask_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XQueryPointer	1
char    *TestName = "XQueryPointer";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XQueryPointer function
 */
static Display *display;
static Window w;
static Window *root_return;
static Window *child_return;
static int *root_x_return;
static int *root_y_return;
static int *win_x_return;
static int *win_y_return;
static unsigned int *mask_return;


Window	root;
Window	child;
int	root_x;
int	root_y;
int	win_x;
int	win_y;
unsigned int mask;

static void
set_variables()
{
	root = (Window)0;
	child= (Window)0;
	root_x= 0;
	root_y= 0;
	win_x = 0;
	win_y =0;
	mask = 0;
}

#define XQP_X 60
#define XQP_Y 50

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
	root_return = &root;
	child_return = &child;
	root_x_return = &root_x;
	root_y_return = &root_y;
	win_x_return = &win_x;
	win_y_return = &win_y;
	mask_return = &mask;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XQueryPointer-1.(A)");
	report_assertion("A call to XQueryPointer returns the root window the pointer");
	report_assertion("is logically on in root_return, and the pointer coordinates");
	report_assertion("relative to the root window's origin in root_x_return and");
	report_assertion("root_y_return.");

	report_strategy("Call XWarpPointer to move pointer to a known position");
	report_strategy("Call XQueryPointer to obtain pointer position");
	report_strategy("Verify that the correct root window and pointer position were returned");

	tpstartup();
	setargs();
/* Call XWarpPointer to move pointer to a known position */
	warppointer(display, DefaultRootWindow(display), XQP_X, XQP_Y);

/* Call xname to obtain pointer position */
	w = DefaultRootWindow(display);
	set_variables();
	startcall(display);
	if (isdeleted())
		return;
	ret = XQueryPointer(display, w, root_return, child_return, root_x_return, root_y_return, win_x_return, win_y_return, mask_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret != True) {
		delete("%s returned %s, expecting True", TestName,
			boolname(ret));
	} else
		CHECK;

/* Verify that the correct root window and pointer position were returned */
	if (root != DefaultRootWindow(display)) {
		FAIL;
		report("%s did not return expected root window", TestName);
		trace("Expected root window=%0x", DefaultRootWindow(display));
		trace("Returned root window=%0x", root);
	} else
		CHECK;

	if (root_x != XQP_X) {
		FAIL;
		report("%s did not return expected root_x_return", TestName);
		trace("Expected root_x_return=%d", XQP_X);
		trace("Returned root_x_return=%d", root_x);
	} else
		CHECK;

	if (root_y != XQP_Y) {
		FAIL;
		report("%s did not return expected root_y_return", TestName);
		trace("Expected root_y_return=%d", XQP_Y);
		trace("Returned root_y_return=%d", root_y);
	} else
		CHECK;

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XQueryPointer-2.(C)");
	report_assertion("If multiple screens are supported: When the pointer is not");
	report_assertion("on the same screen as the specified window w, then a call");
	report_assertion("to XQueryPointer returns False, child_return is set to None,");
	report_assertion("and win_x_return and win_y_return are set to zero.");

	report_strategy("If multiple screens are supported:");
	report_strategy("	Ensure that pointer is not on the alternate screen");
	report_strategy("	Call XQueryPointer to obtain pointer position on alternate screen");
	report_strategy("	Verify that win_x_return, win_y_return and child_return");
	report_strategy("		were set correctly");

	tpstartup();
	setargs();
/* If multiple screens are supported: */
	if (config.alt_screen == -1) {
		unsupported("No alternate screen supported");
		return;
	}

/* 	Ensure that pointer is not on the alternate screen */
	warppointer(display, DefaultRootWindow(display), XQP_X, XQP_Y);

/* 	Call xname to obtain pointer position on alternate screen */
	set_variables();
	w = RootWindow(display, config.alt_screen);
	startcall(display);
	if (isdeleted())
		return;
	ret = XQueryPointer(display, w, root_return, child_return, root_x_return, root_y_return, win_x_return, win_y_return, mask_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret != False) {
		FAIL;
		report("%s returned %s, expecting False.", TestName,
			boolname(ret));
	} else
		CHECK;

/* 	Verify that win_x_return, win_y_return and child_return */
/* 		were set correctly */
	if (child != None) {
		FAIL;
		report("%s returned an unexpected window in child_return",
			TestName);
		trace("Expected (*child_return)=%0x (None)", None);
		trace("Returned (*child_return)=%0x", child);
	} else
		CHECK;

	if (win_x != 0) {
		FAIL;
		report("%s returned an unexpected value for win_x_return",
			TestName);
		trace("Expected (*win_x_return)=0");
		trace("Returned (*win_x_return)=%d", win_x);
	} else
		CHECK;

	if (win_y != 0) {
		FAIL;
		report("%s returned an unexpected value for win_y_return",
			TestName);
		trace("Expected (*win_y_return)=0");
		trace("Returned (*win_y_return)=%d", win_y);
	} else
		CHECK;

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Window rc;
XVisualInfo *vp;
Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XQueryPointer-3.(A)");
	report_assertion("When the pointer is on the same screen as the specified");
	report_assertion("window w and a child of that window contains the pointer,");
	report_assertion("then a call to XQueryPointer returns True, win_x_return and");
	report_assertion("win_y_return are set to the pointer coordinates relative to");
	report_assertion("the origin of the specified window w, and child_return is");
	report_assertion("set to the child window.");

	report_strategy("Create a child of the root window");
	report_strategy("Ensure the pointer is over the child by calling warppointer()");
	report_strategy("Call XQueryPointer to obtain pointer position");
	report_strategy("Verify that win_x_return, win_y_return and child_return");
	report_strategy("	were set correctly");

	tpstartup();
	setargs();
/* Create a child of the root window */
	resetvinf(VI_WIN); (void)nextvinf(&vp);
	/* makewinpos border width had better not change... */
	rc = makewinpos(display, vp, XQP_X-1, XQP_Y-1);

/* Ensure the pointer is over the child by calling warppointer() */
	warppointer(display, DefaultRootWindow(display),
		XQP_X+10, XQP_Y+5);

/* Call xname to obtain pointer position */
	set_variables();
	w = DefaultRootWindow(display);
	startcall(display);
	if (isdeleted())
		return;
	ret = XQueryPointer(display, w, root_return, child_return, root_x_return, root_y_return, win_x_return, win_y_return, mask_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret != True) {
		FAIL;
		report("%s returned %s, expecting True.", TestName,
			boolname(ret));
	} else
		CHECK;

/* Verify that win_x_return, win_y_return and child_return */
/* 	were set correctly */
	if (child != rc) {
		FAIL;
		report("%s returned an unexpected window in child_return",
			TestName);
		trace("Expected (*child_return)=%0x", rc);
		trace("Returned (*child_return)=%0x", child);
	} else
		CHECK;

	if (win_x != XQP_X+10) {
		FAIL;
		report("%s returned an unexpected value for win_x_return",
			TestName);
		trace("Expected (*win_x_return)=%d", XQP_X+10);
		trace("Returned (*win_x_return)=%d", win_x);
	} else
		CHECK;

	if (win_y != XQP_Y+5) {
		FAIL;
		report("%s returned an unexpected value for win_y_return",
			TestName);
		trace("Expected (*win_y_return)=%d", XQP_Y+5);
		trace("Returned (*win_y_return)=%d", win_y);
	} else
		CHECK;

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Bool ret;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XQueryPointer-4.(A)");
	report_assertion("When the pointer is on the same screen as the specified");
	report_assertion("window w and no child of that window contains the pointer,");
	report_assertion("then a call to XQueryPointer returns True, win_x_return and");
	report_assertion("win_y_return are set to the pointer coordinates relative to");
	report_assertion("the origin of the specified window w, and child_return is");
	report_assertion("set to None.");

	report_strategy("Create window");
	report_strategy("Ensure the pointer is over the window by calling warppointer()");
	report_strategy("Call XQueryPointer to obtain pointer position");
	report_strategy("Verify that win_x_return, win_y_return and child_return");
	report_strategy("	were set correctly");

	tpstartup();
	setargs();
/* Create a window */
	w = defwin(display);

/* Ensure the pointer is over the window by calling warppointer() */
	warppointer(display, w, 10, 5);

/* Call xname to obtain pointer position */
	set_variables();
	startcall(display);
	if (isdeleted())
		return;
	ret = XQueryPointer(display, w, root_return, child_return, root_x_return, root_y_return, win_x_return, win_y_return, mask_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret != True) {
		FAIL;
		report("%s returned %s, expecting True.", TestName,
			boolname(ret));
	} else
		CHECK;

/* Verify that win_x_return, win_y_return and child_return */
/* 	were set correctly */
	if (child != None) {
		FAIL;
		report("%s returned an unexpected window in child_return",
			TestName);
		trace("Expected child_return=%0x", None);
		trace("Returned child_return=%0x", child);
	} else
		CHECK;

	if (win_x != 10) {
		FAIL;
		report("%s returned an unexpected value for win_x_return",
			TestName);
		trace("Expected win_x_return=%d", 10);
		trace("Returned win_x_return=%d", win_x);
	} else
		CHECK;

	if (win_y != 5) {
		FAIL;
		report("%s returned an unexpected value for win_y_return",
			TestName);
		trace("Expected (*win_y_return)=%d", 5);
		trace("Returned (*win_y_return)=%d", win_y);
	} else
		CHECK;

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.7669 */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XQueryPointer-5.(B)");
	report_assertion("A call to XQueryPointer returns the current logical state");
	report_assertion("of the keyboard buttons and the modifier keys as the bitwise");
	report_assertion("inclusive OR of one or more of the button or modifier key");
	report_assertion("bitmasks in mask_return.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.7669 */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XQueryPointer-6.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XQueryPointer(display, w, root_return, child_return, root_x_return, root_y_return, win_x_return, win_y_return, mask_return);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
