/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int *
 *   XListDepths(display, screen_number, count_return)
 *   Display	*display;
 *   int	screen_number;
 *   int	*count_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XListDepths	1
char    *TestName = "XListDepths";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XListDepths function
 */
static Display	*display;
static int	screen_number;
static int	*count_return;


static int 	ValueReturn;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	screen_number = DefaultScreen(Dsp);
	count_return = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int	 	number;
int		*dlst;
int		*dptr;
int		i;
Pixmap	pixm;
long	notmem[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XListDepths-1.(B)");
	report_assertion("A call to XListDepths returns an array which can be freed");
	report_assertion("with XFree, of all depths which are available on the screen");
	report_assertion("screen_number and whose size is returned through the");
	report_assertion("count_return argument.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Obtain the list of supported depths using XListDepths.");
	report_strategy("For each number in the list:");
	report_strategy("  Create a pixmap of that depth.");
	report_strategy("  Verify that no error occurred.");
	report_strategy("For numbers not in the list of depths:");
	report_strategy("  Create a pixmap of the depth.");
	report_strategy("  Verify that it was not successful.");
	report_strategy("Free the list using XFree.");

	tpstartup();
	setargs();
	count_return = &number;
	startcall(display);
	if (isdeleted())
		return;
	dptr = dlst = XListDepths(display, screen_number, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	for(; dptr < &dlst[number] ; dptr++) {
		trace("Depth %d", *dptr);
		startcall(display);
		if (isdeleted())
			return;
		pixm = XCreatePixmap(display, DRW(display), 1 , 1, *dptr);
		endcall(display);
		if(geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		} else {
			CHECK;
			XFreePixmap(display, pixm);
		}
	}	

	if(notmember(dlst, number, notmem) == 0) {
		delete("notmember failed.");
		return;
	} else
		CHECK;

	for (i = 0; i < NM_LEN; i++) {
		startcall(display);
		if (isdeleted())
			return;
		/* notmem is a long, and is being cast to an int */
		pixm = XCreatePixmap(display, DRW(display), 1 , 1, (int)notmem[i]);
		endcall(display);
		if(geterr() == Success) {
			XFreePixmap(display, pixm);
			report("Got Success unexpectedly for depth %d.", (int)notmem[i]);
			FAIL;
		} else
			CHECK;
	}	

	XFree((char*)dlst);
	CHECKPASS(1+number+NM_LEN);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	number = -1;
int	*dlst;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XListDepths-2.(A)");
	report_assertion("When screen_number is not a valid screen, then a call to");
	report_assertion("XListDepths does not set the count_return argument and");
	report_assertion("returns NULL.");

	report_strategy("List the depths of an invalid screen using XListDepths.");
	report_strategy("Verify that the function returns NULL.");
	report_strategy("Verify that the count_return argument was unchanged.");

	tpstartup();
	setargs();
	count_return = &number;
	screen_number = -1;
	startcall(display);
	if (isdeleted())
		return;
	dlst = XListDepths(display, screen_number, count_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(dlst != (int *) NULL) {
		report("%s() did not return NULL.", TestName);
		FAIL;
	} else
		CHECK;

	if( number != -1) {
		report("The count_return argument was modified.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);


	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.7161 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XListDepths-3.(B)");
	report_assertion("When sufficient memory cannot be allocated for the returned");
	report_assertion("array, then a call to XListDepths does not set the");
	report_assertion("count_return argument and returns NULL.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.7161 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
