/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window)
 *   Display	*display;
 *   XDevice *device;
 *   int 	button;
 *   unsigned int 	modifiers;
 *   XDevice *modifier_device;
 *   Window	grab_window;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XUngrabDeviceButton	1
char    *TestName = "XUngrabDeviceButton";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW grab_window
#define A_DRAWABLE grab_window


/*
 * Arguments to the XUngrabDeviceButton function
 */
static Display	*display;
static XDevice *device;
static int 	button;
static unsigned int 	modifiers;
static XDevice *modifier_device;
static Window	grab_window;


extern ExtDeviceInfo Devs;


static Bool dgrabbed(dev, win)
	XDevice *dev;
	Window win;
	{
	int ret;
	Display *client1;

/* Create client1, without causing resource registration. */
	if (config.display == NULL) {
		delete("config.display not set");
		return;
	}
	client1 = XOpenDisplay(config.display);
	if (client1 == NULL) {
		delete("Couldn't create client1.");
		return;
	}

	ret = XGrabDevice (client1, dev, win, False, 0, NULL, GrabModeAsync, GrabModeAsync, CurrentTime);
	XSync(client1,0);
	if (ret == AlreadyGrabbed)
	    {
	    XCloseDisplay(client1);
	    return(True);
	    }
	else
	    {
	    XUngrabDevice(client1, dev, CurrentTime);
	    XSync(client1,0);
	    XCloseDisplay(client1);
	    return(False);
	    }
	}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	button = AnyButton;
	modifiers = AnyModifier;
	modifier_device = 0;
	grab_window = defwin(display);
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int ret;
unsigned int mods;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XUngrabDeviceButton-1.(B)");
	report_assertion("A constant of NULL can be specified as the modifier device.");
	report_assertion("This causes the X keyboard to be used.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set up a passive grab on a button, using NULL for the modifier device.");
	report_strategy("Specify a set of modifiers.");
	report_strategy("Activate the grab.");
	report_strategy("Specify NULL for the modifier device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	if (noext(1))
	    return;
	device = Devs.Button;
	modifier_device = NULL;
	warppointer(display, grab_window, 1, 1);
	XSync(display,0);

	mods = wantmods(display, 2);		/* verify grab uses core kbd */
	modifiers = mods;
	ret = XGrabDeviceButton(display, device, Button1, modifiers, 
		modifier_device, grab_window, False, 0, NULL, GrabModeAsync, 
		GrabModeAsync);
	if (ret == Success)
	    CHECK;
	else
	    {
	    report("Failed to establish grab using core modifiers.\n");
	    FAIL;
	    }

	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    CHECK;
	else
	    {
	    report("Failed to activate grab using core modifiers.\n");
	    FAIL;
	    }
	devicebuttonrel(display, Devs.Button, Button1);
	modrel(display, mods);
	XSync(display,0);

	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);				/* cancel grab using core kbd */
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    {
	    report("Failed to cancel grab using core modifiers.\n");
	    FAIL;
	    }
	else
	    CHECK;
	devicebuttonrel(display, Devs.Button, Button1);
	devicerelbuttons(Devs.Button);
	modrel(display, mods);
	relalldev();
	XUngrabDeviceButton(display, device, Button1, modifiers, 
		modifier_device, grab_window);
	XSync(display,0);
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

	if (!Setup_Extension_DeviceInfo(KeyMask | BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = Devs.Key;
	modifiers = AnyModifier;
	XGrabDeviceButton(display, device, button, modifiers, modifier_device, 
		grab_window, False, 0, NULL, GrabModeAsync, GrabModeAsync);
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XUngrabDeviceButton-2.(B)");
	report_assertion("When the specified button/modifier combination has been");
	report_assertion("grabbed by this client, then a call to XUngrabDeviceButton");
	report_assertion("releases the grab.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab a button.");
	report_strategy("Activate the grab.");
	report_strategy("Try to grab the device, verify that AlreadyGrabbed is returned.");
	report_strategy("Call XUngrabDeviceButton to release the grab.");
	report_strategy("Try to grab the device, verify that the grab was released.");

	tpstartup();
	setargs();
	if (noext(1))
	    {
	    report("Test results could not be verified, but a touch test was done.\n");
	    startcall(display);
	    if (isdeleted())
	    	return;
	    XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	    endcall(display);
	    if (geterr() != Success) {
	    	report("Got %s, Expecting Success", errorname(geterr()));
	    	FAIL;
	    }
	    XSync(display,0);
	    return;
	    }
	warppointer(display, grab_window, 1, 1);
	devicebuttonpress (display, Devs.Button, Button1);
	XSync (display, 0);

	if (dgrabbed(device, grab_window))
	    CHECK;
	else
	    {
	    report("Failed to activate button grab.\n");
	    FAIL;
	    }

	devicebuttonrel (display, Devs.Button, Button1);
	XSync (display, 0);

	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	devicebuttonpress (display, Devs.Button, Button1);
	XSync (display, 0);
	if (dgrabbed(device, grab_window))
	    {
	    FAIL;
	    report("Failed to cancel button grab.\n");
	    }
	else
	    CHECK;
	CHECKPASS(2);
	devicebuttonrel (display, Devs.Button, Button1);
	devicerelbuttons(Devs.Button);
	XSync(display,0);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int ret;
unsigned int mods;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XUngrabDeviceButton-3.(B)");
	report_assertion("A modifiers argument of AnyModifier releases all grabs by");
	report_assertion("this client for the specified button and all possible");
	report_assertion("modifier combinations.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set up several grabs with different modifiers.");
	report_strategy("Verify that they can be activated.");
	report_strategy("Call XUngrabDeviceButton with AnyModifier.");
	report_strategy("Verify that all grabs are released.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask | BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	if (noext(1))
	    return;
	device = Devs.Button;
	modifier_device = NULL;
	warppointer(display, grab_window, 1, 1);

	mods = wantmods(display, 1);
	modifiers = mods;
	ret = XGrabDeviceButton(display, device, Button1, modifiers, 
		modifier_device, grab_window, False, 0, NULL, GrabModeAsync, 
		GrabModeAsync);
	if (ret == Success)
	    CHECK;
	else
	    {
	    report("Failed to establish button grab.\n");
	    FAIL;
	    }

	mods = wantmods(display, 2);
	modifiers = mods;
	ret = XGrabDeviceButton(display, device, Button1, modifiers, 
		modifier_device, grab_window, False, 0, NULL, GrabModeAsync, 
		GrabModeAsync);
	if (ret == Success)
	    CHECK;
	else
	    {
	    report("Failed to activate button grab.\n");
	    FAIL;
	    }

	mods = wantmods(display, 1);		/* activate first grab */
	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    CHECK;
	else
	    {
	    report("Failed to activate button grab.\n");
	    FAIL;
	    }
	devicebuttonrel(display, Devs.Button, Button1);
	modrel(display, mods);
	XSync(display,0);

	mods = wantmods(display, 2);		/* activate second grab */
	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    CHECK;
	else
	    {
	    report("Failed to activate second button grab.\n");
	    FAIL;
	    }
	devicebuttonrel(display, Devs.Button, Button1);
	modrel(display, mods);
	XSync(display,0);

	modifiers = AnyModifier;
	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	mods = wantmods(display, 1);		/* activate first grab */
	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    {
	    FAIL;
	    report("Failed to cancel first button grab.\n");
	    }
	else
	    CHECK;
	devicebuttonrel(display, Devs.Button, Button1);
	modrel(display, mods);
	XSync(display,0);

	mods = wantmods(display, 2);		/* activate second grab */
	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    {
	    FAIL;
	    report("Failed to cancel second button grab.\n");
	    }
	else
	    CHECK;
	devicebuttonrel(display, Devs.Button, Button1);
	devicerelbuttons(Devs.Button);
	modrel(display, mods);
	CHECKPASS(6);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int ret;
unsigned int mods;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XUngrabDeviceButton-4.(B)");
	report_assertion("A button argument of AnyButton releases all grabs by this");
	report_assertion("client for the specified modifiers and all buttons.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test using AnyButton.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask | BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	if (noext(1))
	    return;
	device = Devs.Button;
	modifier_device = NULL;
	button = AnyButton;
	warppointer(display, grab_window, 1, 1);

	mods = wantmods(display, 1);
	modifiers = mods;
	ret = XGrabDeviceButton(display, device, Button1, modifiers, 
		modifier_device, grab_window, False, 0, NULL, GrabModeAsync, 
		GrabModeAsync);
	if (ret == Success)
	    CHECK;
	else
	    {
	    report("Failed to establish button grab.\n");
	    FAIL;
	    }

	ret = XGrabDeviceButton(display, device, Button2, modifiers, 
		modifier_device, grab_window, False, 0, NULL, GrabModeAsync, 
		GrabModeAsync);
	if (ret == Success)
	    CHECK;
	else
	    {
	    report("Failed to establish second button grab.\n");
	    FAIL;
	    }

	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    CHECK;
	else
	    {
	    report("Failed to activate first button grab.\n");
	    FAIL;
	    }
	devicebuttonrel(display, Devs.Button, Button1);
	modrel(display, mods);
	XSync(display,0);

	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button2);
	XSync(display,0);
	if (dgrabbed(device, grab_window))
	    CHECK;
	else
	    {
	    report("Failed to activate second button grab.\n");
	    FAIL;
	    }
	devicebuttonrel(display, Devs.Button, Button2);
	modrel(display, mods);
	XSync(display,0);

	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button1);
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    {
	    report("Failed to cancel first button grab.\n");
	    FAIL;
	    }
	else
	    CHECK;
	devicebuttonrel(display, Devs.Button, Button1);
	modrel(display, mods);
	XSync(display,0);

	modpress(display, mods);
	XSync (display, 0);
	devicebuttonpress(display, Devs.Button, Button2);
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    {
	    report("Failed to cancel second button grab.\n");
	    FAIL;
	    }
	else
	    CHECK;
	devicebuttonrel(display, Devs.Button, Button2);
	devicerelbuttons(Devs.Button);
	modrel(display, mods);
	XSync(display,0);
	CHECKPASS(6);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XUngrabDeviceButton-5.(B)");
	report_assertion("A call to XUngrabDeviceButton has no effect on an active");
	report_assertion("grab.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Establish an active grab.");
	report_strategy("Verify the device is grabbed.");
	report_strategy("Call XUngrabDeviceButton.");
	report_strategy("Verify the device is still grabbed.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = NULL;

	ret = XGrabDevice (display, device, grab_window, False, 0, NULL, GrabModeAsync, GrabModeAsync, CurrentTime);
	if (dgrabbed(device, grab_window))
	    CHECK;
	else
	    {
	    report("Failed to establish active grab.\n");
	    FAIL;
	    }

	startcall(display);
	if (isdeleted())
		return;
	ret = XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);			/* attempt to cancel grab */
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (dgrabbed(device, grab_window))
	    CHECK;
	else
	    {
	    report("Cancelled active grab by calling XUngrabDeviceButton.\n");
	    FAIL;
	    }
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XUngrabDeviceButton-6.(B)");
	report_assertion("A call to XUngrabDeviceButton specifying an invalid set of");
	report_assertion("modifiers results in a BadValue error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Establish an active grab.");
	report_strategy("Verify the device is grabbed.");
	report_strategy("Call XUngrabDeviceButton.");
	report_strategy("Verify the device is still grabbed.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = NULL;
 	modifiers = -1;
	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == BadValue)
	    CHECK;
	else
	    FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.10640 */
/* End of included file Mdefcode.tmc.10640 */

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XUngrabDeviceButton-7.(B)");
	report_assertion("A call to XUngrabDeviceButton specifying an invalid grab");
	report_assertion("window results in a BadWindow error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();

	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = NULL;
	grab_window = 0;
	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == BadWindow)
	    CHECK;
	else
	    FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.10640 */
/* End of included file Mdefcode.tmc.10640 */

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XUngrabDeviceButton-8.(B)");
	report_assertion("A call to XUngrabDeviceButton specifying a device with no");
	report_assertion("buttons results in a BadMatch error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NBtnsMask | KeyMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.NoButtons;
	modifier_device = Devs.Key;
	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == BadMatch)
	    CHECK;
	else
	    FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.10640 */
/* End of included file Mdefcode.tmc.10640 */

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XUngrabDeviceButton-9.(B)");
	report_assertion("A call to XUngrabDeviceButton specifying an modifier device");
	report_assertion("with no keys results in a BadMatch error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NKeysMask | BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	modifier_device = Devs.NoKeys;
	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == BadMatch)
	    CHECK;
	else
	    FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.10640 */
/* End of included file Mdefcode.tmc.10640 */

static void t010(){

XID baddevice, savedevice;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XUngrabDeviceButton-10.(B)");
	report_assertion("A call to XUngrabDeviceButton specifying an invalid device");
	report_assertion("results in a BadDevice error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	BadDevice(display, baddevice);
	device = Devs.Button;
	savedevice = device->device_id;
	device->device_id = -1;
	modifier_device = Devs.Key;

	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == baddevice)
	    CHECK;
	else 
	    FAIL;

	CHECKPASS(1);
	device->device_id = savedevice;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.10640 */
/* End of included file Mdefcode.tmc.10640 */

static void t011(){

XID baddevice;
XDevice bogus;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XUngrabDeviceButton-11.(B)");
	report_assertion("A call to XUngrabDeviceButton specifying an invalid");
	report_assertion("modifier device results in a BadDevice error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	BadDevice(display, baddevice);
	device = Devs.Button;
	modifier_device = &bogus;
	bogus.device_id = 128;

	startcall(display);
	if (isdeleted())
		return;
	XUngrabDeviceButton(display, device, button, modifiers, modifier_device, grab_window);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	if (geterr() == baddevice)
	    CHECK;
	else 
	    FAIL;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.10640 */
/* End of included file Mdefcode.tmc.10640 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
