/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* 
* SCCS:  @(#)  crsrfnt.m Rel 1.6	    (11/25/91)
* 
* 	UniSoft Ltd., London, England
* 
* (C) Copyright 1991 X/Open Company Limited
* 
* All rights reserved.  No part of this source code may be reproduced,
* stored in a retrieval system, or transmitted, in any form or by any
* means, electronic, mechanical, photocopying, recording or otherwise,
* except as stated in the end-user licence agreement, without the prior
* permission of the copyright owners.
* 
* X/Open and the 'X' symbol are trademarks of X/Open Company Limited in
* the UK and other countries.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_cursorfont	1
char    *TestName = "cursorfont";



#include	<X11/cursorfont.h>

int 	tet_thistest;

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion cursorfont-1.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_X_cursor is defined with the value 0.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_X_cursor is defined.");
	report_strategy("Verify that the symbol is defined to have value 0.");

	tpstartup();
#ifdef XC_X_cursor

#	if	(XC_X_cursor == 0)
		PASS;
#	else
		report("XC_X_cursor was defined to have value %ld instead of 0.", (long) XC_X_cursor);
		FAIL;
#	endif

#else
	report("XC_X_cursor is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion cursorfont-2.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_bottom_left_corner is defined with the value");
	report_assertion("12.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_bottom_left_corner is defined.");
	report_strategy("Verify that the symbol is defined to have value 12.");

	tpstartup();
#ifdef XC_bottom_left_corner

#	if	(XC_bottom_left_corner == 12)
		PASS;
#	else
		report("XC_bottom_left_corner was defined to have value %ld instead of 12.", (long) XC_bottom_left_corner);
		FAIL;
#	endif

#else
	report("XC_bottom_left_corner is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion cursorfont-3.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_bottom_right_corner is defined with the value");
	report_assertion("14.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_bottom_right_corner is defined.");
	report_strategy("Verify that the symbol is defined to have value 14.");

	tpstartup();
#ifdef XC_bottom_right_corner

#	if	(XC_bottom_right_corner == 14)
		PASS;
#	else
		report("XC_bottom_right_corner was defined to have value %ld instead of 14.", (long) XC_bottom_right_corner);
		FAIL;
#	endif

#else
	report("XC_bottom_right_corner is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion cursorfont-4.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_top_left_corner is defined with the value 134.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_top_left_corner is defined.");
	report_strategy("Verify that the symbol is defined to have value 134.");

	tpstartup();
#ifdef XC_top_left_corner

#	if	(XC_top_left_corner == 134)
		PASS;
#	else
		report("XC_top_left_corner was defined to have value %ld instead of 134.", (long) XC_top_left_corner);
		FAIL;
#	endif

#else
	report("XC_top_left_corner is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion cursorfont-5.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_top_right_corner is defined with the value");
	report_assertion("136.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_top_right_corner is defined.");
	report_strategy("Verify that the symbol is defined to have value 136.");

	tpstartup();
#ifdef XC_top_right_corner

#	if	(XC_top_right_corner == 136)
		PASS;
#	else
		report("XC_top_right_corner was defined to have value %ld instead of 136.", (long) XC_top_right_corner);
		FAIL;
#	endif

#else
	report("XC_top_right_corner is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion cursorfont-6.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_arrow is defined with the value 2.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_arrow is defined.");
	report_strategy("Verify that the symbol is defined to have value 2.");

	tpstartup();
#ifdef XC_arrow

#	if	(XC_arrow == 2)
		PASS;
#	else
		report("XC_arrow was defined to have value %ld instead of 2.", (long) XC_arrow);
		FAIL;
#	endif

#else
	report("XC_arrow is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion cursorfont-7.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_based_arrow_down is defined with the value 4.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_based_arrow_down is defined.");
	report_strategy("Verify that the symbol is defined to have value 4.");

	tpstartup();
#ifdef XC_based_arrow_down

#	if	(XC_based_arrow_down == 4)
		PASS;
#	else
		report("XC_based_arrow_down was defined to have value %ld instead of 4.", (long) XC_based_arrow_down);
		FAIL;
#	endif

#else
	report("XC_based_arrow_down is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion cursorfont-8.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_based_arrow_up is defined with the value 6.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_based_arrow_up is defined.");
	report_strategy("Verify that the symbol is defined to have value 6.");

	tpstartup();
#ifdef XC_based_arrow_up

#	if	(XC_based_arrow_up == 6)
		PASS;
#	else
		report("XC_based_arrow_up was defined to have value %ld instead of 6.", (long) XC_based_arrow_up);
		FAIL;
#	endif

#else
	report("XC_based_arrow_up is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion cursorfont-9.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_double_arrow is defined with the value 42.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_double_arrow is defined.");
	report_strategy("Verify that the symbol is defined to have value 42.");

	tpstartup();
#ifdef XC_double_arrow

#	if	(XC_double_arrow == 42)
		PASS;
#	else
		report("XC_double_arrow was defined to have value %ld instead of 42.", (long) XC_double_arrow);
		FAIL;
#	endif

#else
	report("XC_double_arrow is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion cursorfont-10.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_question_arrow is defined with the value 92.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_question_arrow is defined.");
	report_strategy("Verify that the symbol is defined to have value 92.");

	tpstartup();
#ifdef XC_question_arrow

#	if	(XC_question_arrow == 92)
		PASS;
#	else
		report("XC_question_arrow was defined to have value %ld instead of 92.", (long) XC_question_arrow);
		FAIL;
#	endif

#else
	report("XC_question_arrow is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion cursorfont-11.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_sb_h_double_arrow is defined with the value");
	report_assertion("108.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_sb_h_double_arrow is defined.");
	report_strategy("Verify that the symbol is defined to have value 108.");

	tpstartup();
#ifdef XC_sb_h_double_arrow

#	if	(XC_sb_h_double_arrow == 108)
		PASS;
#	else
		report("XC_sb_h_double_arrow was defined to have value %ld instead of 108.", (long) XC_sb_h_double_arrow);
		FAIL;
#	endif

#else
	report("XC_sb_h_double_arrow is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion cursorfont-12.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_sb_v_double_arrow is defined with the value");
	report_assertion("116.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_sb_v_double_arrow is defined.");
	report_strategy("Verify that the symbol is defined to have value 116.");

	tpstartup();
#ifdef XC_sb_v_double_arrow

#	if	(XC_sb_v_double_arrow == 116)
		PASS;
#	else
		report("XC_sb_v_double_arrow was defined to have value %ld instead of 116.", (long) XC_sb_v_double_arrow);
		FAIL;
#	endif

#else
	report("XC_sb_v_double_arrow is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion cursorfont-13.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_top_left_arrow is defined with the value 132.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_top_left_arrow is defined.");
	report_strategy("Verify that the symbol is defined to have value 132.");

	tpstartup();
#ifdef XC_top_left_arrow

#	if	(XC_top_left_arrow == 132)
		PASS;
#	else
		report("XC_top_left_arrow was defined to have value %ld instead of 132.", (long) XC_top_left_arrow);
		FAIL;
#	endif

#else
	report("XC_top_left_arrow is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion cursorfont-14.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_bottom_tee is defined with the value 18.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_bottom_tee is defined.");
	report_strategy("Verify that the symbol is defined to have value 18.");

	tpstartup();
#ifdef XC_bottom_tee

#	if	(XC_bottom_tee == 18)
		PASS;
#	else
		report("XC_bottom_tee was defined to have value %ld instead of 18.", (long) XC_bottom_tee);
		FAIL;
#	endif

#else
	report("XC_bottom_tee is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion cursorfont-15.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_left_tee is defined with the value 72.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_left_tee is defined.");
	report_strategy("Verify that the symbol is defined to have value 72.");

	tpstartup();
#ifdef XC_left_tee

#	if	(XC_left_tee == 72)
		PASS;
#	else
		report("XC_left_tee was defined to have value %ld instead of 72.", (long) XC_left_tee);
		FAIL;
#	endif

#else
	report("XC_left_tee is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion cursorfont-16.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_right_tee is defined with the value 98.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_right_tee is defined.");
	report_strategy("Verify that the symbol is defined to have value 98.");

	tpstartup();
#ifdef XC_right_tee

#	if	(XC_right_tee == 98)
		PASS;
#	else
		report("XC_right_tee was defined to have value %ld instead of 98.", (long) XC_right_tee);
		FAIL;
#	endif

#else
	report("XC_right_tee is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion cursorfont-17.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_top_tee is defined with the value 140.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_top_tee is defined.");
	report_strategy("Verify that the symbol is defined to have value 140.");

	tpstartup();
#ifdef XC_top_tee

#	if	(XC_top_tee == 140)
		PASS;
#	else
		report("XC_top_tee was defined to have value %ld instead of 140.", (long) XC_top_tee);
		FAIL;
#	endif

#else
	report("XC_top_tee is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion cursorfont-18.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_bottom_side is defined with the value 16.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_bottom_side is defined.");
	report_strategy("Verify that the symbol is defined to have value 16.");

	tpstartup();
#ifdef XC_bottom_side

#	if	(XC_bottom_side == 16)
		PASS;
#	else
		report("XC_bottom_side was defined to have value %ld instead of 16.", (long) XC_bottom_side);
		FAIL;
#	endif

#else
	report("XC_bottom_side is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion cursorfont-19.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_left_side is defined with the value 70.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_left_side is defined.");
	report_strategy("Verify that the symbol is defined to have value 70.");

	tpstartup();
#ifdef XC_left_side

#	if	(XC_left_side == 70)
		PASS;
#	else
		report("XC_left_side was defined to have value %ld instead of 70.", (long) XC_left_side);
		FAIL;
#	endif

#else
	report("XC_left_side is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion cursorfont-20.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_right_side is defined with the value 96.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_right_side is defined.");
	report_strategy("Verify that the symbol is defined to have value 96.");

	tpstartup();
#ifdef XC_right_side

#	if	(XC_right_side == 96)
		PASS;
#	else
		report("XC_right_side was defined to have value %ld instead of 96.", (long) XC_right_side);
		FAIL;
#	endif

#else
	report("XC_right_side is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t021(){

int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion cursorfont-21.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_top_side is defined with the value 138.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_top_side is defined.");
	report_strategy("Verify that the symbol is defined to have value 138.");

	tpstartup();
#ifdef XC_top_side

#	if	(XC_top_side == 138)
		PASS;
#	else
		report("XC_top_side was defined to have value %ld instead of 138.", (long) XC_top_side);
		FAIL;
#	endif

#else
	report("XC_top_side is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t022(){

int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion cursorfont-22.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_ll_angle is defined with the value 76.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_ll_angle is defined.");
	report_strategy("Verify that the symbol is defined to have value 76.");

	tpstartup();
#ifdef XC_ll_angle

#	if	(XC_ll_angle == 76)
		PASS;
#	else
		report("XC_ll_angle was defined to have value %ld instead of 76.", (long) XC_ll_angle);
		FAIL;
#	endif

#else
	report("XC_ll_angle is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t023(){

int 	pass = 0, fail = 0;

 	report_purpose(23);

	report_assertion("Assertion cursorfont-23.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_lr_angle is defined with the value 78.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_lr_angle is defined.");
	report_strategy("Verify that the symbol is defined to have value 78.");

	tpstartup();
#ifdef XC_lr_angle

#	if	(XC_lr_angle == 78)
		PASS;
#	else
		report("XC_lr_angle was defined to have value %ld instead of 78.", (long) XC_lr_angle);
		FAIL;
#	endif

#else
	report("XC_lr_angle is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t024(){

int 	pass = 0, fail = 0;

 	report_purpose(24);

	report_assertion("Assertion cursorfont-24.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_ul_angle is defined with the value 144.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_ul_angle is defined.");
	report_strategy("Verify that the symbol is defined to have value 144.");

	tpstartup();
#ifdef XC_ul_angle

#	if	(XC_ul_angle == 144)
		PASS;
#	else
		report("XC_ul_angle was defined to have value %ld instead of 144.", (long) XC_ul_angle);
		FAIL;
#	endif

#else
	report("XC_ul_angle is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t025(){

int 	pass = 0, fail = 0;

 	report_purpose(25);

	report_assertion("Assertion cursorfont-25.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_ur_angle is defined with the value 148.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_ur_angle is defined.");
	report_strategy("Verify that the symbol is defined to have value 148.");

	tpstartup();
#ifdef XC_ur_angle

#	if	(XC_ur_angle == 148)
		PASS;
#	else
		report("XC_ur_angle was defined to have value %ld instead of 148.", (long) XC_ur_angle);
		FAIL;
#	endif

#else
	report("XC_ur_angle is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t026(){

int 	pass = 0, fail = 0;

 	report_purpose(26);

	report_assertion("Assertion cursorfont-26.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_circle is defined with the value 24.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_circle is defined.");
	report_strategy("Verify that the symbol is defined to have value 24.");

	tpstartup();
#ifdef XC_circle

#	if	(XC_circle == 24)
		PASS;
#	else
		report("XC_circle was defined to have value %ld instead of 24.", (long) XC_circle);
		FAIL;
#	endif

#else
	report("XC_circle is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t027(){

int 	pass = 0, fail = 0;

 	report_purpose(27);

	report_assertion("Assertion cursorfont-27.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_cross is defined with the value 30.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_cross is defined.");
	report_strategy("Verify that the symbol is defined to have value 30.");

	tpstartup();
#ifdef XC_cross

#	if	(XC_cross == 30)
		PASS;
#	else
		report("XC_cross was defined to have value %ld instead of 30.", (long) XC_cross);
		FAIL;
#	endif

#else
	report("XC_cross is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t028(){

int 	pass = 0, fail = 0;

 	report_purpose(28);

	report_assertion("Assertion cursorfont-28.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_crosshair is defined with the value 34.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_crosshair is defined.");
	report_strategy("Verify that the symbol is defined to have value 34.");

	tpstartup();
#ifdef XC_crosshair

#	if	(XC_crosshair == 34)
		PASS;
#	else
		report("XC_crosshair was defined to have value %ld instead of 34.", (long) XC_crosshair);
		FAIL;
#	endif

#else
	report("XC_crosshair is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t029(){

int 	pass = 0, fail = 0;

 	report_purpose(29);

	report_assertion("Assertion cursorfont-29.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_center_ptr is defined with the value 22.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_center_ptr is defined.");
	report_strategy("Verify that the symbol is defined to have value 22.");

	tpstartup();
#ifdef XC_center_ptr

#	if	(XC_center_ptr == 22)
		PASS;
#	else
		report("XC_center_ptr was defined to have value %ld instead of 22.", (long) XC_center_ptr);
		FAIL;
#	endif

#else
	report("XC_center_ptr is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t030(){

int 	pass = 0, fail = 0;

 	report_purpose(30);

	report_assertion("Assertion cursorfont-30.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_left_ptr is defined with the value 68.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_left_ptr is defined.");
	report_strategy("Verify that the symbol is defined to have value 68.");

	tpstartup();
#ifdef XC_left_ptr

#	if	(XC_left_ptr == 68)
		PASS;
#	else
		report("XC_left_ptr was defined to have value %ld instead of 68.", (long) XC_left_ptr);
		FAIL;
#	endif

#else
	report("XC_left_ptr is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t031(){

int 	pass = 0, fail = 0;

 	report_purpose(31);

	report_assertion("Assertion cursorfont-31.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_right_ptr is defined with the value 94.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_right_ptr is defined.");
	report_strategy("Verify that the symbol is defined to have value 94.");

	tpstartup();
#ifdef XC_right_ptr

#	if	(XC_right_ptr == 94)
		PASS;
#	else
		report("XC_right_ptr was defined to have value %ld instead of 94.", (long) XC_right_ptr);
		FAIL;
#	endif

#else
	report("XC_right_ptr is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

static void t032(){

int 	pass = 0, fail = 0;

 	report_purpose(32);

	report_assertion("Assertion cursorfont-32.(A)");
	report_assertion("When the header file <X11/cursorfont.h> is included, then");
	report_assertion("the symbol XC_num_glyphs is defined with a value which is");
	report_assertion("even and is not less than 150.");

	report_strategy("Include the file <X11/cursorfont.h>");
	report_strategy("Verify that the symbol XC_num_glyphs is defined.");
	report_strategy("Verify that the sumbol value is even.");
	report_strategy("Verify that the symbol is defined to have value not less than 150.");

	tpstartup();
#ifdef XC_num_glyphs

	if(XC_num_glyphs < 150) {
		report("XC_num_glyphs (value %ld) is less than 150.", (long) XC_num_glyphs);
		FAIL;
	} else
		CHECK;
	
	if(XC_num_glyphs % 2 != 0) {
		report("XC_num_glyphs (value %ld) is not even.", (long) XC_num_glyphs);
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
#else
	report("XC_num_glyphs is not defined.");
	FAIL;
#endif

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ t026, 26 },
	{ t027, 27 },
	{ t028, 28 },
	{ t029, 29 },
	{ t030, 30 },
	{ t031, 31 },
	{ t032, 32 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
