/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* 
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XrmMergeDatabases(source_db, target_db)
 *   XrmDatabase source_db;
 *   XrmDatabase *target_db;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmMergeDatabases	1
char    *TestName = "XrmMergeDatabases";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmMergeDatabases function
 */
static XrmDatabase source_db;
static XrmDatabase *target_db;



static XrmDatabase
xrm_create_database(data)
char *data;
{
	/* Create a new database for testing with */
	return(XrmGetStringDatabase(data));
}

static void
xrm_fill_value(value, data)
XrmValue *value;
char *data;
{
	value->addr = (caddr_t)data;
	value->size = (unsigned int)(strlen(data)+1);
}

static int
xrm_check_entry(dbase, fullspec, fullclass, type, val)
XrmDatabase dbase;
char *fullspec;
char *fullclass;
char *type;
char *val;
{
	int ret_val;
	char	*type_ret;
	XrmValue	value_ret;

	ret_val=0;
	type_ret=(char *)NULL;
	value_ret.size=0;
	value_ret.addr=(caddr_t)NULL;

	if(XrmGetResource(dbase, fullspec, fullclass, &type_ret, &value_ret)
		==False) {
		report("XrmGetResource failed to find database entry");
		report("Specifier was: %s", fullspec);
		ret_val++;
	} else {
		if (type_ret==NULL || strcmp(type_ret, type)) {
			report("XrmGetResource returned unexpected type information.");
			report("Specifier was: %s", fullspec);
			report("Expected type: '%s'", type);
			report("Returned type: '%s'",
				(type_ret==NULL)?"<NULL POINTER>":type_ret);
			ret_val++;
		}

		if (( value_ret.addr==(caddr_t)NULL)
			|| (strncmp((char *)value_ret.addr, val, strlen(val)))) {
			report("XrmGetResource returned unexpected value information.");
			report("Specifier was: %s", fullspec);
			report("Expected value: '%s'", val);
			if(value_ret.addr == (caddr_t)NULL) {
				report("Returned value: <NULL POINTER>");
			} else {
				report("Returned value: '%.*s' (%u bytes)",
					value_ret.size, (char *)value_ret.addr, value_ret.size);
			}
			ret_val++;
		}
	}

	return(ret_val);
}

static int
xrm_tabulate(from, into)
char *from, *into;
{
	int i,j;

	j = strlen(from);
	for(i=0; i<j; i++) {
		if(from[i]=='T') {
			into[i]='\t';
		} else {
			into[i]=from[i];
		}
	}
	return(j);
}

static XrmDatabase target;

#define XMD_SPEC 0
#define XMD_TYPE 1
#define XMD_VALUE 2
#define XMD_FSPEC 3
#define XMD_FCLASS 4
#define XMD_XTYPE 5
#define XMD_XVALUE 6

/* Test database data */
#define XMD_SIZE 3
static char	*d1_data[XMD_SIZE][5] = {
	/* spec, type, value, fullspec, fullclass */
	{ "one.data", "String", "one", "one.data", "One.Data" },
	{ "one.Misc", "Nylon",  "two", "one.misc", "One.Misc" },
	{ "one*type", "Cotton", "three", "one.type", "One.Type" } };

static char	*d2_data[XMD_SIZE][5] = {
	/* spec, type, value, fullspec, fullclass */
	{ "two.data", "Thread", "four", "two.data", "Two.Data" },
	{ "Two.star", "Lycra",  "five", "two.star", "Two.Star" },
	{ "two*Halt", "Silk",   "six", "two.halt", "Two.Halt" } };

static char *d3_data[XMD_SIZE][7] = {
	/* spec, type, value, fullspec, fullclass, exptype, expvalue */
/* These should replace test data in the target */
	{ "one.data", "Thread", "seven", "one.data", "One.Data", "Thread", "seven" },
	{ "one.Misc", "Lycra",  "eight", "one.misc", "One.Misc", "Lycra",  "eight" },
/* These is new data from the source. */
	{ "two.odd",	"Silk", 	"nine",	"two.odd",	"Two.Odd",	"Silk", "nine" } };

/* This defines from which point in d1_data entries the data is expected to
	remain in the target after the merge in test 3. */
#define XMD_UNREPLACED 2


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	source_db = 0;
	target_db = &target;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

/* Including from file rescommon.mc */
/* End of included file rescommon.mc */

static void t001(){

int a;
XrmValue val;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmMergeDatabases-1.(A)");
	report_assertion("A call to XrmMergeDatabases merges the contents of");
	report_assertion("source_db into target_db.");

	report_strategy("Create two test databases.");
	report_strategy("Add test data to the test databases.");
	report_strategy("Call XrmMergeDatabases to merge the databases.");
	report_strategy("Verify that the target database contains all the test data.");

	tpstartup();
	setargs();
/* Create two test databases. */
	source_db = xrm_create_database("");
	if(source_db == (XrmDatabase)NULL) {
		delete("Could not create source database.");
		return;
	} else
		CHECK;

	target = xrm_create_database("");
	if(target == (XrmDatabase)NULL) {
		delete("Could not create target database.");
		return;
	} else
		CHECK;

/* Add test data to the test databases. */
	for(a=0; a<XMD_SIZE; a++) {
		CHECK;
		xrm_fill_value( &val, d1_data[a][XMD_VALUE] );
		XrmPutResource(&source_db,
			d1_data[a][XMD_SPEC],
			d1_data[a][XMD_TYPE],
			&val);
		
		xrm_fill_value( &val, d2_data[a][XMD_VALUE] );
		XrmPutResource(target_db,
			d2_data[a][XMD_SPEC],
			d2_data[a][XMD_TYPE],
			&val);
	}

/* Call xname to merge the databases. */
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmMergeDatabases(source_db, target_db);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the target database contains all the test data. */
	for(a=0; a<XMD_SIZE; a++) {

		if (xrm_check_entry(target,
			d1_data[a][XMD_FSPEC],
			d1_data[a][XMD_FCLASS],
			d1_data[a][XMD_TYPE],
			d1_data[a][XMD_VALUE])) {
			FAIL;
			report("%s did not merge in the source database correctly",
				TestName);
		} else
			CHECK;

		if (xrm_check_entry(target,
			d2_data[a][XMD_FSPEC],
			d2_data[a][XMD_FCLASS],
			d2_data[a][XMD_TYPE],
			d2_data[a][XMD_VALUE])) {
			FAIL;
			report("%s did not preserve the target database correctly",
				TestName);
		} else
			CHECK;
	}

	CHECKPASS(2 + XMD_SIZE + XMD_SIZE*2);

	XrmDestroyDatabase(target);
	
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.28584 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmMergeDatabases-2.(B)");
	report_assertion("On a call to XrmMergeDatabases, the source database");
	report_assertion("source_db is destroyed.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.28584 */

static void t003(){

int a;
XrmValue val;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XrmMergeDatabases-3.(A)");
	report_assertion("When a resource is a member of both target_db and source_db,");
	report_assertion("then the value and type of the resource in target_db is");
	report_assertion("overwritten with the corresponding value and type from the");
	report_assertion("resource in source_db.");

	report_strategy("Create two test databases.");
	report_strategy("Add test data to the test databases.");
	report_strategy("Call XrmMergeDatabases to merge the databases.");
	report_strategy("Verify that the overlapping source database entries replaced the");
	report_strategy("	corresponding target database entries, and that unique source");
	report_strategy("	database entries were merged correctly.");
	report_strategy("Verify that unique target database entries remained following the merge.");

	tpstartup();
	setargs();
/* Create two test databases. */
	source_db = xrm_create_database("");
	if(source_db == (XrmDatabase)NULL) {
		delete("Could not create source database.");
		return;
	} else
		CHECK;

	target = xrm_create_database("");
	if(target == (XrmDatabase)NULL) {
		delete("Could not create target database.");
		return;
	} else
		CHECK;

/* Add test data to the test databases. */
	for(a=0; a<XMD_SIZE; a++) {
		CHECK;
		
		xrm_fill_value( &val, d3_data[a][XMD_VALUE] );
		XrmPutResource(&source_db,
			d3_data[a][XMD_SPEC],
			d3_data[a][XMD_TYPE],
			&val);

		xrm_fill_value( &val, d1_data[a][XMD_VALUE] );
		XrmPutResource(target_db,
			d1_data[a][XMD_SPEC],
			d1_data[a][XMD_TYPE],
			&val);
	}

/* Call xname to merge the databases. */
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmMergeDatabases(source_db, target_db);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the overlapping source database entries replaced the */
/* 	corresponding target database entries, and that unique source */
/* 	database entries were merged correctly. */
	for(a=0; a<XMD_SIZE; a++) {
		if (xrm_check_entry(target,
			d3_data[a][XMD_FSPEC],
			d3_data[a][XMD_FCLASS],
			d3_data[a][XMD_XTYPE],
			d3_data[a][XMD_XVALUE])) {
			FAIL;
			report("%s did not merge the databases correctly",
				TestName);
		} else
			CHECK;
	}

/* Verify that unique target database entries remained following the merge. */
	for(a=XMD_UNREPLACED; a<XMD_SIZE; a++) {
		if (xrm_check_entry(target,
			d1_data[a][XMD_FSPEC],
			d1_data[a][XMD_FCLASS],
			d1_data[a][XMD_TYPE],
			d1_data[a][XMD_VALUE])) {
			FAIL;
			report("%s did not preserve the target database correctly",
				TestName);
		} else
			CHECK;
	}

	CHECKPASS(2 + XMD_SIZE + XMD_SIZE*2 - XMD_UNREPLACED) ;

	XrmDestroyDatabase(target);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int a;
XrmValue val;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XrmMergeDatabases-4.(A)");
	report_assertion("A call to XrmMergeDatabases when target_db is NULL shall");
	report_assertion("store the contents of source_db into it.");

	report_strategy("Create a test database.");
	report_strategy("Add test data to the test database.");
	report_strategy("Call XrmMergeDatabases with target_db set to NULL.");
	report_strategy("Verify that the target database contains the source_db contents.");

	tpstartup();
	setargs();
	/* Create a test database. */
	source_db = xrm_create_database("");
	if(source_db == (XrmDatabase)NULL) {
		delete("Could not create source database.");
		return;
	}

	target = (XrmDatabase)NULL;

	/* Add test data to the test database. */
	for(a=0; a<XMD_SIZE; a++)
	{
		CHECK;
		xrm_fill_value( &val, d1_data[a][XMD_VALUE] );
		XrmPutResource(&source_db,
			d1_data[a][XMD_SPEC],
			d1_data[a][XMD_TYPE],
			&val);
		
		xrm_fill_value( &val, d2_data[a][XMD_VALUE] );
		XrmPutResource(&source_db,
			d2_data[a][XMD_SPEC],
			d2_data[a][XMD_TYPE],
			&val);
	}

	/* Call xname to merge the databases. */
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmMergeDatabases(source_db, target_db);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* Verify that the target database contains all the test data. */
	for(a=0; a<XMD_SIZE; a++) 
	{
		if (xrm_check_entry(target,
			d1_data[a][XMD_FSPEC],
			d1_data[a][XMD_FCLASS],
			d1_data[a][XMD_TYPE],
			d1_data[a][XMD_VALUE])) {
			FAIL;
			report("%s did not merge in the source database correctly",
				TestName);
		}

		if (xrm_check_entry(target,
			d2_data[a][XMD_FSPEC],
			d2_data[a][XMD_FCLASS],
			d2_data[a][XMD_TYPE],
			d2_data[a][XMD_VALUE])) {
			FAIL;
			report("%s did not preserve the target database correctly",
				TestName);
		}
	}
	XrmDestroyDatabase(target);
	tet_result(TET_PASS);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.28584 */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XrmMergeDatabases-5.(B)");
	report_assertion("A call to XrmMergeDatabases shall merge database entries");
	report_assertion("without changing values of types, regardless of the locales");
	report_assertion("of the databases.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.28584 */

/* Including from file Mdefcode.tmc.28584 */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XrmMergeDatabases-6.(B)");
	report_assertion("A call to XrmMergeDatabases shall not modify the locale of");
	report_assertion("the target database.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.28584 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
