/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XReparentWindow(display, w, parent, x, y)
 *   Display	*display;
 *   Window	w;
 *   Window	parent;
 *   int 	x;
 *   int 	y;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XReparentWindow	1
char    *TestName = "XReparentWindow";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w
#define A_WINDOW2 parent
#define A_DRAWABLE2 parent


/*
 * Arguments to the XReparentWindow function
 */
static Display	*display;
static Window	w;
static Window	parent;
static int 	x;
static int 	y;



#define	RP_X	12
#define	RP_Y	15

char	*Treedesc[] = {
	"base borders",
	"A base (1,3) 50x30",
	  "A1 A (10,1) 4x5",
	  "A2 A (20,6) 4x5",
	"B base (4, 40) 20x20",
	  "B1 B (3,4) 10x10",

};

static	struct	buildtree	*Tree;
static	Window	WinA;
static	Window	WinB;
static	Window	WinBase;

static void
reparentinit()
{
Window	win;

	tpstartup();

	win = defwin(Dsp);
	Tree = buildtree(Dsp, win, Treedesc, NELEM(Treedesc));
	WinA = btntow(Tree, "A");
	WinB = btntow(Tree, "B");
	WinBase = btntow(Tree, "base");
}




#define	ON_WINDOW	0x1	/* event received on window itself */
#define	ON_PARENT	0x2	/* event received on parent window */
#define	ON_NEWPARENT 0x4	/* event received on new parent window */


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
	parent = 0;
	x = RP_X;
	y = RP_Y;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
	parent = ErrdefWindow;
}

static void t001(){

Window	dummy;
Window	par;
Window	*children;
int 	nchild;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XReparentWindow-1.(A)");
	report_assertion("A call to XReparentWindow removes the specified window from");
	report_assertion("its current position in the hierarchy, and inserts it as the");
	report_assertion("child of the specified parent window at the position");
	report_assertion("specified by x and y.");

	report_strategy("Build a window tree.");
	report_strategy("Call XReparentWindow to reparent window.");
	report_strategy("Verify that parent of window has changed.");
	report_strategy("Verify that the old parent no longer has the specified window as a child.");

	reparentinit();
	setargs();
	parent = WinA;
	w = WinB;

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * Check new parent.
	 */
	if (XQueryTree(display, WinB, &dummy, &par, &children, (unsigned*)&nchild) == False) {
		delete("XQueryTree on window failed");
		return;
	}

	if (par != parent) {
		report("New parent was incorrect");
		report(" Got 0x%x, expecting 0x%x", par, parent);
		FAIL;
	} else
		CHECK;

	if (nchild > 0 && children)
		XFree((char*) children);

	/*
	 * Check that window is not still a child of the old parent.
	 */
	if (XQueryTree(display, WinBase, &dummy, &par, &children, (unsigned*)&nchild) == False) {
		delete("XQueryTree on old parent failed");
		return;
	}
	while (nchild-- > 0) {
		if (children[nchild] == WinB)
			break;
	}

	if (nchild == -1)
		CHECK;
	else {
		report("window was still a child of the old parent after reparenting");
		FAIL;
	}

	if (nchild > 0 && children)
		XFree((char*) children);

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XUnmapEvent	good;
XUnmapEvent	*ump;
XEvent	ev;
int 	got = 0;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XReparentWindow-2.(A)");
	report_assertion("When the specified window is mapped, then a call to");
	report_assertion("XReparentWindow automatically performs an UnmapWindow first,");
	report_assertion("and an UnmapNotify event is generated.");

	report_strategy("Build a window tree.");
	report_strategy("Enable StructureNotify events on window.");
	report_strategy("Enable SubstructureNotify events on original parent.");
	report_strategy("Reparent window.");
	report_strategy("Verify that an UnmapNotify is generated on the old parent.");
	report_strategy("Verify that an UnmapNotify is generated on the window.");

	reparentinit();
	setargs();
	parent = WinA;
	w = WinB;

	XSelectInput(display, WinBase, SubstructureNotifyMask);
	XSelectInput(display, w, StructureNotifyMask);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	defsetevent(good, display, UnmapNotify);
	good.window = w;
	good.from_configure = False;

	got = 0;
	while (getevent(display, &ev)) {
		if (ev.type != UnmapNotify)
			continue;
		ump = (XUnmapEvent*)&ev;
		if (ump->event == ump->window) {
			/* On the window itself */
			if (got & ON_WINDOW) {
				report("Repeated unmap event on window");
				FAIL;
			} else
				CHECK;
			got |= ON_WINDOW;
			good.event = WinB;
		} else {
			if (got & ON_PARENT) {
				report("Repeated unmap event on parent window");
				FAIL;
			} else
				CHECK;
			got |= ON_PARENT;
			good.event = WinBase;
		}
		if (checkevent((XEvent*)&good, &ev))
			FAIL;
		else
			CHECK;
	}

	if (!(got & ON_PARENT)) {
		report("UnmapNotify event not received on parent window");
		FAIL;
	} else
		CHECK;
	if (!(got & ON_WINDOW)) {
		report("UnmapNotify event not received on window");
		FAIL;
	} else
		CHECK;
	
	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	n;
int 	nsibs;
struct	buildtree	*btp;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XReparentWindow-3.(A)");
	report_assertion("The window is placed at the top of the stacking order with");
	report_assertion("respect to sibling windows.");

	report_strategy("Build a window tree.");
	report_strategy("Reparent window.");
	report_strategy("Verify that it has been placed at the top of the stacking order.");

	reparentinit();
	setargs();
	parent = WinA;
	w = WinB;

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* Count the number of siblings that window should have */
	nsibs = 0;
	for (btp = Tree+1; btp < Tree+NELEM(Treedesc); btp++) {
		if (btp->parent->wid == WinA)
			nsibs++;
	}

	/*
	 *This is the stacking order number that the window should have after
	 * reparenting
	 */
	n = stackorder(display, w);
	if (n != nsibs) {
		report("Reparented window had incorrect stacking order");
		report(" Got %d, expecting %d", n, nsibs);
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XReparentEvent	good;
XReparentEvent	*rpp;
XEvent	ev;
int 	got = 0;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XReparentWindow-4.(A)");
	report_assertion("A call to XReparentWindow generates a ReparentNotify event");
	report_assertion("on the window and on both the old and new parent windows.");

	report_strategy("Build a window tree.");
	report_strategy("Enable SubstructureNotify events on new parent.");
	report_strategy("Enable SubstructureNotify events on old parent.");
	report_strategy("Enable StructureNotify events on window.");
	report_strategy("Reparent window.");
	report_strategy("Verify ReparentNotify event generated on new parent.");
	report_strategy("Verify ReparentNotify event generated on old parent.");
	report_strategy("Verify ReparentNotify event generated on reparented window.");

	reparentinit();
	setargs();
	parent = WinA;
	w = WinB;

	XSelectInput(display, WinA, SubstructureNotifyMask);
	XSelectInput(display, WinBase, SubstructureNotifyMask);
	XSelectInput(display, w, StructureNotifyMask);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	defsetevent(good, display, ReparentNotify);
	good.event = 0;
	good.window = w;
	good.parent = WinA;
	good.x = x;
	good.y = y;
	good.override_redirect = False;

	got = 0;
	while (getevent(display, &ev)) {
		if (ev.type != ReparentNotify)
			continue;
		rpp = (XReparentEvent*)&ev;
		if (rpp->event == rpp->window) {
			/* On the window itself */
			if (got & ON_WINDOW) {
				report("Repeated unmap event on window");
				FAIL;
			} else
				CHECK;
			got |= ON_WINDOW;
			good.event = WinB;
		} else if (rpp->event == WinA) {
			if (got & ON_NEWPARENT) {
				report("Repeated unmap event on new parent window");
				FAIL;
			} else
				CHECK;
			got |= ON_NEWPARENT;
			good.event = WinA;
		} else if (rpp->event == WinBase) {
			if (got & ON_PARENT) {
				report("Repeated unmap event on old parent window");
				FAIL;
			} else
				CHECK;
			got |= ON_PARENT;
			good.event = WinBase;
		} else {
			report("Event received on window other than old or new parent");
			FAIL;
		}
		if (checkevent((XEvent*)&good, &ev))
			FAIL;
		else
			CHECK;
	}

	if (!(got & ON_NEWPARENT)) {
		report("UnmapNotify event not received on new parent window");
		FAIL;
	} else
		CHECK;
	if (!(got & ON_PARENT)) {
		report("UnmapNotify event not received on old parent window");
		FAIL;
	} else
		CHECK;
	if (!(got & ON_WINDOW)) {
		report("UnmapNotify event not received on window");
		FAIL;
	} else
		CHECK;
	
	CHECKPASS(9);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

XMapEvent	good;
XMapEvent	*mp;
XMapRequestEvent	mreqgood;
XEvent	ev;
Display	*client2;
int 	n;
int 	got = 0;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XReparentWindow-5.(A)");
	report_assertion("When the specified window was originally mapped, then a");
	report_assertion("call to XReparentWindow automatically performs a MapWindow");
	report_assertion("request on it after the window is reparented, and a");
	report_assertion("MapRequest or MapNotify event is generated.");

	report_strategy("Build window tree.");
	report_strategy("Enable StructureNotify on window.");
	report_strategy("Enable SubstructureNotify on new parent.");
	report_strategy("Reparent window with XReparentWindow.");
	report_strategy("Verify that MapNotify is received on window.");
	report_strategy("Verify that MapNotify is received on parent.");
	report_strategy("");
	report_strategy("Build window tree.");
	report_strategy("Create second client.");
	report_strategy("Enable SubstructureRedirect for second client on new parent.");
	report_strategy("Reparent window with XReparentWindow.");
	report_strategy("Verify that MapRequest is received for second client on parent.");

	reparentinit();
	setargs();
	parent = WinA;
	w = WinB;

	XSelectInput(display, parent, SubstructureNotifyMask);
	XSelectInput(display, w, StructureNotifyMask);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	defsetevent(good, display, MapNotify);
	good.window = w;
	good.override_redirect = False;

	got = 0;
	while (getevent(display, &ev)) {
		if (ev.type != MapNotify)
			continue;
		mp = (XMapEvent*)&ev;
		if (mp->event == mp->window) {
			/* On the window itself */
			if (got & ON_WINDOW) {
				report("Repeated map event on window");
				FAIL;
			} else
				CHECK;
			got |= ON_WINDOW;
			good.event = WinB;
		} else {
			if (got & ON_NEWPARENT) {
				report("Repeated map event on parent window");
				FAIL;
			} else
				CHECK;
			got |= ON_NEWPARENT;
			good.event = WinA;
		}
		if (checkevent((XEvent*)&good, &ev))
			FAIL;
		else
			CHECK;
	}

	if (!(got & ON_NEWPARENT)) {
		report("MapNotify event not received on parent window");
		FAIL;
	} else
		CHECK;
	if (!(got & ON_WINDOW)) {
		report("MapNotify event not received on window");
		FAIL;
	} else
		CHECK;

	if (isdeleted())
		return;

	client2 = opendisplay();
	XSelectInput(client2, parent, SubstructureRedirectMask);
	XSync(client2, True);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

	defsetevent(mreqgood, client2, MapRequest);
	mreqgood.parent = parent;
	mreqgood.window = WinB;

	n =  getevent(client2, &ev);
	if (n != 1) {
		report("Expecting one MapRequest event, got %d events", n);
		FAIL;
	} else
		CHECK;
	if (ev.type != MapRequest) {
		report("Expecting one MapRequest event, got event type %s", eventname(ev.type));
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&mreqgood, &ev))
		FAIL;
	else
		CHECK;

	CHECKPASS(9);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XReparentWindow-6.(A)");
	report_assertion("When a call to XReparentWindow uncovers part of any window");
	report_assertion("that was formerly obscured, then either Expose events are");
	report_assertion("generated or the contents are restored from backing store.");

	report_strategy("Build window tree.");
	report_strategy("Use WinB as old parent and B1 and window.");
	report_strategy("Enable expose events on old parent window.");
	report_strategy("Set up old parent window with setforexpose.");
	report_strategy("Call XReparentWindow to reparent window.");
	report_strategy("Verify correct expose processing with checkexpose().");

	reparentinit();
	setargs();
	parent = WinA;
	w = btntow(Tree, "B1");

	XSelectInput(display, WinB, ExposureMask);
	setforexpose(display, WinB);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (exposecheck(display, WinB))
		CHECK;
	else {
		report("Contents of window not restored correctly by Expose or backing store");
		FAIL;
	}

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.27518 */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XReparentWindow-7.(B)");
	report_assertion("A call to XReparentWindow may generate Expose events for");
	report_assertion("regions uncovered by the initial UnmapWindow request that");
	report_assertion("are immediately obscured by the final MapWindow request.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.27518 */

static void t008(){

Window	w;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XReparentWindow-8.(C)");
	report_assertion("If multiple screens are supported: When the new parent");
	report_assertion("window is not on the same screen as the old parent window,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("If multiple screens supported");
	report_strategy("  Create window on default screen.");
	report_strategy("  Create a new parent window on alternate screen.");
	report_strategy("  Attempt to reparent to alternate screen.");
	report_strategy("  Verify BadMatch error occurs.");
	report_strategy("else");
	report_strategy("  UNSUPPORTED");

	tpstartup();
	setargs();
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported");
		return;
	}

	w = defwin(display);
	parent = defdraw(display, VI_ALT_WIN);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XReparentWindow-9.(A)");
	report_assertion("When the new parent window is the specified window, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Create window.");
	report_strategy("Call XReparentWindow with both window parameters set to this window.");
	report_strategy("Verify BadMatch error.");

	tpstartup();
	setargs();
	w = defwin(display);
	parent = w;

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XReparentWindow-10.(A)");
	report_assertion("When the new parent window is an inferior of the specified");
	report_assertion("window, then a BadMatch error occurs.");

	report_strategy("Build window tree.");
	report_strategy("Set w.");
	report_strategy("Set parent to an inferior of w.");
	report_strategy("Call XReparentWindow.");
	report_strategy("Verify that a BadMatch error occurs.");

	reparentinit();
	setargs();
	w = WinA;
	parent = btntow(Tree, "A1");

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

XVisualInfo	*vp;
unsigned int	depth;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XReparentWindow-11.(C)");
	report_assertion("If multiple window depths are supported: When the specified");
	report_assertion("window has a ParentRelative background, and the new parent");
	report_assertion("window does not have the same depth as the specified window,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("If only one window depth is supported");
	report_strategy("  UNSUPPORTED");
	report_strategy("Create window.");
	report_strategy("Set background to parent relative.");
	report_strategy("Create new parent window with depth not equal to window.");
	report_strategy("Call XReparentWindow.");
	report_strategy("Verify that BadMatch error occurs.");

	reparentinit();
	setargs();
	depth = DefaultDepth(display, DefaultScreen(display));
	for (resetvinf(VI_WIN); nextvinf(&vp); ) {
		if (!w && vp->depth == depth) {
			w = makewin(display, vp);
			if (parent)
				break;
		} else if (!parent && vp->depth != depth) {
			parent = makewin(display, vp);
			if (w)
				break;
		}
	}

	if (!parent) {
		unsupported("Only one depth window supported");
		return;
	}

	/*
	 * At the time of writing we do not have a machine on which
	 * the following code can be tested.
	 */
	XSetWindowBackgroundPixmap(display, w, ParentRelative);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XReparentWindow-12.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	reparentinit();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	seterrdef();
	A_WINDOW2 = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XReparentWindow-13.(A)");
	report_assertion("When the new parent is InputOnly and the window is");
	report_assertion("InputOutput, then a BadMatch error occurs.");

	report_strategy("Create an InputOnly window as the parent.");
	report_strategy("Create window.");
	report_strategy("Call XReparentWindow.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	parent = iponlywin(display);
	w = defwin(display);

	startcall(display);
	if (isdeleted())
		return;
	XReparentWindow(display, w, parent, x, y);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;	/* already done */
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
