/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XChangeGC(display, gc, valuemask, values)
 *   Display		*display;
 *   GC		gc;
 *   unsigned 	long valuemask;
 *   XGCValues	*values;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XChangeGC	1
char    *TestName = "XChangeGC";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_GC gc


/*
 * Arguments to the XChangeGC function
 */
static Display		*display;
static GC		gc;
static unsigned 	long valuemask;
static XGCValues	*values;


XGCValues	srcgcv = { GXxor, AllPlanes, 0, 1, 0, LineSolid, CapButt,
			   JoinMiter, FillSolid, EvenOddRule, ArcPieSlice,
			   None, };

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	gc = 0;
	valuemask = GCTile;
	values = &srcgcv;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	gc = ErrdefGC;
}

static void t001(){

XVisualInfo	*vp;
Window		win;
XGCValues	gcv;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XChangeGC-1.(A)");
	report_assertion("A call to XChangeGC changes the components specified by the");
	report_assertion("valuemask argument in the specified GC to the values in the");
	report_assertion("values argument.");

	report_strategy("Create a GC fg = W_FG, bg = W_BG, function = GXCopy.");
	report_strategy("Change the function component of the GC to GXxor using XChangeGC.");
	report_strategy("Plot point (0,0) with XDrawPoint.");
	report_strategy("Set fg to W_FG ^ W_BG using XChangeGC.");
	report_strategy("Plot point (0,0) with XDrawPoint.");
	report_strategy("Verify that pixel at (0,0) is W_BG.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);
	gc = makegc(display, win);
	
	gcv.function = GXxor;
	valuemask = GCFunction;
	values = &gcv;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XDrawPoint(display, win, gc, 0, 0);
	XSetForeground(display, gc, W_FG ^ W_BG);
	XDrawPoint(display, win, gc, 0, 0);

	if( ! checkpixel(display, win, 0, 0, W_BG) ) {
		report("The GC function component was not set to GXxor");
		report("by a call to XChangeGC");
		FAIL;
	} else
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
XGCValues   srcgcv;
GC gc;
Window win;
XImage	*im;
XRectangle *rectangles;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XChangeGC-2.(A)");
	report_assertion("When a call to XChangeGC changes the clip-mask component of");
	report_assertion("gc, then any previous XSetClipRectangles request on the");
	report_assertion("specified GC is overridden.");

	report_strategy("Create a GC.");
	report_strategy("Draw line from (0, 0) to (100, 0) using XDrawLine.");
	report_strategy("Save image on drawable using XGetImage.");
	report_strategy("Clear drawable.");
	report_strategy("Change the clip_mask component of the GC using XSetClipRectangles.");
	report_strategy("Draw line from (0, 0) to (100, 0) using XDrawLine.");
	report_strategy("Verify using XGetImage that the image on the drawable is altered.");
	report_strategy("Change the GC clip_mask component using XChangeGC to original.");
	report_strategy("Draw line from (0, 0) to (100, 0) using XDrawLine.");
	report_strategy("Verify using XGetImage that the image is restored.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);

	srcgcv.foreground = W_FG;
	srcgcv.line_width = 10;
	srcgcv.clip_mask = None;

	/* Create a GC. */
	gc = XCreateGC(display, win, (GCClipMask | GCLineWidth | GCForeground),
								 &srcgcv);

	/* Draw line from (0, 0) to (100, 0) using XDrawLine. */
	XDrawLine(display, win, gc, 0, 0, 100, 0);

	/* Save image on drawable using XGetImage. */
	im = savimage(display, win);

	/* Clear drawable. */
	dclear(display, win);

	/* Change the clip_mask component of the GC using XSetClipRectangles. */
	XSetClipRectangles(display, gc, 0, 0, rectangles, 0, Unsorted);

	/* Draw line from (0, 0) to (100, 0) using XDrawLine. */
	XDrawLine(display, win, gc, 0, 0, 100, 0);

	/* Verify using XGetImage that the image on the drawable is altered. */
	if(diffsavimage(display, win, im)) {
		delete("XSetClipRectangles did not set clip_mask component of GC");
		return;
	} else
		CHECK;

	/* Change the GC clip_mask component using XChangeGC to original. */
	srcgcv.clip_mask = None;
	values = &srcgcv;
	valuemask = GCClipMask;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* Draw line from (0, 0) to (100, 0) using XDrawLine. */
	XDrawLine(display, win, gc, 0, 0, 100, 0);

	/* Verify using XGetImage that the image is restored. */
	if( ! compsavimage(display, win, im)) {
		report("XChangeGC with GCClipMask did not override call to XSetClipRectangles");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo *vp;
XGCValues   srcgcv;
GC gc;
Window win;
XImage	*im;
static char	dashes[] = {20, 10};
static char	odashes[] = {10, 10};
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XChangeGC-3.(A)");
	report_assertion("When a call to XChangeGC changes the dash-offset or dashes");
	report_assertion("component of gc, then any previous XSetDashes request on the");
	report_assertion("specified GC is overridden.");

	report_strategy("Create a GC.");
	report_strategy("Draw dashed line from (0, 0) to (100, 0) using XDrawLine.");
	report_strategy("Save image on drawable using XGetImage.");
	report_strategy("");
	report_strategy("Part 1. Verify cancelling when GCDashList is used.");
	report_strategy("Change the dashes component of the GC");
	report_strategy("Draw dashed line from (0, 0) to (100, 0) using XDrawLine.");
	report_strategy("Verify using XGetImage that XSetDashes altered image on drawable.");
	report_strategy("Change the GC dashes component using XChangeGC to original value.");
	report_strategy("Draw dashed line from (0, 0) to (100, 0) using XDrawLine.");
	report_strategy("Verify using XGetImage that the image is as before XSetDashes.");
	report_strategy("");
	report_strategy("Part 2. Verify cancelling when GCDashOffset is used.");
	report_strategy("Change the dash_offset component of the GC using XSetDashes.");
	report_strategy("Draw dashed line from (0, 0) to (100, 0) using XDrawLine.");
	report_strategy("Verify using XGetImage that XSetDashes altered image on drawable.");
	report_strategy("Change the GC dash_offset component using XChangeGC to original value.");
	report_strategy("Draw dashed line from (0, 0) to (100, 0) using XDrawLine.");
	report_strategy("Verify using XGetImage that the image is as before XSetDashes.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);

	srcgcv.foreground = W_FG;
	srcgcv.background = W_BG;
	srcgcv.line_style = LineDoubleDash;
	srcgcv.line_width = 10;
	srcgcv.dashes = 10;
	srcgcv.dash_offset = 0;

	/* Create a GC. */
	gc = XCreateGC(display, win, (GCLineWidth | GCLineStyle | GCDashOffset |
			GCDashList | GCForeground | GCBackground), &srcgcv);

	/* Draw dashed line from (0, 0) to (100, 0) using XDrawLine. */
	XDrawLine(display, win, gc, 0, 0, 100, 0);

	/* Save image on drawable using XGetImage. */
	im = savimage(display, win);

	/* Part 1. Verify cancelling when GCDashList is used. */
	/* Change the dashes component of the GC */
	XSetDashes(display, gc, 0, dashes, sizeof(dashes)/sizeof(char));

	/* Draw dashed line from (0, 0) to (100, 0) using XDrawLine. */
	XDrawLine(display, win, gc, 0, 0, 100, 0);

	/* Verify using XGetImage that XSetDashes altered image on drawable. */
	if(diffsavimage(display, win, im)) {
		delete("XSetDashes did not set dashes component of GC");
		return;
	} else
		CHECK;

	/* Change the GC dashes component using XChangeGC to original value. */
	srcgcv.dashes = 10;
	values = &srcgcv;
	valuemask = GCDashList;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* Draw dashed line from (0, 0) to (100, 0) using XDrawLine. */
	XDrawLine(display, win, gc, 0, 0, 100, 0);

	/* Verify using XGetImage that the image is as before XSetDashes. */
	if( ! compsavimage(display, win, im)) {
		report("XChangeGC with GCDashList did not override call to XSetDashes");
		FAIL;
	} else
		CHECK;

	/* Part 2. Verify cancelling when GCDashOffset is used. */
	/* Change the dash_offset component of the GC using XSetDashes. */
	XSetDashes(display, gc, 5, odashes, sizeof(odashes)/sizeof(char));

	/* Draw dashed line from (0, 0) to (100, 0) using XDrawLine. */
	XDrawLine(display, win, gc, 0, 0, 100, 0);

	/* Verify using XGetImage that XSetDashes altered image on drawable. */
	if(diffsavimage(display, win, im)) {
		delete("XSetDashes did not set dash_offset component of GC");
		return;
	} else
		CHECK;

	/* Change the GC dash_offset component using XChangeGC to original value. */
	srcgcv.dash_offset = 0;
	values = &srcgcv;
	valuemask = GCDashOffset;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* Draw dashed line from (0, 0) to (100, 0) using XDrawLine. */
	XDrawLine(display, win, gc, 0, 0, 100, 0);

	/* Verify using XGetImage that the image is as before XSetDashes. */
	if( ! compsavimage(display, win, im)) {
		report("XChangeGC with GCDashOffset did not override call to XSetDashes");
		FAIL;
	} else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EGC.mc */
/* End of included file error/EGC.mc */

/* Including from file error/EGC.mc */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XChangeGC-4.(A)");
	report_assertion("When the GC argument does not name a defined GC, then a");
	report_assertion("BadGC error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Set GC id to -1 using XTestSetGContextOfGC.");
	report_strategy("Call test function using bad GC as the GC argument.");
	report_strategy("Verify that a BadGC error occurs.");

	tpstartup();
	setargs();
	seterrdef();


	A_GC = badgc(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadGC) {
		report("Got %s, Expecting BadGC", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadGC)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EGC.mc */

static void t005(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XChangeGC-5.(A)");
	report_assertion("When the font does not name a valid font, and the GCFont");
	report_assertion("bit is set in valuemask, then a BadFont error occurs.");

	report_strategy("Create a font for the default screen and free font with XFreeFont.");
	report_strategy("Create a GC with root window as the drawable.");
	report_strategy("Change GC using XChangeGC with bad font as the font component.");
	report_strategy("Verify that a BadFont error occurs. ");

	tpstartup();
	setargs();
	vals.font = badfont(Dsp);

	gc = makegc(display, DRW(display));
	values = &vals;
	valuemask = GCFont;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadFont) {
		report("Got %s, Expecting BadFont", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadFont) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XChangeGC-6.(A)");
	report_assertion("When the tile does not name a valid pixmap, and the GCTile");
	report_assertion("bit is set in valuemask, then a BadPixmap error occurs.");

	report_strategy("Create a bad pixmap for the root window and free pixmap with XFreePixmap.");
	report_strategy("Create a GC with window as the drawable.");
	report_strategy("Change GC using XChangeGC with pixmap as the tile.");
	report_strategy("Verify that a BadPixmap error occurs. ");

	tpstartup();
	setargs();
	vals.tile = badpixm(display);

	gc = makegc(display, DRW(display));
	values = &vals;
	valuemask = GCTile;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadPixmap) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XChangeGC-7.(A)");
	report_assertion("When the stipple does not name a valid pixmap, and the");
	report_assertion("GCStipple bit is set in valuemask, then a BadPixmap error");
	report_assertion("occurs.");

	report_strategy("Create a bad pixmap for the root window and free pixmap with XFreePixmap.");
	report_strategy("Create a GC with window as the drawable.");
	report_strategy("Change GC using XChangeGC with pixmap as the stipple.");
	report_strategy("Verify that a BadPixmap error occurs. ");

	tpstartup();
	setargs();
	vals.stipple = badpixm(display);

	gc = makegc(display, DRW(display));
	values = &vals;
	valuemask = GCStipple;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadPixmap) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XChangeGC-8.(A)");
	report_assertion("When the clip-mask does not name a valid pixmap, or None,");
	report_assertion("and the GCClipMask bit is set in valuemask, then a");
	report_assertion("BadPixmap error occurs.");

	report_strategy("Create a bad pixmap for the root window and free pixmap with XFreePixmap.");
	report_strategy("Create a GC with window as the drawable.");
	report_strategy("Change GC using XChangeGC with pixmap as the clip_mask.");
	report_strategy("Verify that a BadPixmap error occurs. ");

	tpstartup();
	setargs();
	vals.clip_mask = badpixm(display);

	gc = makegc(display, DRW(display));
	values = &vals;
	valuemask = GCClipMask;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadPixmap)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int		count;
XGCValues 	vals;
XVisualInfo	*vp;
Drawable	d;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XChangeGC-9.(C)");
	report_assertion("When the graphics context and the tile pixmap do not have");
	report_assertion("the same depth, and the GCTile bit is set in valuemask,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("For all non-depth1 drawables:");
	report_strategy("	Created such a drawable.");
	report_strategy("	Create a depth 1 pixmap.");
	report_strategy("	Create a GC with window as the drawable.");
	report_strategy("	Change GC using XChangeGC with pixmap as the tile.");
	report_strategy("	Verify that a BadMatch error occurs. ");

	tpstartup();
	setargs();
	count = 0;
	vals.tile = XCreatePixmap(display, DRW(display), 1,1,1);
	valuemask = GCTile;
	values = &vals;
	for(resetvinf(VI_WIN); nextvinf(&vp);)
		if(vp->depth != 1) {
			trace("Testing a window of depth %d",vp->depth);
			count++;
			d = makewin(display, vp);
			gc = makegc(display, d);
			startcall(display);
			if (isdeleted())
				return;
			XChangeGC(display, gc, valuemask, values);
			gcflush(A_DISPLAY, A_GC);
			endcall(display);
			if (geterr() != BadMatch) {
				report("Got %s, Expecting BadMatch", errorname(geterr()));
				FAIL;
			}
			if(geterr() == BadMatch)
				CHECK;
			else
				FAIL;
		}

	for(resetvinf(VI_PIX); nextvinf(&vp);)
		if(vp->depth != 1) {
			trace("Testing a window of depth %d",vp->depth);
			count++;
			d = makepixm(display, vp);
			gc = makegc(display, d);
			startcall(display);
			if (isdeleted())
				return;
			XChangeGC(display, gc, valuemask, values);
			gcflush(A_DISPLAY, A_GC);
			endcall(display);
			if (geterr() != BadMatch) {
				report("Got %s, Expecting BadMatch", errorname(geterr()));
				FAIL;
			}
			if(geterr() == BadMatch)
				CHECK;
			else
				FAIL;
		}


	if(count == 0) {
		tet_result(TET_UNSUPPORTED);
		report("Only depth one drawables are supported.");
		return;
	} else
		CHECKPASS(count);

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

char    *altroot;
int     scr_num;
XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XChangeGC-10.(A)");
	report_assertion("When the graphics context and the tile pixmap were not");
	report_assertion("created for the same root, and the GCTile bit is set in");
	report_assertion("valuemask, then a BadMatch error occurs.");

	report_strategy("If multiple roots are supported:");
	report_strategy("	Create a pixmap for one root.");
	report_strategy("	Create a GC for another root ");
	report_strategy("	Change GC using XChangeGC with pixmap as the tile component.");
	report_strategy("	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	altroot = tet_getvar("XT_ALT_SCREEN");
	if (altroot == NULL) {
		delete("XT_ALT_SCREEN not set");
		return;
	}
	if (*altroot == 'U') {
		report("Only one screen supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	scr_num = atoi(altroot);
	if (scr_num == DefaultScreen(display)) {
		delete("The Alternate root was the same as the one under test");
		return;
	}
	if (scr_num >= ScreenCount(display)) {
		delete("Screen given in XT_ALT_SCREEN could not be accessed");
		return;
	}

	/*
	 * Create a 1x1 depth 1 pixmap on other screen
	 * and use it to create a gc
	 */
	
	vals.tile =  XCreatePixmap(display, RootWindow(display, scr_num), 1, 1, 1);
	gc = makegc(display, DRW(display));
	values = &vals;
	valuemask = GCTile;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XChangeGC-11.(C)");
	report_assertion("When the stipple pixmap does not have depth one, and the");
	report_assertion("GCStipple bit is set in valuemask, then a BadMatch error");
	report_assertion("occurs.");

	report_strategy("If pixmaps with depth other than one are supported:");
	report_strategy("	Create a pixmap with depth other than one.");
	report_strategy("  	Create a GC ");
	report_strategy("	Change GC using XChangeGC with the pixmap as the stipple component.");
	report_strategy("  	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	if((vals.stipple = nondepth1pixmap(display, DRW(display))) == (Pixmap) 0) {
		tet_result(TET_UNSUPPORTED);
		report("Only depth 1 pixmaps are supported.");
		return;
	} else
		CHECK;

	gc = makegc(display, DRW(display));
	values = &vals;
	valuemask = GCStipple;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	
	if(geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

char    *altroot;
int     scr_num;
XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XChangeGC-12.(C)");
	report_assertion("When the graphics context and the stipple pixmap were not");
	report_assertion("created for the same root, and the GCStipple bit is set in");
	report_assertion("valuemask, then a BadMatch error occurs.");

	report_strategy("If multiple roots are supported:");
	report_strategy("	Create a pixmap for one root.");
	report_strategy("	Create a GC for another root ");
	report_strategy("	Change GC using XChangeGC with pixmap as the stipple component.");
	report_strategy("  	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	altroot = tet_getvar("XT_ALT_SCREEN");
	if (altroot == NULL) {
		delete("XT_ALT_SCREEN not set");
		return;
	}
	if (*altroot == 'U') {
		report("Only one screen supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	scr_num = atoi(altroot);
	if (scr_num == DefaultScreen(display)) {
		delete("The Alternate root was the same as the one under test");
		return;
	}
	if (scr_num >= ScreenCount(display)) {
		delete("Screen given in XT_ALT_SCREEN could not be accessed");
		return;
	}

	/*
	 * Create a 1x1 depth 1 pixmap on other screen
	 * and use it to create a gc
	 */
	
	vals.stipple = XCreatePixmap(display, RootWindow(display, scr_num), 1, 1, 1);
	gc = makegc(display, DRW(display));
	values = &vals;
	valuemask = GCStipple;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

XGCValues vals;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XChangeGC-13.(C)");
	report_assertion("When the clip-mask is set to a pixmap, and the clip-mask");
	report_assertion("does not have depth one, and the GCClipMask bit is set in");
	report_assertion("valuemask, then a BadMatch error occurs.");

	report_strategy("If pixmaps with depth other than one are supported:");
	report_strategy("	Create a pixmap with depth other than one.");
	report_strategy("  	Create a GC ");
	report_strategy("	Change GC using XChangeGC with the pixmap as the clip_mask component.");
	report_strategy("  	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	if((vals.clip_mask = nondepth1pixmap(display, DRW(display))) == (Pixmap) 0) {
		tet_result(TET_UNSUPPORTED);
		report("Only depth 1 pixmaps are supported.");
		return;
	} else
		CHECK;

	gc = makegc(display, DRW(display));
	values = &vals;
	valuemask = GCClipMask;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

char    *altroot;
int     scr_num;
XGCValues	vals;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XChangeGC-14.(C)");
	report_assertion("When the clip-mask is set to a pixmap, and the graphics");
	report_assertion("context and the clip-mask were not created for the same");
	report_assertion("root, and the GCClipMask bit is set in valuemask, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("If multiple roots are supported:");
	report_strategy("	Create a pixmap for one root.");
	report_strategy("	Create a GC for another root ");
	report_strategy("	Change GC using XChangeGC with the pixmap as the clip_mask component.");
	report_strategy("  	Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	altroot = tet_getvar("XT_ALT_SCREEN");
	if (altroot == NULL) {
		delete("XT_ALT_SCREEN not set");
		return;
	}
	if (*altroot == 'U') {
		report("Only one screen supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	scr_num = atoi(altroot);
	if (scr_num == DefaultScreen(display)) {
		delete("The Alternate root was the same as the one under test");
		return;
	}
	if (scr_num >= ScreenCount(display)) {
		delete("Screen given in XT_ALT_SCREEN could not be accessed");
		return;
	}

	/*
	 * Create a 1x1 depth 1 pixmap on other screen
	 * and use it to create a gc
	 */

	vals.clip_mask = XCreatePixmap(display, RootWindow(display, scr_num), 1, 1, 1);
	gc = makegc(display, DRW(display));
	values = &vals;
	valuemask = GCClipMask;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

XGCValues srcgcv;
int i;
unsigned char *p;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XChangeGC-15.(A)");
	report_assertion("When the valuemask argument is other than a bitwise OR of");
	report_assertion("none or any of GCFunction, GCPlaneMask, GCForeground,");
	report_assertion("GCBackground, GCLineWidth, GCLineStyle, GCCapStyle,");
	report_assertion("GCJoinStyle, GCFillStyle, GCFillRule, GCTile, GCStipple,");
	report_assertion("GCTileStipXOrigin, GCTileStipYOrigin, GCFont,");
	report_assertion("GCSubWindowMode, GCGraphicsExposures, GCClipXOrigin,");
	report_assertion("GCClipYOrigin, GCClipMask, GCDashOffset, GCDashList, or");
	report_assertion("GCArcMode, then a BadValue error occurs.");

	report_strategy("Create a gc ");
	report_strategy("Change GC using XChangeGC with function component GXcopy ");
	report_strategy("    and foreground component = 1 using a mask of GCFunction | GCForeground | ");
	report_strategy("    ~(GCFunction | GCPlaneMask | GCForeground | GCBackground |");
	report_strategy("    GCLineWidth | GCLineStyle | GCCapStyle | GCJoinStyle |");
	report_strategy("    GCFillStyle | GCFillRule | GCTile | GCStipple |");
	report_strategy("    GCTileStipXOrigin | GCTileStipYOrigin | GCFont | GCSubwindowMode |");
	report_strategy("    GCGraphicsExposures | GCClipXOrigin | GCClipYOrigin | GCClipMask |");
	report_strategy("    GCDashOffset | GCDashList | GCArcMode)");
	report_strategy("Verify that a bad value error occurred.");

	tpstartup();
	setargs();
	i = sizeof(XGCValues);
	p = (unsigned char *)&srcgcv;
	while( i-- > 0 )
		*p++ = 0xff;

	gc = makegc(display, DRW(display));
	values = &srcgcv;
	srcgcv.foreground = 1;
	srcgcv.function = ~0;
	valuemask = GCFunction | GCForeground | ~(GCFunction | GCPlaneMask | GCForeground | GCBackground |
		    GCLineWidth | GCLineStyle | GCCapStyle | GCJoinStyle |
		    GCFillStyle | GCFillRule | GCTile | GCStipple |
		    GCTileStipXOrigin | GCTileStipYOrigin | GCFont | GCSubwindowMode |
		    GCGraphicsExposures | GCClipXOrigin | GCClipYOrigin | GCClipMask |
		    GCDashOffset | GCDashList | GCArcMode);
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadValue)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XChangeGC-16.(A)");
	report_assertion("When the function is other than GXclear, GXand,");
	report_assertion("GXandReverse, GXcopy, GXandInverted, GXnoop, GXxor,");
	report_assertion("GXor, GXnor, GXequiv, GXinvert, GXorReverse,");
	report_assertion("GXcopyInverted, GXorInverted, GXnand or GXset, and the");
	report_assertion("GCFunction bit is set in valuemask, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC function to GXclear + GXand + GXandReverse + GXcopy + ");
	report_strategy("			GXandInverted + GXnoop + GXxor + GXor + GXnor + ");
	report_strategy("			GXequiv + GXinvert + GXorReverse +");
	report_strategy("			GXcopyInverted + GXorInverted + GXnand + GXset + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	gc = makegc(display, DRW(display));
	srcgcv.function = GXclear + GXand + GXandReverse + GXcopy + 
			GXandInverted + GXnoop + GXxor + GXor + GXnor + 
			GXequiv + GXinvert + GXorReverse +
			GXcopyInverted + GXorInverted + GXnand + GXset + 1;
	values = &srcgcv;
	valuemask = GCFunction;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XChangeGC-17.(A)");
	report_assertion("When the line_style is other than LineSolid,");
	report_assertion("LineDoubleDash or LineOnOffDash, and the GCLineStyle bit is");
	report_assertion("set in valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC line_style to LineSolid + LineDoubleDash + LineOnOffDash + 1;");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	gc = makegc(display, DRW(display));
	srcgcv.line_style = LineSolid + LineDoubleDash + LineOnOffDash + 1;
	values = &srcgcv;
	valuemask = GCLineStyle;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t018(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(18);

	report_assertion("Assertion XChangeGC-18.(A)");
	report_assertion("When the cap_style is other than CapNotLast, CapButt,");
	report_assertion("CapRound or CapProjecting, and the GCCapStyle bit is set in");
	report_assertion("valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC cap_style to CapNotLast + CapButt + CapRound + CapProjecting + 1");
	report_strategy("Verify that a BadValue error occurred");

	tpstartup();
	setargs();
	gc = makegc(display, DRW(display));
	srcgcv.cap_style = CapNotLast + CapButt + CapRound + CapProjecting + 1;
	values = &srcgcv;
	valuemask = GCCapStyle;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t019(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(19);

	report_assertion("Assertion XChangeGC-19.(A)");
	report_assertion("When the join_style is other than JoinMiter, JoinRound or");
	report_assertion("JoinBevel, and the GCJoinStyle bit is set in valuemask,");
	report_assertion("then a BadValue error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC join_style to JoinMiter + JoinRound + JoinBevel + 1");
	report_strategy("Verify that a BadValue error occurs");

	tpstartup();
	setargs();
	gc = makegc(display, DRW(display));
	srcgcv.join_style = JoinMiter + JoinRound + JoinBevel + 1;
	values = &srcgcv;
	valuemask = GCJoinStyle;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t020(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(20);

	report_assertion("Assertion XChangeGC-20.(A)");
	report_assertion("When the fill_style is other than FillSolid, FillTiled,");
	report_assertion("FillStippled or FillOpaqueStippled, and the GCFillStyle bit");
	report_assertion("is set in valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC fill_style to FillSolid + FillTiled + FillStippled + FillOpaqueStippled + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	gc = makegc(display, DRW(display));
	srcgcv.fill_style = FillSolid + FillTiled + FillStippled + FillOpaqueStippled + 1;
	values = &srcgcv;
	valuemask = GCFillStyle;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t021(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(21);

	report_assertion("Assertion XChangeGC-21.(A)");
	report_assertion("When the fill_rule is other than EvenOddRule or WindingRule,");
	report_assertion("and the GCFillRule bit is set in valuemask, then a BadValue");
	report_assertion("error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC fill_rule to EvenOddRule + WindingRule + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	gc = makegc(display, DRW(display));
	srcgcv.fill_rule = EvenOddRule + WindingRule + 1;
	values = &srcgcv;
	valuemask = GCFillRule;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t022(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(22);

	report_assertion("Assertion XChangeGC-22.(A)");
	report_assertion("When arc_mode is other than ArcChord or ArcPieSlice, and");
	report_assertion("the GCArcMode bit is set in valuemask, then a BadValue");
	report_assertion("error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC arc_mode to ArcChord + ArcPieSlice + 1.");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	gc = makegc(display, DRW(display));
	srcgcv.arc_mode = ArcChord + ArcPieSlice + 1;
	values = &srcgcv;
	valuemask = GCArcMode;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t023(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(23);

	report_assertion("Assertion XChangeGC-23.(A)");
	report_assertion("When the subwindow_mode is other than ClipByChildren or");
	report_assertion("IncludeInferiors, and the GCSubwindowMode bit is set in");
	report_assertion("valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC subwindow_mode to ClipByChildren + IncludeInferiors + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	gc = makegc(display, DRW(display));
	srcgcv.subwindow_mode = ClipByChildren + IncludeInferiors + 1;
	values = &srcgcv;
	valuemask = GCSubwindowMode;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t024(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(24);

	report_assertion("Assertion XChangeGC-24.(A)");
	report_assertion("When graphics_exposure is other than True or False, and");
	report_assertion("the GCGraphicsExposures bit is set in valuemask, then a");
	report_assertion("BadValue error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC graphics_exposures component to (int) False + (int) True + 1");
	report_strategy("Verify that a BadValue error occurred.");

	tpstartup();
	setargs();
	gc = makegc(display,DRW(display));
	srcgcv.graphics_exposures = (int) False + (int) True + 1;
	values = &srcgcv;
	valuemask = GCGraphicsExposures;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);


	tpcleanup();
	pfcount(pass, fail);
}

static void t025(){

XGCValues srcgcv;
int 	pass = 0, fail = 0;

 	report_purpose(25);

	report_assertion("Assertion XChangeGC-25.(A)");
	report_assertion("When dashes is set to zero, and the GCDashList bit is set");
	report_assertion("in valuemask, then a BadValue error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Change GC using XChangeGC with dashes component = 0");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	gc = makegc(display, DRW(display));
	srcgcv.dashes = (char) 0;
	values = &srcgcv;
	valuemask = GCDashList;
	startcall(display);
	if (isdeleted())
		return;
	XChangeGC(display, gc, valuemask, values);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if( geterr() == BadValue) 
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ t019, 19 },
	{ t020, 20 },
	{ t021, 21 },
	{ t022, 22 },
	{ t023, 23 },
	{ t024, 24 },
	{ t025, 25 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = fontstartup;
void	(*tet_cleanup)() = fontcleanup;
