/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels)
 *   Display *display;
 *   Colormap colormap;
 *   Bool contig;
 *   unsigned long *plane_masks_return;
 *   unsigned int nplanes;
 *   unsigned long *pixels_return;
 *   unsigned int npixels;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XAllocColorCells	1
char    *TestName = "XAllocColorCells";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XAllocColorCells function
 */
static Display *display;
static Colormap colormap;
static Bool contig;
static unsigned long *plane_masks_return;
static unsigned int nplanes;
static unsigned long *pixels_return;
static unsigned int npixels;


static int 	StatusReturn;

#define lowbit(x)	((x) & (~(x) + 1))
#define bitcontig(x)	((((x) + lowbit(x)) & (x)) == 0)
#define bitsubset(a,b)	(((a) & (b)) == (a))



/* Value list for use in test t009 */
static int 	contigvallist[] = {
	True,
	False,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = 0;
	contig = 0;
	plane_masks_return = 0;
	nplanes = 0;
	pixels_return = 0;
	npixels = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	colormap = ErrdefColormap;
}

static void t001(){

XVisualInfo *vp;
XColor color, qcolor;
Status status;
unsigned long vmask, mask, planemask;
int i, j, k, cells;
int pathcnt;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XAllocColorCells-1.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor, or");
	report_assertion("GrayScale is supported: A call to XAllocColorCells allocates");
	report_assertion("npixels*2pow(nplanes) read/write colourmap entries whose");
	report_assertion("indices in the colourmap are obtained by ORing each pixel");
	report_assertion("value returned in the pixels_return argument with zero or");
	report_assertion("more of the planes returned in the plane_mask argument.");

	report_strategy("For each visual class DirectColor, PseudoColor and GrayScale:");
	report_strategy("  Create a colormap.");
	report_strategy("  Allocate all colors and no planemasks with XAllocColorCells.");
	report_strategy("  Verify the correct number of cells have been allocated by initialising ");
	report_strategy("    them with XStoreColors, and reading them with XQueryColors.");
	report_strategy("  Allocate planes and masks such that lg(colors) + planes = lg(colormap_size)");
	report_strategy("  Verify the correct number of cells have been allocated by initialising ");
	report_strategy("    them with XStoreColors, and reading them with XQueryColors.");

	tpstartup();
	setargs();
#define RW_COLORMAP_MASK ((1L<<DirectColor) | (1L<<PseudoColor) | (1L<<GrayScale))

	if( (vmask = visualsupported(display, RW_COLORMAP_MASK)) == 0L) {
		unsupported("DirectColor, PseudoColor and GrayScale are not supported");
		return;
	}

	contig = False;
	color.red = 1<<8;
	color.green = 2<<8;
	color.blue = 3<<8;
	color.flags = DoRed | DoGreen | DoBlue;

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting XAllocColorCells() for class %s", displayclassname(vp->class));

		/* Test that we can allocate the entire colormap, nplanes = 0 */

		colormap = makecolmap(display, vp -> visual, AllocNone);
		nplanes = 0;
		npixels = maxsize(vp);
		plane_masks_return = (unsigned long *) 0;
		pixels_return = (unsigned long *) malloc( npixels * sizeof(unsigned long));
		trace("Testing XAllocColorCells with %u colors and %u planes", npixels, nplanes);
		if(pixels_return == (unsigned long *) 0) {
			delete("Malloc failed to allocate memory for pixels return value.");
			return;
		}

		for(j=0; j<npixels; j++)
			pixels_return[j] = npixels+1;

		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if(status == (Status) 0) {
			report("%s failed to return non-zero", TestName);
			report("allocating all %d cells with visual class %s.",
				 npixels, displayclassname(vp->class));
			FAIL;
			continue;
		} else
			CHECK;

		for(pathcnt = 0, j=0; j < npixels; j++) {
			color.pixel = pixels_return[j];
			startcall(display);
			XStoreColor(display, colormap, &color);
			endcall(display);
			if(geterr() != Success) {
				report("XStoreColor() failed (%s) to store pixel value %lu in colormap of class %s", errorname(geterr()), color.pixel, displayclassname(vp->class));
				FAIL;
			} else {
				qcolor.pixel = pixels_return[j];
				startcall(display);
				XQueryColor(display, colormap, &qcolor);
				endcall(display);
				if(geterr() != Success) {
					report("XQueryColor() failed (%s) to return pixel value %lu in colormap of class %s", errorname(geterr()), qcolor.pixel, displayclassname(vp->class));
					FAIL;
				} else
					pathcnt++;
			}
		}

		if(pathcnt == npixels)
			CHECK;

		free( (char *) pixels_return);

		/* Test that we can allocate planes and cells of size floor(log2(colormapsize)). */

		colormap = makecolmap(display, vp -> visual, AllocNone);
		cells = 1<<lg(maxsize(vp));
		npixels = (unsigned int) 1<<(lg(maxsize(vp))/2);
		nplanes = (unsigned int) lg(maxsize(vp)) - lg(npixels);
		plane_masks_return = (unsigned long *) malloc(nplanes * sizeof(unsigned long));
		pixels_return = (unsigned long *) malloc(npixels * sizeof(unsigned long));

		if(plane_masks_return == (unsigned long*) 0 || pixels_return == (unsigned long*) 0) {
			delete("Malloc() failed to allocate memory for return values.");
			return;
		} else
			CHECK;

		for(j=0; j<npixels; j++)
			pixels_return[j] = cells+1;

		for(j=0; j<nplanes; j++)
			plane_masks_return[j] = cells+1;

		trace("Testing XAllocColorCells() with nplanes = %u, npixels = %u, cells = %d, pixels * 2 pow planes = %u", nplanes, npixels, cells, npixels * (1<<nplanes));

		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);		
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		if(status == (Status) 0) {
			report("%s failed to return non-zero", TestName);
			report("allocating %lu pixels and %lu planes with visual class %s.",
				 npixels, nplanes, displayclassname(vp->class));
			FAIL;
			continue;
		} else
			CHECK;

		for(pathcnt = 0, j=0; j < npixels; j++)
			for(i=0; i < (1<<nplanes); i++) {
				planemask = 0L;
				for(k=0, mask=1; k < nplanes; k++, mask <<= 1) /*                                        */
					if((unsigned long) i & mask)           /* Select the i th subset of plane masks. */
						mask |= plane_masks_return[k]; /*                                        */
		
				color.pixel = pixels_return[j] | planemask;
				startcall(display);
				XStoreColor(display, colormap, &color);
				endcall(display);

				if(geterr() != Success) {
					report("XStoreColor() failed (%s) to store pixel value %lu in colormap of class %s", errorname(geterr()), color.pixel, displayclassname(vp->class));
					FAIL;
				} else {
					qcolor.pixel = pixels_return[j] | planemask;
					startcall(display);
					XQueryColor(display, colormap, &qcolor);
					endcall(display);
					if(geterr() != Success) {
						report("XQueryColor() failed (%s) to return pixel value %lu in colormap of class %s", errorname(geterr()), qcolor.pixel, displayclassname(vp->class));
						FAIL;
					} else
						pathcnt++;
				}
		}

		if(pathcnt == npixels*(1<<nplanes))
			CHECK;

		free( (char *) pixels_return);
		free( (char *) plane_masks_return);
	}

	CHECKPASS(5 * nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
Status status;
unsigned long vmask, planemask, pixelmask;
int i, j, cells, pathcnt = 0;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XAllocColorCells-2.(C)");
	report_assertion("If any of the visual classes DirectColor, PseudoColor, or");
	report_assertion("GrayScale is supported: A call to XAllocColorCells returns");
	report_assertion("nplanes plane masks in the plane_mask_return argument and");
	report_assertion("npixels pixel values in the pixels_return argument such that");
	report_assertion("no plane mask has a bit set in common with any other plane");
	report_assertion("mask or with any of the pixels.");

	report_strategy("For each supported visual with r/w colour cells:");
	report_strategy("  Create a colourmap with alloc set to AllocNone.");
	report_strategy("  Allocate planes and masks such that lg(colors) + planes = lg(colormap_size)");
	report_strategy("  Form the bitwise OR of all the pixels.");
	report_strategy("  For each planemask:");
	report_strategy("    Verify that the bitwise AND of every other planemask is 0.");
	report_strategy("    Verify that the bitwise AND of the planemask and the OR of the colours is 0.");

	tpstartup();
	setargs();

	if( (vmask = visualsupported(display, RW_COLORMAP_MASK)) == 0L) {
		unsupported("DirectColor, PseudoColor and GrayScale are not supported");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting XAllocColorCells() for class %s", displayclassname(vp->class));

		contig = False;
		colormap = makecolmap(display, vp -> visual, AllocNone);
		cells = 1<<lg(maxsize(vp));
		npixels = (unsigned int) 1<<(lg(maxsize(vp))/2);
		nplanes = (unsigned int) lg(maxsize(vp)) - lg(npixels);
		plane_masks_return = (unsigned long *) malloc(nplanes * sizeof(unsigned long));
		pixels_return = (unsigned long *) malloc(npixels * sizeof(unsigned long));
		if(plane_masks_return == (unsigned long*) 0 ||
		   pixels_return == (unsigned long*) 0) {
			delete("Malloc() failed to allocate memory for return values.");
			return;
		} else
			CHECK;

		pathcnt += nplanes*(nplanes+1);

		for(j=0; j<npixels; j++)
			pixels_return[j] = cells+1;

		for(j=0; j<nplanes; j++)
			plane_masks_return[j] = cells+1;

		trace("Testing XAllocColorCells() with nplanes = %u, npixels = %u, cells = %d, pixels * 2 pow planes = %u",
			nplanes, npixels, cells, npixels * (1<<nplanes));
		
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(status == (Status) 0) {
			report("%s failed to return non-zero", TestName);
			report("for visual class %s.", 	
						displayclassname(vp->class));
			FAIL;
		} else {
			pixelmask = 0L;
			for(j=0; j < npixels; j++)
				pixelmask |= pixels_return[j];
	
			for(j=0; j < nplanes; j++) {
				planemask = plane_masks_return[j];
				for(i=0; i < nplanes; i++) 
					if(((planemask & plane_masks_return[i]) != 0) && (i != j)) {
						report("Plane mask %d(%lu) has a bit in common with mask %d(%ln).", j, planemask, i, plane_masks_return[i]);
						FAIL;
					} else
						CHECK;

				if( (pixelmask & planemask) != 0L) {
					report("Plane mask %d(%lu) has a bit in common with a pixel value.", j, planemask);
					FAIL;
				} else
					CHECK;
			}
		}

		free( (char *) plane_masks_return);
		free( (char *) pixels_return);
	}

	CHECKPASS(pathcnt+nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo *vp;
Status status;
unsigned long vmask;
int j, cells, pathcnt = 0;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XAllocColorCells-3.(A)");
	report_assertion("If either of the visual classes PseudoColor or GrayScale");
	report_assertion("are supported: When the visual type of the colormap argument");
	report_assertion("is PseudoColor or GrayScale, then a call to");
	report_assertion("XAllocColorCells sets exactly one bit in each plane mask in");
	report_assertion("plane_mask_return.");

	report_strategy("For the visuals PseudoColor and GrayScale:");
	report_strategy("  Create a colourmap with alloc set to AllocNone.");
	report_strategy("  Allocate 1 color and all planemasks with XAllocColorCells.");
	report_strategy("  Verify that the number of bits set in each planemask is exactly 1.");

	tpstartup();
	setargs();

	if( (vmask = visualsupported(display, (1<<PseudoColor) | (1<<GrayScale)) ) == 0L) {
		unsupported("PseudoColor and GrayScale are not supported");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting XAllocColorCells() for class %s", displayclassname(vp->class));

		contig = False;
		colormap = makecolmap(display, vp -> visual, AllocNone);
		cells = 1<<lg(maxsize(vp));
		npixels = 1;
		nplanes = (unsigned int) lg(maxsize(vp));
		plane_masks_return = (unsigned long *) malloc(nplanes * sizeof(unsigned long));
		pixels_return = (unsigned long *) malloc(npixels * sizeof(unsigned long));
		if(plane_masks_return == (unsigned long*) 0 || pixels_return == (unsigned long*) 0) {
			delete("Malloc() failed to allocate memory for return values.");
			return;
		} else
			CHECK;

		pathcnt += nplanes;

		for(j=0; j<npixels; j++)
			pixels_return[j] = cells+1;

		for(j=0; j<nplanes; j++)
			plane_masks_return[j] = cells+1;

		trace("Testing XAllocColorCells() with nplanes = %u, npixels = %u, cells = %d, pixels * 2 pow planes = %u", nplanes, npixels, cells, npixels * (1<<nplanes));
		
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(status == (Status) 0) {
			report("%s failed to return non-zero", TestName);
			report("for visual class %s.", 	
						displayclassname(vp->class));
			FAIL;
		} else {
			int bits;
			for(j=0; j < nplanes; j++)
				if( (bits = bitcount(plane_masks_return[j])) != 1 ) {
					report("Plane_mask %d had %d bits set instead of 1", j, bits);
					FAIL;
				}
				else
					CHECK;
		}
	}

	CHECKPASS(pathcnt + nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo *vp;
Status status;
unsigned long vmask;
int j, cells;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XAllocColorCells-4.(A)");
	report_assertion("If the visual class DirectColor is supported: When the");
	report_assertion("visual type of the colormap argument is DirectColor, then a");
	report_assertion("call to XAllocColorCells sets exactly three bits in each");
	report_assertion("plane mask in plane_mask_return.");

	report_strategy("For the visual class DirectColor:");
	report_strategy("  Create a colormap.");
	report_strategy("  Allocate 1 color and all planemasks with XAllocColorCells.");
	report_strategy("  Verify that for each planemask exactly three bits are set.");

	tpstartup();
	setargs();

	if( (vmask = visualsupported(display, 1<<DirectColor)) == 0L) {
		unsupported("DirectColor is not supported");
		return;
	}

	resetsupvis(vmask);
	nextsupvis(&vp);
	trace("Attempting XAllocColorCells() for class %s", displayclassname(vp->class));
	contig = False;
	colormap = XCreateColormap(display, DRW(display), vp -> visual, AllocNone);
	cells = 1<<lg(maxsize(vp));
	npixels = 1;
	nplanes = (unsigned int) lg(maxsize(vp));
	plane_masks_return = (unsigned long *) malloc(nplanes * sizeof(unsigned long));
	pixels_return = (unsigned long *) malloc(npixels * sizeof(unsigned long));
	if(plane_masks_return == (unsigned long*) 0 || pixels_return == (unsigned long*) 0) {
		delete("Malloc() failed to allocate memory for return values.");
		return;
	} else
		CHECK;

	for(j=0; j<npixels; j++)
		pixels_return[j] = cells+1;

	for(j=0; j<nplanes; j++)
		plane_masks_return[j] = cells+1;

	trace("Testing XAllocColorCells() with nplanes = %u, npixels = %u, cells = %d, pixels * 2 pow planes = %u", nplanes, npixels, cells, npixels * (1<<nplanes));
		
	startcall(display);
	if (isdeleted())
		return;
	status = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == (Status) 0) {
		report("%s failed to return non-zero", TestName);
		report("for visual class %s.", 	
					displayclassname(vp->class));
		FAIL;
	} else {
		int bits;
		for(j=0; j < nplanes; j++)
			if( (bits = bitcount(plane_masks_return[j])) != 3 ) {
				report("Plane_mask %d had %d bits set instead of 3", j, bits);
				FAIL;
			}
			else
				CHECK;
	}

	CHECKPASS(nplanes+nsupvis());


	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

XVisualInfo *vp;
Status status;
unsigned long vmask;
unsigned long planeor;
int j, cells;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XAllocColorCells-5.(A)");
	report_assertion("If either of the visual classes PseudoColor or GrayScale");
	report_assertion("are supported: When the contig argument is True, and the");
	report_assertion("visual type of the colormap argument is GrayScale or");
	report_assertion("PseudoColor, then the mask formed by ORing the plane masks");
	report_assertion("in plane_mask_return contains one set of contiguous bits.");

	report_strategy("For the visual types PseudoColor and GreyScale:");
	report_strategy("  Create a colourmap.");
	report_strategy("  Allocate 1 color and some planemasks using XAllocColorCells and contig = True.");
	report_strategy("  Form the bitwise OR of all the planemasks.");
	report_strategy("  Verify that the returned planemasks were contiguous.");

	tpstartup();
	setargs();

	if( (vmask = visualsupported(display, (1<<PseudoColor) | (1<<GrayScale)) ) == 0L) {
		unsupported("PseudoColor and GrayScale are not supported");
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		trace("Attempting XAllocColorCells() for class %s", displayclassname(vp->class));

		contig = True;
		colormap = makecolmap(display, vp -> visual, AllocNone);
		cells = 1<<lg(maxsize(vp));
		npixels = 1;
		nplanes = (unsigned int) lg(maxsize(vp));
		/* 
		 * Just ask for a small number of planes if more was possible.
		 * Originally this test requested all planes - but of course this
		 * gave little scope for contig to make any difference.
		 */
		if(nplanes > 2) 
			nplanes = 2;
		plane_masks_return = (unsigned long *) malloc(nplanes * sizeof(unsigned long));
		pixels_return = (unsigned long *) malloc(npixels * sizeof(unsigned long));
		if(plane_masks_return == (unsigned long*) 0 || pixels_return == (unsigned long*) 0) {
			delete("Malloc() failed to allocate memory for return values.");
			return;
		} else
			CHECK;

		for(j=0; j<npixels; j++)
			pixels_return[j] = cells+1;

		for(j=0; j<nplanes; j++)
			plane_masks_return[j] = cells+1;

		trace("Testing XAllocColorCells() with contig = True, nplanes = %u, npixels = %u, cells = %d, pixels * 2 pow planes = %u", nplanes, npixels, cells, npixels * (1<<nplanes));
		
		startcall(display);
		if (isdeleted())
			return;
		status = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(status == (Status) 0) {
			report("%s failed to return non-zero", TestName);
			report("for visual class %s.", 	
						displayclassname(vp->class));
			FAIL;
		} else {
			planeor = 0L;
			for(j=0; j < nplanes; j++)
				planeor |= plane_masks_return[j];

			if(bitcontig(planeor) == 0) {
				report("The allocated planemask bits were not contiguous.");
				FAIL;
			} else
				CHECK;
		}
	}

	CHECKPASS(2*nsupvis());
  
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XVisualInfo *vp;
Status status;
unsigned long vmask;
int j, cells;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XAllocColorCells-6.(A)");
	report_assertion("If the visual class DirectColor is supported: When the");
	report_assertion("contig argument is True, and the visual type of the");
	report_assertion("colormap argument is DirectColor, then the mask formed by");
	report_assertion("ORing the plane masks in plane_mask_return contains three");
	report_assertion("sets of contiguous bits set to one, one lying in each of the");
	report_assertion("red, green and blue pixel subfields.");

	report_strategy("For the visual class DirectColor:");
	report_strategy("  Create a colormap.");
	report_strategy("  Allocate 1 color and some planemasks using XAllocColorCells and contig = True.");
	report_strategy("  Form the bitwise OR of all the planemasks per bit set.");
	report_strategy("  Verify that the returned planemasks in the red, green and blue subfields ");
	report_strategy("    were contiguous and distinct.");

	tpstartup();
	setargs();

	if( (vmask = visualsupported(display, 1<<DirectColor)) == 0L) {
		unsupported("DirectColor is not supported");
		return;
	}

	resetsupvis(vmask);
	nextsupvis(&vp);
	trace("Attempting XAllocColorCells() for class %s", displayclassname(vp->class));
	contig = True;
	colormap = makecolmap(display, vp -> visual, AllocNone);
	cells = 1<<lg(maxsize(vp));
	npixels = 1;
	nplanes = (unsigned int) lg(maxsize(vp));
	trace("nplanes %d", nplanes);
	/* 
	 * Just ask for a small number of planes if more was possible.
	 * Originally this test requested all planes - but of course this
	 * gave little scope for contig to make any difference.
	 */
	if(nplanes > 2) 
		nplanes = 2;
	trace("nplanes %d", nplanes);
	plane_masks_return = (unsigned long *) malloc(nplanes * sizeof(unsigned long));
	pixels_return = (unsigned long *) malloc(npixels * sizeof(unsigned long));
	if(plane_masks_return == (unsigned long*) 0 || pixels_return == (unsigned long*) 0) {
		delete("Malloc() failed to allocate memory for return values.");
		return;
	} else
		CHECK;


	for(j=0; j<npixels; j++)
		pixels_return[j] = cells+1;

	for(j=0; j<nplanes; j++)
		plane_masks_return[j] = cells+1;

	for(j=0; j < nplanes; j++)
	{
		trace("plane_mask_return is initially %x", plane_masks_return[j]);
	}

	trace("Testing XAllocColorCells() with nplanes = %u, npixels = %u, cells = %d, pixels * 2 pow planes = %u", nplanes, npixels, cells, npixels * (1<<nplanes));
		
	startcall(display);
	if (isdeleted())
		return;
	status = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status == (Status) 0) {
		report("XAllocColorCells() failed to return non-zero for visual class %s.", displayclassname(vp->class));
		FAIL;
	} else {
		unsigned long planeor1 = 0L, planeor2 = 0L, planeor3 = 0L, pln;

		for(j=0; j < nplanes; j++)
		{
			trace("plane_mask_return is %x", plane_masks_return[j]);
			pln = plane_masks_return[j];
			if (bitcount(pln) != 3) {
				report("Planemask %d did not have 3 bits set (0x%lx)", j, pln);
				FAIL;
			} else
				CHECK;
			planeor1 |= lowbit(pln);
			pln &= ~lowbit(pln);
			planeor2 |= lowbit(pln);
			pln &= ~lowbit(pln);
			planeor3 |= lowbit(pln);
			pln &= ~lowbit(pln);
		}

		trace("red_mask is %x", vp->red_mask);
		trace("green_mask is %x", vp->green_mask);
		trace("blue_mask is %x", vp->blue_mask);
		if(!((bitsubset(planeor1, vp->red_mask) &&
		      bitsubset(planeor2, vp->green_mask) &&
		      bitsubset(planeor3, vp->blue_mask)) ||
		     (bitsubset(planeor1, vp->red_mask) &&
		      bitsubset(planeor3, vp->green_mask) &&
		      bitsubset(planeor2, vp->blue_mask)) ||
		     (bitsubset(planeor2, vp->red_mask) &&
		      bitsubset(planeor1, vp->green_mask) &&
		      bitsubset(planeor3, vp->blue_mask)) ||
		     (bitsubset(planeor2, vp->red_mask) &&
		      bitsubset(planeor3, vp->green_mask) &&
		      bitsubset(planeor1, vp->blue_mask)) ||
		     (bitsubset(planeor3, vp->red_mask) &&
		      bitsubset(planeor1, vp->green_mask) &&
		      bitsubset(planeor2, vp->blue_mask)) ||
		     (bitsubset(planeor3, vp->red_mask) &&
		      bitsubset(planeor2, vp->green_mask) &&
		      bitsubset(planeor1, vp->blue_mask)))) {
			report("Planemasks (0x%lx, 0x%lx, 0x%lx) are not subsets of RGB masks (0x%lx, 0x%lx, 0x%lx)", planeor1, planeor2, planeor3, vp->red_mask, vp->green_mask, vp->blue_mask);
			FAIL;
		} else
			CHECK;
		if (bitcount(planeor1) != nplanes ||
		    bitcount(planeor2) != nplanes ||
		    bitcount(planeor3) != nplanes) {
			report("Planemasks not all distinct (0x%lx, 0x%lx, 0x%lx)", planeor1, planeor2, planeor3);
			FAIL;
		} else
			CHECK;
		if (!bitcontig(planeor1) ||
		    !bitcontig(planeor2) ||
		    !bitcontig(planeor3)) {
			report("Planemasks not all contiguous (0x%lx, 0x%lx, 0x%lx)", planeor1, planeor2, planeor3);
			FAIL;
		} else
			CHECK;
		
	}

	CHECKPASS(4+nplanes);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XAllocColorCells-7.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XAllocColorCells-8.(A)");
	report_assertion("When the npixels argument is zero, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("Verify that with npixels = 0, nplanes = 0, with the DefaultColormap, ");
	report_strategy("  XAllocColorCells generates a BadValue error.");

	tpstartup();
	setargs();
	colormap = DefaultColormap(display, DefaultScreen(display));
	npixels = 0;
	nplanes = 0;
	plane_masks_return = (unsigned long *) 0;
	pixels_return = (unsigned long *) 0;
	contig = False;
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	if(geterr() != BadValue)
		FAIL;
	else
		CHECK;

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.26489 */
/* End of included file Mval.tmc.26489 */

/* Including from file error/EVal.mc */
static void t009(){

#undef	VALUE_ARG
#define	VALUE_ARG contig
#undef	VALUE_LIST
#define	VALUE_LIST contigvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XAllocColorCells-9.(A)");
	report_assertion("When the value of contig is other than True or False, then");
	report_assertion("a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		StatusReturn = XAllocColorCells(display, colormap, contig, plane_masks_return, nplanes, pixels_return, npixels);
		endcall(display);
		if (StatusReturn != 0) {
			report("Status returned was %d", StatusReturn);
			FAIL;
		}
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
