/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XConvertSelection(display, selection, target, property, requestor, thetime)
 *   Display *display;
 *   Atom selection;
 *   Atom target;
 *   Atom property;
 *   Window requestor;
 *   Time  thetime;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XConvertSelection	1
char    *TestName = "XConvertSelection";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_ATOM selection
#define A_WINDOW requestor
#define A_DRAWABLE requestor


/*
 * Arguments to the XConvertSelection function
 */
static Display *display;
static Atom selection;
static Atom target;
static Atom property;
static Window requestor;
static Time  thetime;


#include "X11/Xatom.h"

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	selection = XA_COPYRIGHT;
	target = XA_NOTICE;
	property = XA_INTEGER;
	requestor = defwin(display);
	thetime = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *client1, *client2;
Window owner;
int num_ev;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XConvertSelection-1.(A)");
	report_assertion("When the specified selection has an owner, then a call to");
	report_assertion("XConvertSelection generates a SelectionRequest event to the");
	report_assertion("selection owner, with selection, target, property,");
	report_assertion("requestor, and time arguments passed unchanged as event");
	report_assertion("structure members.");

	report_strategy("Create a new client.");
	report_strategy("Create a window with a selection which it owns on client2.");
	report_strategy("Call XConvertSelection to convert the selection.");
	report_strategy("Verify that the correct SelectionNotify event was delivered to client2");
	report_strategy("Verify no events were delivered to client1.");

	tpstartup();
	setargs();
/* Create a new client. */
	client1 = display;
	client2 = opendisplay();
	if (client2 == (Display *)NULL) {
		delete("Could not create client2");
		return;
	} else
		CHECK;

/* Create a window with a selection which it owns on client2. */
	owner = defwin(client2);
	XSetSelectionOwner(client2, selection, owner, CurrentTime);
	XSync(client2, True);

/* Call xname to convert the selection. */
	startcall(display);
	if (isdeleted())
		return;
	XConvertSelection(display, selection, target, property, requestor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client1, False);
	XSync(client2, False);

/* Verify that the correct SelectionNotify event was delivered to client2 */
	num_ev = getevent(client2, &ev);
	if (num_ev != 1) {
		FAIL;
		report("%s did not cause a single SelectionNotify event",
			TestName);
		trace("Received %d events", num_ev);
		while (num_ev > 0) {
			trace("Event %s", eventname(ev.type));
			num_ev = getevent(client2, &ev);
		}
	} else {
		XEvent good;

		good.type = SelectionRequest;
		good.xselectionrequest.type = SelectionRequest;
		good.xselectionrequest.display = client2;
		good.xselectionrequest.owner = owner;
		good.xselectionrequest.requestor = requestor;
		good.xselectionrequest.selection = selection;
		good.xselectionrequest.target = target;
		good.xselectionrequest.property = property; 
		good.xselectionrequest.time	= -1;

		if (checkevent(&good, &ev)) {
			FAIL;
			report("SelectionNotify event was incorrect");
		} else
			CHECK;
	}

/* Verify no events were delivered to client1. */
	num_ev = getevent(client1, &ev);
	if (num_ev != 0) {
		FAIL;
		report("%s generated unexpected events on client1",
			TestName);
		trace("Expected 0 events");
		trace("Received %d events", num_ev);
		do {
			trace("Event: %s", eventname(ev.type));
		} while(getevent(client1, &ev));
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int num_ev;
XEvent ev;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XConvertSelection-2.(A)");
	report_assertion("When the specified selection has no owner, then a call to");
	report_assertion("XConvertSelection generates a SelectionNotify event to the");
	report_assertion("requestor window with selection, target and time arguments");
	report_assertion("passed unchanged as event structure members, and with");
	report_assertion("property set to None.");

	report_strategy("Call XConvertSelection to convert the selection.");
	report_strategy("Verify that the correct SelectionNotify event was delivered to display.");

	tpstartup();
	setargs();
/* Call xname to convert the selection. */
	startcall(display);
	if (isdeleted())
		return;
	XConvertSelection(display, selection, target, property, requestor, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display, False);

/* Verify that the correct SelectionNotify event was delivered to display. */
	num_ev = getevent(display, &ev);
	if (num_ev != 1) {
		FAIL;
		report("%s did not cause a single SelectionNotify event",
			TestName);
		trace("Received %d events", num_ev);
		while (num_ev > 0) {
			trace("Event %s", eventname(ev.type));
			num_ev = getevent(display, &ev);
		}
	} else {
		XEvent good;

		good.type = SelectionNotify;
		good.xselection.type = SelectionNotify;
		good.xselection.display = display;
		good.xselection.requestor = requestor;
		good.xselection.selection = selection;
		good.xselection.target = target;
		good.xselection.property = None; /* is passed with no owner */
		good.xselection.time	= -1;

		if (checkevent(&good, &ev)) {
			FAIL;
			report("SelectionNotify event was incorrect");
		} else
			CHECK;
	}

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Atom primary, secondary;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XConvertSelection-3.(A)");
	report_assertion("The atoms PRIMARY and SECONDARY are predefined selection");
	report_assertion("atoms.");

	report_strategy("Obtain the server representation for the PRIMARY and SECONDARY atoms.");
	report_strategy("Verify that the atoms were defined.");

	tpstartup();
	setargs();
/* Obtain the server representation for the PRIMARY and SECONDARY atoms. */
	primary = XInternAtom(display, "PRIMARY", True);
	secondary = XInternAtom(display, "SECONDARY", True);

/* Verify that the atoms were defined. */
	if (primary == None) {
		FAIL;
		report("PRIMARY was not defined");
	} else
		CHECK;

	if (secondary == None) {
		FAIL;
		report("SECONDARY was not defined");
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XConvertSelection-4.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XConvertSelection(display, selection, target, property, requestor, thetime);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* Including from file error/EAto.mc */
/* End of included file error/EAto.mc */

/* Including from file error/EAto.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XConvertSelection-5.(A)");
	report_assertion("When an atom argument does not name a valid Atom, then a");
	report_assertion("BadAtom error occurs.");

	report_strategy("Call test function using a value with the top bits set as the atom argument.");
	report_strategy("Verify that a BadAtom error occurs.");

	tpstartup();
	setargs();
	A_ATOM = ~0L;
	startcall(display);
	if (isdeleted())
		return;
	XConvertSelection(display, selection, target, property, requestor, thetime);
	endcall(display);
	if (geterr() != BadAtom) {
		report("Got %s, Expecting BadAtom", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadAtom)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAto.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
