/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   XWMHints *
 *   XGetWMHints(display, w)
 *   Display	*display;
 *   Window	w;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetWMHints	1
char    *TestName = "XGetWMHints";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XGetWMHints function
 */
static Display	*display;
static Window	w;


#include	"X11/Xatom.h"

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window		win;
XVisualInfo	*vp;
XWMHints	hints;
XWMHints	*hints_ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetWMHints-1.(A)");
	report_assertion("When the WM_HINTS property has been set for the window w,");
	report_assertion("and is format 32, length (>= 9 elements, and of type");
	report_assertion("WM_HINTS, then a call to XGetWMHints returns a pointer to a");
	report_assertion("XWMHints structure which contains the window manager hints");
	report_assertion("for the window and can be freed with XFree.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_HINTS property for the window with XSetWMHints.");
	report_strategy("Obtain the WM_HINTS property values with XGetWMHints.");
	report_strategy("Verify the result is non-NULL.");
	report_strategy("Verify that the returned values are correct.");
	report_strategy("Release the allocated memory using XFree.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);

	hints.flags = AllHints;
	hints.input = True;
	hints.initial_state = IconicState;
	hints.icon_pixmap =  1L;
	hints.icon_window = 1L;
	hints.icon_x = 13;
	hints.icon_y = 7;
	hints.icon_mask = 1L;
	hints.window_group = 1L;

	XSetWMHints(display, win, &hints);

	w = win;
	startcall(display);
	if (isdeleted())
		return;
	hints_ret = XGetWMHints(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(hints_ret == (XWMHints *) 0) {
		report("XGetWMHints() returned NULL.");
		FAIL;
		return; /* failure invalidates rest of test, and no freeing */
	} else
		CHECK;

	if(hints_ret->flags != AllHints) {
		report("The flags component was %lu instead of AllHints.", hints_ret->flags);
		FAIL;
	} else
		CHECK;

	if(hints_ret->input != True) {
		report("The hints_ret component of the XWMHints structure was %d instead of True.", (Bool) hints_ret->input);
		FAIL;
	} else
		CHECK;

	if(hints_ret->initial_state != IconicState) {
		report("The initial_state component of the XWMHints structure was %d instead of IconicState.",
			hints_ret->initial_state);
		FAIL;
	} else
		CHECK;

	if(hints_ret->icon_pixmap !=  1L) {
		report("The icon_pixmap component of the XWMHints structure was %lu instead of 1.", hints_ret->icon_pixmap);
		FAIL;
	} else
		CHECK;

	if(hints_ret->icon_window != 1L) {
		report("The icon_window component of the XWMHints structure was %lu instead of 1.", hints_ret->icon_window);
		FAIL;
	} else
		CHECK;

	if(hints_ret->icon_x != 13) {
		report("The icon_x component of the XWMHints structure was %d instead of 13.", hints_ret->icon_x);
		FAIL;
	} else
		CHECK;

	if(hints_ret->icon_y != 7) {
		report("The icon_y component of the XWMHints structure was %d instead of 7.", hints_ret->icon_y);
		FAIL;
	} else
		CHECK;

	if(hints_ret->icon_mask != 1L) {
		report("The icon_mask component of the XWMHints structure was %lu instead of 1.", hints_ret->icon_mask);
		FAIL;
	} else
		CHECK;

	if(hints_ret->window_group != 1L) {
		report("The window_group component of the XWMHints structure was %lu instead of 1.", hints_ret->window_group);
		FAIL;
	} else
		CHECK;

	XFree((char*)hints_ret);

	CHECKPASS(10);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo	*vp;
XWMHints	hints;
XWMHints	*hints_ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetWMHints-2.(A)");
	report_assertion("When the WM_HINTS property has not been set for the window");
	report_assertion("w, or is format other than 32, length < 9 elements, or of");
	report_assertion("type other than WM_HINTS, then a call to XGetWMHints");
	report_assertion("returns NULL.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Obtain the value of the unset WM_HINTS property with XGetWMHints.");
	report_strategy("Verify that the call returned NULL.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_HINTS property with format 16 and type WM_HINTS and size 9 using XChangeProperty.");
	report_strategy("Obtain the value of the WM_HINTS property with XGetWMHints.");
	report_strategy("Verify that the call returned NULL.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_HINTS property with format 32 type WM_ATOM and size 9 using XChangeProperty.");
	report_strategy("Obtain the value of the WM_HINTS property with XGetWMHints.");
	report_strategy("Verify that the call returned NULL.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_HINTS property with format 32 type WM_HINTS and size 1 using XChangeProperty.");
	report_strategy("Obtain the value of the WM_HINTS property with XGetWMHints.");
	report_strategy("Verify that the call returned NULL.");
	report_strategy("");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);

	w = makewin(display, vp);
/* Property unset */

	startcall(display);
	if (isdeleted())
		return;
	hints_ret = XGetWMHints(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(hints_ret != (XWMHints *) NULL){	
		report("XGetWMHints() did not return NULL with the WM_HINTS property unset.");
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);
/* format 16 */
	XChangeProperty(display, w, XA_WM_HINTS, XA_WM_HINTS, 16, PropModeReplace, (unsigned char *) &hints, 9);

	startcall(display);
	if (isdeleted())
		return;
	hints_ret = XGetWMHints(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(hints_ret != (XWMHints *) NULL){	
		report("XGetWMHints() did not return NULL with the WM_HINTS property format set to 16.");
		FAIL;
	} else
		CHECK;

	w = makewin(display, vp);
/* type ATOM */
	XChangeProperty(display, w, XA_WM_HINTS, XA_ATOM, 32, PropModeReplace, (unsigned char *) &hints, 9);

	startcall(display);
	if (isdeleted())
		return;
	hints_ret = XGetWMHints(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(hints_ret != (XWMHints *) NULL){	
		report("XGetWMHints() did not return NULL with the WM_HINTS type set to ATOM.");
		FAIL;
	} else
		CHECK;


	w = makewin(display, vp);
/* size 1 */
	XChangeProperty(display, w, XA_WM_HINTS, XA_WM_HINTS, 32, PropModeReplace, (unsigned char *) &hints, 1);

	startcall(display);
	if (isdeleted())
		return;
	hints_ret = XGetWMHints(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(hints_ret != (XWMHints *) NULL){	
		report("XGetWMHints() did not return NULL with the WM_HINTS size set to 1.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetWMHints-3.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XGetWMHints(display, w);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
