/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Bool
 *   XCheckTypedWindowEvent(display, w, event_type, event_return)
 *   Display *display;
 *   Window w;
 *   int event_type;
 *   XEvent	*event_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCheckTypedWindowEvent	1
char    *TestName = "XCheckTypedWindowEvent";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XCheckTypedWindowEvent function
 */
static Display *display;
static Window w;
static int event_type;
static XEvent	*event_return;


/*
 * Can not use "xcall" because it empties the event queue.
 */
#define	_xcall_(rvalue)	\
		_startcall(display);\
		rvalue = XCheckTypedWindowEvent(display, w, event_type, event_return);\
		_endcall(display)
static XEvent _event;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
	event_type = 0;
	event_return = &_event;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Window	w1;
Window	w2;
XEvent	event;
XAnyEvent *ep;
Bool	return_value;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCheckTypedWindowEvent-1.(A)");
	report_assertion("A call to XCheckTypedWindowEvent returns in event_return");
	report_assertion("the first event in the event queue that matches event_type");
	report_assertion("and window w.");

	report_strategy("Create a window.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XCheckTypedWindowEvent.");
	report_strategy("Verify that XCheckTypedWindowEvent returned True.");
	report_strategy("Verify the correct event-type was returned.");
	report_strategy("Verify the event contained correct window.");
	report_strategy("Verify the first matching event in event queue was returned.");

	tpstartup();
	setargs();
/* Create a window. */
	w1 = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
	w2 = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	ep = (XAnyEvent *) &event;
	ep->type = KeyPress;
	ep->window = w1;
	ep->send_event = False;
	XPutBackEvent(display, &event);
	ep->type = ButtonPress;
	ep->window = w2;
	ep->send_event = False;
	XPutBackEvent(display, &event);
	ep->type = ButtonPress;
	ep->window = w2;
	ep->send_event = True;	/* first occurrence has send_event True */
	XPutBackEvent(display, &event);
	ep->type = KeyPress;
	ep->window = w1;
	ep->send_event = False;
	XPutBackEvent(display, &event);
/* Call XCheckTypedWindowEvent. */
	w = w2;
	event_type = ButtonPress;
	_xcall_(return_value);
/* Verify that XCheckTypedWindowEvent returned True. */
	if (return_value != True) {	
		report("Did not return True: returned %d", return_value);
		FAIL;
	}
	else
		CHECK;
/* Verify the correct event-type was returned. */
	ep = (XAnyEvent *) event_return;
	if (ep->type != event_type) {
		report("Got %s, expected %s", eventname(ep->type), eventname(ButtonPress));
		FAIL;
	}
	else
		CHECK;
/* Verify the event contained correct window. */
	if (ep->window != w2) {
		report("Got %d, expected %d", ep->window, w2);
		FAIL;
	}
	else
		CHECK;
/* Verify the first matching event in event queue was returned. */
	if (ep->send_event != True) {
		report("First event in event queue was not returned.");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion XCheckTypedWindowEvent-2.(-)");
	report_assertion("When a call to XCheckTypedWindowEvent finds a matching");
	report_assertion("event, then XCheckTypedWindowEvent returns True.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t003(){

XEvent	event;
XAnyEvent *ep;
int	oldqsize;
int	newqsize;
Bool	return_value;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCheckTypedWindowEvent-3.(A)");
	report_assertion("A call to XCheckTypedWindowEvent removes the returned event");
	report_assertion("from the event queue.");

	report_strategy("Create a window.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XPutBackEvent to put events on the event queue.");
	report_strategy("Call XPending to get the current event queue size.");
	report_strategy("Call XCheckTypedWindowEvent.");
	report_strategy("Verify that XCheckTypedWindowEvent returned True.");
	report_strategy("Call XPending to get the current event queue size.");
	report_strategy("Verify that size of event queue has decreased by one.");

	tpstartup();
	setargs();
/* Create a window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XPutBackEvent to put events on the event queue. */
	ep = (XAnyEvent *) &event;
	ep->type = ButtonPressMask;
	ep->window = w;
	XPutBackEvent(display, &event);
/* Call XPending to get the current event queue size. */
	oldqsize = XPending(display);
/* Call XCheckTypedWindowEvent. */
	event_type = ButtonPress;
	_xcall_(return_value);
/* Verify that XCheckTypedWindowEvent returned True. */
	if (return_value != True) {	
		report("Did not return True: returned %d", return_value);
		FAIL;
	}
	else
		CHECK;
/* Call XPending to get the current event queue size. */
	newqsize = XPending(display);
/* Verify that size of event queue has decreased by one. */
	if (newqsize != (oldqsize-1)) {
		report("Event queue size %d, expected %d", newqsize, oldqsize-1);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion XCheckTypedWindowEvent-4.(-)");
	report_assertion("When the event queue does not contain a matching event,");
	report_assertion("then a call to XCheckTypedWindowEvent returns in");
	report_assertion("event_return the first matching event available on the X");
	report_assertion("server connection.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t005(){

Bool	return_value;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCheckTypedWindowEvent-5.(A)");
	report_assertion("When a matching event is not in the event queue and is not");
	report_assertion("available on the X server connection, then a call to");
	report_assertion("XCheckTypedWindowEvent returns False.");

	report_strategy("Create a window.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Call XCheckTypedWindowEvent.");
	report_strategy("Verify that XCheckTypedWindowEvent returned False.");

	tpstartup();
	setargs();
/* Create a window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Discard all events on the event queue. */
	XSync(display, True);
/* Call XCheckTypedWindowEvent. */
	event_type = ButtonPress;
	_xcall_(return_value);
/* Verify that XCheckTypedWindowEvent returned False. */
	if (return_value != False) {	
		report("Did not return False: returned %d", return_value);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Bool	return_value;
Pixmap	pm;
Display *client2;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCheckTypedWindowEvent-6.(A)");
	report_assertion("When a matching event is not in the event queue and is not");
	report_assertion("available on the X server connection, then a call to");
	report_assertion("XCheckTypedWindowEvent flushes the output buffer.");

	report_strategy("Create client2.");
	report_strategy("Discard all events on the event queue.");
	report_strategy("Create pixmap.");
	report_strategy("Create a window.");
	report_strategy("Call XCheckTypedWindowEvent.");
	report_strategy("Verify that XCheckTypedWindowEvent returned False.");
	report_strategy("Empty the buffer.");
	report_strategy("Ensure the server has dealt with anything flushed to it: do XSync()");
	report_strategy("Verify that the output buffer was flushed by effect on server.");

	tpstartup();
	setargs();
/* Create client2. */
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Discard all events on the event queue. */
	XSync(display, True);
/* Create pixmap. */
	/* avoid using makepixm() */
	pm = XCreatePixmap(display, DRW(display), 10, 10, 1);
/* Create a window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Call XCheckTypedWindowEvent. */
	event_type = ButtonPress;
	_xcall_(return_value);
/* Verify that XCheckTypedWindowEvent returned False. */
	if (return_value != False) {	
		report("Did not return False: returned %d", return_value);
		FAIL;
	}
	else
		CHECK;
/* Empty the buffer. */
	(void)XTestDiscard(display);
/* Ensure the server has dealt with anything flushed to it: do XSync() */
	XSync(display, False);
/* Verify that the output buffer was flushed by effect on server. */
	_startcall(client2);
	XFreePixmap(client2, pm);
	XSync(client2, True);
	_endcall(client2);
	if (geterr() != Success) {
		report("The output buffer was not flushed.");
		XFreePixmap(display, pm);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
