/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XSetDeviceModifierMapping(display, device, modmap)
 *   Display	*display;
 *   XDevice *device;
 *   XModifierKeymap	*modmap;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetDeviceModifierMapping	1
char    *TestName = "XSetDeviceModifierMapping";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XSetDeviceModifierMapping function
 */
static Display	*display;
static XDevice *device;
static XModifierKeymap	*modmap;


static int 	ValueReturn;


extern ExtDeviceInfo Devs;
extern int MinKeyCode, MaxKeyCode;

static	XModifierKeymap	*origmap;

static void
savemap()
{

	startup();
	if (!Setup_Extension_DeviceInfo(ModMask))
	    {
	    return;
	    }
	SelectExtensionEvents (Dsp, DefaultRootWindow(Dsp));
	XSync(Dsp,0);
	device = Devs.Mod;
	if(Dsp) {
		origmap = XGetDeviceModifierMapping(Dsp, device);
	}
}

static void
cleanmap()
{
	if(Dsp && Devs.Key)
		XSetDeviceModifierMapping(Dsp, Devs.Mod, origmap);
	XSync(Dsp,0);
	cleanup();
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	modmap = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	i;
int 	kpm;
XModifierKeymap	*newmap;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetDeviceModifierMapping-1.(B)");
	report_assertion("A succesful call to XSetDeviceModifierMapping specifies the");
	report_assertion("KeyCodes of the keys that are to be used as modifiers and");
	report_assertion("returns MappingSuccess.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set up a modifier map.");
	report_strategy("Call XSetDeviceModifierMapping to set servers map.");
	report_strategy("Verify that MappingSuccess is returned.");
	report_strategy("Get current map with XGetModifierMapping.");
	report_strategy("Verify that the mapping has been set correctly.");

	tpstartup();
	setargs();
	if (!Devs.Mod) {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	/*
	 * Because some keycodes may not be usable as modifiers in a server
	 * dependent fashion, then we must take steps to avoid this.
	 * Therefore: get current modifiers and rearrange them.
	 */
	kpm = origmap->max_keypermod;
	modmap = XNewModifiermap(kpm);
	if (modmap == 0) {
		delete("Could not create new map");
		return;
	}

	for (i = 0; i < kpm*8; i++)
		modmap->modifiermap[i] = origmap->modifiermap[kpm*8-1 - i];

	device = Devs.Key;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XSetDeviceModifierMapping(display, device, modmap);
	endcall(display);
	if (ValueReturn != MappingSuccess) {
		report("Returned value was %d, expecting MappingSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	newmap = XGetDeviceModifierMapping(display, device);

	if (newmap->max_keypermod == modmap->max_keypermod)
		CHECK;
	else {
		report("max_keypermod was %d, expecting %d", newmap->max_keypermod,
			modmap->max_keypermod);
		FAIL;
	}
	for (i = 0; i < kpm*8; i++) {
		if (modmap->modifiermap[i] == newmap->modifiermap[i])
			CHECK;
		else {
			report("Modifier map was not set correctly");
			FAIL;
			break;
		}
	}
	CHECKPASS(1+kpm*8);

	XFreeModifiermap(newmap);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	n, dmn;
XEvent	ev;
XDeviceMappingEvent	good;
XEventClass dmnc;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetDeviceModifierMapping-2.(B)");
	report_assertion("When a call to XSetDeviceModifierMapping succeeds, then a");
	report_assertion("DeviceMappingNotify event is generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XSetDeviceModifierMapping to set mapping.");
	report_strategy("Verify that a DeviceMappingNotify event is generated.");

	tpstartup();
	setargs();
	if (!Devs.Mod) {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	modmap = origmap;

	device = Devs.Mod;
	DeviceMappingNotify(Devs.Mod, dmn, dmnc);
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XSetDeviceModifierMapping(display, device, modmap);
	endcall(display);
	if (ValueReturn != MappingSuccess) {
		report("Returned value was %d, expecting MappingSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	defsetevent(good, display, dmn);
	good.window = None;	/* unused */
	good.request = MappingModifier;
	good.deviceid = Devs.Key->device_id;
	/* rest not used */

	n = getevent(display, &ev);
	if (n == 0 || ev.type != dmn) {
		report("Expecting a devicemappingnotify event");
		FAIL;
		return;
	} else
		CHECK;

	if (checkevent((XEvent*)&good, &ev))
		FAIL;
	else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){


 	report_purpose(3);

	report_assertion("Assertion XSetDeviceModifierMapping-3.(-)");
	report_assertion("The modifiermap member of the XModifierKeymap structure");
	report_assertion("contains eight sets of max_keypermod KeyCodes, one for each");
	report_assertion("modifier in the order Shift, Lock, Control, Mod1, Mod2,");
	report_assertion("Mod3, Mod4, and Mod5.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t004(){

XModifierKeymap	*oldmap;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetDeviceModifierMapping-4.(B)");
	report_assertion("When a zero KeyCode occurs in a set, then it is ignored.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set up a mapping with all keycodes zero.");
	report_strategy("Set mapping with XSetDeviceModifierMapping.");
	report_strategy("Verify no BadValue error.");

	tpstartup();
	setargs();
	if (!Devs.Mod) {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Mod;
	oldmap = XGetDeviceModifierMapping(display, device);
	if (oldmap == 0) {
		delete("Could not get the old map");
		return;
	}

	modmap = XNewModifiermap(1);
	for (i = 0; i < 8; i++)
		modmap->modifiermap[i] = 0;

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XSetDeviceModifierMapping(display, device, modmap);
	endcall(display);
	if (ValueReturn != MappingSuccess) {
		report("Returned value was %d, expecting MappingSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (geterr() == Success)
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	i;
int 	ret;
int 	found;
XModifierKeymap *newmap;
unsigned int	kc;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetDeviceModifierMapping-5.(C)");
	report_assertion("When an implementation restriction on which keys can be");
	report_assertion("used as modifiers is violated, then a call to");
	report_assertion("XSetDeviceModifierMapping returns MappingFailed and none of");
	report_assertion("the modifiers are changed.");

	report_strategy("Try in turn all possible keycodes.");
	report_strategy("If all return MappingSuccess:");
	report_strategy("  Report unsupported.");
	report_strategy("else");
	report_strategy("  Verify that MappingFailed is returned.");
	report_strategy("  Verify that modifier has not been set to this keycode.");

	tpstartup();
	setargs();
	if (!Devs.Mod) {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Mod;
	if ((modmap = XNewModifiermap(1)) == 0) {
		delete("Failed to create new modifier map");
		return;
	}

	for (i = 0; i < 8; i++)
		modmap->modifiermap[i] = 0;

	found = 0;
	for (kc = MinKeyCode; kc <= MaxKeyCode; kc++) {
		modmap->modifiermap[0] = (KeyCode)kc;

		startcall(display);
		if (isdeleted())
			return;
		ret = XSetDeviceModifierMapping(display, device, modmap);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (ret != MappingSuccess) {

			found = True;

			if (ret != MappingFailed) {
				report("Return value was %d, expecting MappingFailure", ret);
				FAIL;
				break;
			}
			newmap = XGetDeviceModifierMapping(display, device);

			if (newmap->modifiermap[0] == (KeyCode)kc) {
				report("An invalid keycode (%u) was set into the map", kc);
				FAIL;
				break;
			} else
				CHECK;
		} else
			CHECK;
	}

	if (!found)
		unsupported("All keycodes are acceptable as modifiers for this server");
	else
		CHECKPASS(MaxKeyCode-MinKeyCode+1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int 	i, ret;
int 	kpm;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetDeviceModifierMapping-6.(B)");
	report_assertion("When the new KeyCodes specified for a modifier differ from");
	report_assertion("those currently defined and any of the current or new keys");
	report_assertion("for that modifier are in the logically down state, then a");
	report_assertion("call to XSetDeviceModifierMapping returns MappingBusy and");
	report_assertion("none of the modifiers are changed.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If the XTest extension is present, press one of the keys to be used as one");
	report_strategy("of the modifiers.  Then change the mapping.  Verify that a MappingBusy");
	report_strategy("error was returned.");

	tpstartup();
	setargs();
	if (!Devs.Mod) {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	if (noext(1)) {
		return;
	}

	/*
	 * Because some keycodes may not be usable as modifiers in a server
	 * dependent fashion, then we must take steps to avoid this.
	 * Therefore: get current modifiers and rearrange them.
	 */
	kpm = origmap->max_keypermod;
	modmap = XNewModifiermap(kpm);
	if (modmap == 0) {
		delete("Could not create new map");
		return;
	}

	for (i = 0; i < kpm*8; i++)
		{
		modmap->modifiermap[i] = origmap->modifiermap[kpm*8-1 - i];
		devicekeypress (display, Devs.Mod, modmap->modifiermap[i]);
		}


	device = Devs.Mod;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceModifierMapping(display, device, modmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret != MappingBusy) {
		report("Return value was %d, expecting MappingBusy", ret);
		FAIL;
	}
	else
		PASS;
	for (i = 0; i < kpm*8; i++)
		{
		modmap->modifiermap[i] = origmap->modifiermap[kpm*8-1 - i];
		devicekeyrel (display, Devs.Mod, modmap->modifiermap[i]);
		}
	devicerelkeys (Devs.Mod);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetDeviceModifierMapping-7.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

static void t008(){

int 	i, ret;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XSetDeviceModifierMapping-8.(B)");
	report_assertion("When a KeyCode is not in the range returned by");
	report_assertion("XListInputDevices, then a BadValue error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set up map with keycode less than the minimum value.");
	report_strategy("Call XSetDeviceModifierMapping.");
	report_strategy("Verify that a BadValue error occurs.");
	report_strategy("");
	report_strategy("Set up map with keycode greater than the maximum value (if possible).");
	report_strategy("Call XSetDeviceModifierMapping.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	if (!Devs.Mod) {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Mod;
	modmap = XNewModifiermap(1);
	for (i = 0; i < 8*modmap->max_keypermod; i++)
		modmap->modifiermap[i] = 0;

	modmap->modifiermap[0] = MinKeyCode-1;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceModifierMapping(display, device, modmap);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	XSync(Dsp,0);

	if (geterr() == BadValue)
		CHECK;
	else
		FAIL;

	if (MaxKeyCode+1 < 0xff) {
		modmap->modifiermap[0] = MaxKeyCode+1;
		startcall(display);
		if (isdeleted())
			return;
		ret = XSetDeviceModifierMapping(display, device, modmap);
		endcall(display);
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else
			FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

int ret;
XID baddevice;
XDevice bogus;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XSetDeviceModifierMapping-9.(B)");
	report_assertion("If an invalid device is specified, a BadDevice error");
	report_assertion("occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specifiy an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err)) {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice(display, baddevice);
	bogus.device_id = -1;
	device = &bogus;
	modmap = XNewModifiermap(1);
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceModifierMapping(display, device, modmap);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = savemap;
void	(*tet_cleanup)() = cleanmap;
