/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetDeviceMode(display, device, mode)
 *   Display	*display;
 *   XDevice *device;
 *   int mode;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetDeviceMode	1
char    *TestName = "XSetDeviceMode";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XSetDeviceMode function
 */
static Display	*display;
static XDevice *device;
static int mode;


extern ExtDeviceInfo Devs;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	mode = Absolute;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int i, ret;
XDeviceState *state;
XInputClass *cp;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetDeviceMode-1.(B)");
	report_assertion("A call to XSetDeviceMode will change the mode of a device");
	report_assertion("from Absolute to Relative and vice versa.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an valid device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(DModMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }

	device = Devs.DvMod;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceMode(display, device, mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	state = XQueryDeviceState(display, device);
	cp = state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (cp->class == ValuatorClass)
		if (((XValuatorState *)cp)->mode == Absolute)
		    CHECK;
		else
		    {
		    report("%s: Couldn't set Absolute mode\n",TestName);
		    FAIL;
		    }
	    cp = (XInputClass *) ((char *) cp + cp->length);
	    }

	mode = Relative;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceMode(display, device, mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	state = XQueryDeviceState(display, device);
	cp = state->data;
	for (i=0; i<state->num_classes; i++)
	    {
	    if (cp->class == ValuatorClass)
		if (((XValuatorState *)cp)->mode == Relative)
		    CHECK;
		else
		    {
		    report("%s: Couldn't set Relative mode\n",TestName);
		    FAIL;
		    }
	    cp = (XInputClass *) ((char *) cp + cp->length);
	    }
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int ret;
Display	*client2;
Window grab_window;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetDeviceMode-2.(B)");
	report_assertion("A call to XSetDeviceMode will return a status of");
	report_assertion("AlreadyGrabbed if a another client has the device grabbed.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Grab the device from another client.");
	report_strategy("Make the call with an valid device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(DModMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.DvMod;
        grab_window = defwin(Dsp);

	XGrabDevice(Dsp, Devs.DvMod, grab_window, True, 0, 
		NULL, GrabModeAsync, GrabModeAsync, CurrentTime);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}

	if ((client2 = opendisplay()) == NULL)
		return;

	display = client2;
	startcall(display);
	if (isdeleted())
		return;
	ret = XSetDeviceMode(display, device, mode);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret == AlreadyGrabbed)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.29213 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetDeviceMode-3.(D)");
	report_assertion("A call to SetDeviceMode will fail with a BadMatch error if");
	report_assertion("a device is specified that does not support this request.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.29213 */

/* Including from file Mdefcode.tmc.29213 */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetDeviceMode-4.(D)");
	report_assertion("A call to SetDeviceMode will fail with a DeviceBusy status");
	report_assertion("if another client already has the device open with a mode");
	report_assertion("other than the one specified.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.29213 */

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetDeviceMode-5.(B)");
	report_assertion("A call to XSetDeviceMode will fail with a BadMatch error if");
	report_assertion("an valid device that has no valuators is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an valid device that has no valuators.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NValsMask))
	    {
	    untested("%s: No input extension device without valuators.\n", TestName);
	    return;
	    }
	device = Devs.NoValuators;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceMode(display, device, mode);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

XDevice nodevice;
XID baddevice;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetDeviceMode-6.(B)");
	report_assertion("A call to XSetDeviceMode will fail with a BadDevice error");
	report_assertion("if an invalid device is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err)) {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceMode(display, device, mode);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
