/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Display *
 *   XOpenDisplay(display_name)
 *   char	*display_name;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XOpenDisplay	1
char    *TestName = "XOpenDisplay";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XOpenDisplay function
 */
static char	*display_name;


#include	"ctype.h"
#include	"X11/Xatom.h"
static char *copystring (src, len) /* Courtesy of Xlib. */
    char *src;
    int len;
{
    char *dst = (char *) malloc (len + 1);

    if (dst) {
	strncpy (dst, src, len);
	dst[len] = '\0';
    }

    return dst;
}


extern char **environ;

static void
t005exec()
{
char	*argv[2];
char	*str;
char	*mstr = "DISPLAY=%s";

	if((str = (char *) malloc( strlen(config.display) + strlen(mstr) - 1)) == (char *) NULL) {
		delete("malloc() failed.");
		return;
	}

	sprintf(str, mstr, config.display);

	argv[0] = "./Test1";
	argv[1] = (char *) NULL;

	if (xtest_putenv(str)) {
		delete("xtest_putenv failed");
		return;
	}

	tet_exec("./Test1", argv, environ);

	delete("Exec of file ./Test1 failed");
	free( (char *) str);
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display_name = config.display;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display	*display;
char	*cptr, *sptr, *dnop, *snop;
int	dno;
int	sno;
char	ssno[9], sdno[9];
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XOpenDisplay-1.(C)");
	report_assertion("If the system is POSIX compliant and supports DECnet: When");
	report_assertion("the display_name argument is a string of the form");
	report_assertion("hostname::number.screen_num, then a call to XOpenDisplay");
	report_assertion("returns a pointer to a display structure and opens a");
	report_assertion("connection to display server number number on hostname with");
	report_assertion("default screen screen_number.");

	report_strategy("If the system is POSIX compliant and supports DECnet transport:");
	report_strategy("  Obtain the display and screen numbers by parsing the DISPLAY config variable.");
	report_strategy("  Open a connection using XOpenDisplay.");
	report_strategy("  Verify that the call did not return NULL.");
	report_strategy("  Issue a NoOperation request using XNoOp.");
	report_strategy("  Flush the Output buffer using XFlush.");
	report_strategy("  Close the display using XCloseDisplay.");

	tpstartup();
	setargs();
	if(config.posix_system == 0) {
		unsupported("This assertion can only be tested on a POSIX system.");
		return;
	} else
		CHECK;

	if(config.decnet == 0) {
		unsupported("This assertion can only be tested on a system with support for DECnet.");
		return;
	} else
		CHECK;

	for(cptr = config.display; (*cptr) && (*cptr != ':'); cptr++)
		;

	if(*cptr == '\0') {
		delete("DISPLAY does not specify a display.");
		return;
	} else {
		CHECK;
		if(*++cptr != ':') {
			delete("DISPLAY does not contain a valid display name.");
			return;
		} else
			CHECK;

		for(sptr = ++cptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
			;
		if( (sptr == cptr) || (*sptr != '\0' && *sptr != '.') ) {
			delete("Bad display number in DISPLAY.");
			return;
		} else
			CHECK;

		if( (dnop = copystring(cptr, sptr - cptr)) == (char *) 0) {
			delete("malloc failed,");
			return;
		} else
			CHECK;

		dno = atoi(dnop);

		if(*sptr) {
			for(cptr = ++sptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
				;
			if(*sptr) {
				delete("Bad screen number in DISPLAY.");
				return;
			} else
				CHECK;

			if((snop = copystring(cptr, sptr - cptr)) == (char *) NULL) {
				delete("malloc failed.");
				return;
			} else
				CHECK;

			sno = atoi(snop);
			free(snop);

		} else {
			CHECK; CHECK;
			sno = 0; /* No screen number in DISPLAY, assume zero. */
		}
	}

	sprintf(ssno, "%d", sno);
	sprintf(sdno, "%d", dno);

	if((display_name = (char *) malloc(1 + 3 + strlen(ssno) + strlen(sdno) + strlen(config.displayhost))) == (char *) 0) {
		delete("malloc failed.");
		return;
	} else
		CHECK;

	sprintf(display_name, "%s::%s.%s", config.displayhost, sdno, ssno);

	display = XOpenDisplay(display_name);
	if(display == (Display *) NULL) {
		report("%s() returned NULL with argument \"%s\".", TestName, display_name);
		FAIL;
	} else {
		CHECK;
		XNoOp(display);
		XFlush(display);
		XCloseDisplay(display);
	}

	free(display_name);
	CHECKPASS(10);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*display;
char	*cptr, *sptr, *dnop, *snop;
int	rsno;
int	dno;
char	sdno[9];
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XOpenDisplay-2.(C)");
	report_assertion("If the system is POSIX compliant and supports DECnet: When");
	report_assertion("the display_name argument is a string of the form");
	report_assertion("hostname::number, then a call to XOpenDisplay returns a");
	report_assertion("pointer to a display structure and opens a connection to");
	report_assertion("display server number number on hostname with default screen");
	report_assertion("0.");

	report_strategy("If the system is POSIX compliant and supports DECnet transport:");
	report_strategy("  Obtain the display numbers by parsing the DISPLAY config variable.");
	report_strategy("  Open a connection of the form host::number using XOpenDisplay.");
	report_strategy("  Verify that the call did not return NULL.");
	report_strategy("  Obtain the screen number using XDefaultScreen.");
	report_strategy("  Verify that the screen number is 0.");
	report_strategy("  Close the display using XCloseDisplay.");

	tpstartup();
	setargs();
	if(config.posix_system == 0) {
		unsupported("This assertion can only be tested on a POSIX system.");
		return;
	} else
		CHECK;

	if(config.decnet == 0) {
		unsupported("This assertion can only be tested on a system with support for DECnet.");
		return;
	} else
		CHECK;

	for(cptr = config.display; (*cptr) && (*cptr != ':'); cptr++)
		;

	if(*cptr == '\0') {
		delete("DISPLAY does not specify a display.");
		return;
	} else {
		CHECK;
		if(*++cptr != ':') {
			delete("DISPLAY does not contain a valid display name.");
			return;
		} else
			CHECK;

		for(sptr = ++cptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
			;
		if( (sptr == cptr) || (*sptr != '\0' && *sptr != '.') ) {
			delete("Bad display number in DISPLAY.");
			return;
		} else
			CHECK;

		if( (dnop = copystring(cptr, sptr - cptr)) == (char *) 0) {
			delete("malloc failed,");
			return;
		} else
			CHECK;

		dno = atoi(dnop);
		free(dnop);

		if(*sptr) {
			for(cptr = ++sptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
				;
			if(*sptr) {
				delete("Bad screen number in DISPLAY.");
				return;
			} else
				CHECK;

			if((snop = copystring(cptr, sptr - cptr)) == (char *) NULL) {
				delete("malloc failed.");
				return;
			} else
				CHECK;

		} else {
			CHECK; CHECK;
		}
	}

	sprintf(sdno, "%d", dno);

	if((display_name = (char *) malloc(1 + 2 + strlen(sdno) + strlen(config.displayhost))) == (char *) 0) {
		delete("malloc failed.");
		return;
	} else
		CHECK;

	sprintf(display_name, "%s::%s", config.displayhost, sdno);
	free(snop);
	free(dnop);

	display = XOpenDisplay(display_name);
	if(display == (Display *) NULL) {
		report("%s() returned NULL with argument \"%s\".", TestName, display_name);
		FAIL;
	} else {
		CHECK;
		if( (rsno=XDefaultScreen(display)) != 0 ) {
			report("%s() with argument \"%s\" opened screen %d instead of screen 0.", TestName, display_name, rsno);
			FAIL;
		} else
			CHECK;

		XNoOp(display);
		XFlush(display);
		XCloseDisplay(display);
	}

	free(display_name);
	CHECKPASS(11);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display	*display;
char	*cptr, *sptr, *dnop, *snop;
int	dno;
int	sno;
char	ssno[9], sdno[9];
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XOpenDisplay-3.(C)");
	report_assertion("If the system is POSIX compliant and supports TCP: When the");
	report_assertion("display_name argument is a string of the form");
	report_assertion("hostname:number.screen_num, then a call to XOpenDisplay");
	report_assertion("returns a pointer to a display structure and opens a");
	report_assertion("connection to display server number number on hostname with");
	report_assertion("default screen screen_number.");

	report_strategy("If the system is POSIX compliant and supports TCP transport:");
	report_strategy("  Obtain the display and screen numbers by parsing the DISPLAY config variable.");
	report_strategy("  Open a connection using XOpenDisplay.");
	report_strategy("  Verify that the call did not return NULL.");
	report_strategy("  Issue a NoOperation request using XNoOp.");
	report_strategy("  Flush the Output buffer using XFlush.");
	report_strategy("  Close the display using XCloseDisplay.");

	tpstartup();
	setargs();
	if(config.posix_system == 0) {
		unsupported("This assertion can only be tested on a POSIX system.");
		return;
	} else
		CHECK;

	if(config.tcp == 0) {
		unsupported("This assertion can only be tested on a system with support for TCP.");
		return;
	} else
		CHECK;

	for(cptr = config.display; (*cptr) && (*cptr != ':'); cptr++)
		;

	if(*cptr == '\0') {
		delete("DISPLAY does not specify a display.");
		return;
	} else {
		CHECK;
		for(sptr = ++cptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
			;
		if( (sptr == cptr) || (*sptr != '\0' && *sptr != '.') ) {
			delete("Bad display number in DISPLAY.");
			return;
		} else
			CHECK;

		if( (dnop = copystring(cptr, sptr - cptr)) == (char *) 0) {
			delete("malloc failed,");
			return;
		} else
			CHECK;

		dno = atoi(dnop);
		free(dnop);

		if(*sptr) {
			for(cptr = ++sptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
				;
			if(*sptr) {
				delete("Bad screen number in DISPLAY.");
				return;
			} else
				CHECK;

			if((snop = copystring(cptr, sptr - cptr)) == (char *) NULL) {
				delete("malloc failed.");
				return;
			} else
				CHECK;

			sno = atoi(snop);
			free(snop);

		} else {
			CHECK; CHECK;
			sno = 0; /* No screen number in DISPLAY, assume zero. */
		}
	}

	sprintf(ssno, "%d", sno);
	sprintf(sdno, "%d", dno);

	if((display_name = (char *) malloc(1 + 2 + strlen(ssno) + strlen(sdno) + strlen(config.displayhost))) == (char *) 0) {
		delete("malloc failed.");
		return;
	} else
		CHECK;

	sprintf(display_name, "%s:%s.%s", config.displayhost, sdno, ssno);

	display = XOpenDisplay(display_name);
	if(display == (Display *) NULL) {
		report("%s() returned NULL with argument \"%s\".", TestName, display_name);
		FAIL;
	} else {
		CHECK;
		XNoOp(display);
		XFlush(display);
		XCloseDisplay(display);
	}

	free(display_name);
	CHECKPASS(9);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display	*display;
char	*cptr, *sptr, *dnop, *snop;
int	rsno;
int	dno;
char	sdno[9];
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XOpenDisplay-4.(C)");
	report_assertion("If the system is POSIX compliant and supports TCP: When the");
	report_assertion("display_name argument is a string of the form");
	report_assertion("hostname:number, then a call to XOpenDisplay returns a");
	report_assertion("pointer to a display structure and opens a connection to");
	report_assertion("display server number number on hostname with default screen");
	report_assertion("0.");

	report_strategy("If the system is POSIX compliant and supports TCP transport:");
	report_strategy("  Obtain the display numbers by parsing the DISPLAY config variable.");
	report_strategy("  Open a connection of the form host:number using XOpenDisplay.");
	report_strategy("  Verify that the call did not return NULL.");
	report_strategy("  Obtain the screen number using XDefaultScreen.");
	report_strategy("  Verify that the screen number is 0.");
	report_strategy("  Close the display using XCloseDisplay.");

	tpstartup();
	setargs();
	if(config.posix_system == 0) {
		unsupported("This assertion can only be tested on a POSIX system.");
		return;
	} else
		CHECK;

	if(config.tcp == 0) {
		unsupported("This assertion can only be tested on a system with support for TCP.");
		return;
	} else
		CHECK;

	for(cptr = config.display; (*cptr) && (*cptr != ':'); cptr++)
		;

	if(*cptr == '\0') {
		delete("DISPLAY does not specify a display.");
		return;
	} else {
		CHECK;

		for(sptr = ++cptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
			;
		if( (sptr == cptr) || (*sptr != '\0' && *sptr != '.') ) {
			delete("Bad display number in DISPLAY.");
			return;
		} else
			CHECK;

		if( (dnop = copystring(cptr, sptr - cptr)) == (char *) 0) {
			delete("malloc failed,");
			return;
		} else
			CHECK;

		dno = atoi(dnop);
		free(dnop);

		if(*sptr) {
			for(cptr = ++sptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
				;
			if(*sptr) {
				delete("Bad screen number in DISPLAY.");
				return;
			} else
				CHECK;

			if((snop = copystring(cptr, sptr - cptr)) == (char *) NULL) {
				delete("malloc failed.");
				return;
			} else
				CHECK;

			free(snop);

		} else {
			CHECK; CHECK;
		}
	}

	sprintf(sdno, "%d", dno);

	if((display_name = (char *) malloc(1 + 1 + strlen(sdno) + strlen(config.displayhost))) == (char *) 0) {
		delete("malloc failed.");
		return;
	} else
		CHECK;

	sprintf(display_name, "%s:%s", config.displayhost, sdno);

	display = XOpenDisplay(display_name);
	if(display == (Display *) NULL) {
		report("%s() returned NULL with argument \"%s\".", TestName, display_name);
		FAIL;
	} else {
		CHECK;
		if( (rsno=XDefaultScreen(display)) != 0 ) {
			report("%s() with argument \"%s\" opened screen %d instead of screen 0.", TestName, display_name, rsno);
			FAIL;
		} else
			CHECK;

		XNoOp(display);
		XFlush(display);
		XCloseDisplay(display);
	}

	free(display_name);
	CHECKPASS(10);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XOpenDisplay-5.(C)");
	report_assertion("If the system is POSIX compliant: When the display_name");
	report_assertion("argument is NULL, then a call to XOpenDisplay opens a");
	report_assertion("connection specified by the value of the DISPLAY environment");
	report_assertion("variable.");

	report_strategy("Fork a child process using tet_fork.");
	report_strategy("In child:");
	report_strategy("  Exec the file \"./Test1\" with the environment variable DISPLAY set to the value of DISPLAY config variable.");
	report_strategy("  Open the display NULL using XOpenDisplay.");
	report_strategy("  Obtain the actual display string used using XDisplayString.");
	report_strategy("  Obtain the value of the DISPLAY environment variable using getvar.");
	report_strategy("  Verify that these values are the same.");

	tpstartup();
	setargs();
	if(config.posix_system == 0) {
		unsupported("This assertion can only be tested on a POSIX system.");
	} else
		tet_fork(t005exec, TET_NULLFP, 0 , ~0);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display	*display;
char	*cptr, *sptr, *dnop, *snop;
int	dno;
int	sno;
char	ssno[9], sdno[9];
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XOpenDisplay-6.(D)");
	report_assertion("If the system is POSIX compliant and supports DECnet and a");
	report_assertion("local display server: When the display_name argument is a");
	report_assertion("string of the form ::number.screen_num or ::number, then a");
	report_assertion("call to XOpenDisplay opens the most efficient transport");
	report_assertion("connection available to the specified display server and");
	report_assertion("default screen on the client machine.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If the system is POSIX compliant and supports DECnet and a local display server:");
	report_strategy("  Obtain the display and screen numbers from DISPLAY.");
	report_strategy("  Open a connection of the form ::number.display.");
	report_strategy("  Verify that the call did not return NULL.");
	report_strategy("  Issue a NoOperation request using XNoOp.");
	report_strategy("  Flush the Output buffer using XFlush.");
	report_strategy("  Close the display using XCloseDisplay.");
	report_strategy("  Open a connection of the form ::number .");
	report_strategy("  Verify that the call did not return NULL.");
	report_strategy("  Issue a NoOperation request using XNoOp.");
	report_strategy("  Flush the Output buffer using XFlush.");
	report_strategy("  Close the display using XCloseDisplay.");

	tpstartup();
	setargs();
	if(config.posix_system == 0) {
		unsupported("This assertion can only be tested on a POSIX system.");
		return;
	} else
		CHECK;

	if(config.decnet == 0) {
		unsupported("This assertion can only be tested on a system with support for DECnet.");
		return;
	} else
		CHECK;

	if(config.local == 0) {
		unsupported("This assertion can only be tested on a system with a local display server.");
		return;
	} else
		CHECK;

	for(cptr = config.display; (*cptr) && (*cptr != ':'); cptr++)
		;

	if(*cptr == '\0') {
		delete("DISPLAY does not specify a display.");
		return;
	} else {
		CHECK;
		if(*++cptr != ':') {
			delete("_DISPLAY does not contain a valid display name.");
			return;
		} else
			CHECK;

		for(sptr = ++cptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
			;
		if( (sptr == cptr) || (*sptr != '\0' && *sptr != '.') ) {
			delete("Bad display number in DISPLAY.");
			return;
		} else
			CHECK;

		if( (dnop = copystring(cptr, sptr - cptr)) == (char *) 0) {
			delete("malloc failed,");
			return;
		} else
			CHECK;

		dno = atoi(dnop);
		free(dnop);

		if(*sptr) {
			for(cptr = ++sptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
				;
			if(*sptr) {
				delete("Bad screen number in DISPLAY.");
				return;
			} else
				CHECK;

			if((snop = copystring(cptr, sptr - cptr)) == (char *) NULL) {
				delete("malloc failed.");
				return;
			} else
				CHECK;

			sno = atoi(snop);
			free(snop);

		} else {
			CHECK; CHECK;
			sno = 0; /* No screen number in DISPLAY, assume zero. */
		}
	}

	sprintf(ssno, "%d", sno);
	sprintf(sdno, "%d", dno);

	if((display_name = (char *) malloc(1 + 3 + strlen(ssno) + strlen(sdno))) == (char *) 0) {
		delete("malloc failed.");
		return;
	} else
		CHECK;

	sprintf(display_name, "::%s.%s", sdno, ssno);

	display = XOpenDisplay(display_name);
	if(display == (Display *) NULL) {
		report("%s() returned NULL with argument \"%s\".", TestName, display_name);
		FAIL;
	} else {
		CHECK;
		XNoOp(display);
		XFlush(display);
		XCloseDisplay(display);
	}

	free(display_name);
/* added :: */

	if((display_name = (char *) malloc(1 + 2 + strlen(sdno))) == (char *) 0) {
		delete("malloc failed.");
		return;
	} else
		CHECK;

	sprintf(display_name, "::%s", sdno);

	display = XOpenDisplay(display_name);
	if(display == (Display *) NULL) {
		report("%s() returned NULL with argument \"%s\".", TestName, display_name);
		FAIL;
	} else {
		CHECK;
		XNoOp(display);
		XFlush(display);
		XCloseDisplay(display);
	}

	free(display_name);

	CHECKUNTESTED(13);


	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Display	*display;
char	*cptr, *sptr, *dnop, *snop;
int	dno;
int	sno;
char	ssno[9], sdno[9];
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XOpenDisplay-7.(D)");
	report_assertion("If the system is POSIX compliant and supports TCP and a");
	report_assertion("local display server: When the display_name argument is a");
	report_assertion("string of the form :number.screen_num or :number, then a");
	report_assertion("call to XOpenDisplay opens the most efficient transport");
	report_assertion("connection available to the specified display server and");
	report_assertion("default screen on the client machine.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If the system is POSIX compliant and supports TCP and a local display server:");
	report_strategy("  Obtain the display and screen numbers from DISPLAY.");
	report_strategy("  Open a connection of the form :number.display.");
	report_strategy("  Verify that the call did not return NULL.");
	report_strategy("  Issue a NoOperation request using XNoOp.");
	report_strategy("  Flush the Output buffer using XFlush.");
	report_strategy("  Close the display using XCloseDisplay.");
	report_strategy("  Open a connection of the form :number .");
	report_strategy("  Verify that the call did not return NULL.");
	report_strategy("  Issue a NoOperation request using XNoOp.");
	report_strategy("  Flush the Output buffer using XFlush.");
	report_strategy("  Close the display using XCloseDisplay.");

	tpstartup();
	setargs();
	if(config.posix_system == 0) {
		unsupported("This assertion can only be tested on a POSIX system.");
		return;
	} else
		CHECK;

	if(config.tcp == 0) {
		unsupported("This assertion can only be tested on a system with support for TCP.");
		return;
	} else
		CHECK;

	if(config.local == 0) {
		unsupported("This assertion can only be tested on a system with a local display server.");
		return;
	} else
		CHECK;

	for(cptr = config.display; (*cptr) && (*cptr != ':'); cptr++)
		;

	if(*cptr == '\0') {
		delete("DISPLAY does not specify a display.");
		return;
	} else {
		CHECK;

		for(sptr = ++cptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
			;
		if( (sptr == cptr) || (*sptr != '\0' && *sptr != '.') ) {
			delete("Bad display number in DISPLAY.");
			return;
		} else
			CHECK;

		if( (dnop = copystring(cptr, sptr - cptr)) == (char *) 0) {
			delete("malloc failed,");
			return;
		} else
			CHECK;

		dno = atoi(dnop);
		free(dnop);

		if(*sptr) {
			for(cptr = ++sptr; *sptr && isascii(*sptr) && isdigit(*sptr); sptr++)
				;
			if(*sptr) {
				delete("Bad screen number in DISPLAY.");
				return;
			} else
				CHECK;

			if((snop = copystring(cptr, sptr - cptr)) == (char *) NULL) {
				delete("malloc failed.");
				return;
			} else
				CHECK;

			sno = atoi(snop);
			free(snop);

		} else {
			CHECK; CHECK;
			sno = 0; /* No screen number in DISPLAY, assume zero. */
		}
	}

	sprintf(ssno, "%d", sno);
	sprintf(sdno, "%d", dno);

	if((display_name = (char *) malloc(1 + 2 + strlen(ssno) + strlen(sdno))) == (char *) 0) {
		delete("malloc failed.");
		return;
	} else
		CHECK;

	sprintf(display_name, ":%s.%s", sdno, ssno);

	display = XOpenDisplay(display_name);
	if(display == (Display *) NULL) {
		report("%s() returned NULL with argument \"%s\".", TestName, display_name);
		FAIL;
	} else {
		CHECK;
		XNoOp(display);
		XFlush(display);
		XCloseDisplay(display);
	}

	free(display_name);
/* added : */

	if((display_name = (char *) malloc(1 + 1 + strlen(sdno))) == (char *) 0) {
		delete("malloc failed.");
		return;
	} else
		CHECK;

	sprintf(display_name, ":%s", sdno);

	display = XOpenDisplay(display_name);
	if(display == (Display *) NULL) {
		report("%s() returned NULL with argument \"%s\".", TestName, display_name);
		FAIL;
	} else {
		CHECK;
		XNoOp(display);
		XFlush(display);
		XCloseDisplay(display);
	}

	free(display_name);

	CHECKUNTESTED(12);


	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int			scount;
int			i;
Window			aroot;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XOpenDisplay-8.(A)");
	report_assertion("When a call to XOpenDisplay is successful, then all of the");
	report_assertion("screens in the display can be used by the client.");

	report_strategy("For each screen:");
	report_strategy("	Obtain the root window ID of the alternate screen.");
	report_strategy("	Obtain the window attributes of that window using XGetWindowAttributes.");
	report_strategy("	Verify that the call returned non zero.");

	tpstartup();
	setargs();
	scount = ScreenCount(Dsp);

	for(i=0; i< scount; i++) {

		aroot = RootWindow(Dsp, i);
	
		if(XGetWindowAttributes(Dsp, aroot, &atts) == 0) {
			report("Unable to access the attributes of the root window of screen %d.", i);
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(scount);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Window	root0;
unsigned char	*rmstr;
char	*rstr;
Display	*display;
Atom	type_ret;
int	format_ret;
unsigned long	nitems_ret;
unsigned long	bytes_after_ret;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XOpenDisplay-9.(A)");
	report_assertion("On a call to XOpenDisplay the RESOURCE_MANAGER property of");
	report_assertion("the root window of screen 0 is read and stored.");

	report_strategy("Get the RESOURCE_MANAGER property of the root window on screen 0 ");
	report_strategy("	using XGetWindowProperty.");
	report_strategy("Open a display using XOpenDisplay.");
	report_strategy("Verify that the call did not return NULL.");
	report_strategy("Obtain the value of the RESOURCE_MANAGER property using XResourceManagerString.");
	report_strategy("Verify that the value of the property is correct.");

	tpstartup();
	setargs();
	root0 = XRootWindow(Dsp, 0);

	if(XGetWindowProperty(Dsp, root0, XA_RESOURCE_MANAGER, 0L, -1L, False, 
			XA_STRING, &type_ret, &format_ret, &nitems_ret,
				&bytes_after_ret, &rmstr) != Success) {
		delete("XGetWindowProperty did not return Success");
		return;
	}
	if(type_ret != XA_STRING || format_ret != 8 ||
	  nitems_ret == 0 || rmstr == (unsigned char *)NULL) {
		trace("nitems was %ld", nitems_ret);
		trace("type was  %d", type_ret);
		trace("format was  %d", format_ret);
		rmstr = (unsigned char *)NULL;
	}
	trace("Config.display is %s", config.display);
	display = XOpenDisplay(config.display);
	
	if(display == (Display *) NULL) {
		report("%s() returned NULL with argument %s.", TestName, config.display);
		FAIL;
		return;
	} else 
		CHECK;

	rstr = XResourceManagerString(display);

	if(rmstr == (unsigned char *)NULL) {
		if(rstr != (char *)NULL && *rstr != '\0') {
			report("After calling %s", TestName);
			report("XResourceManagerString returned a value :");
			report("  \"%s\",", rstr);
			report("although the RESOURCE_MANAGER property of the");
			report("root window of screen zero was unset.");
			FAIL;
		} else
			CHECK;
	} else {
		if((rstr == (char *) NULL) || (strcmp(rstr, (char *)rmstr) != 0)) {
			report("After calling %s", TestName);
			report("XResourceManagerString returned a value :");
			report("  \"%s\",", rstr == (char *) NULL ? "<NULL_POINTER>" : rstr);
			report("instead of:");
			report("  \"%s\".", rmstr);
			FAIL;
		} else
			CHECK;
	}

	XCloseDisplay(display);

	CHECKPASS(2);	

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Display *display;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XOpenDisplay-10.(A)");
	report_assertion("When a call to XOpenDisplay is not successful, then it");
	report_assertion("returns NULL.");

	report_strategy("Open a display with hostname as the argument using XOpenDisplay.");
	report_strategy("Verify that the call returned NULL.");

	tpstartup();
	setargs();
	display_name = config.displayhost;
	startcall(Dsp);
	if (isdeleted())
		return;
	display = XOpenDisplay(display_name);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(display != (Display *) NULL) {
		report("%s() did not return NULL with argument \"%s\".", TestName, display_name);
		FAIL;
	} else
		PASS;		
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
