/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetWMSizeHints(display, w, hints_return, supplied_return, property)
 *   Display		*display;
 *   Window		w;
 *   XSizeHints	*hints_return;
 *   long		*supplied_return;
 *   Atom		property;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetWMSizeHints	1
char    *TestName = "XGetWMSizeHints";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w
#define A_ATOM property


/*
 * Arguments to the XGetWMSizeHints function
 */
static Display		*display;
static Window		w;
static XSizeHints	*hints_return;
static long		*supplied_return;
static Atom		property;


static int 	StatusReturn;

#include	"X11/Xatom.h"
#define		NumPropSizeElements 18
#define		OldNumPropSizeElements 15
static XSizeHints	sizehints = {0,1,2,3,4,5,6,7,8,9,10, {11,12} ,  {13,14},  15, 16, 17};
static XSizeHints	rhints =    {100,101,102,103,104,105,106,107,108,109,110, {111,112} ,  {113,114},  115, 116, 117};
static long		supret;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	hints_return = &sizehints;
	supplied_return = &supret;
	property = XA_WM_NORMAL_HINTS;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status		status;
Window		win;
long		rsupp;
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetWMSizeHints-1.(A)");
	report_assertion("When the property specified by the property argument is set");
	report_assertion("on the window w with a type of WM_SIZE_HINTS, a format of 32");
	report_assertion("and is long enough to contain either a pre-ICCCM structure");
	report_assertion("or a new size hints structure, then a call to");
	report_assertion("XGetWMSizeHints sets the components of the XSizeHints");
	report_assertion("structure named by the hints_return clear argument and");
	report_assertion("returns non-zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the property WM_NORMAL_HINTS with XSetWMSizeHints.");
	report_strategy("Obtain the value of the WM_NORMAL_HINTS property using XGetWMSizeHints.");
	report_strategy("Verify that the function did not return False.");
	report_strategy("Verify that the entire structure has been returned.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);

	XSetWMSizeHints(display, win, &sizehints, property);

	w = win;
	hints_return = &rhints;
	supplied_return = &rsupp;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMSizeHints(display, w, hints_return, supplied_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if( status == False ) {
		report("XGetWMSizeHints() returned False.");
		FAIL;
	} else
		CHECK;
	
	if(rhints.flags != 0) {
		report("The flags component of the XSizeHints structure was %lu instead of 0.", rhints.flags);
		FAIL;
	} else
		CHECK;

	if(rhints.x != 1) {
		report("The x component of the XSizeHints structure was %d instead of 1.", rhints.x);
		FAIL;
	} else
		CHECK;

	if(rhints.y != 2) {
		report("The y component of the XSizeHints structure was %d instead of 2.", rhints.y);
		FAIL;
	} else
		CHECK;

	if(rhints.width != 3) {
		report("The width component of the XSizeHints structure was %d instead of 3.", rhints.width);
		FAIL;
	} else
		CHECK;

	if(rhints.height != 4) {
		report("The height component of the XSizeHints structure was %d instead of 4.", rhints.height);
		FAIL;
	} else
		CHECK;

	if(rhints.min_width != 5) {
		report("The min_width component of the XSizeHints structure was %d instead of 5.", rhints.min_width);
		FAIL;
	} else
		CHECK;

	if(rhints.min_height != 6) {
		report("The min_height component of the XSizeHints structure was %d instead of 6.", rhints.min_height);
		FAIL;
	} else
		CHECK;

	if(rhints.max_width != 7) {
		report("The max_width component of the XSizeHints structure was %d instead of 7.", rhints.max_width);
		FAIL;
	} else
		CHECK;

	if(rhints.max_height != 8) {
		report("The max_height component of the XSizeHints structure was %d instead of 8.", rhints.max_height);
		FAIL;
	} else
		CHECK;

	if(rhints.width_inc != 9) {
		report("The width_inc component of the XSizeHints structure was %d instead of 9.", rhints.width_inc);
		FAIL;
	} else
		CHECK;

	if(rhints.height_inc != 10) {
		report("The height_inc component of the XSizeHints structure was %d instead of 10.", rhints.height_inc);
		FAIL;
	} else
		CHECK;

	if((rhints.min_aspect.x != 11) || (rhints.min_aspect.y != 12)){
		report("The min_aspect components of the XSizeHints structure were %d, %d instead of 11, 12.",
			rhints.min_aspect.x, rhints.min_aspect.y);
		FAIL;
	} else
		CHECK;

	if((rhints.max_aspect.x != 13) || (rhints.max_aspect.y != 14)){
		report("The max_aspect components of the XSizeHints structure were %d, %d instead of 13, 14.",
			rhints.max_aspect.x, rhints.max_aspect.y);
		FAIL;
	} else
		CHECK;

	if(rhints.base_width != 15) {
		report("The base_width component of the XSizeHints structure was %d instead of 15.", rhints.base_width);
		FAIL;
	} else
		CHECK;

	if(rhints.base_height != 16) {
		report("The base_height component of the XSizeHints structure was %d instead of 16.", rhints.base_height);
		FAIL;
	} else
		CHECK;

	if(rhints.win_gravity != 17) {
		report("The win_gravity component of the XSizeHints structure was %d instead of 17", rhints.win_gravity);
		FAIL;
	} else
		CHECK;

	CHECKPASS(17);


	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Status		status;
Window		win;
XSizeHints	rhints;
long		rsupp;
XSizeHints	dummy; /* Big enough (by definition). */
XVisualInfo	*vp;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetWMSizeHints-2.(A)");
	report_assertion("When the property specified by the property argument is not");
	report_assertion("set on the window w, or is not of type WM_SIZE_HINTS, or is");
	report_assertion("not of format 32, or the property is not long enough to");
	report_assertion("contain either a pre-ICCCM structure or a new size hints");
	report_assertion("structure, then a call to XGetWMSizeHints returns zero.");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Obtain the property WM_NORMAL_HINTS with XGetWMSizeHints.");
	report_strategy("Verify that the call returned zero.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_NORMAL_HINTS property of format 32 type WM_SIZE_HINTS with OldNumPropSizeElements-1 elements XChangeProperty.");
	report_strategy("Obtain the property WM_NORMAL_HINTS with XGetWMSizeHints.");
	report_strategy("Verify that the call returned zero.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_NORMAL_HINTS property of format 16 type WM_SIZE_HINTS with NumPropSizeElements elements with XChangeProperty.");
	report_strategy("Obtain the property WM_NORMAL_HINTS with XGetWMSizeHints.");
	report_strategy("Verify that the call returned zero.");
	report_strategy("");
	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the WM_NORMAL_HINTS property of format 32 type STRING with NumPropSizeElements elements with XChangeProperty.");
	report_strategy("Obtain the property WM_NORMAL_HINTS with XGetWMSizeHints.");
	report_strategy("Verify that the call returned zero.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);

	win = makewin(display, vp);

	w = win;
	hints_return = &rhints;
	supplied_return = &rsupp;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMSizeHints(display, w, hints_return, supplied_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(status != False) {
		report("XGetWMSizeHints() did not return False when the WM_NORMAL_HINTS property was unset.");
		FAIL;
	} else
		CHECK;

	win = makewin(display, vp);
	XChangeProperty(display, win, XA_WM_NORMAL_HINTS, XA_WM_SIZE_HINTS, 32, PropModeReplace, (unsigned char *)&dummy, OldNumPropSizeElements-1);
	w = win;
	hints_return = &rhints;
	supplied_return = &rsupp;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMSizeHints(display, w, hints_return, supplied_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(status != False) {
		report("XGetWMSizeHints() did not return False when size was %lu 32-bit elements.", OldNumPropSizeElements-1);
		FAIL;
	} else
		CHECK;

	win = makewin(display, vp);
	XChangeProperty(display, win, XA_WM_NORMAL_HINTS, XA_WM_SIZE_HINTS, 16, PropModeReplace, (unsigned char *)&dummy, NumPropSizeElements);
	w = win;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMSizeHints(display, w, hints_return, supplied_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("XGetWMSizeHints() did not return False when format was 16.");
		FAIL;
	} else
		CHECK;

	win = makewin(display, vp);
	XChangeProperty(display, win, XA_WM_NORMAL_HINTS, XA_STRING, 32, PropModeReplace, (unsigned char *)&dummy, NumPropSizeElements);
	w = win;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMSizeHints(display, w, hints_return, supplied_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if(status != False) {
		report("XGetWMSizeHints() did not return False when type was STRING.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Status		status;
Window		win;
XSizeHints	rhints;
long		rsupp;
XSizeHints	dummy; /* Big enough (by definition). */
XVisualInfo	*vp;
unsigned long	flagval = (USPosition | USSize | PPosition | PSize | PMinSize | PMaxSize | PResizeInc | PAspect) ;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetWMSizeHints-3.(A)");
	report_assertion("When a call to XGetWMSizeHints returns successfully and a");
	report_assertion("pre-ICCCM size hints property is read, then the");
	report_assertion("supplied_return argument contains the bits (USPosition|");
	report_assertion("USSize|PPosition|PSize|PMinSize|PMaxSize|");
	report_assertion("PResizeInc|PAspect).");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the property WM_NORMAL_HINTS with size OldNumPropSizeElements using XChangeProperty.");
	report_strategy("Obtain the value of the WM_NORMAL_HINTS property using XGetWMSizeHints.");
	report_strategy("Verify that the value returned in supplied_return was (USPositionUSSize|PPosition|PSize|PMinSize|PMaxSize|PResizeInc|PAspect).");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);

	XChangeProperty(display, win, XA_WM_NORMAL_HINTS, XA_WM_SIZE_HINTS, 32, PropModeReplace, (unsigned char *)&dummy, OldNumPropSizeElements);
	w = win;
	hints_return = &rhints;
	supplied_return = &rsupp;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMSizeHints(display, w, hints_return, supplied_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(status == False) {
		report("XGetWMSizeHints() returned False.");
		FAIL;
	} else
		CHECK;

	if( rsupp != flagval ) {
		report("supplied_return was %lu instead of (USPosition | USSize | PPosition | PSize | PMinSize | PMaxSize | PResizeInc | PAspect) (%lu)", rsupp, flagval);
		report("for a pre-ICCCM structure.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Status		status;
Window		win;
XSizeHints	rhints;
long		rsupp;
XSizeHints	dummy; /* Big enough (by definition). */
XVisualInfo	*vp;
long		flagval = (PBaseSize | PWinGravity | USPosition | USSize | PPosition | PSize | PMinSize | PMaxSize | PResizeInc | PAspect);
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGetWMSizeHints-4.(A)");
	report_assertion("When the property specified by the property argument is");
	report_assertion("large enough to contain the base size and window gravity");
	report_assertion("fields, then the supplied_return argument contains the bits");
	report_assertion("(PBaseSize|PWinGravity|USPosition|USSize|PPosition|");
	report_assertion("PSize|PMinSize|PMaxSize|PResizeInc|PAspect).");

	report_strategy("Create a window with XCreateWindow.");
	report_strategy("Set the property WM_NORMAL_HINTS with size OldNumPropSizeElements using XChangeProperty.");
	report_strategy("Obtain the value of the WM_NORMAL_HINTS property using XGetWMSizeHints.");
	report_strategy("Verify that the value returned in supplied_return was (PBaseSize|PWinGravity|USPosition|USSize|PPosition|PSize|PMinSize|PMaxSize|PResizeInc|PAspect).");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);

	XChangeProperty(display, win, XA_WM_NORMAL_HINTS, XA_WM_SIZE_HINTS, 32, PropModeReplace, (unsigned char *)&dummy, NumPropSizeElements);
	w = win;
	hints_return = &rhints;
	supplied_return = &rsupp;
	startcall(display);
	if (isdeleted())
		return;
	status = XGetWMSizeHints(display, w, hints_return, supplied_return, property);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(status == False) {
		report("%s() returned False.", TestName);
		FAIL;
	} else
		CHECK;

	if( rsupp != flagval) {
		report("supplied_return was %lu instead of (PBaseSize | PWinGravity | USPosition | USSize | PPosition | PSize | PMinSize | PMaxSize | PResizeInc | PAspect) (%lu)", rsupp, flagval);
		report("for an ICCCMv1 structure.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAto.mc */
/* End of included file error/EAto.mc */

/* Including from file error/EAto.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGetWMSizeHints-5.(A)");
	report_assertion("When an atom argument does not name a valid Atom, then a");
	report_assertion("BadAtom error occurs.");

	report_strategy("Call test function using a value with the top bits set as the atom argument.");
	report_strategy("Verify that a BadAtom error occurs.");

	tpstartup();
	setargs();
	A_ATOM = ~0L;
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetWMSizeHints(display, w, hints_return, supplied_return, property);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadAtom) {
		report("Got %s, Expecting BadAtom", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadAtom)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAto.mc */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XGetWMSizeHints-6.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetWMSizeHints(display, w, hints_return, supplied_return, property);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
