/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XUngrabDevice(display, device, time1)
 *   Display	*display;
 *   XDevice *device;
 *   Time time1;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XUngrabDevice	1
char    *TestName = "XUngrabDevice";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XUngrabDevice function
 */
static Display	*display;
static XDevice *device;
static Time time1;


extern int MinKeyCode;
extern ExtDeviceInfo Devs;



static Status
ispfrozen()
{
Window	win;
XEvent	ev;

	win = defwin(display);
	XSelectInput(display, win, PointerMotionMask);

	warppointer(display, win, 0, 0);
	warppointer(display, win, 1, 1);

	if (XCheckWindowEvent(display, win, PointerMotionMask, &ev))
		return(False);
	else
		return(True);
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	time1 = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window	win;
int 	n;
int 	first;
XEvent	ev;
XEventClass dkclass[2];
int dkp, dkr;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XUngrabDevice-1.(B)");
	report_assertion("When the client has actively grabbed the device, then a");
	report_assertion("call to UngrabDevice releases the device and any queued");
	report_assertion("events.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create grab window.");
	report_strategy("Grab and freeze device.");
	report_strategy("If no extensions:");
	report_strategy("  Touch test XUngrabDevice.");
	report_strategy("else");
	report_strategy("  Press and release key.");
	report_strategy("  Call XUngrabDevice.");
	report_strategy("  Verify that events are released.");
	report_strategy("  Create new window.");
	report_strategy("  Verify that device events can be received on it.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	DeviceKeyPress(device, dkp, dkclass[0]);
	DeviceKeyRelease(device, dkr, dkclass[1]);
	win = defwin(display);
	XSelectExtensionEvent(display, win, dkclass, 2);

	XGrabDevice(display, device, win, False, 0, NULL, GrabModeSync, GrabModeAsync, time1);

	if (noext(0)) {
		startcall(display);
		if (isdeleted())
			return;
		XUngrabDevice(display, device, time1);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
		untested("There is no reliable test method, but a touch test was performed");
		return;
	} else
		CHECK;

	warppointer(display, win, 10, 10);
	XSync(display,1);
	devicekeypress(display, Devs.Key, MinKeyCode);
	devicekeyrel(display, Devs.Key, MinKeyCode);
	XSync(display,0);

	if (XPending(display)) {
		report("Got events while device was meant to be frozen");
		FAIL;
	} else
		CHECK;

	startcall(display);
	if (isdeleted())
		return;
	XUngrabDevice(display, device, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display,0);

	n = getevent(display, &ev);
	if (n != 2) {
		report("Expecting two events to be released after grab");
		report("  got %d", n);
		FAIL;
	} else {
		first = ev.type;
		getevent(display, &ev);

		if (ev.type != dkp && first != dkp) {
			report("Did not get DeviceKeyPress event after releasing grab");
			FAIL;
		} else
			CHECK;
		if (ev.type != dkr && first != dkr) {
			report("Did not get DeviceKeyRelease event after releasing grab");
			FAIL;
		} else
			CHECK;
	}

	win = defwin(display);
	XSelectExtensionEvent(display, win, &dkclass[0], 1);
	warppointer(display, win, 5, 5);
	devicekeypress(display, Devs.Key, MinKeyCode);
	if (XPending(display)) {
		XNextEvent(display, &ev);
		if (ev.type == dkp)
		CHECK;
	} else {
		report("Device grab was not released");
		FAIL;
	}

	CHECKPASS(5);

	devicekeyrel(display, Devs.Key, MinKeyCode);
	devicerelkeys(Devs.Key);
	restoredevstate();

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window	win;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XUngrabDevice-2.(B)");
	report_assertion("When the specified time is earlier than the last-device-");
	report_assertion("grab time or is later than the current X server time, then a");
	report_assertion("call to UngrabDevice does not release the device and any");
	report_assertion("queued events.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Get current time.");
	report_strategy("Grab device and freeze other devices with this time.");
	report_strategy("Call XUngrabDevice with earlier time.");
	report_strategy("Verify that the pointer is still frozen and therefore device grab is not ");
	report_strategy("released.");
	report_strategy("");
	report_strategy("Get current time and add several seconds to get future time.");
	report_strategy("Call XUngrabDevice with this time.");
	report_strategy("Verify that the pointer is still frozen and therefore keyboard grab is not ");
	report_strategy("released.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	win = defwin(display);
	time1 = gettime(display);

	XGrabDevice(display, device, win, False, 0, NULL, GrabModeSync, GrabModeSync, time1);

	time1 -= 1;
	startcall(display);
	if (isdeleted())
		return;
	XUngrabDevice(display, device, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen())
		CHECK;
	else {
		report("Grab released for time earlier than last-device-grab time");
		FAIL;
	}

	time1 = gettime(display);
	time1 += (config.speedfactor+1) * 1000000;

	startcall(display);
	if (isdeleted())
		return;
	XUngrabDevice(display, device, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ispfrozen())
		CHECK;
	else {
		report("Grab release for time later than current X server time");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Window	grabwin;
Window	win;
Window	ofocus;
XEvent	ev;
XDeviceFocusInEvent	figood;
XDeviceFocusOutEvent	fogood;
int 	orevert;
Time	otime;
int 	dfi, dfo;
XEventClass dfclass[2];
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XUngrabDevice-3.(B)");
	report_assertion("A call to UngrabDevice generates DeviceFocusIn and");
	report_assertion("DeviceFocusOut events as though the focus were to change");
	report_assertion("from the grab window to the current focus window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create grab window.");
	report_strategy("Create a focus window and set focus to that window.");
	report_strategy("Grab device.");
	report_strategy("Enable events on windows.");
	report_strategy("Call XUngrabDevice to release device.");
	report_strategy("Verify that DeviceFocusIn and DeviceFocusOut events are received.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(AnyMask))
	    {
	    untested("%s: Required input extension device not present.\n", TestName);
	    return;
	    }
	device = Devs.Any;
	DeviceFocusIn(device, dfi, dfclass[0]);
	DeviceFocusOut(device, dfo, dfclass[1]);
	/*
	 * Save current input focus to pose as little inconvenience as
	 * possible.
	 */
	XGetDeviceFocus(display, device, &ofocus, &orevert, &otime);

	grabwin = defwin(display);
	win = defwin(display);
	XSetDeviceFocus(display, device, win, RevertToNone, CurrentTime);
	if (isdeleted()) {
		report("Could not set up focus");
		return;
	}
	XGrabDevice(display, device, grabwin, False, 1, dfclass, GrabModeSync, GrabModeSync, time1);

	XSelectExtensionEvent(display, grabwin, dfclass, 2);
	XSelectExtensionEvent(display, win, dfclass, 2);

	startcall(display);
	if (isdeleted())
		return;
	XUngrabDevice(display, device, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/*
	 * Set up the expected good events.
	 */
	defsetevent(figood, display, dfi);
	figood.window = win;
	figood.mode = NotifyUngrab;
	figood.detail = NotifyNonlinear;
	figood.deviceid = device->device_id;

	defsetevent(fogood, display, dfo);
	fogood.window = grabwin;
	fogood.mode = NotifyUngrab;
	fogood.detail = NotifyNonlinear;
	fogood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Did not get expected DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	if (getevent(display, &ev) == 0 || ev.type != dfi) {
		report("Did not get expected DeviceFocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	/* Reset old focus */
	XSetDeviceFocus(display, device, ofocus, orevert, CurrentTime);
	XSync(display,0);

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XDevice nodevice;
XID baddevice;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XUngrabDevice-4.(B)");
	report_assertion("A call to XUngrabDevice will fail with a BadDevice error if");
	report_assertion("an invalid device is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err))
	    {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;

	startcall(display);
	if (isdeleted())
		return;
	XUngrabDevice(display, device, time1);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
