'\" t
.\"     Title: xiqueryversion
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.75.2 <http://docbook.sf.net/>
.\"      Date: 08/04/2010
.\"    Manual: [FIXME: manual]
.\"    Source: [FIXME: source]
.\"  Language: English
.\"
.TH "XIQUERYVERSION" "libmansuffix" "08/04/2010" "[FIXME: source]" "[FIXME: manual]"
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XIQueryVersion \- announce and query the support XI2 version\&.
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput2\&.h>
.fi
.sp
.nf
Status XIQueryVersion( Display *display,
                       int *major_version_inout,
                       int *minor_version_inout);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
major_version_inout
       Specifies the client\'s supported XI2 version, and
       returns the server\'s supported version\&.
.fi
.sp
.nf
minor_version_inout
       Specifies the client\'s supported XI2 version, and
       returns the server\'s supported version\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
XIQueryVersion announces the client\'s supported XI2 version to
the server and returns server\'s supported X Input version\&. Clients
are required to use XIQueryVersion instead of XGetExtensionVersion
if they use XI2 calls\&. The server may treat a client differently
depending on the supported version announced by the client\&.
The major_version_inout must be 2 or greater, otherwise a BadValue
error occurs\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If the server does not support XI2, XIQueryVersion returns BadRequest
to the client\&. Otherwise, XIQueryVersion returns Success\&. In both
cases major_version_inout and minor_version_inout are set to the
server\'s supported version\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIQueryVersion can generate a BadValue error\&.
.fi
.if n \{\
.RE
.\}
.SH "EXAMPLES"
.sp
.if n \{\
.RS 4
.\}
.nf
int rc;
int major = 2;
int minor = 0;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
rc = XIQueryVersion(dpy, &major, &minor);
if (rc == Success)
    printf("XI2 supported\&. (%d\&.%d)\en", major, minor);
else if (rc == BadRequest)
    printf("No XI2 support\&. (%d\&.%d only)\en", major, minor);
else
    printf("Internal error\en");
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadValue
       A value is outside of the permitted range\&.
.fi
.if n \{\
.RE
.\}
