'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetXlibControls __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetXlibControls \- Determines the current state of the Library Controls
.SH SYNOPSIS
.HP
.B unsigned int XkbGetXlibControls
.BI "(\^Display  *" "display" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
connection to X server
.SH DESCRIPTION
.LP
.I XkbGetXlibControls 
returns the current state of the Library Controls as a bit mask that is an 
inclusive OR of the control masks from Table 1 for the controls that are 
enabled. For the optional compose processing controls, the fact that a control 
is enabled does not imply that it is actually implemented.

.TS
c s
l l
l l.
Table 1 Library Control Masks
_
Library Control Mask	Value
_
XkbLC_ForceLatin1Lookup	(1 << 0)
XkbLC_ConsumeLookupMods	(1 << 1)
XkbLC_AlwaysConsumeShiftAndLock	(1 << 2)
XkbLC_IgnoreNewKeyboards	(1 << 3)
XkbLC_ConsumeKeysOnComposeFail	(1 << 29)
XkbLC_ComposeLED	(1 << 30)
XkbLC_BeepOnComposeFail	(1 << 31)
XkbLC_AllControls	(0xc0000007)
.TE

