'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbSetAccessXTimeout __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSetAccessXTimeout \- Configures the AccessXTimeout options for a keyboard 
device
.SH SYNOPSIS
.HP
.B Bool XkbSetAccessXTimeout
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "device_spec" "\^,"
.BI "unsigned short " "timeout" "\^,"
.BI "unsigned int " "ctrls_mask" "\^,"
.BI "unsigned int " "ctrls_values" "\^,"
.BI "unsigned short " "opts_mask" "\^,"
.BI "unsigned short " "opts_values" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
connection to X server
.TP
.I \- device_spec
device to configure, or XkbUseCoreKbd
.TP
.I \- timeout
seconds idle until AccessXTimeout occurs
.TP
.I \- ctrls_mask
boolean controls to modify 
.TP
.I \- ctrls_values
new bits for controls selected by ctrls_mask
.TP
.I \- opts_mask
ax_options to change
.TP
.I \- opts_values
new bits for ax_options selected by opts_mask
.SH DESCRIPTION
.LP
In environments where computers are shared, features such as SlowKeys present a 
problem: if SlowKeys is on, the keyboard can appear to be unresponsive because 
keys are not accepted until they are held for a certain period of time. To help 
solve this problem, Xkb provides an AccessXTimeout control to automatically 
change the enabled/disabled state of any boolean controls and to change the 
value of the AccessXKeys and AccessXFeedback control attributes if the keyboard 
is idle for a specified period of time.

When a timeout as specified by AccessXTimeout occurs and a control is 
consequently modified, Xkb generates an XkbControlsNotify event. For more 
information on XkbControlsNotify events.

.I timeout 
specifies the number of seconds the keyboard must be idle before the controls 
are modified. 
.I ctrls_mask 
specifies what controls are to be enabled or disabled, and 
.I ctrls_values 
specifies whether those controls are to be enabled or disabled. The bit values 
correspond to those for enabling and disabling boolean controls using 
.I XkbChangeEnabledControls.
 The 
.I opts_mask 
field specifies which attributes of the AccessXKeys and AccessXFeedback controls 
are to be changed, and 
.I opts_values 
specifies the new values for those options. The bit values correspond to those 
for the 
.I ax_options 
field of an XkbDescRec.

.I XkbSetAccessXTimeout 
sends a request to configure the AccessXTimeout control to the server. It does 
not wait for a reply, and normally returns True. If a compatible version of the 
Xkb extension is not available in the server, 
.I XkbSetAccessXTimeout 
returns False.
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbSetAccessXTimeout
function returns True when a compatible version of the Xkb extension is available in the server.
.TP 15
False
The 
.I XkbSetAccessXTimeout
function returns False when a compatible version of the Xkb extension is not available in the server.
.SH STRUCTURES
.LP
The complete description of an Xkb keyboard is given by an XkbDescRec. The component 
structures in the XkbDescRec represent the major Xkb components.

.nf
typedef struct {
   struct _XDisplay * display;      /\(** connection to X server */
   unsigned short     flags;        /\(** private to Xkb, do not modify */
   unsigned short     device_spec;  /\(** device of interest */
   KeyCode            min_key_code; /\(** minimum keycode for device */
   KeyCode            max_key_code; /\(** maximum keycode for device */
   XkbControlsPtr     ctrls;        /\(** controls */
   XkbServerMapPtr    server;       /\(** server keymap */
   XkbClientMapPtr    map;          /\(** client keymap */
   XkbIndicatorPtr    indicators;   /\(** indicator map */
   XkbNamesPtr        names;        /\(** names for all components */
   XkbCompatMapPtr    compat;       /\(** compatibility map */
   XkbGeometryPtr     geom;         /\(** physical geometry of keyboard */
} XkbDescRec, *XkbDescPtr;

.fi
The 
.I display 
field points to an X display structure. The 
.I flags field is private to the library: modifying 
.I flags 
may yield unpredictable results. The 
.I device_spec 
field specifies the device identifier of the keyboard input device, or 
XkbUseCoreKeyboard, which specifies the core keyboard device. The 
.I min_key_code
and 
.I max_key_code 
fields specify the least and greatest keycode that can be returned by the keyboard. 

Each structure component has a corresponding mask bit that is used in function calls to 
indicate that the structure should be manipulated in some manner, such as allocating it 
or freeing it. These masks and their relationships to the fields in the XkbDescRec are 
shown in Table 1.

.TS
c s s
l l l
l l l.
Table 1 Mask Bits for XkbDescRec
_
Mask Bit	XkbDescRec Field	Value
_
XkbControlsMask	ctrls	(1L<<0)
XkbServerMapMask	server	(1L<<1)
XkbIClientMapMask	map	(1L<<2)
XkbIndicatorMapMask	indicators	(1L<<3)
XkbNamesMask	names	(1L<<4)
XkbCompatMapMask	compat	(1L<<5)
XkbGeometryMask	geom	(1L<<6)
XkbAllComponentsMask	All Fields	(0x7f)
.TE

The structure for the XkbControlsNotify event is defined as follows:
.nf

    typedef struct {
        int           type;          /\(** Xkb extension base event code */
        unsigned long serial;        /\(** X server serial number for event */
        Bool          send_event;    /\(** True => synthetically generated */
        Display *     display;       /\(** server connection where event generated */
        Time          time;          /\(** server time when event generated */
        int           xkb_type;      /\(** XkbCompatMapNotify */
        int           device;        /\(** Xkb device ID, will not be XkbUseCoreKbd */
        unsigned int  changed_ctrls; /\(** bits indicating which controls data have changed*/
        unsigned int  enabled_ctrls; /\(** controls currently enabled in server */
        unsigned int  enabled_ctrl_changes; /\(** bits indicating enabled/disabled controls */
        int           num_groups;    /\(** current number of keyboard groups */
        KeyCode       keycode;       /\(** != 0 => keycode of key causing change */
        char          event_type;    /\(** Type of event causing change */
        char          req_major;     /\(** major event code of event causing change */
        char          req_minor;     /\(** minor event code of event causing change */
    } XkbControlsNotifyEvent;
    
.fi    
.SH "SEE ALSO"
.BR XkbChangeEnabledControls (__libmansuffix__)
