'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbNoteDeviceChanges __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbNoteDeviceChanges \- Note device changes reported in an XkbExtensionDeviceNotify event
.SH SYNOPSIS
.HP
.B void XkbNoteDeviceChanges
.BI "(\^XkbDeviceChangesPtr " "old" "\^,"
.BI "XkbExtensionDeviceNotifyEvent *" "new" "\^,"
.BI "unsigned int " "wanted" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- old
structure tracking state changes
.TP
.I \- new
event indicating state changes
.TP
.I \- wanted
mask indicating changes to note
.SH DESCRIPTION
.LP
The 
.I wanted 
field specifies the changes that should be noted in 
.I old, 
and is composed of the bitwise inclusive OR of one or more of the masks from Table 1. The
.I reason 
field of the event in 
.I new 
indicates the types of changes the event is reporting. 
.I XkbNoteDeviceChanges 
updates the XkbDeviceChangesRec specified by 
.I old 
with the changes that are both specified in 
.I wanted 
and contained in 
.I new->reason.

.nf
                         Table 1 XkbDeviceInfoRec Mask Bits                        
____________________________________________________________________________________
Name                         XkbDeviceInfoRec Value     Capability If Set
                             Fields Effected            
____________________________________________________________________________________
XkbXI_KeyboardsMask                           (1L <<0) Clients can use all
                                                       Xkb requests and events
                                                       with KeyClass devices 
                                                       supported by the input
                                                       device extension.

XkbXI_ButtonActionsMask       num_btns        (1L <<1) Clients can assign key 
                              btn_acts                 actions to buttons 
                                                       non-KeyClass input
                                                       extension devices.
                           
XkbXI_IndicatorNamesMask      leds->names     (1L <<2) Clients can assign
                                                       names to indicators on
                                                       non-KeyClass input
                                                       extension devices.
                                                             
XkbXI_IndicatorMapsMask       leds->maps      (1L <<3) Clients can assign
                                                       indicator maps to
                                                       indicators on 
                                                       non-KeyClass input
                                                       extension devices.

XkbXI_IndicatorStateMask      leds->state     (1L <<4) Clients can request 
                                                       the status of indicators
                                                       on non-KeyClass input
                                                       extension devices.

XkbXI_IndicatorsMask          sz_leds         (0x1c)   XkbXI_IndicatorNamesMask |
                              num_leds                 XkbXI_IndicatorMapsMask |
                              leds->*                  XkbXI_IndicatorStateMask

XkbXI_UnsupportedFeaturesMask unsupported     (1L <<15)

XkbXI_AllDeviceFeaturesMask   Those selected  (0x1e)   XkbXI_IndicatorsMask |
                              by Value Column          XkbSI_ButtonActionsMask
                              masks 

XkbXI_AllFeaturesMask         Those selected  (0x1f)   XkbSI_AllDeviceFeaturesMask |
                              by Value Column          XkbSI_KeyboardsMask
                              masks

XkbXI_AllDetailsMask          Those selected  (0x801f) XkbXI_AllFeaturesMask |
                              by Value column          XkbXI_UnsupportedFeaturesMask
                              masks
.fi

To update a local copy of the state and configuration of an X input extension device with the changes 
previously noted in an XkbDeviceChangesRec structure, use
.I XkbGetDeviceInfoChanges.
.SH STRUCTURES
.LP
Changes to an Xkb extension device may be tracked by listening to XkbDeviceExtensionNotify events and 
accumulating the changes in an XkbDeviceChangesRec structure. The changes noted in the structure may 
then be used in subsequent operations to update either a server configuration or a local copy of an 
Xkb extension device configuration. The changes structure is defined as follows:
.nf

typedef struct _XkbDeviceChanges {
    unsigned int         changed;       /\(** bits indicating what has changed */
    unsigned short       first_btn;     /\(** number of first button which changed, if any */
    unsigned short       num_btns;      /\(** number of buttons that have changed */
    XkbDeviceLedChangesRec leds;
} XkbDeviceChangesRec,*XkbDeviceChangesPtr;

.fi
.SH "SEE ALSO"
.BR XkbGetDeviceInfoChanges (__libmansuffix__)
