.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbComputeShapeBounds __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbComputeShapeBounds \- Updates the bounding box of a shape
.SH SYNOPSIS
.HP
.B Bool XkbComputeShapeBounds
.BI "(\^XkbShapePtr " "shape" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- shape
shape to be examined
.SH DESCRIPTION
.LP
Xkb provides a number of convenience functions to help use a keyboard geometry. These include 
functions to return the bounding box of a shape's top surface and to update the bounding box 
of a shape row or section.

A shape is made up of a number of outlines. Each outline is a polygon made up of a number of 
points. The bounding box of a shape is a rectangle that contains all the outlines of that 
shape. 

A ShapeRec contains a BoundsRec that describes the bounds of the shape. If you add or delete 
an outline to or from a shape, the bounding box must be updated.

.I XkbComputeShapeBounds 
updates the BoundsRec contained in the 
.I shape 
by examining all the outlines of the shape and setting the BoundsRec to the minimum x and 
minimum y, and maximum x and maximum y values found in those outlines. 
.I XkbComputeShapeBounds 
returns False if 
.I shape 
is NULL or if there are no outlines for the shape; otherwise, it returns True.

If you add or delete a key to or from a row, or if you update the shape of one of the keys in that row, you may need to update the bounding box of that row. To update the bounding box of a row, use 
.I XkbComputeRowBounds.
.SH STRUCTURES
.LP
.nf

typedef struct _XkbShape {
    Atom           name;         /\(** shape's name */
    unsigned short num_outlines; /\(** number of outlines for the shape */
    unsigned short sz_outlines;  /\(** size of the outlines array */
    XkbOutlinePtr  outlines;     /\(** array of outlines for the shape */
    XkbOutlinePtr  approx;       /\(** pointer into the array to the approximating outline */
    XkbOutlinePtr  primary;      /\(** pointer into the array to the primary outline */
    XkbBoundsRec   bounds;       /\(** bounding box for the shape; encompasses all outlines */
} XkbShapeRec, *XkbShapePtr;

typedef struct _XkbBounds {
    short	x1,y1;	/\(** upper left corner of the bounds, in mm/10 */
    short	x2,y2;	/\(** lower right corner of the bounds, in mm/10 */
} XkbBoundsRec, *XkbBoundsPtr;

.fi
.SH "SEE ALSO"
.BR XkbComputeRowBounds (__libmansuffix__)

