.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbGetGeometry __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetGeometry \- Loads a keyboard geometry if you already have the keyboard 
description
.SH SYNOPSIS
.B Status XkbGetGeometry
(
.I dpy,
.I xkb
)
.br
      Display * \fIdpy\fP\^;
.br
      XkbDescPtr \fIxkb\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to the X server
.TP
.I \- xkb
keyboard description that contains the ID for the keyboard and into which the 
geometry should be loaded
.SH DESCRIPTION
.LP
You can load a keyboard geometry as part of the keyboard description returned by
.I XkbGetKeyboard. 
However, if a keyboard description has been previously loaded, you can instead 
obtain the geometry by calling the 
.I XkbGetGeometry. 
In this case, the geometry returned is the one associated with the keyboard 
whose device ID is contained in the keyboard description.

.I XkbGetGeometry 
can return BadValue, BadImplementation, BadName, BadAlloc, or BadLength errors 
or Success if it succeeds.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadImplementation
Invalid reply from server
.TP 15
.B BadLength
The length of a request is shorter or longer than that required to minimally 
contain the arguments
.TP 15
.B BadName
A font or color of the specified name does not exist
.TP 15
.B BadValue
An argument is out of range
.SH "SEE ALSO"
.BR XkbGetKeyboard (__libmansuffix__)
