.\" Header:   //Mercury/Projects/archives/XFree86/4.0/siliconmotion.cpp-arc   1.4   29 Nov 2000 14:12:56   Frido  $
.\" $XFree86: xc/programs/Xserver/hw/xfree86/drivers/siliconmotion/siliconmotion.man,v 1.4 2001/12/20 21:35:38 eich Exp $
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH siliconmotion __drivermansuffix__ __vendorversion__
.SH NAME
siliconmotion \- Silicon Motion video driver
.SH SYNOPSIS
.B "Section \*qDevice\*q"
.br
.BI "  Identifier \*q"  devname \*q
.br
.B  "  Driver \*qsiliconmotion\*q"
.br
\ \ ...
.br
\ \ [
.B "Option"
"optionname" ["optionvalue"]]
.br
.B EndSection
.SH DESCRIPTION
.B siliconmotion 
is an __xservername__ driver for Silicon Motion based video cards.  The driver is fully
accelerated, and provides support for the following framebuffer depths:
8, 16, and 24.  All
visual types are supported for depth 8, and TrueColor
visuals are supported for the other depths.
.SH SUPPORTED HARDWARE
The
.B siliconmotion
driver supports PCI and AGP video cards based on the following Silicon Motion chips:
.TP 12
.B Lynx
SM910
.TP 12
.B LynxE
SM810
.TP 12
.B Lynx3D
SM820
.TP 12
.B LynxEM
SM710
.TP 12
.B LynxEM+
SM712
.TP 12
.B Lynx3DM
SM720
.TP 12
.B Cougar3DR
SM731
.TP 12
.B MSOC
SM501,SM502
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.  All options names are case and white space insensitive when
parsed by the server, for example,  "lynxe" and "LynxE" are equivalent.
.PP
Multihead mode configuration is done through the RandR1.2 interface
(see __xconfigfile__(__filemansuffix__) and xrandr(__appmansuffix__)
for further information). Hardware accelerated screen rotation and
framebuffer resizing are only supported with the
.B EXA
acceleration architecture (see the
.B AccelMethod
option below).
.PP
The driver auto-detects the chipset type, but the following
.B ChipSet
names may optionally be specified in the config file
.B \*qDevice\*q
section, and will override the auto-detection:
.PP
.RS 4
"lynx", "lynxe", "lynx3d", "lynxem", "lynxem+", "lynx3dm", "cougar3dr", "msoc".
.RE

.PP
The following Cursor
.B Options
are supported:
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
Enable or disable the HW cursor.  Default: on.
.TP
.BI "Option \*qSWCursor\*q \*q" boolean \*q
Inverse of "HWCursor".  Default: off.

.PP
The following display
.B Options
are supported:
.TP
.BI "Option \*qVideoKey\*q \*q" integer \*q
Set the video color key.  Default: a little off full blue.
.TP
.BI "Option \*qByteSwap\*q \*q" boolean \*q
Turn on byte swapping for capturing using SMI demo board.  Default: off.
.TP
.BI "Option \*qInterlaced\*q \*q" boolean \*q
Turn on interlaced video capturing.  Default: off.
.TP
.BI "Option \*qUseBIOS\*q \*q" boolean \*q
Use the BIOS to set the modes. This is used for custom panel timings.
Default: on.
.TP
.BI "Option \*qDualhead\*q \*q" boolean \*q
Enable dualhead mode.
Currently not all chips are supported and on lynx chipsets hardware video
overlay (XV) will only work on the secondary VGA output.
Default: off.
.TP
.BI "Option \*qPanelSize\*q \*q" width x height \*q
Override LCD panel dimension autodetection.
.TP
.BI "Option \*qUseFBDev\*q \*q"  boolean \*q
Don't actually program the hardware mode registers, but leave it as
set by the operating system. Only available on MSOC chips. Default: off.
.TP
.BI "Option \*qCSCVideo\*q \*q"  boolean \*q
CSC video uses color space conversion to render video directly to
the framebuffer, without using an overlay.
Only available on MSOC chips. Default: on.
.PP

The following video memory
.B Options
are supported:
.TP
.BI "Option \*qmclk\*q \*q" integer \*q
Sets the memory clock. You must specify the units.  For example \fI50Mhz\fP
is the same as \fI50000Khz\fP or \fI50000000Hz\fP.
On MSOC chips this is the main clock source for all functional blocks, such
as the 2D engine, GPIO, Video Engine, and DMA Engine. This option is only
used for debugging purposes on MSOC chips.
Default: probe the memory clock value, and use it at server start.
.TP
.BI "Option \*qmxclk\*q \*q" integer \*q
Sets the memory clock. You must specify the units.  For example \fI50Mhz\fP
is the same as \fI50000Khz\fP or \fI50000000Hz\fP.
Clock source for the local SDRAM controller. This option is only available
on MSOC chips and used only for debugging purposes.
Default: probe the memory clock value, and use it at server start.
.PP

The following acceleration and graphics engine
.B Options
are supported:
.TP
.B "Option \*qNoAccel\*q"
Disable acceleration.  Very useful for determining if the
driver has problems with drawing and acceleration routines.  This is the first
option to try if your server runs but you see graphic corruption on the screen.
Using it decreases performance, as it uses software emulation for drawing
operations the video driver can accelerate with hardware.
Default: acceleration is enabled.
.TP
.BI "Option \*qAccelMethod\*q \*q" "string" \*q
Chooses between available acceleration architectures.  Valid options are
.B XAA
and
.B EXA.
XAA is the traditional acceleration architecture and support for it is very
stable.  EXA is a newer acceleration architecture with better performance for
the Render and Composite extensions, but the rendering code for it is newer and
possibly unstable.  The default is
.B XAA.

.PP
The following PCI bus
.B Options
are supported:
.TP
.BI "Option \*qPciBurst\*q \*q" boolean \*q
will enable PCI burst mode. This should work on all but a
few broken PCI chipsets, and will increase performance.  Default: on.
.TP
.BI "Option \*qPciRetry\*q \*q" boolean \*q
will allow the driver to rely on PCI Retry to program the registers.
.B "PciBurst"
must be enabled for this to work. 
This will increase performance, especially for small fills/blits, 
because the driver does not have to poll the card before sending it
commands to make sure it is ready. It should work on most 
recent PCI chipsets.  Default: value of
.I PciBurst
option.

.SH SEE ALSO
__xservername__(1), __xconfigfile__(__filemansuffix__), xorgconfig(1), Xserver(1), X(__miscmansuffix__)

.SH SUPPORT
For assistance with this driver, or __xservername__ in general, check the web
site at http://www.x.org/.  If you find a problem with __xservername__ or have a
question not answered in the FAQ please use our bug report form available on
the web site or send mail to xorg@lists.freedesktop.org.  When reporting problems
with the driver send as much detail as possible, including chipset type, a 
server output log, and operating system specifics.

.SH AUTHORS
Kevin Brosius, 
Matt Grossman, 
Harald Koenig,
Sebastien Marineau,
Mark Vojkovich,
Frido Garritsen,
Corvin Zahn.
