.\"
.\" Copyright 2001 Keith Packard
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Keith Packard not be used in
.\" advertising or publicity pertaining to distribution of the software without
.\" specific, written prior permission.  Keith Packard makes no
.\" representations about the suitability of this software for any purpose.  It
.\" is provided "as is" without express or implied warranty.
.\"
.\" KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.\"
.\" $XFree86: xc/programs/xrandr/xrandr.man,v 1.6 2003/06/12 14:12:39 eich Exp $
.\"
.TH XRANDR __appmansuffix__ __vendorversion__
.SH NAME
xrandr \- primitive command line interface to RandR extension
.SH SYNOPSIS
.B "xrandr"
[\-help]  [\-display \fIdisplay\fP]
[\-q] [\-v]
[\-\-verbose]
[\-\-dryrun]
[\-\-screen \fIsnum\fP]
[\-\-q1]
[\-\-q12]
.br
.B RandR version 1.3 options
.br
[\-\-current]
[\-\-noprimary]
.br
.B Per-output options
.br
[\-\-panning \fIwidth\fPx\fIheight\fP[+\fIx\fP+\fIy\fP[/\fItrack_width\fPx\fItrack_height\fP+\fItrack_x\fP+\fItrack_y\fP[/\fIborder_left\fP/\fIborder_top\fP/\fIborder_right\fP/\fIborder_bottom\fP]]]]
[\-\-scale \fIx\fPx\fIy\fP]
[\-\-transform \fIa\fP,\fIb\fP,\fIc\fP,\fId\fP,\fIe\fP,\fIf\fP,\fIg\fP,\fIh\fP,\fIi\fP]
[\-\-primary]
.br
.B RandR version 1.2 options
.br
[\-\-prop]
[\-\-fb \fIwidth\fPx\fIheight\fP]
[\-\-fbmm \fIwidth\fPx\fIheight\fP]
[\-\-dpi \fIdpi\fP]
[\-\-newmode \fIname\fP \fImode\fP]
[\-\-rmmode \fIname\fP]
[\-\-addmode \fIoutput\fP \fIname\fP]
[\-\-delmode \fIoutput\fP \fIname\fP]
.br
.B Per-output options
.br
[\-\-output \fIoutput\fP]
[\-\-auto]
[\-\-mode \fImode\fP]
[\-\-preferred]
[\-\-pos \fIx\fPx\fIy\fP]
[\-\-rate \fIrate\fP]
[\-\-reflect \fIreflection\fP]
[\-\-rotate \fIorientation\fP]
[\-\-left\-of \fIoutput\fP\]
[\-\-right\-of \fIoutput\fP\]
[\-\-above \fIoutput\fP\]
[\-\-below \fIoutput\fP\]
[\-\-same-as \fIoutput\fP\]
[\-\-set \fIproperty\fP \fIvalue\fP]
[\-\-off]
[\-\-crtc \fIcrtc\fP]
[\-\-gamma \fIred\fP:\fIgreen\fP:\fIblue\fP]

.br
.B RandR version 1.0 and version 1.1 options
.br
[\-o \fIorientation\fP]
[\-s \fIsize\fP]
[\-r \fIrate\fP]
[\-x] [\-y]
.SH DESCRIPTION
.I Xrandr
is used to set the size, orientation and/or reflection of the outputs for a
screen. It can also set the screen size.

If invoked without any option, it will dump the state of the outputs,
showing the existing modes for each of them, with a '+' after the preferred
mode and a '*' after the current mode.

There are a few global options. Other options modify the last output that is
specified in earlier parameters in the command line. Multiple outputs may
be modified at the same time by passing multiple \-\-output options followed
immediately by their corresponding modifying options.
.IP \-help
Print out a summary of the usage and exit.
.IP "\-v, \-\-version"
Print out the RandR version reported by the X server and exit.
.IP \-\-verbose
Causes xrandr to be more verbose. When used with \-q (or without other
options), xrandr will display more information about the server state. When
used along with options that reconfigure the system, progress will be
reported while executing the configuration changes.
.IP "\-q, \-\-query"
When this option is present, or when no configuration changes are requested,
xrandr will display the current state of the system. 
.IP "\-\-dryrun"
Performs all the actions specified except that no changes are made.
.IP "\-\-nograb"
Apply the modifications without grabbing the screen. It avoids to block other
applications during the update but it might also cause some applications that
detect screen resize to receive old values.
.IP "\-d, \-display \fIname\fP"
This option selects the X display to use. Note this refers to the X
screen abstraction, not the monitor (or output).
.IP "\-\-screen \fIsnum\fP"
This option selects which screen to manipulate. Note this refers to the X
screen abstraction, not the monitor (or output).
.IP \-\-q1
Forces the usage of the RandR version 1.1 protocol, even if a higher version
is available.
.IP \-\-q12
Forces the usage of the RandR version 1.2 protocol, even if the display does
not report it as supported or a higher version is available.
.PP
.SH "RandR version 1.3 options"
.PP
Options for RandR 1.3 are used as a superset of the options for RandR 1.2.
.PP
.IP \-\-current
Return the current screen configuration, without polling for hardware changes.
.IP \-\-noprimary
Don't define a primary output.
.PP
.B "Per-output options"
.IP "\-\-panning \fIwidth\fPx\fIheight\fP[+\fIx\fP+\fIy\fP[/\fItrack_width\fPx\fItrack_height\fP+\fItrack_x\fP+\fItrack_y\fP[/\fIborder_left\fP/\fIborder_top\fP/\fIborder_right\fP/\fIborder_bottom\fP]]]"
This option sets the panning parameters.  As soon as panning is
enabled, the CRTC position can change with every pointer move.
The first four parameters specify the total panning area, the next four the
pointer tracking area (which defaults to the same area). The last four
parameters specify the border and default to 0. A width or height set to zero
disables panning on the according axis. You typically have to set the screen
size with \fI--fb\fP simultaneously.
.IP "\-\-transform \fIa\fP,\fIb\fP,\fIc\fP,\fId\fP,\fIe\fP,\fIf\fP,\fIg\fP,\fIh\fP,\fIi\fP"
Specifies a transformation matrix to apply on the output. Automatically a bilinear filter is selected.
The mathematical form corresponds to:
.RS 
.RS 
a b c
.br
d e f
.br
g h i
.RE
The transformation matrix multiplied by a coordinate vector of a pixel of the
output (extended to 3 values) gives the approximate coordinate vector of a pixel
in the graphic buffer. Typically, \fIa\fP and
\fIe\fP corresponds to the scaling on the X and Y axes, \fIc\fP and \fIf\fP
corresponds to the tranlastion on those axes, and \fIg\fP, \fIh\fP, and \fIi\fP
are respectively 0, 0 and 1. It also allows to express a rotation of an angle T
with:
.RS 
cos T  -sin T   0
.br
sin T   cos T   0
.br
 0       0      1
.RE
As a special argument, instead of
passing a matrix, one can pass the string \fInone\fP, in which case the default
values are used (a unit matrix without filter).
.RE
.IP "\-\-scale \fIx\fPx\fIy\fP"
Changes the dimensions of the output picture. Values superior to 1 will lead to
a compressed screen (screen dimension bigger than the dimension of the output
mode), and values below 1 leads to a zoom in on the output. This option is
actually a shortcut version of the \fI\-\-transform\fP option.
.IP \-\-primary
Set the output as primary.
It will be sorted first in Xinerama and RANDR geometry requests.
.PP
.SH "RandR version 1.2 options"
These options are only available for X server supporting RandR version 1.2
or newer.
.IP "\-\-prop, \-\-properties"
This option causes xrandr to display the contents of properties for each
output. \-\-verbose also enables \-\-prop.
.IP "\-\-fb \fIwidth\fPx\fIheight\fP"
Reconfigures the screen to the specified size. All configured monitors must
fit within this size. When this option is not provided, xrandr computes the
smallest screen size that will hold the set of configured outputs; this
option provides a way to override that behaviour.
.IP "\-\-fbmm \fIwidth\fPx\fIheight\fP"
Sets the reported values for the physical size of the screen. Normally,
xrandr resets the reported physical size values to keep the DPI constant.
This overrides that computation.
.IP "\-\-dpi \fIdpi\fP"
This also sets the reported physical size values of the screen, it uses the
specified DPI value to compute an appropriate physical size using whatever
pixel size will be set.
.IP "\-\-newmode \fIname\fP \fImode\fP"
New modelines can be added to the server and then associated with outputs.
This option does the former. The \fImode\fP is specified using the ModeLine
syntax for xorg.conf: hdisp hsyncstart hsyncend htotal vdisp vsyncstart
vsyncend vtotal \fIflags\fP. \fIflags\fP can be zero or more of +HSync,
-HSync, +VSync, -VSync, Interlace, DoubleScan, CSync, +CSync, -CSync. Several
tools permit to compute the usual modeline from a height, width, and refresh
rate, for instance you can use \fBcvt\fR.
.IP "\-\-rmmode \fIname\fP"
This removes a mode from the server if it is otherwise unused.
.IP "\-\-addmode \fIoutput\fP \fIname\fP"
Add a mode to the set of valid modes for an output.
.IP "\-\-delmode \fIoutput\fP \fIname\fP"
Remove a mode from the set of valid modes for an output.
.PP
.B "Per-output options"
.IP "\-\-output \fIoutput\fP"
Selects an output to reconfigure. Use either the name of the output or the
XID.
.IP \-\-auto
For connected but disabled outputs, this will enable them using their
preferred mode (or, something close to 96dpi if they have no preferred
mode). For disconnected but enabled outputs, this will disable them.
.IP "\-\-mode \fImode\fP"
This selects a mode. Use either the name or the XID for \fImode\fP
.IP "\-\-preferred"
This selects the same mode as \-\-auto, but it doesn't automatically enable or
disable the output.
.IP "\-\-pos \fIx\fPx\fIy\fP"
Position the output within the screen using pixel coordinates. In case reflection
or rotation is applied, the translation is applied after the effects.
.IP "\-\-rate \fIrate\fP"
This marks a preference for refresh rates close to the specified value, when
multiple modes have the same name, this will select the one with the nearest
refresh rate.
.IP "\-\-reflect \fIreflection\fP"
Reflection can be one of 'normal' 'x', 'y' or 'xy'. This causes the output
contents to be reflected across the specified axes.
.IP "\-\-rotate \fIrotation\fP"
Rotation can be one of 'normal', 'left', 'right' or 'inverted'. This causes
the output contents to be rotated in the specified direction. 'right' specifies
a clockwise rotation of the picture and 'left' specifies a counter-clockwise
rotation.
.IP "\-\-left\-of, \-\-right\-of, \-\-above, \-\-below, \-\-same-as \fIanother-output\fP"
Use one of these options to position the output relative to the position of
another output. This allows convenient tiling of outputs within the screen.
The position is always computed relative to the new position of the other
output, so it is not valid to say \-\-output a \-\-left\-of b \-\-output 
b \-\-left\-of a.
.IP "\-\-set \fIproperty\fP \fIvalue\fP"
Sets an output property. Integer properties may be specified as a valid
(see \-\-prop) decimal or hexadecimal (with a leading 0x) value. Atom properties
may be set to any of the valid atoms (see \-\-prop). String properties may be
set to any value.
.IP "\-\-off"
Disables the output.
.IP "\-\-crtc \fIcrtc\fP"
Uses the specified crtc (either as an index in the list of CRTCs or XID).
In normal usage, this option is not required as xrandr tries to make
sensible choices about which crtc to use with each output. When that fails
for some reason, this option can override the normal selection.
.IP "\-\-gamma \fIred\fP:\fIgreen\fP:\fIblue\fP"
Set the specified floating point values as gamma correction on the crtc 
currently attached to this output. Note that you cannot get two different values
for cloned outputs and that switching an output to another crtc doesn't change
the crtc gamma corrections at all.
.PP
.SH "RandR version 1.1 options"
These options are available for X servers supporting RandR version 1.1 or
older. They are still valid for newer X servers, but they don't interact
sensibly with version 1.2 options on the same command line.
.IP "\-s, \-\-size \fIsize-index\fP or \-\-size \fIwidth\fPx\fIheight\fP"
This sets the screen size, either matching by size or using the index into
the list of available sizes.
.IP "\-r, \-\-rate, \-\-refresh \fIrate\fP"
This sets the refresh rate closest to the specified value.
.IP "\-o, \-\-orientation \fIrotation\fP"
This specifies the orientation of the screen,
and can be one of normal, inverted, left or right.
.IP \-x
Reflect across the X axis.
.IP \-y
Reflect across the Y axis.
.SH EXAMPLES
Sets an output called LVDS to its preferred mode, and on its right put an
output called VGA to preferred mode of a screen which has been physically rotated clockwise:
.RS 
xrandr --output LVDS --auto --rotate normal --pos 0x0 --output VGA --auto --rotate left --right-of LVDS
.RE
.PP
Forces to use a 1024x768 mode on an output called VGA:
.RS 
xrandr --newmode "1024x768" 63.50  1024 1072 1176 1328  768 771 775 798 -hsync +vsync
.br
xrandr --addmode VGA 1024x768
.br
xrandr --output VGA --mode 1024x768
.RE
.PP
Enables panning on a 1600x768 desktop while displaying 1024x768 mode on an output called VGA:
.RS 
xrandr --fb 1600x768 --output VGA --mode 1024x768 --panning 1600x0
.RE
.PP
Have one small 1280x800 LVDS screen showing a small version of a huge 3200x2000 desktop, and have a
big VGA screen display the surrounding of the mouse at normal size.
.RS 
xrandr --fb 3200x2000 --output LVDS --scale 2.5x2.5 --output VGA --pos 0x0 --panning 3200x2000+0+0/3200x2000+0+0/64/64/64/64
.RE
.SH "SEE ALSO"
Xrandr(3), cvt(1)
.SH AUTHORS
Keith Packard,
Open Source Technology Center, Intel Corporation.
and
Jim Gettys, 
Cambridge Research Laboratory, HP Labs, HP.
