.\" $Id: scratchpad.man,v 6.1 1994/05/18 23:26:01 asente Exp $
.TH SCRATCHPAD 1 "4 Apr 1994" "Adobe Systems"
.SH NAME
scratchpad \- Display PostScript text "playground"

.SH SYNTAX
.B scratchpad
[
.I toolkit options
] [
.B \-debug
]

.SH DESCRIPTION
.LP
.B scratchpad
lets you play and experiment with fonts in the Display PostScript system.
You can align, 
resize, rotate, and slant text. You can also experiment with font outlines. 
You can select any font that is available in the Display PostScript 
extension.
.LP
After 
.B scratchpad 
starts, it presents an option panel and a drawing window. You can load a 
preexisting file with the Load button, or you can start from scratch. 
Double-clicking on the left mouse button while in the drawing window 
produces a text cursor that allows you to enter text. All typed text 
appears on the screen.
.LP
To change the font or size, click on the "Show Font Panel" button
of the Option panel. The Font Panel lets you
select a different font and size.  
If the font you select has not been used recently, it will be loaded
from disk. Loading from disk may take a moment, so you may notice
some initial delay when you return to the drawing window. 
.LP
To produce outlined text, click on the "Outline Text" toggle before
you type.
.LP
Select Mode:
.RS .25in
.LP
To select a character or characters, either click on the desired character 
with the left button, or hold the left button and drag out a selection 
region. To append to the current selections, use the right button. You can 
move a selected character by clicking and dragging it. Several commands 
can be used to modify selected characters. For example, changing the font 
in the Font Panel automatically changes the selected characters to the new 
font.
.LP
In all other modes, select mode may be temporarily re-enabled by holding
down the CTRL key.  The CTRL key must be held down for the entire
time of the operation (whether it be a drag, click, or double click). 
.RE 
.LP
Realign Mode:
.RS .25in
.LP
Characters that have been resized or scrolled can be restored to their 
previous state using Realign. This operator takes all selected characters 
and returns them to their original state on the same line.
.RE
.LP
Delete Mode:
.RS .25in
.LP
To delete a selected character, click on it
while in delete mode. If no characters are selected, select mode may
temporarily be enabled by pressing using the CTRL key and selecting
characters. In addition, clicking on an unselected character
or dragging out a selection box without the CTRL key pressed will
subsequently delete any affected characters.
.RE
.LP
Rotate, Resize, and Scale modes:
.RS .25in
.LP
Select the Rotate, Resize, or Scale mode. The mouse pointer turns into a 
cross-hair glyph.
.LP
Click the left button once to set the anchor point. The pointer glyph will 
then change to denote the selected mode.
.LP
Hold the left mouse button and drag the pointer on a 
control point to perform the operation. 
.RE

.SH LOADING, SAVING, AND PRINTING
.LP
The Load, Save, and Print buttons allow documents to be stored
or retrieved from disk. Load and Save ask you to enter the file name,
while Print requests the file name or printer name, depending upon the 
destination.
.LP
While it is possible to print to a file, this file is not loadable by
the program, and is suitable only for PostScript printer output. The
Save option stores information in a format which can be used by Load.
.LP
If you use Print while "send to printer" is selected, the output is sent
to the default printer specified by the PRINTER environment variable.
You can optionally specify a different printer.

.SH DIAGNOSTICS
.LP
Specifying the 
.B \-debug
option opens up a text context on stdout. All PostScript sent to the 
Display PostScript extension will be displayed on the screen. 

.SH BUGS
.LP
The pointer sometimes is not updated correctly.  Race conditions can
result in error states when text is selected.

.SH AUTHOR
.LP
Adobe Systems Incorporated

.SH NOTES
.LP
PostScript and Display PostScript are trademarks
of Adobe Systems Incorporated which may be registered
in certain jurisdictions.
.LP
Copyright (c) 1990-1991 Adobe Systems Incorporated.  All rights reserved.
