.TH aname2num 1 "AF"
.SH NAME
aname2num - convert name to a phone number from .phonelist file
.SH SYNOPSIS
.B aname2num
[options] [name [name...]]
.SH DESCRIPTION
The \fIaname2num\fP program 
is used to lookup names in the user .phonelist file and
return a phone number. The .phonelist file should be specified
as follows:

.TS
c s s
l c l.

<phone-list>	::=	[<entry>...]
<entry>	::=	<first> [<more>...]
<first>	::=	<name> [<num>] [<adr>] CR
<more>	::=	TAB [<white>...] <more2> CR
<more2>	::=	[<name>] [<num>] [<adr>]
<name>	::=	<name1> [<name2>...]
<name1>	::=	{any printing but ":" or ";"}
<name2>	::=	<name1> | <white>
<num>	::=	":" [<num1>...]
<num1>	::=	<white> | <num2>
<num2>	::=	{any printing but ";"}
<adr>	::=	";" [<adr1>...]
<adr1>	::=	<white> | <adr2>
<adr2>	::=	{any printing}
<white>	::=	SPACE | TAB
.TE

The name may be specified as
separate arguments (which will be concatenated with delimiting spaces).
If no name is specified, the name will be read from standard input.
The search is then performed on all lines that do not begin with white
space (e.g., space, tab) and is an un-anchored search upto any ":" on the
line.
.PP
If the supplied name begins with a digit, then the string is assumed to
be a phone number and a search will not be performed. The number will still
be rewritten and returned on standard output.
.PP
After the number is in hand, aname2num uses rewrite rules to generate
the actual dialled sequence.  Seven digit numbers are prepended with
"9," and 10 digit numbers are prepended with "10,".
.SH OPTIONS
\fIaname2num\fP accepts the following command line options described below.
.TP 8
.B \-c
Name comparisons will be case sensitive. The default is for case to be
ignored.
.TP 8
.BI \-f " fileName"
The specified
.I fileName
will be used for the phonelist instead of the default $HOME/.phonelist
file.
.TP 8
.BI \-n 
Supress the rewrite rules, so that the given number is used exactly.
.SH "RETURN VALUE"
.PP
If a match is found, the phone-number will be returned after being cleaned
up (anything before a ":" and after a ";" will be deleted) and re-written
(rules are location dependent. See the source code rewrite() routine for an
example).
.PP
Exit status is 0 on success, 1 if no match found, -1 if an error occurred.
.SH "SEE ALSO"
AF(1) adial(1)
.SH BUGS
.SH COPYRIGHT
Copyright 1993-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Dave Wecker, Cambridge Research Lab, Digital Equipment Corporation.
.br
Larry Stewart,  Cambridge Research Lab, Digital Equipment Corporation.
