.ds xL AFlib \- C Language AF Interface
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
.tm \\n%:\\$1:\\$2:\\$3
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de PN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH AFAddHost 3 "Release 1" "AF Version 3" 
.SH NAME
\fBAFAddHost, AFAddHosts, AFListHosts, AFRemoveHost, AFRemoveHosts,
AFSetAccessControl, AFEnableAccessControl, AFDisableAccessControl, 
AFHostAddress\fP \- control host access and host control structure
.SH SYNTAX
\fB#include <AF/AFlib.h>\fP
.LP
void \fBAFAddHost\fP(AFAudioConn \fI*aud\fP, AFHostAddress \fI*host\fP)
.LP
void \fBAFAddHosts\fP(AFAudioConn \fI*aud\fP, AFHostAddress \fI*hosts\fP, int \fIn\fP)
.LP
AFHostAddress *\fBAFListHosts\fP(AFAudioConn \fI*aud\fP, int \fI*nhosts_ret\fP, 
.br
                                        ABool \fI*enabled_ret\fP)
.LP
void \fBAFRemoveHost\fP(AFAudioConn \fI*aud\fP, AFHostAddress \fI*host\fP)
.LP
void \fBAFRemoveHosts\fP(AFAudioConn \fI*aud\fP, AFHostAddress \fI*hosts\fP, int \fIn\fP)
.LP
void \fBAFSetAccessControl\fP(AFAudioConn \fI*aud\fP, int \fImode\fP)
.LP
void \fBAFEnableAccessControl\fP(AFAudioConn \fI*aud\fP)
.LP
void \fBAFDisableAccessControl\fP(AFAudioConn \fI*aud\fP)
.SH ARGUMENTS
.IP \fIaud\fP 1i
Specifies the connection to the AF server.
.IP \fIenabled_ret\fP 1i
Returns the current state of access control.
.ds Ho added or removed
.IP \fIhost\fP 1i
Specifies the host that is to be \*(Ho.
.ds Ho added or removed
.IP \fIhosts\fP 1i
Specifies each host that is to be \*(Ho.
.IP \fImode\fP 1i
Specifies the mode.
.IP \fIn\fP 1i
Specifies the number of hosts in the host list.
You can pass
.PN AEnableAccess
or
.PN ADisableAccess .
.IP \fInhosts_ret\fP 1i
Returns the number of hosts currently in the access control list.
.IP \fInum_hosts\fP 1i
Specifies the number of hosts.
.IP \fIstate_return\fP 1i
Returns the state of the access control.
.SH DESCRIPTION
The
.PN AFAddHost
function adds the specified host to the access control list for that aud.
The server must be on the same host as the client issuing the command, or a
.PN ABadAccess
error results.
.LP
.PN AFAddHost
can generate
.PN ABadAccess
and
.PN ABadValue
errors.
.LP
The
.PN AFAddHosts
function adds each specified host to the access control list for that aud.
The server must be on the same host as the client issuing the command, or a
.PN ABadAccess
error results.
.LP
.PN AFAddHosts
can generate
.PN ABadAccess
and
.PN ABadValue
errors.
.LP
The
.PN AFListHosts
function returns the current access control list as well as whether the use 
of the list at connection setup was enabled or disabled.
.PN AFListHosts
allows a program to find out what machines can make connections.
It also returns a pointer to a list of host structures that
were allocated by the function. 
When no longer needed,
this memory should be freed by calling
.PN AFFree .
.LP
The
.PN AFRemoveHost
function removes the specified host from the access control list 
for that aud.
The server must be on the same host as the client process, or a
.PN ABadAccess
error results.
If you remove your machine from the access list,
you can no longer connect to that server,
and this operation cannot be reversed unless you reset the server.
.LP
.PN AFRemoveHost
can generate
.PN ABadAccess
and
.PN ABadValue
errors.
.LP
The
.PN AFRemoveHosts
function removes each specified host from the access control list for that 
aud.  
The AF server must be on the same host as the client process, or a
.PN ABadAccess
error results.
If you remove your machine from the access list, 
you can no longer connect to that server,
and this operation cannot be reversed unless you reset the server.
.LP
.PN AFRemoveHosts
can generate
.PN ABadAccess
and
.PN ABadValue
errors.
.LP
The
.PN AFSetAccessControl
function either enables or disables the use of the access control list 
at each connection setup.
.LP
.PN AFSetAccessControl
can generate
.PN ABadAccess
and
.PN ABadValue 
errors.
.LP
The
.PN AFEnableAccessControl
function enables the use of the access control list at each connection setup.
.LP
.PN AFEnableAccessControl
can generate a
.PN ABadAccess 
error.
.LP
The
.PN AFDisableAccessControl
function disables the use of the access control list at each connection setup.
.LP
.PN AFDisableAccessControl
can generate a
.PN ABadAccess 
error.
.SH STRUCTURES
The
.PN AFHostAddress
structure contains:
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
typedef struct {
	int family;	/* e.g., AFamilyInternet */
	int length;	/* length of address, in bytes */
	char *address;	/* pointer to where to find the address */
} AFHostAddress;
.De
.LP
The family member specifies which protocol address family to use 
(for example, TCP/IP or DECnet) and can be
.PN AFamilyInternet ,
.PN AFamilyDECnet ,
or
.PN AFamilyChaos .
The length member specifies the length of the address in bytes.
The address member specifies a pointer to the address.
.SH DIAGNOSTICS
.TP 1i
.PN ABadAccess
A client attempted
to modify the access control list from other than the local
(or otherwise authorized) host.
.TP 1i
.PN ABadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
AFFree(3)
.br
AF(1)


.SH BUGS
If you encounter a \fBreproducible\fP bug, please 
submit a problem report to (af-bugs@crl.dec.com).
.SH COPYRIGHT
Copyright 1990-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Digital Cambridge Research Lab
