/* $Xorg: do_tests.c,v 1.3 2000/08/17 19:54:10 cpqbld Exp $ */
/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

#include "x11perf.h"

extern void DoGetAtom();
extern void DoQueryPointer();

extern void DoNoOp();

extern Bool InitGetProperty();
extern void DoGetProperty();

extern Bool InitRectangles();
extern void DoRectangles();
extern void DoOutlineRectangles();
extern void EndRectangles();

extern Bool InitGC();
extern void DoChangeGC();
extern void EndGC();

extern Bool InitSegments();
extern Bool InitHorizSegments();
extern Bool InitVertSegments();
extern Bool InitWideHorizSegments();
extern Bool InitWideVertSegments();
extern Bool InitDashedSegments();
extern Bool InitDoubleDashedSegments();
extern void DoSegments();
extern void EndSegments();

extern Bool InitLines();
extern Bool InitWideLines();
extern Bool InitDashedLines();
extern Bool InitWideDashedLines();
extern Bool InitDoubleDashedLines();
extern Bool InitWideDoubleDashedLines();
extern void DoLines();
extern void EndLines();


extern Bool InitCircles();
extern Bool InitPartCircles();
extern Bool InitWideCircles();
extern Bool InitPartWideCircles();
extern Bool InitDashedCircles();
extern Bool InitWideDashedCircles();
extern Bool InitDoubleDashedCircles();
extern Bool InitWideDoubleDashedCircles();
extern Bool InitChordPartCircles();
extern Bool InitSlicePartCircles();

extern Bool InitEllipses();
extern Bool InitPartEllipses();
extern Bool InitWideEllipses();
extern Bool InitPartWideEllipses();
extern Bool InitDashedEllipses();
extern Bool InitWideDashedEllipses();
extern Bool InitDoubleDashedEllipses();
extern Bool InitWideDoubleDashedEllipses();
extern Bool InitChordPartEllipses();
extern Bool InitSlicePartEllipses();
extern void DoArcs();
extern void DoFilledArcs();
extern void EndArcs();

extern Bool InitDots();
extern void DoDots();
extern void EndDots();

extern Bool InitCreate();
extern void CreateChildren();
extern void DestroyChildren();
extern void EndCreate();

extern Bool InitMap();
extern void MapParents();
extern void UnmapParents();

extern Bool InitDestroy();
extern void DestroyParents();
extern void RenewParents();

extern Bool InitMoveWindows();
extern void DoMoveWindows();
extern void EndMoveWindows();

extern void DoResizeWindows();

extern Bool InitCircWindows();
extern void DoCircWindows();
extern void EndCircWindows();

extern Bool InitMoveTree();
extern void DoMoveTree();
extern void EndMoveTree();

extern Bool InitText();
extern Bool InitText16();
extern void DoText();
extern void DoText16();
extern void DoImageText();
extern void DoImageText16();
extern void DoPolyText();
extern void DoPolyText16();
extern void ClearTextWin();
extern void EndText();
extern void EndText16();

extern Bool InitCopyPlane();
extern void DoCopyPlane();
extern void EndCopyPlane();

extern Bool InitPopups();
extern void DoPopUps();
extern void EndPopups();

extern Bool InitScroll();
extern void DoScroll();
extern void MidScroll();
extern void EndScroll();

extern Bool InitCopyWin();
extern Bool InitCopyPix();
extern void DoCopyWinWin();
extern void DoCopyPixWin();
extern void DoCopyWinPix();
extern void DoCopyPixPix();
extern void MidCopyPix();
extern void EndCopyWin();
extern void EndCopyPix();

extern Bool InitGetImage();
extern void DoGetImage();
extern void EndGetImage();

extern Bool InitPutImage();
extern void DoPutImage();

#ifdef MITSHM
extern Bool InitShmPutImage();
extern void DoShmPutImage();
extern void EndShmPutImage();
#endif

extern Bool InitTriangles();
extern void DoTriangles();
extern void EndTriangles();

extern Bool InitTrapezoids();
extern void DoTrapezoids();
extern void EndTrapezoids();

extern Bool InitComplexPoly();
extern void DoComplexPoly();
extern void EndComplexPoly();

extern Bool InitGeneralPoly();
extern void DoGeneralPoly();

/*
 * some test must be done a certain multiple of times. That multiple is
 * in the second half of the products below. You can edit the multiplier,
 * just not the multiplicand.
 */

Test test[] = {
  {"-dot",      "Dot", NULL,
		InitDots, DoDots, NullProc, EndDots,
		V1_2FEATURE, ROP, 0,
		{POLY}},
  {"-rect1",    "1x1 rectangle", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 1, NULL, NULL, FillSolid}},
  {"-rect10",   "10x10 rectangle", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 10, NULL, NULL, FillSolid}},
  {"-rect100",  "100x100 rectangle", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{36, 100, NULL, NULL, FillSolid}},
  {"-rect500",  "500x500 rectangle", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{1, 500, NULL, NULL, FillSolid}},
  {"-srect1",  "1x1 stippled rectangle",
		"1x1 stippled rectangle (8x8 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 1, NULL, NULL, FillStippled}},
  {"-srect10", "10x10 stippled rectangle",
		"10x10 stippled rectangle (8x8 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 10, NULL, NULL, FillStippled}},
  {"-srect100", "100x100 stippled rectangle",
		"100x100 stippled rectangle (8x8 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{36, 100, NULL, NULL, FillStippled}},
  {"-srect500", "500x500 stippled rectangle",
		"500x500 stippled rectangle (8x8 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{1, 500, NULL, NULL, FillStippled}},
  {"-osrect1",  "1x1 opaque stippled rectangle",
		"1x1 opaque stippled rectangle (8x8 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 1, NULL, NULL, FillOpaqueStippled}},
  {"-osrect10", "10x10 opaque stippled rectangle",
		"10x10 opaque stippled rectangle (8x8 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 10, NULL, NULL, FillOpaqueStippled}},
  {"-osrect100", "100x100 opaque stippled rectangle",
		"100x100 opaque stippled rectangle (8x8 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{36, 100, NULL, NULL, FillOpaqueStippled}},
  {"-osrect500", "500x500 opaque stippled rectangle",
		"500x500 opaque stippled rectangle (8x8 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{1, 500, NULL, NULL, FillOpaqueStippled}},
  {"-tilerect1", "1x1 4x4 tiled rectangle",
		"1x1 tiled rectangle (4x4 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 1, NULL, NULL, FillTiled}},
  {"-tilerect10", "10x10 4x4 tiled rectangle",
		"10x10 tiled rectangle (4x4 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 10, NULL, NULL, FillTiled}},
  {"-tilerect100", "100x100 4x4 tiled rectangle",
		"100x100 tiled rectangle (4x4 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{36, 100, NULL, NULL, FillTiled}},
  {"-tilerect500", "500x500 4x4 tiled rectangle",
		"500x500 tiled rectangle (4x4 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{1, 500, NULL, NULL, FillTiled}},
  {"-oddsrect1",  "1x1 stippled rectangle (17x15 stipple)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "OddTile", NULL, FillStippled}},
  {"-oddsrect10", "10x10 stippled rectangle (17x15 stipple)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{POLY, 10, "OddTile", NULL, FillStippled}},
  {"-oddsrect100", "100x100 stippled rectangle (17x15 stipple)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{36, 100, "OddTile", NULL, FillStippled}},
  {"-oddsrect500", "500x500 stippled rectangle (17x15 stipple)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{1, 500, "OddTile", NULL, FillStippled}},
  {"-oddosrect1",  "1x1 opaque stippled rectangle (17x15 stipple)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "OddTile", NULL, FillOpaqueStippled}},
  {"-oddosrect10", "10x10 opaque stippled rectangle (17x15 stipple)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{POLY, 10, "OddTile", NULL, FillOpaqueStippled}},
  {"-oddosrect100", "100x100 opaque stippled rectangle (17x15 stipple)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{36, 100, "OddTile", NULL, FillOpaqueStippled}},
  {"-oddosrect500", "500x500 opaque stippled rectangle (17x15 stipple)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{1, 500, "OddTile", NULL, FillOpaqueStippled}},
  {"-oddtilerect1", "1x1 tiled rectangle (17x15 tile)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "OddTile", NULL, FillTiled}},
  {"-oddtilerect10", "10x10 tiled rectangle (17x15 tile)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{POLY, 10, "OddTile", NULL, FillTiled}},
  {"-oddtilerect100", "100x100 tiled rectangle (17x15 tile)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{36, 100, "OddTile", NULL, FillTiled}},
  {"-oddtilerect500", "500x500 tiled rectangle (17x15 tile)", NULL,
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_4FEATURE, ROP, 0,
		{1, 500, "OddTile", NULL, FillTiled}},
  {"-bigsrect1",  "1x1 161x145 stippled rectangle",
		"1x1 stippled rectangle (161x145 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 1, "mensetmanus", NULL, FillStippled}},
  {"-bigsrect10", "10x10 161x145 stippled rectangle",
		"10x10 stippled rectangle (161x145 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 10, "mensetmanus", NULL, FillStippled}},
  {"-bigsrect100", "100x100 161x145 stippled rectangle",
		"100x100 stippled rectangle (161x145 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{36, 100, "mensetmanus", NULL, FillStippled}},
  {"-bigsrect500", "500x500 161x145 stippled rectangle",
		"500x500 stippled rectangle (161x145 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{1, 500, "mensetmanus", NULL, FillStippled}},
  {"-bigosrect1",  "1x1 161x145 opaque stippled rectangle",
		"1x1 opaque stippled rectangle (161x145 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 1, "mensetmanus", NULL, FillOpaqueStippled}},
  {"-bigosrect10", "10x10 161x145 opaque stippled rectangle",
		"10x10 opaque stippled rectangle (161x145 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 10, "mensetmanus", NULL, FillOpaqueStippled}},
  {"-bigosrect100", "100x100 161x145 opaque stippled rectangle",
		"100x100 opaque stippled rectangle (161x145 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{36, 100, "mensetmanus", NULL, FillOpaqueStippled}},
  {"-bigosrect500", "500x500 161x145 opaque stippled rectangle",
		"500x500 opaque stippled rectangle (161x145 stipple)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{1, 500, "mensetmanus", NULL, FillOpaqueStippled}},
  {"-bigtilerect1", "1x1 161x145 tiled rectangle",
		"1x1 tiled rectangle (161x145 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 1, "mensetmanus", NULL, FillTiled}},
  {"-bigtilerect10", "10x10 161x145 tiled rectangle",
		"10x10 tiled rectangle (161x145 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{POLY, 10, "mensetmanus", NULL, FillTiled}},
  {"-bigtilerect100", "100x100 161x145 tiled rectangle",
		"100x100 tiled rectangle (161x145 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{36, 100, "mensetmanus", NULL, FillTiled}},
  {"-bigtilerect500", "500x500 161x145 tiled rectangle",
		"500x500 tiled rectangle (161x145 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_2FEATURE, ROP, 0,
		{1, 500, "mensetmanus", NULL, FillTiled}},
  {"-eschertilerect1", "1x1 216x208 tiled rectangle",
		"1x1 tiled rectangle (216x208 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 1, "escherknot", NULL, FillTiled}},
  {"-eschertilerect10", "10x10 216x208 tiled rectangle",
		"10x10 tiled rectangle (216x208 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 10, "escherknot", NULL, FillTiled}},
  {"-eschertilerect100", "100x100 216x208 tiled rectangle",
		"100x100 tiled rectangle (216x208 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{36, 100, "escherknot", NULL, FillTiled}},
  {"-eschertilerect500", "500x500 216x208 tiled rectangle",
		"500x500 tiled rectangle (216x208 tile)",
		InitRectangles, DoRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{1, 500, "escherknot", NULL, FillTiled}},
  {"-seg1",     "1-pixel line segment", NULL,
		InitSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 0,
		{POLY, 1}},
  {"-seg10",    "10-pixel line segment", NULL,
		InitSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-seg100",   "100-pixel line segment", NULL,
		InitSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 0,
		{POLY, 100}},
  {"-seg500",   "500-pixel line segment", NULL,
		InitSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 0,
		{POLY, 500}},
  {"-seg100c1", "100-pixel line segment (1 kid)", NULL,
		InitSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 1,
		{POLY, 100}},
  {"-seg100c2", "100-pixel line segment (2 kids)", NULL,
		InitSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 2,
		{POLY, 100}},
  {"-seg100c3", "100-pixel line segment (3 kids)", NULL,
		InitSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 3,
		{POLY, 100}},
  {"-dseg10",   "10-pixel dashed segment", NULL,
		InitDashedSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-dseg100", "100-pixel dashed segment", NULL,
		InitDashedSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 0,
		{POLY, 100}},
  {"-ddseg100", "100-pixel double-dashed segment", NULL,
		InitDoubleDashedSegments, DoSegments, NullProc, EndSegments,
		V1_2FEATURE, ROP, 0,
		{POLY, 100}},
  {"-hseg10",   "10-pixel horizontal line segment", NULL,
		InitHorizSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{POLY, 10}},
  {"-hseg100",  "100-pixel horizontal line segment", NULL,
		InitHorizSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{POLY, 100}},
  {"-hseg500",  "500-pixel horizontal line segment", NULL,
		InitHorizSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{POLY, 500}},
  {"-vseg10",   "10-pixel vertical line segment", NULL,
		InitVertSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{POLY, 10}},
  {"-vseg100",  "100-pixel vertical line segment", NULL,
		InitVertSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{POLY, 100}},
  {"-vseg500",  "500-pixel vertical line segment", NULL,
		InitVertSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{POLY, 500}},
  {"-whseg10",  "10x1 wide horizontal line segment", NULL,
		InitWideHorizSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{200, 10}},
  {"-whseg100", "100x10 wide horizontal line segment", NULL,
		InitWideHorizSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{100, 100}},
  {"-whseg500", "500x50 wide horizontal line segment", NULL,
		InitWideHorizSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{50, 500}},
  {"-wvseg10",  "10x1 wide vertical line segment", NULL,
		InitWideVertSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{200, 10}},
  {"-wvseg100", "100x10 wide vertical line segment", NULL,
		InitWideVertSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{100, 100}},
  {"-wvseg500", "500x50 wide vertical line segment", NULL,
		InitWideVertSegments, DoSegments, NullProc, EndSegments,
		V1_3FEATURE, ROP, 0,
		{50, 500}},
  {"-line1",   "1-pixel line", NULL,
		InitLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{POLY, 1}},
  {"-line10",   "10-pixel line", NULL,
		InitLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-line100",  "100-pixel line", NULL,
		InitLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{POLY, 100}},
  {"-line500", "500-pixel line", NULL,
		InitLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{POLY, 500}},
  {"-dline10",  "10-pixel dashed line", NULL,
		InitDashedLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-dline100", "100-pixel dashed line", NULL,
		InitDashedLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{POLY, 100}},
  {"-ddline100", "100-pixel double-dashed line", NULL,
		InitDoubleDashedLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{POLY, 100}},
  {"-wline10",  "10x1 wide line", NULL,
		InitWideLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{100, 10}},
  {"-wline100", "100x10 wide line", NULL,
		InitWideLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{100, 100}},
  {"-wline500", "500x50 wide line", NULL,
		InitWideLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{50, 500}},
  {"-wdline100", "100x10 wide dashed line", NULL,
		InitWideDashedLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{100, 100}},
  {"-wddline100",  "100x10 wide double-dashed line", NULL,
		InitWideDoubleDashedLines, DoLines, NullProc, EndLines,
		V1_2FEATURE, ROP, 0,
		{100, 100}},
  {"-orect10",  "10x10 rectangle outline", NULL,
		InitRectangles, DoOutlineRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 10, NULL, "0", FillSolid}},
  {"-orect100", "100x100 rectangle outline", NULL,
		InitRectangles, DoOutlineRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{36, 100, NULL, "0", FillSolid}},
  {"-orect500",	"500x500 rectangle outline", NULL,
		InitRectangles, DoOutlineRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{1, 500, NULL, "0", FillSolid}},
  {"-worect10",	"10x10 wide rectangle outline", NULL,
		InitRectangles, DoOutlineRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 10, NULL, "1", FillSolid}},
  {"-worect100", "100x100 wide rectangle outline", NULL,
		InitRectangles, DoOutlineRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{36, 100, NULL, "10", FillSolid}},
  {"-worect500", "500x500 wide rectangle outline", NULL,
		InitRectangles, DoOutlineRectangles, NullProc, EndRectangles,
		V1_3FEATURE, ROP, 0,
		{1, 500, NULL, "50", FillSolid}},
  {"-circle1",  "1-pixel circle", NULL,
		InitCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{POLY, 1}},
  {"-circle10", "10-pixel circle", NULL,
		InitCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-circle100", "100-pixel circle", NULL,
		InitCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{200, 100}},
  {"-circle500", "500-pixel circle", NULL,
		InitCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{50, 500}},
  {"-dcircle100", "100-pixel dashed circle", NULL,
		InitDashedCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{100, 100}},
  {"-ddcircle100", "100-pixel double-dashed circle", NULL,
		InitDoubleDashedCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{100, 100}},
  {"-wcircle10", "10-pixel wide circle", NULL,
		InitWideCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-wcircle100", "100-pixel wide circle", NULL,
		InitWideCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{100, 100}},
  {"-wcircle500", "500-pixel wide circle", NULL,
		InitWideCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{25, 500}},
  {"-wdcircle100", "100-pixel wide dashed circle", NULL,
		InitWideDashedCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{100, 100}},
  {"-wddcircle100", "100-pixel wide double-dashed circle", NULL,
		InitWideDoubleDashedCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{100, 100}},
  {"-pcircle10", "10-pixel partial circle", NULL,
		InitPartCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-pcircle100", "100-pixel partial circle", NULL,
		InitPartCircles, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{198, 100}},
  {"-wpcircle10", "10-pixel wide partial circle", NULL,
		InitPartWideCircles, DoArcs, NullProc, EndArcs,
		V1_3FEATURE, ROP, 0,
		{POLY, 10}},
  {"-wpcircle100", "100-pixel wide partial circle", NULL,
		InitPartWideCircles, DoArcs, NullProc, EndArcs,
		V1_3FEATURE, ROP, 0,
		{198, 100}},
  {"-fcircle1",  "1-pixel solid circle", NULL,
		InitCircles, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{POLY, 1}},
  {"-fcircle10", "10-pixel solid circle", NULL,
		InitCircles, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-fcircle100", "100-pixel solid circle", NULL,
		InitCircles, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{100, 100}},
  {"-fcircle500", "500-pixel solid circle", NULL,
		InitCircles, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{20, 500}},
  {"-fcpcircle10", "10-pixel fill chord partial circle", NULL,
		InitChordPartCircles, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-fcpcircle100", "100-pixel fill chord partial circle", NULL,
		InitChordPartCircles, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{108, 100}},
  {"-fspcircle10", "10-pixel fill slice partial circle", NULL,
		InitSlicePartCircles, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-fspcircle100", "100-pixel fill slice partial circle", NULL,
		InitSlicePartCircles, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{108, 100}},
  {"-ellipse10", "10-pixel ellipse", NULL,
		InitEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{500, 10}},
  {"-ellipse100", "100-pixel ellipse", NULL,
		InitEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{300, 100}},
  {"-ellipse500", "500-pixel ellipse", NULL,
		InitEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{100, 500}},
  {"-dellipse100", "100-pixel dashed ellipse", NULL,
		InitDashedEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{25, 100}},
  {"-ddellipse100", "100-pixel double-dashed ellipse", NULL,
		InitDoubleDashedEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{25, 100}},
  {"-wellipse10", "10-pixel wide ellipse", NULL,
		InitWideEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{200, 10}},
  {"-wellipse100", "100-pixel wide ellipse", NULL,
		InitWideEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{25, 100}},
  {"-wellipse500", "500-pixel wide ellipse", NULL,
		InitWideEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{20, 500}},
  {"-wdellipse100", "100-pixel wide dashed ellipse", NULL,
		InitWideDashedEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{25, 100}},
  {"-wddellipse100", "100-pixel wide double-dashed ellipse", NULL,
		InitWideDoubleDashedEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{25, 100}},
  {"-pellipse10", "10-pixel partial ellipse", NULL,
		InitPartEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{540, 10}},
  {"-pellipse100", "100-pixel partial ellipse", NULL,
		InitPartEllipses, DoArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{360, 100}},
  {"-wpellipse10", "10-pixel wide partial ellipse", NULL,
		InitPartWideEllipses, DoArcs, NullProc, EndArcs,
		V1_3FEATURE, ROP, 0,
		{540, 10}},
  {"-wpellipse100", "100-pixel wide partial ellipse", NULL,
		InitPartWideEllipses, DoArcs, NullProc, EndArcs,
		V1_3FEATURE, ROP, 0,
		{360, 100}},
  {"-fellipse10", "10-pixel filled ellipse", NULL,
		InitEllipses, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{200, 10}},
  {"-fellipse100", "100-pixel filled ellipse", NULL,
		InitEllipses, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{25, 100}},
  {"-fellipse500", "500-pixel filled ellipse", NULL,
		InitEllipses, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{10, 500}},
  {"-fcpellipse10", "10-pixel fill chord partial ellipse", NULL,
		InitChordPartEllipses, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{270, 10}},
  {"-fcpellipse100", "100-pixel fill chord partial ellipse", NULL,
		InitChordPartEllipses, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{36, 100}},
  {"-fspellipse10", "10-pixel fill slice partial ellipse", NULL,
		InitSlicePartEllipses, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{270, 10}},
  {"-fspellipse100", "100-pixel fill slice partial ellipse", NULL,
		InitSlicePartEllipses, DoFilledArcs, NullProc, EndArcs,
		V1_2FEATURE, ROP, 0,
		{36, 100}},
  {"-triangle1", "Fill 1-pixel/side triangle", NULL,
		InitTriangles, DoTriangles, NullProc, EndTriangles,
		V1_2ONLY, ROP, 0,
		{POLY, 1}},
  {"-triangle10", "Fill 10-pixel/side triangle", NULL,
		InitTriangles, DoTriangles, NullProc, EndTriangles,
		V1_2ONLY, ROP, 0,
		{POLY, 10}},
  {"-triangle100", "Fill 100-pixel/side triangle", NULL,
		InitTriangles, DoTriangles, NullProc, EndTriangles,
		V1_2ONLY, ROP, 0,
		{100, 100}},
  {"-triangle1", "Fill 1x1 equivalent triangle", NULL,
		InitTriangles, DoTriangles, NullProc, EndTriangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 1}},
  {"-triangle10", "Fill 10x10 equivalent triangle", NULL,
		InitTriangles, DoTriangles, NullProc, EndTriangles,
		V1_3FEATURE, ROP, 0,
		{POLY, 10}},
  {"-triangle100", "Fill 100x100 equivalent triangle", NULL,
		InitTriangles, DoTriangles, NullProc, EndTriangles,
		V1_3FEATURE, ROP, 0,
		{100, 100}},
  {"-trap1", "Fill 1x1 trapezoid", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1}},
  {"-trap10", "Fill 10x10 trapezoid", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_2FEATURE, ROP, 0,
		{POLY, 10}},
  {"-trap100", "Fill 100x100 trapezoid", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_2FEATURE, ROP, 0,
		{POLY/10, 100}},
  {"-trap300", "Fill 300x300 trapezoid", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300}},
  {"-strap1", "Fill 1x1 stippled trapezoid (8x8 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, NULL, NULL, FillStippled}},
  {"-strap10", "Fill 10x10 stippled trapezoid",
		"Fill 10x10 stippled trapezoid (8x8 stipple)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_2FEATURE, ROP, 0,
		{POLY, 10, NULL, NULL, FillStippled}},
  {"-strap100", "Fill 100x100 stippled trapezoid",
		"Fill 100x100 stippled trapezoid (8x8 stipple)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_2FEATURE, ROP, 0,
		{100, 100, NULL, NULL, FillStippled}},
  {"-strap300", "Fill 300x300 stippled trapezoid (8x8 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, NULL, NULL, FillStippled}},
  {"-ostrap1", "Fill 1x1 opaque stippled trapezoid (8x8 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, NULL, NULL, FillOpaqueStippled}},
  {"-ostrap10", "Fill 10x10 opaque stippled trapezoid",
		"Fill 10x10 opaque stippled trapezoid (8x8 stipple)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_2FEATURE, ROP, 0,
		{POLY, 10, NULL, NULL, FillOpaqueStippled}},
  {"-ostrap100", "Fill 100x100 opaque stippled trapezoid",
		"Fill 100x100 opaque stippled trapezoid (8x8 stipple)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_2FEATURE, ROP, 0,
		{100, 100, NULL, NULL, FillOpaqueStippled}},
  {"-ostrap300", "Fill 300x300 opaque stippled trapezoid (8x8 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, NULL, NULL, FillOpaqueStippled}},
  {"-tiletrap1", "Fill 1x1 tiled trapezoid (4x4 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, NULL, NULL, FillTiled}},
  {"-tiletrap10", "Fill 10x10 tiled trapezoid",
		"Fill 10x10 tiled trapezoid (4x4 tile)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_2FEATURE, ROP, 0,
		{POLY, 10, NULL, NULL, FillTiled}},
  {"-tiletrap100", "Fill 100x100 tiled trapezoid",
		"Fill 100x100 tiled trapezoid (4x4 tile)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_2FEATURE, ROP, 0,
		{100, 100, NULL, NULL, FillTiled}},
  {"-tiletrap300", "Fill 300x300 tiled trapezoid (4x4 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, NULL, NULL, FillTiled}},
  {"-oddstrap1", "Fill 1x1 stippled trapezoid (17x15 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "OddTile", NULL, FillStippled}},
  {"-oddstrap10", "Fill 10x10 stippled trapezoid (17x15 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 10, "OddTile", NULL, FillStippled}},
  {"-oddstrap100", "Fill 100x100 stippled trapezoid (17x15 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{100, 100, "OddTile", NULL, FillStippled}},
  {"-oddstrap300", "Fill 300x300 stippled trapezoid (17x15 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, "OddTile", NULL, FillStippled}},
  {"-oddostrap1", "Fill 1x1 opaque stippled trapezoid (17x15 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "OddTile", NULL, FillOpaqueStippled}},
  {"-oddostrap10", "Fill 10x10 opaque stippled trapezoid (17x15 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 10, "OddTile", NULL, FillOpaqueStippled}},
  {"-oddostrap100", "Fill 100x100 opaque stippled trapezoid (17x15 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{100, 100, "OddTile", NULL, FillOpaqueStippled}},
  {"-oddostrap300", "Fill 300x300 opaque stippled trapezoid (17x15 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, "OddTile", NULL, FillOpaqueStippled}},
  {"-oddtiletrap1", "Fill 1x1 tiled trapezoid (17x15 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "OddTile", NULL, FillTiled}},
  {"-oddtiletrap10", "Fill 10x10 tiled trapezoid (17x15 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 10, "OddTile", NULL, FillTiled}},
  {"-oddtiletrap100", "Fill 100x100 tiled trapezoid (17x15 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{100, 100, "OddTile", NULL, FillTiled}},
  {"-oddtiletrap300", "Fill 300x300 tiled trapezoid (17x15 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, "OddTile", NULL, FillTiled}},
  {"-bigstrap1", "Fill 1x1 stippled trapezoid (161x145 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "mensetmanus", NULL, FillStippled}},
  {"-bigstrap10", "Fill 10x10 161x145 stippled trapezoid",
		"Fill 10x10 stippled trapezoid (161x145 stipple)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_3FEATURE, ROP, 0,
		{POLY, 10, "mensetmanus", NULL, FillStippled}},
  {"-bigstrap100", "Fill 100x100 161x145 stippled trapezoid",
		"Fill 100x100 stippled trapezoid (161x145 stipple)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_3FEATURE, ROP, 0,
		{100, 100, "mensetmanus", NULL, FillStippled}},
  {"-bigstrap300", "Fill 300x300 stippled trapezoid (161x145 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, "mensetmanus", NULL, FillStippled}},
  {"-bigostrap1", "Fill 1x1 opaque stippled trapezoid (161x145 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "mensetmanus", NULL, FillOpaqueStippled}},
  {"-bigostrap10", "Fill 10x10 161x145 opaque stippled trapezoid",
		"Fill 10x10 opaque stippled trapezoid (161x145 stipple)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_3FEATURE, ROP, 0,
		{POLY, 10, "mensetmanus", NULL, FillOpaqueStippled}},
  {"-bigostrap100", "Fill 100x100 161x145 opaque stippled trapezoid",
		"Fill 100x100 opaque stippled trapezoid (161x145 stipple)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_3FEATURE, ROP, 0,
		{100, 100, "mensetmanus", NULL, FillOpaqueStippled}},
  {"-bigostrap300", "Fill 300x300 opaque stippled trapezoid (161x145 stipple)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, "mensetmanus", NULL, FillOpaqueStippled}},
  {"-bigtiletrap1", "Fill 1x1 tiled trapezoid (161x145 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "mensetmanus", NULL, FillTiled}},
  {"-bigtiletrap10", "Fill 10x10 161x145 tiled trapezoid",
		"Fill 10x10 tiled trapezoid (161x145 tile)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_3FEATURE, ROP, 0,
		{POLY, 10, "mensetmanus", NULL, FillTiled}},
  {"-bigtiletrap100", "Fill 100x100 161x145 tiled trapezoid",
		"Fill 100x100 tiled trapezoid (161x145 tile)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_3FEATURE, ROP, 0,
		{100, 100, "mensetmanus", NULL, FillTiled}},
  {"-bigtiletrap300", "Fill 300x300 tiled trapezoid (161x145 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, "mensetmanus", NULL, FillTiled}},
  {"-eschertiletrap1", "Fill 1x1 tiled trapezoid (216x208 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{POLY, 1, "escherknot", NULL, FillTiled}},
  {"-eschertiletrap10", "Fill 10x10 216x208 tiled trapezoid",
		"Fill 10x10 tiled trapezoid (216x208 tile)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_3FEATURE, ROP, 0,
		{POLY, 10, "escherknot", NULL, FillTiled}},
  {"-eschertiletrap100", "Fill 100x100 216x208 tiled trapezoid",
		"Fill 100x100 tiled trapezoid (216x208 tile)",
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_3FEATURE, ROP, 0,
		{36, 100, "escherknot", NULL, FillTiled}},
  {"-eschertiletrap300", "Fill 300x300 tiled trapezoid (216x208 tile)", NULL,
		InitTrapezoids, DoTrapezoids, NullProc, EndTrapezoids,
		V1_4FEATURE, ROP, 0,
		{2, 300, "escherknot", NULL, FillTiled}},
  {"-complex10", "Fill 10-pixel/side complex polygon", NULL,
		InitComplexPoly, DoComplexPoly, NullProc, EndComplexPoly,
		V1_2ONLY, ROP, 0,
		{POLY, 10}},
  {"-complex100", "Fill 100-pixel/side complex polygons", NULL,
		InitComplexPoly, DoComplexPoly, NullProc, EndComplexPoly,
		V1_2ONLY, ROP, 0,
		{POLY/10, 100}},
  {"-complex10", "Fill 10x10 equivalent complex polygon", NULL,
		InitComplexPoly, DoComplexPoly, NullProc, EndComplexPoly,
		V1_3FEATURE, ROP, 0,
		{POLY, 10}},
  {"-complex100", "Fill 100x100 equivalent complex polygons", NULL,
		InitComplexPoly, DoComplexPoly, NullProc, EndComplexPoly,
		V1_3FEATURE, ROP, 0,
		{POLY/10, 100}},
  {"-64poly10convex", "Fill 10x10 64-gon (Convex)", NULL,
		InitGeneralPoly, DoGeneralPoly, NullProc, EndComplexPoly,
		V1_4FEATURE, ROP, 0,
		{POLY, 10, (char *) 64, (char *) Convex}},
  {"-64poly100convex", "Fill 100x100 64-gon (Convex)", NULL,
		InitGeneralPoly, DoGeneralPoly, NullProc, EndComplexPoly,
		V1_4FEATURE, ROP, 0,
		{POLY/10, 100, (char *) 64, (char *) Convex}},
  {"-64poly10complex", "Fill 10x10 64-gon (Complex)", NULL,
		InitGeneralPoly, DoGeneralPoly, NullProc, EndComplexPoly,
		V1_4FEATURE, ROP, 0,
		{POLY, 10, (char *) 64, (char *) Complex}},
  {"-64poly100complex", "Fill 100x100 64-gon (Complex)", NULL,
		InitGeneralPoly, DoGeneralPoly, NullProc, EndComplexPoly,
		V1_4FEATURE, ROP, 0,
		{POLY/10, 100, (char *) 64, (char *) Complex}},
  {"-ftext",    "Char in 80-char line (6x13)", NULL,
		InitText, DoText, ClearTextWin, EndText,
		V1_2FEATURE, ROP, 0,
		{80, False, "6x13", NULL}},
  {"-f8text",    "Char in 70-char line (8x13)", NULL,
		InitText, DoText, ClearTextWin, EndText,
		V1_3FEATURE, ROP, 0,
		{70, False, "8x13", NULL}},
  {"-f9text",    "Char in 60-char line (9x15)", NULL,
		InitText, DoText, ClearTextWin, EndText,
		V1_3FEATURE, ROP, 0,
		{60, False, "9x15", NULL}},
  {"-f14text16",  "Char16 in 40-char line (k14)", NULL,
		InitText16, DoText16, ClearTextWin, EndText16,
		V1_3FEATURE, ROP, 0,
		{40, False,
	      "-misc-fixed-medium-r-normal--14-130-75-75-c-140-jisx0208.1983-*",
		NULL}},
  {"-f24text16",  "Char16 in 23-char line (k24)", NULL,
		InitText16, DoText16, ClearTextWin, EndText16,
		V1_3FEATURE, ROP, 0,
		{23, False, 
	      "-jis-fixed-medium-r-normal--24-230-75-75-c-240-jisx0208.1983-*",
		NULL}},
  {"-tr10text", "Char in 80-char line (TR 10)", NULL,
		InitText, DoText, ClearTextWin, EndText,
		V1_2FEATURE, ROP, 0,
		{80, False, 
		"-adobe-times-medium-r-normal--10-100-75-75-p-54-iso8859-1", 
		NULL}},
  {"-tr24text", "Char in 30-char line (TR 24)", NULL,
		InitText, DoText, ClearTextWin, EndText,
		V1_2FEATURE, ROP, 0,
		{30, False, 
		"-adobe-times-medium-r-normal--24-240-75-75-p-124-iso8859-1",
 		NULL}},
  {"-polytext", "Char in 20/40/20 line (6x13, TR 10)", NULL,
		InitText, DoPolyText, ClearTextWin, EndText,
		V1_2FEATURE, ROP, 0,
		{80, True, "6x13", 
		"-adobe-times-medium-r-normal--10-100-75-75-p-54-iso8859-1"}},
  {"-polytext16", "Char16 in 7/14/7 line (k14, k24)", NULL,
		InitText16, DoPolyText16, ClearTextWin, EndText16,
		V1_3FEATURE, ROP, 0,
		{28, True, 
	     "-misc-fixed-medium-r-normal--14-130-75-75-c-140-jisx0208.1983-*",
             "-jis-fixed-medium-r-normal--24-230-75-75-c-240-jisx0208.1983-*"}},
  {"-fitext",   "Char in 80-char image line (6x13)", NULL,
		InitText, DoImageText, ClearTextWin, EndText,
		V1_2FEATURE, PLANEMASK, 0,
		{80, False, "6x13", NULL}},
  {"-f8itext",   "Char in 70-char image line (8x13)", NULL,
		InitText, DoImageText, ClearTextWin, EndText,
		V1_3FEATURE, PLANEMASK, 0,
		{70, False, "8x13", NULL}},
  {"-f9itext",   "Char in 60-char image line (9x15)", NULL,
		InitText, DoImageText, ClearTextWin, EndText,
		V1_3FEATURE, PLANEMASK, 0,
		{60, False, "9x15", NULL}},
  {"-f14itext16", "Char16 in 40-char image line (k14)", NULL,
		InitText16, DoImageText16, ClearTextWin, EndText16,
		V1_3FEATURE, PLANEMASK, 0,
		{40, False,
	      "-misc-fixed-medium-r-normal--14-130-75-75-c-140-jisx0208.1983-*",
		NULL}},
  {"-f24itext16", "Char16 in 23-char image line (k24)", NULL,
		InitText16, DoImageText16, ClearTextWin, EndText16,
		V1_3FEATURE, PLANEMASK, 0,
		{23, False, 
	      "-jis-fixed-medium-r-normal--24-230-75-75-c-240-jisx0208.1983-*",
		NULL}},
  {"-tr10itext", "Char in 80-char image line (TR 10)", NULL,
		InitText, DoImageText, ClearTextWin, EndText,
		V1_2FEATURE, PLANEMASK, 0,
		{80, False, 
		"-adobe-times-medium-r-normal--10-100-75-75-p-54-iso8859-1", 
		NULL}},
  {"-tr24itext", "Char in 30-char image line (TR 24)", NULL,
		InitText, DoImageText, ClearTextWin, EndText,
		V1_2FEATURE, PLANEMASK, 0,
		{30, False, 
		"-adobe-times-medium-r-normal--24-240-75-75-p-124-iso8859-1",
 		NULL}},
  {"-scroll10", "Scroll 10x10 pixels", NULL,
		InitScroll, DoScroll, MidScroll, EndScroll,
		V1_2FEATURE, ROP, 0,
		{1, 10}},
  {"-scroll100", "Scroll 100x100 pixels", NULL,
		InitScroll, DoScroll, MidScroll, EndScroll,
		V1_2FEATURE, ROP, 0,
		{1, 100}},
  {"-scroll500", "Scroll 500x500 pixels", NULL,
		InitScroll, DoScroll, MidScroll, EndScroll,
		V1_2FEATURE, ROP, 0,
		{1, 500}},
  {"-copywinwin10", "Copy 10x10 from window to window", NULL,
		InitCopyWin, DoCopyWinWin, MidScroll, EndCopyWin,
		V1_2FEATURE, ROP, 0,
		{4, 10}},
  {"-copywinwin100", "Copy 100x100 from window to window", NULL,
		InitCopyWin, DoCopyWinWin, MidScroll, EndCopyWin,
		V1_2FEATURE, ROP, 0,
		{4, 100}},
  {"-copywinwin500", "Copy 500x500 from window to window", NULL,
		InitCopyWin, DoCopyWinWin, MidScroll, EndCopyWin,
		V1_2FEATURE, ROP, 0,
		{4, 500}},
  {"-copypixwin10", "Copy 10x10 from pixmap to window", NULL,
		InitCopyPix, DoCopyPixWin, MidCopyPix, EndCopyPix,
		V1_2FEATURE, ROP, 0,
		{4, 10}},
  {"-copypixwin100", "Copy 100x100 from pixmap to window", NULL,
		InitCopyPix, DoCopyPixWin, MidCopyPix, EndCopyPix, 
		V1_2FEATURE, ROP, 0,
		{4, 100}},
  {"-copypixwin500", "Copy 500x500 from pixmap to window", NULL,
		InitCopyPix, DoCopyPixWin, MidCopyPix, EndCopyPix,
		V1_2FEATURE, ROP, 0,
		{4, 500}},
  {"-copywinpix10", "Copy 10x10 from window to pixmap", NULL,
		InitCopyPix, DoCopyWinPix, MidScroll, EndCopyPix,
		V1_2FEATURE, ROP, 0,
		{4, 10}},
  {"-copywinpix100", "Copy 100x100 from window to pixmap", NULL,
		InitCopyPix, DoCopyWinPix, MidScroll, EndCopyPix, 
		V1_2FEATURE, ROP, 0,
		{4, 100}},
  {"-copywinpix500", "Copy 500x500 from window to pixmap", NULL,
		InitCopyPix, DoCopyWinPix, MidScroll, EndCopyPix,
		V1_2FEATURE, ROP, 0,
		{4, 500}},
  {"-copypixpix10", "Copy 10x10 from pixmap to pixmap", NULL,
		InitCopyPix, DoCopyPixPix, NullProc, EndCopyPix,
		V1_2FEATURE, ROP, 0,
		{4, 10}},
  {"-copypixpix100", "Copy 100x100 from pixmap to pixmap", NULL,
		InitCopyPix, DoCopyPixPix, NullProc, EndCopyPix, 
		V1_2FEATURE, ROP, 0,
		{4, 100}},
  {"-copypixpix500", "Copy 500x500 from pixmap to pixmap", NULL,
		InitCopyPix, DoCopyPixPix, NullProc, EndCopyPix,
		V1_2FEATURE, ROP, 0,
		{4, 500}},
  {"-copyplane10", "Copy 10x10 1-bit deep plane", NULL,
		InitCopyPlane, DoCopyPlane, MidCopyPix, EndCopyPix,
		V1_2FEATURE, ROP, 0,
		{4, 10}},
  {"-copyplane100", "Copy 100x100 1-bit deep plane", NULL,
		InitCopyPlane, DoCopyPlane, MidCopyPix, EndCopyPix,
		V1_2FEATURE, ROP, 0,
		{4, 100}},
  {"-copyplane500", "Copy 500x500 1-bit deep plane", NULL,
		InitCopyPlane, DoCopyPlane, MidCopyPix, EndCopyPix,
		V1_2FEATURE, ROP, 0,
		{4, 500}},
  {"-deepcopyplane10", "Copy 10x10 n-bit deep plane", NULL,
		InitCopyPlane, DoCopyPlane, MidCopyPix, EndCopyPix,
		V1_5FEATURE, ROP, 0,
		{4, 10, "Deep"}},
  {"-deepcopyplane100", "Copy 100x100 n-bit deep plane", NULL,
		InitCopyPlane, DoCopyPlane, MidCopyPix, EndCopyPix,
		V1_5FEATURE, ROP, 0,
		{4, 100, "Deep"}},
  {"-deepcopyplane500", "Copy 500x500 n-bit deep plane", NULL,
		InitCopyPlane, DoCopyPlane, MidCopyPix, EndCopyPix,
		V1_5FEATURE, ROP, 0,
		{4, 500, "Deep"}},
  {"-putimage10", "PutImage 10x10 square", NULL,
		InitPutImage, DoPutImage, MidCopyPix, EndGetImage,
		V1_2FEATURE, ROP, 0,
		{4, 10}},
  {"-putimage100", "PutImage 100x100 square", NULL,
		InitPutImage, DoPutImage, MidCopyPix, EndGetImage,
		V1_2FEATURE, ROP, 0,
		{4, 100}},
  {"-putimage500", "PutImage 500x500 square", NULL,
		InitPutImage, DoPutImage, MidCopyPix, EndGetImage,
		V1_2FEATURE, ROP, 0,
		{4, 500}},
  {"-putimagexy10", "PutImage XY 10x10 square", NULL,
		InitPutImage, DoPutImage, MidCopyPix, EndGetImage,
		V1_4FEATURE, ROP, 0,
		{4, 10, "XY"}},
  {"-putimagexy100", "PutImage XY 100x100 square", NULL,
		InitPutImage, DoPutImage, MidCopyPix, EndGetImage,
		V1_4FEATURE, ROP, 0,
		{4, 100, "XY"}},
  {"-putimagexy500", "PutImage XY 500x500 square", NULL,
		InitPutImage, DoPutImage, MidCopyPix, EndGetImage,
		V1_4FEATURE, ROP, 0,
		{4, 500, "XY"}},
#ifdef MITSHM
  {"-shmput10", "ShmPutImage 10x10 square", NULL,
		InitShmPutImage, DoShmPutImage, MidCopyPix, EndShmPutImage,
		V1_2FEATURE, ROP, 0,
		{4, 10}},
  {"-shmput100", "ShmPutImage 100x100 square", NULL,
		InitShmPutImage, DoShmPutImage, MidCopyPix, EndShmPutImage,
		V1_2FEATURE, ROP, 0,
		{4, 100}},
  {"-shmput500", "ShmPutImage 500x500 square", NULL,
		InitShmPutImage, DoShmPutImage, MidCopyPix, EndShmPutImage,
		V1_2FEATURE, ROP, 0,
		{4, 500}},
  {"-shmputxy10", "ShmPutImage XY 10x10 square", NULL,
		InitShmPutImage, DoShmPutImage, MidCopyPix, EndShmPutImage,
		V1_4FEATURE, ROP, 0,
		{4, 10, "XY"}},
  {"-shmputxy100", "ShmPutImage XY 100x100 square", NULL,
		InitShmPutImage, DoShmPutImage, MidCopyPix, EndShmPutImage,
		V1_4FEATURE, ROP, 0,
		{4, 100, "XY"}},
  {"-shmputxy500", "ShmPutImage XY 500x500 square", NULL,
		InitShmPutImage, DoShmPutImage, MidCopyPix, EndShmPutImage,
		V1_4FEATURE, ROP, 0,
		{4, 500, "XY"}},
#endif
  {"-getimage10", "GetImage 10x10 square", NULL,
		InitGetImage, DoGetImage, NullProc, EndGetImage,
		V1_2FEATURE, PLANEMASK, 0,
		{4, 10}},
  {"-getimage100", "GetImage 100x100 square", NULL,
		InitGetImage, DoGetImage, NullProc, EndGetImage,
		V1_2FEATURE, PLANEMASK, 0,
		{4, 100}},
  {"-getimage500", "GetImage 500x500 square", NULL,
		InitGetImage, DoGetImage, NullProc, EndGetImage,
		V1_2FEATURE, PLANEMASK, 0,
		{4, 500}},
  {"-getimagexy10", "GetImage XY 10x10 square", NULL,
		InitGetImage, DoGetImage, NullProc, EndGetImage,
		V1_4FEATURE, PLANEMASK, 0,
		{4, 10, "XY"}},
  {"-getimagexy100", "GetImage XY 100x100 square", NULL,
		InitGetImage, DoGetImage, NullProc, EndGetImage,
		V1_4FEATURE, PLANEMASK, 0,
		{4, 100, "XY"}},
  {"-getimagexy500", "GetImage XY 500x500 square", NULL,
		InitGetImage, DoGetImage, NullProc, EndGetImage,
		V1_4FEATURE, PLANEMASK, 0,
		{4, 500, "XY"}},
  {"-noop",     "X protocol NoOperation", NULL,
		NullInitProc, DoNoOp, NullProc, NullProc,
		V1_2FEATURE, PLANEMASK, 0,
		{1}},
  {"-atom",     "GetAtomName", NULL,
		NullInitProc, DoGetAtom, NullProc, NullProc,
		VERSION1_2 | VERSION1_3, NONROP, 0,
		{1}},
  {"-pointer",  "QueryPointer", NULL,
		NullInitProc, DoQueryPointer, NullProc, NullProc,
		V1_4FEATURE, NONROP, 0,
		{1}},
  {"-prop",     "GetProperty", NULL,
		InitGetProperty, DoGetProperty, NullProc, NullProc,
		V1_2FEATURE, NONROP, 0,
		{1}},
  {"-gc",       "Change graphics context", NULL,
		InitGC, DoChangeGC, NullProc, EndGC,
		V1_2FEATURE, NONROP, 0,
		{4}},
  {"-create",   "Create and map subwindows", NULL,
		InitCreate, CreateChildren, DestroyChildren, EndCreate,
		V1_2FEATURE, WINDOW, 0,
		{0, True}},
  {"-ucreate",  "Create unmapped window", NULL,
		InitCreate, CreateChildren, DestroyChildren, EndCreate,
		V1_2FEATURE, WINDOW, 0,
		{0, False}},
  {"-map",      "Map window via parent", NULL,
		InitMap, MapParents, UnmapParents, EndCreate,
		V1_2FEATURE, WINDOW, 0,
		{0, True}},
  {"-unmap",    "Unmap window via parent", NULL,
		InitDestroy, UnmapParents, MapParents, EndCreate,
		V1_2FEATURE, WINDOW, 0,
		{0, True}},
  {"-destroy",  "Destroy window via parent", NULL,
		InitDestroy, DestroyParents, RenewParents, EndCreate,
		V1_2FEATURE, WINDOW, 0,
		{0, True}},
  {"-popup",    "Hide/expose window via popup", NULL,
		InitPopups, DoPopUps, NullProc, EndPopups,
		V1_2FEATURE, WINDOW, 0,
		{0, True}},
  {"-move",     "Move window", NULL,
		InitMoveWindows, DoMoveWindows, NullProc, EndMoveWindows,
		V1_2FEATURE, WINDOW, 0,
		{0, True}},
  {"-umove",    "Moved unmapped window", NULL,
		InitMoveWindows, DoMoveWindows, NullProc, EndMoveWindows,
		V1_2FEATURE, WINDOW, 0,
		{0, False}},
  {"-movetree", "Move window via parent", NULL,
		InitMoveTree, DoMoveTree, NullProc, EndMoveTree,
		V1_2FEATURE, WINDOW, 0,
		{4, True}},
  {"-resize",   "Resize window", NULL,
		InitMoveWindows, DoResizeWindows, NullProc, EndMoveWindows,
		V1_2FEATURE, WINDOW, 0,
		{4, True}},
  {"-uresize",  "Resize unmapped window", NULL,
		InitMoveWindows, DoResizeWindows, NullProc, EndMoveWindows,
		V1_2FEATURE, WINDOW, 0,
		{4, False}},
  {"-circulate", "Circulate window", NULL,
		InitCircWindows, DoCircWindows, NullProc, EndCircWindows,
		V1_2FEATURE, WINDOW, 0,
		{4, True}},
  {"-ucirculate", "Circulate Unmapped window", NULL,
		InitCircWindows, DoCircWindows, NullProc, EndCircWindows,
		V1_2FEATURE, WINDOW, 0,
		{4, False}},
  { NULL, NULL, NULL,
		NULL, NULL, NULL, NULL,
		0, NONROP, 0,
		{0, False}}
};
