.\" $Xorg: mkfontdir.man,v 1.3 2000/08/17 19:53:59 cpqbld Exp $
.\" Copyright 1993, 1994, 1998  The Open Group
.\" 
.\" All Rights Reserved.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.TH MKFONTDIR 1 "Release 6.4" "X Version 11"
.SH NAME
mkfontdir, fonts.dir, fonts.scale, fonts.alias \- create an index of X font files in a directory
.SH SYNOPSIS
.B "mkfontdir"
[\fIdirectory-name\fP .\|.\|. ]
.SH DESCRIPTION
For each directory argument, \fImkfontdir\fP reads all of the font files in the
directory searching for properties named "FONT", or (failing that) the name
of the file stripped of its suffix.  These are converted to lower case and
used as font names, and,
along with the name of the font file, are
written out to the file "fonts.dir" in the directory.
The X server and font server use "fonts.dir" to find font files.
.PP
The kinds of font files read by \fImkfontdir\fP depend on configuration
parameters, but typically include PCF (suffix ".pcf"), SNF (suffix ".snf")
and BDF (suffix ".bdf").  If a font exists in multiple formats,
.I mkfontdir
will first choose PCF, then SNF and finally BDF.
.PP
The first line of fonts.dir gives the number of fonts in the file.
The remaining lines list the fonts themselves, one per line, in two
fields.  First is the name of the font file, followed by a space and
the name of the font.
.SH "SCALABLE FONTS"
Because scalable font files do not usually include the X font name, the
file "fonts.scale" can be used to name the scalable fonts in the
directory.
The fonts listed in it are copied to fonts.dir by \fImkfontdir\fP.
"fonts.scale" has the same format as the "fonts.dir" file.
.SH "FONT NAME ALIASES"
The file "fonts.alias", which can be put in any directory of the font-path, is
used to map new names to existing fonts, and should be edited by hand.  The
format is two white-space separated columns, the
first containing aliases and the second containing font-name patterns.
Lines beginning with "!" are comment lines and are ignored.
.PP
If neither the alias nor the value specifies the size fields of the
font name, this is a scalable alias.  A font name of any size that
matches this alias will be mapped to the same size of the font that
the alias resolves to.
.PP
When a font alias is used, the name it references is searched for in the normal
manner, looking through each font directory in turn.  This means that the
aliases need not mention fonts in the same directory as the alias file.
.PP
To embed white space in either name, simply enclose it in double-quote
marks; to embed double-quote marks (or any other character), precede them
with back-slash:
.PP
.nf
"magic-alias with spaces"	"\\"font name\\" with quotes"
regular-alias			fixed
.fi
.PP
If the string "FILE_NAMES_ALIASES" stands alone on a line, each file-name
in the directory (stripped of its suffix) will be used as an alias for
that font.
.SH FILES
.TP 15
.B fonts.dir
List of fonts in the directory and the files they are stored in.
Created by \fImkfontdir\fP.  Read by the X server and font server each
time the font path is set (see xset(1)).
.TP 15
.B fonts.scale
List of scalable fonts in the directory.  Contents are copied to
fonts.dir by \fImkfontdir\fP.
.TP 15
.B fonts.alias
List of font name aliases.
Read by the X server and font server each
time the font path is set (see xset(1)).
.SH "SEE ALSO"
X(1), Xserver(1), xfs(1), xset(1)
