.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XSetScreenSaver 3X11 "Release 6.4" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XSetScreenSaver, XForceScreenSaver, XActivateScreenSaver, XResetScreenSaver, XGetScreenSaver \- manipulate the screen saver
.SH SYNTAX
XSetScreenSaver\^(\^\fIdisplay\fP, \fItimeout\fP\^, \fIinterval\fP\^, \fIprefer_blanking\fP\^, \fIallow_exposures\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int \fItimeout\fP\^, \fIinterval\fP\^;
.br
      int \fIprefer_blanking\fP\^; 
.br
      int \fIallow_exposures\fP\^;
.LP
XForceScreenSaver\^(\^\fIdisplay\fP\^, \fImode\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int \fImode\fP\^;
.LP
XActivateScreenSaver\^(\^\fIdisplay\fP\^)
.br
      Display *\fIdisplay\fP\^;
.LP
XResetScreenSaver\^(\^\fIdisplay\fP\^)
.br
      Display *\fIdisplay\fP\^;
.LP
XGetScreenSaver\^(\^\fIdisplay\fP, \fItimeout_return\fP\^, \fIinterval_return\fP\^, \fIprefer_blanking_return\fP\^, 
.br
                  \fIallow_exposures_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int *\fItimeout_return\fP\^, *\fIinterval_return\fP\^;
.br
      int *\fIprefer_blanking_return\fP\^;
.br
      int *\fIallow_exposures_return\fP\^;
.SH ARGUMENTS
.IP \fIallow_exposures\fP 1i
Specifies the screen save control values.
You can pass
.ZN DontAllowExposures ,
.ZN AllowExposures ,
or
.ZN DefaultExposures .
.IP \fIallow_exposures_return\fP 1i
Returns the current screen save control value
.Pn ( DontAllowExposures ,
.ZN AllowExposures ,
or
.ZN DefaultExposures ).
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIinterval\fP 1i
Specifies the interval, in seconds, between screen saver alterations.
.IP \fIinterval_return\fP 1i
Returns the interval between screen saver invocations.
.IP \fImode\fP 1i
Specifies the mode that is to be applied.
You can pass
.ZN ScreenSaverActive
or
.ZN ScreenSaverReset .
.IP \fIprefer_blanking\fP 1i
Specifies how to enable screen blanking.
You can pass
.ZN DontPreferBlanking ,
.ZN PreferBlanking ,
or
.ZN DefaultBlanking .
.IP \fIprefer_blanking_return\fP 1i
Returns the current screen blanking preference
.Pn ( DontPreferBlanking ,
.ZN PreferBlanking ,
or
.ZN DefaultBlanking ).
.IP \fItimeout\fP 1i
Specifies the timeout, in seconds, until the screen saver turns on.
.IP \fItimeout_return\fP 1i
Returns the timeout, in seconds, until the screen saver turns on.
.SH DESCRIPTION
Timeout and interval are specified in seconds. 
A timeout of 0 disables the screen saver 
(but an activated screen saver is not deactivated),
and a timeout of \-1 restores the default.
Other negative values generate a
.ZN BadValue
error.
If the timeout value is nonzero, 
.ZN XSetScreenSaver
enables the screen saver.
An interval of 0 disables the random-pattern motion.
If no input from devices (keyboard, mouse, and so on) is generated 
for the specified number of timeout seconds once the screen saver is enabled,
the screen saver is activated.
.LP
For each screen, 
if blanking is preferred and the hardware supports video blanking, 
the screen simply goes blank.  
Otherwise, if either exposures are allowed or the screen can be regenerated 
without sending 
.ZN Expose 
events to clients, 
the screen is tiled with the root window background tile randomly 
re-origined each interval seconds.
Otherwise, the screens' state do not change, 
and the screen saver is not activated.
The screen saver is deactivated,
and all screen states are restored at the next
keyboard or pointer input or at the next call to
.ZN XForceScreenSaver
with mode
.ZN ScreenSaverReset .  
.LP
If the server-dependent screen saver method supports periodic change,
the interval argument serves as a hint about how long the change period
should be, and zero hints that no periodic change should be made.
Examples of ways to change the screen include scrambling the colormap
periodically, moving an icon image around the screen periodically, or tiling
the screen with the root window background tile, randomly re-origined
periodically.
.LP
.ZN XSetScreenSaver
can generate a
.ZN BadValue 
error.
.LP
If the specified mode is 
.ZN ScreenSaverActive 
and the screen saver currently is deactivated,
.ZN XForceScreenSaver
activates the screen saver even if the screen saver had been disabled
with a timeout of zero.
If the specified mode is 
.ZN ScreenSaverReset 
and the screen saver currently is enabled,
.ZN XForceScreenSaver
deactivates the screen saver if it was activated,
and the activation timer is reset to its initial state 
(as if device input had been received).
.LP
.ZN XForceScreenSaver
can generate a
.ZN BadValue 
error.
.LP
The
.ZN XActivateScreenSaver
function activates the screen saver.
.LP
The
.ZN XResetScreenSaver
function resets the screen saver.
.LP
The
.ZN XGetScreenSaver
function gets the current screen saver values.
.SH DIAGNOSTICS
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
\fI\*(xL\fP
