/* $XConsortium: xkbleds.c /main/7 1996/02/05 11:44:39 kaleb $ */
/************************************************************
Copyright (c) 1993 by Silicon Graphics Computer Systems, Inc.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of Silicon Graphics not be 
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
Silicon Graphics makes no representation about the suitability 
of this software for any purpose. It is provided "as is"
without any express or implied warranty.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <X11/Xproto.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/XKBlib.h>
#include <X11/extensions/XKBfile.h>
#include <X11/Xfuncs.h>

#include <X11/extensions/XI.h>

/***====================================================================***/

static	char *		dpyName = 	NULL;
static	Bool		verbose= 	False;
static	Bool		synch = 	False;
static	Bool		createVMods= 	False;
static	unsigned	device= 	XkbUseCoreKbd;
static	unsigned	class= 		XkbDfltXIClass;
static	unsigned	id= 		XkbDfltXIId;
static	Bool		ownState=	False;

static	int		defining= -1;

typedef struct {
	Bool			defined;
	Bool			create;
	Bool			merge;
	int			ndx;
	Atom			name;
	XkbIndicatorMapRec	map;
	Bool			changeState;
	Bool			newState;
} LEDDefinition;

LEDDefinition		def[XkbNumIndicators];

static	unsigned long	changed= 0;
static	unsigned long	nameChanged= 0;
static	unsigned long	vmodsChanged= 0;
static	unsigned long	stateChanged= 0;
XkbIndicatorMapRec	leds[XkbNumIndicators];
Atom			names[XkbNumIndicators];
Atom			vmods[XkbNumVirtualMods];
int			vmod_remap[XkbNumVirtualMods];

#define	E(s)		fprintf(stderr,s)
#define	E1(s,a)		fprintf(stderr,s,a)

/***====================================================================***/

Bool
#if NeedFunctionPrototypes
GetLEDByIndex(int tmp)
#else
GetLEDByIndex(tmp)
    int	tmp;
#endif
{
register int i;

    for (i=0;i<XkbNumIndicators;i++) {
	if (!def[i].defined) {
	    defining= i;
	    bzero(&def[i],sizeof(LEDDefinition));
	    def[i].defined= True;
	    def[i].ndx= tmp-1;
	    return True;
	}
	else if (def[i].ndx==tmp-1) {
	    E1("Multiple command line settings for LED %d\n",tmp);
	    E("Merging them\n");
	    defining= i;
	    return True;
	}
    }
    return False;
}

Bool
#if NeedFunctionPrototypes
GetLEDByName(char *name)
#else
GetLEDByName(name)
    char *	name;
#endif
{
register int i;
Atom	atom;

    atom= XkbInternAtom(NULL,name,False);
    for (i=0;i<XkbNumIndicators;i++) {
	if (!def[i].defined) {
	    defining= i;
	    bzero(&def[i],sizeof(LEDDefinition));
	    def[i].defined= True;
	    def[i].ndx= -1;
	    def[i].name= atom;
	    return True;
	}
	else if (def[i].name==atom) {
	    E1("Multiple command line settings for LED %s\n",name);
	    E("Merging them\n");
	    defining= i;
	    return True;
	}
    }
    return False;
}

/***====================================================================***/

int
#if NeedFunctionPrototypes
GetVModByName(char *name)
#else
GetVModByName(name)
    char *name;
#endif
{
register int i;
Atom	atom;

    atom= XkbInternAtom(NULL,name,False);
    for (i=0;i<XkbNumIndicators;i++) {
	if (vmods[i]==atom)
	    return (1<<i);
	else if (vmods[i]==None) {
	    vmods[i]= atom;
	    return (1<<i);
	}
    }
    E1("Too many virtual modifiers used (max %d)\n",XkbNumVirtualMods);
    return 0;
}

/***====================================================================***/

Bool
#if NeedFunctionPrototypes
ParseModsAndGroups(char *str,int *mods_inout,int *vmods_inout,int *grps_inout)
#else
ParseModsAndGroups(str,mods_inout,vmods_inout,grps_inout)
    char *	str;
    int *	mods_inout;
    int *	vmods_inout;
    int *	grps_inout;
#endif
{
char 	*tmp,*next;
int	mask;

    *mods_inout= 0;
    *vmods_inout= 0;
    *grps_inout= 0;
    tmp= str;
    while (tmp!=NULL) {
	next= strchr(tmp,'+');
	if (next!=NULL)
	    *next++= '\0';
	if (strcmp(tmp,"shift")==0)		*mods_inout|= ShiftMask;
	else if (strcmp(tmp,"lock")==0)		*mods_inout|= LockMask;
	else if (strcmp(tmp,"caps")==0)		*mods_inout|= LockMask;
	else if (strcmp(tmp,"control")==0)	*mods_inout|= ControlMask;
	else if (strcmp(tmp,"ctrl")==0)		*mods_inout|= ControlMask;
	else if (strcmp(tmp,"mod1")==0)		*mods_inout|= Mod1Mask;
	else if (strcmp(tmp,"mod2")==0)		*mods_inout|= Mod2Mask;
	else if (strcmp(tmp,"mod3")==0)		*mods_inout|= Mod3Mask;
	else if (strcmp(tmp,"mod4")==0)		*mods_inout|= Mod4Mask;
	else if (strcmp(tmp,"mod5")==0)		*mods_inout|= Mod5Mask;
	else if (strcmp(tmp,"group1")==0)	*grps_inout|= 0x1;
	else if (strcmp(tmp,"group2")==0)	*grps_inout|= 0x2;
	else if (strcmp(tmp,"group3")==0)	*grps_inout|= 0x4;
	else if (strcmp(tmp,"group4")==0)	*grps_inout|= 0x8;
	else if ((mask=GetVModByName(tmp))!=0)	*vmods_inout|= mask;
	else					return False;
	tmp= next;
    }
    return True;
}

/***====================================================================***/

void
#if NeedFunctionPrototypes
RemapVMods(Display *dpy,XkbDescPtr xkb)
#else
RemapVMods(dpy,xkb)
Display *	dpy;
XkbDescPtr	xkb;
#endif
{
register int	o,n;

    for (o=0;o<XkbNumVirtualMods;o++) {
	vmod_remap[o]= 0;
	if (vmods[o]!=None) {
	    vmods[o]= XkbChangeAtomDisplay(NULL,dpy,vmods[o]);
	    for (n=0;n<XkbNumVirtualMods;n++) {
		if (xkb->names->vmods[n]==vmods[o]) {
		    vmod_remap[o]= (1<<n);
		    break;
		}
	    }
	    if ((vmod_remap[o]==0)&&(createVMods)) {
		for (n=0;n<XkbNumVirtualMods;n++) {
		    if (xkb->names->vmods[n]==None) {
			xkb->names->vmods[n]= vmods[o];
			vmodsChanged|= (1<<n);
			vmod_remap[o]= (1<<n);
			break;
		    }
		}
		if (vmod_remap[o]==0) {
		    E1("Couldn't create virtual modifier %s\n",
					XkbAtomText(dpy,vmods[o],XkbMessage));
		}
	    }
	}
    }
    return;
}

void
#if NeedFunctionPrototypes
RetargetMaps(Display *oldDpy,Display *newDpy)
#else
RetargetMaps(oldDpy,newDpy)
    Display *	oldDpy;
    Display *	newDpy;
#endif
{
register int	i,v,bit;
int	new;

    for (i=0;i<XkbNumIndicators;i++) {
	if (def[i].name!=None)
	    def[i].name= XkbChangeAtomDisplay(oldDpy,newDpy,def[i].name);
	if (def[i].map.mods.vmods!=0) {
	    new= 0;
	    for (v=0,bit=1;v<XkbNumVirtualMods;v++,bit<<=1) {
		if (def[i].map.mods.vmods&bit)
		    new|= vmod_remap[v];
	    }
	    def[i].map.mods.vmods= new;
	}
    }
    return;
}

/***====================================================================***/

Bool
#if NeedFunctionPrototypes
CheckDefined(char *opt)
#else
CheckDefined(opt)
    char *opt;
#endif
{
    if (defining<0) {
	E1("Must specify an LED before using %s option\n",opt);
	return False;
    }
    return True;
}

Bool
#if NeedFunctionPrototypes
CheckComponents(int argc,char *argv[],int *pi,int *pmods,int *pvmods,int *pgrps)
#else
CheckComponents(argc,argv,pi,pmods,pvmods,pgrps)
    int		argc;
    char *	argv[];
    int *	pi;
    int *	pmods;
    int *	pvmods;
    int *	pgrps;
#endif
{
int 	i;
char *	opt;
    
    i= *pi;
    opt= argv[i];
    if ( ++i>=argc ) {
	E1("Must specify components for %s option\n",opt);
	return False;
    }
    if (!CheckDefined(opt))
	return False;
    if (!ParseModsAndGroups(argv[i],pmods,pvmods,pgrps))
	return False;
    *pi= i;
    return True;
}

/***====================================================================***/

int
#if NeedFunctionPrototypes
ParseArgs(int argc,char *argv[])
#else
ParseArgs(argc,argv)
    int argc;
    char *argv[];
#endif
{
int 	i,tmp;
int	mods,grps,vmods;

    for (i=1;i<argc;i++) {
	if ( strcmp(argv[i],"-class")==0 ) {
	    if ( ++i>=argc ) {
		E("Must specify a feedback class for -class option\n");
		return 0;
	    }
	    if (strcmp(argv[i],"kbd")==0)
		class= KbdFeedbackClass;
	    else if (strcmp(argv[i],"led")==0)
		class= LedFeedbackClass;
	    else if (strcmp(argv[i],"dflt")==0)
		class= XkbDfltXIClass;
	    else {
		E("Feedback class must be one of kbd, led, or dflt\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-device")==0 ) {
	    if ( ++i>=argc ) {
		E("Must specify a device id for -device option\n");
		return 0;
	    }
	    if (sscanf(argv[i],"%i",&tmp)==1) {
		if ((tmp<0)||(tmp>255)) {
		    E("Device id must be in the range 0..255\n");
		    return 0;
		}
		device= tmp;
	    }
	    else if (strcmp(argv[i],"kbd")==0)
		device= XkbUseCoreKbd;
	    else if (strcmp(argv[i],"ptr")==0)
		device= XkbUseCorePtr;
	    else {
		E("Device ID must be kbd, ptr, or an integer 0..255\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-display")==0 ) {
	    if ( ++i<argc )	dpyName= argv[i];
	    else {
		E("Must specify a display with -display option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-id")==0 ) {
	    if ( ++i>=argc ) {
		E("Must specify a feedback id for -id option\n");
		return 0;
	    }
	    if (sscanf(argv[i],"%i",&tmp)==1) {
		if ((tmp<0)||(tmp>255)) {
		    E("Feedback id must be in the range 0..255\n");
		    return 0;
		}
		id= tmp;
	    }
	    else if (strcmp(argv[i],"dflt")==0)
		id= XkbDfltXIId;
	    else {
		E("Feedback ID must be an integer 0..255 or dflt\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-synch")==0 ) {
	    synch= 1;
	}
	else if ( strcmp(argv[i],"-v")==0 ) {
	    verbose++;
	}
	else if ( strcmp(argv[i],"-led")==0 ) {
	    if ( ++i>=argc ) {
		E("Must specify an led with -led option\n");
		return 0;
	    }
	    if (sscanf(argv[i],"%i",&tmp)==1) {
		if ((tmp<1)||(tmp>XkbNumIndicators)) {
		    E1("LED index must be in the range 1..%d\n",
							XkbNumIndicators);
		    return 0;
		}
		if (!GetLEDByIndex(tmp))
		    return 0;
	    }
	    else if (!GetLEDByName(argv[i])) {
		return 0;
	    }
	}
	else if (strcmp(argv[i],"-ctrls")==0) {
	    char *opt= argv[i];
	    if ( ++i>=argc ) {
		E1("Must specify controls for %s option\n",opt);
		return 0;
	    }
	    if (!CheckDefined(opt))
		return 0;
	}
	else if ((strcmp(argv[i],"-base")==0)||(strcmp(argv[i],"-b")==0)) {
	    if (!CheckComponents(argc,argv,&i,&mods,&vmods,&grps))
		return 0;
	    if (mods || vmods) {
		def[defining].map.which_mods|= XkbIM_UseBase;
		def[defining].map.mods.real_mods|= mods;
		def[defining].map.mods.vmods|= vmods;
	    }
	    if (grps) {
		def[defining].map.which_groups|= XkbIM_UseBase;
		def[defining].map.groups|= grps;
	    }
	}
	else if (strcmp(argv[i],"-compat")==0) {
	    if (!CheckComponents(argc,argv,&i,&mods,&vmods,&grps))
		return 0;
	    if (mods || vmods) {
		def[defining].map.which_mods|= XkbIM_UseCompat;
		def[defining].map.mods.real_mods|= mods;
		def[defining].map.mods.vmods|= vmods;
	    }
	    if (grps) {
		E("Cannot specify groups with -compat flag\n");
		return 0;
	    }
	}
	else if ((strcmp(argv[i],"-set")==0)||(strcmp(argv[i],"-s")==0)||
		 (strcmp(argv[i],"-effective")==0)||(strcmp(argv[i],"-e")==0)) {
	    if (!CheckComponents(argc,argv,&i,&mods,&vmods,&grps))
		return 0;
	    if (mods || vmods) {
		def[defining].map.which_mods|= XkbIM_UseEffective;
		def[defining].map.mods.real_mods|= mods;
		def[defining].map.mods.vmods|= vmods;
	    }
	    if (grps) {
		def[defining].map.which_groups|= XkbIM_UseEffective;
		def[defining].map.groups|= grps;
	    }
	}
	else if ((strcmp(argv[i],"-latched")==0)||(strcmp(argv[i],"-l")==0)) {
	    if (!CheckComponents(argc,argv,&i,&mods,&vmods,&grps))
		return 0;
	    if (mods || vmods) {
		def[defining].map.which_mods|= XkbIM_UseLatched;
		def[defining].map.mods.real_mods|= mods;
		def[defining].map.mods.vmods|= vmods;
	    }
	    if (grps) {
		def[defining].map.which_groups|= XkbIM_UseLatched;
		def[defining].map.groups|= grps;
	    }
	}
	else if ((strcmp(argv[i],"-locked")==0)||(strcmp(argv[i],"-L")==0)) {
	    if (!CheckComponents(argc,argv,&i,&mods,&vmods,&grps))
		return 0;
	    if (mods || vmods) {
		def[defining].map.which_mods|= XkbIM_UseLocked;
		def[defining].map.mods.real_mods|= mods;
		def[defining].map.mods.vmods|= vmods;
	    }
	    if (grps) {
		def[defining].map.which_groups|= XkbIM_UseLocked;
		def[defining].map.groups|= grps;
	    }
	}
	else if ((strcmp(argv[i],"-noexplicit")==0)||
						(strcmp(argv[i],"-ne")==0)) {
	    if (!CheckDefined(argv[i]))
		return 0;
	    def[defining].map.flags|= XkbIM_NoExplicit;
	}
	else if ((strcmp(argv[i],"-noautomatic")==0)||
						(strcmp(argv[i],"-na")==0)) {
	    if (!CheckDefined(argv[i]))
		return 0;
	    def[defining].map.flags|= XkbIM_NoAutomatic;
	}
	else if ((strcmp(argv[i],"-driveskbd")==0)||(strcmp(argv[i],"-dk")==0)){
	    if (!CheckDefined(argv[i]))
		return 0;
	    def[defining].map.flags|= XkbIM_LEDDrivesKB;
	}
	else if ((strcmp(argv[i],"-create")==0)||(strcmp(argv[i],"-c")==0)) {
	    if (!CheckDefined(argv[i]))
		return 0;
	    def[defining].create= True;
	}
	else if ((strcmp(argv[i],"-merge")==0)||(strcmp(argv[i],"-m")==0)) {
	    if (!CheckDefined(argv[i]))
		return 0;
	    def[defining].merge= True;
	}
	else if (strcmp(argv[i],"-on")==0) {
	    if (!CheckDefined(argv[i]))
		return 0;
	    def[defining].changeState= True;
	    def[defining].newState= True;
	}
	else if (strcmp(argv[i],"-off")==0) {
	    if (!CheckDefined(argv[i]))
		return 0;
	    def[defining].changeState= True;
	    def[defining].newState= False;
	}
	else if ((strcmp(argv[i],"-name")==0)||(strcmp(argv[i],"-n")==0)) {
	    Atom atom;
	    if ( ++i>=argc ) {
		E1("Must specify name for %s option\n",argv[i]);
		return 0;
	    }
	    if (!CheckDefined(argv[i]))
		return 0;
	    atom= XkbInternAtom(NULL,argv[i],False);
	    def[defining].name= atom;
	}
	else {
	    E1("Unknown option %s\n",argv[i]);
	    return 0;
	}
    }
    if (defining<0)
	verbose= 1;
    return 1;
}

void
#if NeedFunctionPrototypes
ShowMaps(	Display *		dpy,
		XkbDescPtr		xkb,
		XkbDeviceInfoPtr 	devi,
		XkbDeviceLedInfoPtr 	devli)
#else
ShowMaps(dpy,xkb,devi,devli)
    Display *		dpy;
    XkbDescPtr		xkb;
    XkbDeviceInfoPtr	devi;
    XkbDeviceLedInfoPtr	devli;
#endif
{
register int 	i;
char	*	name;
unsigned 	state;

    state= devli->state;
    printf("state: 0x%08x\n",state);
    for (i=0;i<XkbNumIndicators;i++) {
	unsigned	f,wm,mask,m,vm,wg,g,c;
	f= devli->maps[i].flags;
	wm= devli->maps[i].which_mods;
	mask= devli->maps[i].mods.mask;
	m= devli->maps[i].mods.real_mods;
	vm= devli->maps[i].mods.vmods;
	wg= devli->maps[i].which_groups;
	g= devli->maps[i].groups;
	c= devli->maps[i].ctrls;
	if ((wm==0)&&(wg==0)&&(c==0)&&(f==0)&&
	    ((!devli->names)||(devli->names[i]==None)))
	    continue;
	if (devli->phys_indicators&(1<<i)) 
	     printf("Physical ");
	else printf("Virtual  ");
	printf("indicator %d",i+1);
	if (devli->names&&
		(name=XkbAtomText(dpy,devli->names[i],XkbMessage))&&
		(name[0])) {
	    printf(" (%s)",name);
	}
	printf(": %s\n",(state&(1<<i)?"on":"off"));
	printf("    change:     %s",
			((f&XkbIM_LEDDrivesKB)?"drives keyboard (":""));
	switch (f&(XkbIM_NoExplicit|XkbIM_NoAutomatic)) {
	    case XkbIM_NoExplicit:
		if (XkbIM_InUse(&devli->maps[i]))
		     printf("automatic");
		else printf("never");
		break;
	    case XkbIM_NoAutomatic:
		printf("explicit");
		break;
	    case XkbIM_NoExplicit|XkbIM_NoAutomatic:
		printf("never");
		break;
	    case 0:
		if (XkbIM_InUse(&devli->maps[i]))
		     printf("automatic/explicit");
		else printf("explicit");
		break;
	}
	printf("%s\n",((f&XkbIM_LEDDrivesKB)?")":""));

	if ((wm!=0)&&((m!=0)||(vm!=0))) {
	    printf("    modifiers:  %s (%s)\n",
				XkbVModMaskText(dpy,xkb,m,vm,XkbMessage),
				XkbIMWhichStateMaskText(wm,XkbMessage));
	    if (mask!=m)
		printf("    mask:       %s\n",XkbModMaskText(mask,XkbMessage));
	}
	if ((wg!=0)&&(g!=0)) {
	    printf("    groups:     0x%x (%s)\n",devli->maps[i].groups,
				XkbIMWhichStateMaskText(wg,XkbMessage));
	}
	if (c!=0) {
	    printf("    controls:   %s\n",XkbControlsMaskText(c,XkbMessage));
	}
	fflush(stdout);
    }
    return;
}

int
#if NeedFunctionPrototypes
main(int argc,char *argv[])
#else
main(argc,argv)
    int argc;
    char *argv[];
#endif
{
Display	*		dpy;
int			major,minor,why,i1,i2;
XkbDescPtr		xkb;
XkbDeviceInfoPtr	devi;
XkbDeviceLedInfoPtr	devli;
XkbDeviceChangesRec	dev_changes;
XkbMapChangesRec	map_changes;

    XkbInitAtoms(NULL);
    if (!ParseArgs(argc,argv)) {
	E1("Usage: %s <options>\n",argv[0]);
	E("Where legal options are:\n");
	E("-display <dpy>         specifies display to use\n");
	E("-class <class>         specifies class of feedback to use\n");
	E("-device <id>           specifies id of device to use\n");
	E("-d[rives]k[b]          changing LED affects keyboard state\n");
	E("-id <id>               specifies id of feedback to use\n");
	E("-v                     show indicator mapping\n");
	E("-synch                 turn on synchronization\n");
	E("-led <name>            update led named <name>\n");
	E("-led <number>          update led number <number>\n");
	E("-b[ase] <parts>        use base <parts>\n");
	E("-l[atched] <parts>     use latched <parts>\n");
	E("-locked <parts>        use locked <parts>\n");
	E("-L <parts>             use locked <parts>\n");
	E("-e[ffective] <parts>   use effective <parts>\n");
	E("-ctrls <ctrls>         use <ctrls>\n");
	E("-n[ame] <name>         assign <name> to LED\n");
	E("-n[o]e[xplicit]        prevent explicit changes\n");
	E("-n[o]a[utomatic]       prevent automatic changes\n");
	E("-c[reate]              create a new indicator map if necessary\n");
	E("-c[reate]v[mods]       allocate names for new virtual modifiers\n");
	E("-m[erge]               merge with existing def'n\n");
	E("-on                    (attempt to) turn the indicator on\n");
	E("-off                   (attempt to) turn the indicator off\n");
	return 1;
    }
    major= XkbMajorVersion;
    minor= XkbMinorVersion;
    dpy = XkbOpenDisplay(dpyName,NULL,NULL,&major,&minor,&why);
    if (dpy==NULL) {
	if (dpyName==NULL)
	    dpyName= "default display";
        switch (why) {
            case XkbOD_BadLibraryVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Xlib supports incompatible version %d.%02d\n",
                                major,minor);
                break;
            case XkbOD_ConnectionRefused:
                fprintf(stderr,"Cannot open display \"%s\"\n",dpyName);
                break;
            case XkbOD_NonXkbServer:
                fprintf(stderr,"XKB extension not present on %s\n",dpyName);
                break;
            case XkbOD_BadServerVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Server %s uses incompatible version %d.%02d\n",
                                dpyName,major,minor);
                break;
            default:
                fprintf(stderr,
		    "Internal Error! Unknown error %d from XkbOpenDisplay\n",
		    why);
        }
	return 1;
    }
    if (synch)
	XSynchronize(dpy,1);
    devi= XkbGetDeviceInfo(dpy,XkbXI_IndicatorsMask,device,class,id);
    if (!devi) {
	fprintf(stderr,"XkbGetDeviceInfo failed\n");
	goto BAIL;
    }
    else if (!devi->leds) {
	fprintf(stderr,"Device has no indicators\n");
	goto BAIL;
    }
    devli= devi->leds;
    if (devi->has_own_state)
	 xkb= XkbGetMap(dpy,XkbVirtualModsMask,device);
    else xkb= XkbGetMap(dpy,XkbVirtualModsMask,XkbUseCoreKbd);
    if (!xkb) {
	fprintf(stderr,"Couldn't get keyboard map\n");
	goto BAIL;
    }
    if (XkbGetNames(dpy,XkbVirtualModNamesMask,xkb)!=Success) {
	fprintf(stderr,"Couldn't get virtual modifier names\n");
	goto BAIL;
    }
	
    RemapVMods(dpy,xkb);
    RetargetMaps(NULL,dpy);
    if (verbose>1) {
	fprintf(stderr,"Indicator maps before changes...\n");
	ShowMaps(dpy,xkb,devi,devli);
    }
    changed= stateChanged= nameChanged= vmodsChanged= 0;
    /* find indices for indicators defined by name, if possible */
    for (i1=0;i1<XkbNumIndicators;i1++) {
	if ((!def[i1].defined)||(def[i1].name==None)||(def[i1].ndx>=0))
	    continue;
	for (i2=0;i2<XkbNumIndicators;i2++) {
	    if (def[i1].name==devli->names[i2]) {
		def[i1].ndx= i2;
		break;
	    }
	}
    }
    /* deal with any indicators defined by index */
    for (i1=0;i1<XkbNumIndicators;i1++) {
	if (!def[i1].defined)
	    continue;
	if (def[i1].ndx>=0) {
	    int ndx= def[i1].ndx;
	    if (def[i1].name!=devli->names[ndx]) {
		devli->names[ndx]= def[i1].name;
		if (def[i1].name!=None)
		     devli->names_present|= (1<<ndx);
		else devli->names_present&= ~(1<<ndx);
		nameChanged|= (1<<ndx);
	    }
	    if (!def[i1].merge)
		devli->maps[ndx]= def[i1].map;
	    else {
		XkbIndicatorMapPtr old= &devli->maps[ndx];
		old->flags|= def[i1].map.flags;
		old->which_mods|= def[i1].map.which_mods;
		old->mods.real_mods|= def[i1].map.mods.real_mods;
		old->mods.vmods|= def[i1].map.mods.vmods;
		old->which_groups|= def[i1].map.which_groups;
		old->groups|= def[i1].map.groups;
		old->ctrls|= def[i1].map.ctrls;
	    }
	    if (XkbIM_InUse(&devli->maps[ndx]))
		 devli->maps_present|= (1<<ndx);
	    else devli->maps_present&= ~(1<<ndx);
	    if (def[i1].changeState) {
		stateChanged|= (1<<ndx);
		if (def[i1].newState)	devli->state|= (1<<ndx);
		else			devli->state&= ~(1<<ndx);
	    }
	    changed|= (1<<ndx);
	    def[i1].defined= False;
	}
    }
    bzero(&map_changes,sizeof(map_changes));
    if (vmodsChanged) {
	map_changes.changed|= XkbVirtualModNamesMask;
	map_changes.vmods= vmodsChanged;
	if (verbose) {
	    register unsigned i,bit;
	    fprintf(stderr,"Changing vmod names:");
	    for (i=0,bit=1;i<XkbNumVirtualMods;i++,bit<<=1) {
		if (vmodsChanged&bit) {
		    fprintf(stderr," %d=\"%s\"",i,
				XkbAtomText(dpy,vmods[i],XkbMessage));
		}
	    }
	    fprintf(stderr,"\n");
	}
    }
    bzero(&dev_changes,sizeof(dev_changes));
    if (nameChanged||changed||stateChanged) {
	dev_changes.changed= 0;
	if (nameChanged)	dev_changes.changed|= XkbXI_IndicatorNamesMask;
	if (changed)		dev_changes.changed|= XkbXI_IndicatorMapsMask;
	if (stateChanged)	dev_changes.changed|= XkbXI_IndicatorStateMask;

	dev_changes.leds.led_class= class;
	dev_changes.leds.led_id= id;
	dev_changes.leds.defined= devli->maps_present|devli->names_present;
	if (verbose) {
	    register unsigned i,bit,nOut;
	    nOut=0;
	    fprintf(stderr,"Changing indicator ");
	    if (nameChanged)	fprintf(stderr,"%snames",(nOut++?"":","));
	    if (changed)	fprintf(stderr,"%smaps",(nOut++?"":","));
	    if (stateChanged)	fprintf(stderr,"%sstate",(nOut++?"":","));
	    for (i=0,bit=1;i<XkbNumIndicators;i++,bit<<=1) {
		if (((nameChanged|changed|stateChanged)&bit)==0)
		    continue;
		fprintf(stderr,"    indicator %2d: ",i);
		nOut= 0;
		if (nameChanged&bit) {
		    fprintf(stderr,"%sname=\"%s\"",(nOut++?"":","),
				XkbAtomText(dpy,def[i].name,XkbMessage));
		}
		if (changed&bit) {
		    fprintf(stderr,"%snew map",(nOut++?"":","));
		}
		if (stateChanged&bit) {
		    fprintf(stderr,"%s%s",(nOut++?"":","),
					((devli->state&bit)?"on":"off"));
		}
	    }
	    fprintf(stderr,"\n");
	}
    }

    /* time to actually write the names and mappings so far */
    if (map_changes.changed)
	XkbChangeMap(dpy,xkb,&map_changes);
    if (dev_changes.changed)
	XkbChangeDeviceInfo(dpy,devi,&dev_changes);

    /* create maps for new indicators defined by name */
    for (i1=0;i1<XkbNumIndicators;i1++) {
	if ((!def[i1].defined)||(def[i1].name==None))
	    continue;
	XkbSetNamedDeviceIndicator(dpy,device,class,id,def[i1].name,
				def[i1].changeState,def[i1].newState,
				True,&def[i1].map);
				
    }
    if (verbose) {
	if (verbose>2)
	    fprintf(stderr,"Indicator maps after changes...\n");
	ShowMaps(dpy,xkb,devi,devli);
    }
    XCloseDisplay(dpy);
    return 0;
BAIL:
    XCloseDisplay(dpy);
    return 1;
}
