.\\"$Header: xpr.man,v 1.1 87/06/23 14:49:31 dkk Exp $
.\\"$Locker:  $
.TH XPR 1 "14 October 1986" "X Version 10"
.SH NAME
xpr \- print X window dump
.SH SYNOPSIS
.B xpr
[
.B \-scale
.I scale
] [
.B \-height
.I inches
] [
.B \-width
.I inches
] [
.B \-left
.I inches
] [
.B \-top
.I inches
] [
.B \-header
.I string
] [
.B \-trailer
.I string
] [
.B \-landscape
] [
.B \-portrait
] [
.B \-compact
] [
.B \-output
.I filename
] [
.B \-append
.I filename
] [
.B \-noff
] [
.B \-split
.I n
] [
.B \-device
.I dev
] [
.I filename
]
.SH DESCRIPTION

.I Xpr
takes as input an X window dump file produced by
.IR xwd (1)
and formats it for output on the LN03, LA100, or Apple LaserWriter
printer.  If no file
argument is given, the standard input is used.  By default, \fIxpr\fP
prints the largest possible representation of the window on the
output page.  Options allow the user to add headers and trailers,
specify margins, adjust the scale and orientation, and append
multiple window dumps to a single output file.  Output is to
standard output unless 
.B \-output
is specified.
.sp 1
.ne 8
.B Command Options
.sp 1
.IP "\fB\-scale\fP \fIscale\fP"
Affects the size of the window on the page.  The LN03 and LaserWriter are
able to
translate each bit in a window pixel map into a grid of a specified size.
For example each bit might translate into a 3x3 grid.  This would be
specified by \fB\-scale\fP \fI3\fP.  By default a window is printed 
with the largest scale that will fit onto the page for the specified
orientation.
.IP "\fB\-height\fP \fIinches\fP"
Specifies the maximum height of the window on the page.
.IP "\fB\-width\fP \fIinches\fP"
Specifies the maximum width of the window.
.IP "\fB\-left\fP \fIinches\fP"
Specifies the left margin in inches.  Fractions
are allowed.  By default the window is centered in the page.
.IP "\fB\-top\fP \fIinches\fP"
Specifies the top margin for the picture in inches.  Fractions are
allowed.
.IP "\fB\-header\fP \fIheader\fP"
Specifies a header string to be printed above the window.
.IP "\fB\-trailer\fP \fItrailer\fP"
Specifies a trailer string to be printed below the window.
.IP "\fB\-landscape\fP"
Forces the window to printed in landscape mode.  By default
a window is printed such that its longest side follows the long side of
the paper.
.IP "\fB\-portrait\fP"
Forces the window to be printed in portrait mode.  By default
a window is printed such that its longest side follows the long side of
the paper.
.IP "\fB\-compact\fP"
Uses simple run-length encoding for compact representation of windows
with lots of white pixels.
.IP "\fB\-output\fP \fIfilename\fP"
Specifies an output file name.  If this option is not specified, standard
output is used.
.IP "\fB\-append\fP \fIfilename\fP"
Specifies a filename previously produced by \fIxpr\fP to which the window
is to be appended.
.IP "\fB\-noff\fP"
When specified in conjunction with \fB\-append\fP, the window will appear
on the same page as the previous window.
.IP "\fB\-split\fP \fIn\fP"
This option allows the user to split a window onto several pages.  
This might be necessary for very large windows that would otherwise
cause the printer to overload and print the page in an obscure manner.
.IP "\fB\-device\fP \fIdevice\fP"
Specifies the device on which the file will be printed.  Currently only
the LN03 (-device ln03), LA100 (-device la100) and Apple LaserWriter
(-device lw or -device ps) are supported.
.SH SEE ALSO
xwd(1), xdpr(1), xwud(1), X(1)
.SH LIMITATIONS

The current version of \fIxpr\fP can generally  print out on  the LN03
most X  windows that are not   larger than two-thirds   of the screen.
For example, it will be able to print out a  large Emacs  window,  but
it will usually fail when trying to print out the  entire screen.  The
LN03 has memory  limitations that can cause it  to  incorrectly  print
very   large or complex    windows.    The two   most common    errors
encountered  are ``band  too  complex'' and ``page  memory exceeded.''
In the first case, a window may have  a particular six  pixel row that
contains too many  changes (from black to  white to black).  This will
cause the printer to drop part of the line  and possibly  parts of the
rest of the page.  The printer will flash the  number `1' on its front
panel when this problem occurs.  A  possible solution  to this problem
is to increase the scale of the picture, or to split the picture  onto
two  or  more pages.   The second problem,   ``page memory exceeded,''
will occur if the picture contains too much  black, or if the  picture
contains    complex half-tones such   as   the  background  color of a
display.  When this   problem occurs  the  printer will  automatically
split the picture  into two or  more pages.   It may  flash the number
`5' on  its from panel.   There  is no easy  solution to this problem.
It will probably be  necessary to either  cut  and paste, or rework to
application to produce a less complex picture.

\fIXpr\fP provides some support  for the  LA100.   However, there  are
several limitations on its use: The picture will  always be printed in
portrait mode (this  may  be  changed  in the future;)   there   is no
scaling; and the aspect ratio will be slightly off.

Support for the the LaserWriter currently cannot handle the \fB-append\fP,
\fB-noff\fP or \fB-split\fP options.
The \fB-compact\fP option is
.I only
supported for the LaserWriter.
It compresses white space but not black space, so it is not useful for
reverse-video windows.
.SH AUTHOR
.PP
Copyright 1985, Massachusetts Institute of Technology.
LaserWriter support copyright 1986, Marvin Solomon and the University of
Wisconsin.
.PP
Michael R. Gretzinger, MIT Project Athena
