# SWI Play TV

<img src="https://github.com/goggle/plugin.video.swiplaytv/raw/master/resources/icon.png" width="256">

**SWI Play TV** (plugin.video.swiplaytv) is a Kodi plugin to access the video library of Swissinfo,
a multilingual news and information platform produced by the Swiss Broadcasting Corporation (SRG SSR).
This repository is kept as minimal as possible. All the relevant code resides in [script.module.srgssr](https://github.com/goggle/script.module.srgssr).

## Goals of the plugin
Get the [Swissinfo video library](https://play.swissinfo.ch/play/tv/) on your TV (or another device) via [Kodi](https://kodi.tv/). The plugin aims to be close to the original media library, so that the experience of consuming media through the browser or through Kodi should be similar.

## Features
 - [x] Content from homepage
 - [x] Topics
 - [x] Shows by date
 - [x] Search videos
 - [x] Choose between SD and HD quality
 - [x] Subtitle support
 - [x] SWI on YouTube: Browse the official SWI channels on YouTube.

## Installation

 - The plugin is available in the official "Kodi Add-on repository". This is the recommended way to get the plugin.
 - You can download the newest release as a zip file from the [release section](https://github.com/goggle/plugin.video.swiplaytv/releases) on github and manually install the plugin from the zip file. If you choose this method, make sure to have all the dependencies installed, especially
   - [script.module.srgssr](https://github.com/goggle/script.module.srgssr)
   - [script.module.youtube_channels](https://github.com/goggle/script.module.youtube_channels)

   Keep in mind that you won't get any automatic updates if you choose this method

## Support this plugin
How you can help improving this plugin:
 - For bugs and feature requests use the [issue tracker](https://github.com/goggle/plugin.video.swiplaytv/issues) on the github page.
 - Feel free to submit a pull request. Please style your code according to [PEP 8](https://www.python.org/dev/peps/pep-0008/).

If you like this plugin, consider to make a donation to the author:

| Method | Link / Address | QR code |
| --- | --- | --- |
| Paypal | [Donation link](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=ZXAFRHTZGRARS) | ![Paypal link](https://raw.githubusercontent.com/goggle/plugin.video.srfplaytv/e62b52bb394eeee98c929895005bbc33e6028770/paypal.png) |
| Bitcoin | 14d2as82kQ3mRoCSyrnHNoDi8PkFvxMMgP | ![Bitcoin address](https://raw.githubusercontent.com/goggle/plugin.video.srfplaytv/af1c696004d9b42c730dc55f7e66596ec3521b99/bitcoin.png) |


## Screenshots
![Main menu](https://raw.githubusercontent.com/goggle/plugin.video.swiplaytv/master/resources/screenshot-01.png)
![A list menu](https://raw.githubusercontent.com/goggle/plugin.video.swiplaytv/master/resources/screenshot-02.png)
![Episode information](https://raw.githubusercontent.com/goggle/plugin.video.swiplaytv/master/resources/screenshot-03.png)
