# ----------------------------------------------------------------------------------------------------------------------
#  Copyright (c) 2024 Dimitri Kroon.
#  This file is part of plugin.video.viwx.
#  SPDX-License-Identifier: GPL-2.0-or-later
#  See LICENSE.txt
# ----------------------------------------------------------------------------------------------------------------------

import random


telemetry_data = [
    'a=&&&e=MkFEREQxNDQzRjlGOTJGNkI1RjQ2M0M1ODVGRDJDQjl+WUFBUTdCcDdYRGFkNkVtUUFRQUFETm85U2hoNkJQbVJSRXZDVnF5Q1JwMEhEZVIrTWNtbTBKMkFpMEpCUE8yZ2c2TkF0QW9yaDNJYWdXeTlESGl2MkpoL05LNlFDbDZ2OVR2T01raUZ6dFZCaE9Yd1FET2QxMWdoSFBMYzRXbTN6WHpyRmhYaXhEUGZyTjlBQytrc3YrYTF3aGVaNGpaUi9GNFliTTRkQkp1WUpLdEMzbWhVaUVZOVdsbWdod2dWaUlqdHlpakQ0dG8rT043NkpjVWJJd1hUVnB0d251azBVMXBUdExzTlUvZWRIZkxtOUlkWGFVS0oxSE43Q1lySGxNSEp1Z3pBUE1IYXluQzAvaEoyOG9UWjNoSTh0RzlwM0ZEQlhHS0g2b0RiQ0RqdXpRY1I0Q3p1d0F4YTAva05EV0M5em8yZnlDNzliaGtacWpUMTQrb09aRlg0Wm9Jc0ZrdE14cHl6U2QvZExMbkh3a2tJRFZNcFc3SkZSOEpUQzB0NXVMZHBmNkpiTzFPY003NitscjhvejlHRTFFWFM0TE4rV25PcktNQ2h2RjRPKzZJN09iVHVIdzFMOHd6R21BOTVSQjRoZ2NHTzVTNDBub3NweG5EbDkwemZqTW9ueEt4QzhvRGVyemkreGljRDc1bWtmeCtifjQ1MzQ4NTN+MzQ4ODA1NQ==&&&sensor_data=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',
    'a=&&&e=OTc2Q0ZGMTcxNjNDMkREQzY4OTNCQTdDQ0FDMjQ5Rjl+WUFBUUpJQVFBb0hadFZTUUFRQUFaUW5jVmhpK080amRadEJzQnExelBOemNzcXEwTHNKMzl6Y1VLWDkrUVhacHV6ZVhoS0FiQnE3c2xzQlhUYlRzL3FhMDdyS2J4M3hQbEsyNHVGMWNnZ2tNWlNqZmxmd2V1M1RZaUVDMGpqdXNtZmU3dk84WE5EN0VuWDZac3RSdVkzMzFnbXRDaXQ4a01nakJuTmgraG5jdnRsZUFrVXJIMXk0a1hkbzZ1ekdwcVF0bm40NHF3SFJ1Q0hodlZPOFM1R25rYkdKY1dNK2E4TGRzZkFVZElPaFF1Z3hRaXBpS3UwK01hWXVlenJ1Qk53MXUzZmZ3S2xvVTB6US9WN204cDRYY2NKakU4TjdIOEhCTU4reFR0WkdHd0FrVXBQZnBzSDg2M1NhMmVyd2ZyNlBZbjQ0RVpnYVZGMnlVdXJrM29RRmpiT0RoZE5oYXZJY3Y4Q3p2WWxVKzFib1VpOFB0emtWekV1dXlYVEFoTTRBeEtGVTc1a0M3R2JkRW9vaEhGVFhlfjM0ODcwMzB+MzE1OTYwMw==&&&sensor_data=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',
    'a=&&&e=OTc2Q0ZGMTcxNjNDMkREQzY4OTNCQTdDQ0FDMjQ5Rjl+WUFBUUpJQVFBaFhrdFZTUUFRQUE4d2ZqVmhoYkdtektMdyttOXl1UkttYXNReGszUi9GZmRNUmFLc2Jqak1QWXd2YnNRSGMvaVZScXF0MWUrNS9EelU0OTFHb3FDVUxRT3l6VzhnYlBwQk1ZdWxDamYybUtDWUVyeHllR2JhWm1jWkJIZk9MbDZwQ0hVdU9ZcjdheUlwZkNrcGs2OGJxSzU0RnlDZFl3TFVxSGV2VXBadTlDS2JPUlQ5MjgydXg4d21ML2YrZDFwbFZQaXBnUjNvR2Vwb3dhZ3VmTzNMTWp0bzB0S3M4RFUrL0VQUzZoTVZlUUN0OVhBUGt2VHM4NkVDMTZJWUtqVlNlUkt1NkRUY3FhMGV3OVljaVZJMG82TkdvdU5aYTVPQjkrS3ZQRUVlM3NMWWxCamY3aUYrdE50NlpyWmpSWkN6KzR6dHZFT3pMVk0vb3Z2OEwrUUpqSzI1aHJaOUlrQzhIaGZISGtVd3A4eURVdkVZMElITEt1c2NIdXV6MmhLSGdST3Z5MTljTUZHSUUwSzFLeWtjTmRzYXNzSGNuMEhJNkxCMEZBdkdzRUF3ditSbG5iZnlwcytWWT1+MzQ4NzAzMH4zMTU5NjAz&&&sensor_data=MjszNDg3MDMwOzMxNTk2MDM7MjEsMiwwLDEsMyw0Njs9MGM/S2Ndd3glO0hvfk5gdHR5Y0VdZDx5LGN9cDI8OTUtbklte1Y5UlNsI01iN0htbCBlP2x6X0NAN11MbW99diBZQl5BREU8TnV7djpvMUNQMmFFb3QyMj5DXWQrUmoxZUk9SFpda28gWWo/ZDZyZ2wxJTtfKnFXb2opP0spbXZ4W1kucl5TeSFTcURbNWwuaykgI1RwalVxeT9SdzZjWSYyLmM5SUdwfmMkZzQhUis/XlNTKllNRWxnPFMtTmNvOSZ+UTU+JlN7SHxwPjRUPVoufHxTOjErTWUqTDJDISZLPEolVmtdLVA2dWA1KGtKZytFTS1hZGt7ck9LfjJfX1VNXz56MEReak55Sn1+W0dvRUVAOSEtL1NuUiVnJXZ+VVlgVS5PYCpOSy0mXWBNN2xBUnJJOUVIJjYzYDlwSnRBUGFQN1F3O29lU1Y4QS0lWCRDZEs4UXU4WkByZUQwVjNNTUk4UGpJLXptcnBvXl44cjhHQD1dcUV1YUM1X1gmaCBBNC1QYV0/KiEmKywlMG1aJD4mKENlTnZuRU84dVAvV3lsaD5ZTCYvMEQ3VktMLnVFamlzOExDdnJKTzw5I0x7S0RRdzI3dTYwN0lOWFtHUHNJRUxpOTNaZU1WPk8qcTZdYW9TdHBjdHo8MVhedVdgMnF2a0tqc05KPEw7OyNvSHouLGxMRDxOVSMqR1FoZW0wdisxbkRHIzYkNS03eXRSMTpJKWdxYXs4ZG8tOlZSXUMlNEooXlJVZFd1YndkZko0R1s0dyUjVld9SXwhT1lUPSU0Xzp1eGYuJX56PXpTd1VxJjxmdXs0KD5iQFgvYyBnQj1SQSMlJT4hQE1SLVo8QGR5PWBtKUhjPGI4XSkzc2hnc0UycyomTGB8NUdEVkxDViB6aywza0pwPUw8ezxCbTZaR2FCe2NKKzI/Y2Uldi9ELFM2Ul5DXSMmOjpCSmtlO2EpajppezZRfkZzajQqfFM4OiNOYkwoZjQpSyxSc3x3TSsuI0VVL0VrPWh3Qy89blFQU31EMWFGNXxLQ1QkKyx0Ql1BdTddM196YHlDQz0lWGh5QnBZSSBvZTw4SSYhP3xZZXQ8WDhYPHJIYCs7RyBwJDVgLHtPYUFFe2w3IzNCMWd2I1IjXn13RHlAcCVGeGx6PWdCNyQpaF4lLUgwTilzZHQ1VzEkN2NJTjBfYH5yV3gqdEtELzEkM3B3T20tV0U3RW0wIClRS35nTyUvWEFCYHRtUUAqMHAsJXxQPmAqc35mWDJbdV5MNzRjS2ModnZEWEg1PTFIPlRRTTImRm9wZzNnPChsTVUzPWVTMDo2Q3E/Nnd3fjlAS0JTSjZtNUE+dzB9WU9APTI9cnA0U1hlNmtfUGJhci1HS19GTXtQXWRBVEkyNzYyIzRnZylheHVUISNzLj1nZSY6SD1HI1NndkF7fmprWHBidGNgM2dtfWBBOEpmbipEZSE9MENsWGh7M2tnIyshSWd7QDN2VjJ+XUZXUW8hWm45fHd2dTNUbk5YaT1bRUpfZH5ASU5wUnRZdUkqTmhqLjh+bUowOWJIYFEyP0hLXSh1Qj1FMW04U0YlSlUqQH44ZXI9WWhGQmYlamM7Iy5mJjZNYW1VRGY1d3omQnk6dDV5Rmk4STcvWyt7cHohUFouRWlrJWVnNF1XUmEhbXhsUXlSfkFrXWB8LktNXWw3IXdjYjlPIEt5JFZVPmFBaFcxSXIkRzVqPnZDfnMzcGtfZ1ImYFt+KS83OD9sM0Z6XXRZV3A2aWI/TXw1LE9sO2U2YjlSeHshYkBBVihDOGZjODJ1XX1aW2pOLD09ZyppL25DazZZYnZYR0dYLFdBMi5tZzkuWENLY08pP0prNHpNLF9DYC9LVzt+QFgzVCZwJTAjZmY6d31JNCYwP3RAJFFTI1gxZ30+emR9SiRpYD9LOEEuMF9NbX57X3ozeUgvYE4tckoqNlZMTGImaFZGPVJGTDs8eGsvRz08WXtYKiFrSjUlYDVTfnFrQ1NULj05PjY/RUUpfUNlZGkwSTp6ZkhDMSFXRm06PDBgNX5ocmsjJTlIST4lUyg0emMqZk9NJDAlfGJRej0+Tn5HSCxGU1tpfiZAOCVUNixFdjwqa29abltUSTlrRENUOGJfSmFtOTtnbCZ3fFg3NUR5UkgkRC4/MEIofUc1QFAqYW5fJCRWbTRJXlNeQncuU35fYENTUGFja1taN3okRSxudWwuNmwsVW9+K0F+ZCAxdFheVl5odSE4fCVhRmc0bF9yYC8/eDppIEZWYlAwaXZlO0M8WWopK1dESzF6QmVQN0FZLE15OSA8bmcodmsoXkF5PDRWW34yWlVmQkRkMyNyLzF2M2o6fj50JjUzLFUgdG1scDtNezNTU3kyKGdaQjlkdUxmYCRpOWx9PUc7bDw+JU5PeTlgIU1Yb1RjKV9lYSlKfUI2ZFclYn1DP1J5RVBOb35FYz1bKzdYWWA0cmhmQl1LdGhPOmNGbzdBPSNuU1h7OG0ldS1dfkNKSyFkbXZYamQ0KVtWQCNWdSo5d1VlZjpKIEg3WzdWKXgxdVpqd0d5YU5OLCBhVCNUbC1gR01gMFM/ZUxyYCVTXm5SRFZzQ3peUFs5WFRgcS0pOj0oR1IpXzRpUDd4Pn4jPip7K1Q3W1pNU0lNO35wUFgocm0gN3Y8NzFdNH5HKzloJXU1LmtBSnBAPEUyPSRnVk05N1lAVFJ5fk4uek1seD5kXylQQkovTGIrP2gwdnFmM2NUKG55V002NX55QjtTI3F4XnBoWmNddW8lKzJ8bExkZ20vXUQrJn13Y2ZDL2N7JitmLG5pc2RbTmp3IXZsRHY/Wm1ZIWtfPllDPElKWTdATz45bENETT1naWlMeXRKdW9+Ry4+NH1tdkBqZ3x5ZHY6MnZKUl9tTkJAPl5ZPSZwayFfWStZST9zeUs/dmZwI3l6ckFVKFJSVj0lQkVnK3VNTml5aXkkMD9AZlBsJC1JZlRydFBTcUBpWWY6QH47fihzZmFIYyU2Zis+dTc8X1VtZHlMZ2dlIUFwWTMxWCs3YXpYPHcrWUJRQV97U1kxYyY1WElpJCl1PCVTZ2llNTRtdGJ2NXArcU4ue0FYR0lgVUA+cndQdT8+W1o5bmNUVChNZCwqS3VGIC1Ja0t7dW12I1U0T25sJEtlLThdL1EwaSwhJlczV0tWSE0hezlZXiM8dGYvMn4/fmBPIzc9dzVSMztiSUF6NVd6ZGM2NlFXSVJFaEl7cFRDMiFbSE1BbTBWUWouQXR1ZT9lT01PKWYuYT1+aCN6dEY8Mz8+SiRwdS0tJHZ7OkgsaC8oKilPMDAlKDJdbGpibVEwKC1rJUNuTShmJiBnP2lVMX0jSD12Zis4I2hNR085SDYxZzphdGhZfS5rNX1eSSEgOH0oWkY0V3FQPUIqNCgoeyRkTWE6MHpDUztkVTY1IWc4JildS1J5MXtdbVtwOWBGT2RPbT00MFN0Xz4taXFZTCNtOVdTZnFTQyMyMkA3YVRbUEViPj06bjNwVUs3PmxpUixWfS8melNYM1NNcGUqQzQsKFovLjlxPnlvIFBlSVIyKWV+NUZvQ0w7Vl8mLFBJYmJbN3khfls/JnN3dnl8d25WKGxsI240RTtYazZCXXEzMitmTVd5Un1zdnVyeig8JSBUO0tsTCMpLUtjLD9zJj1PRDZ2LUQhZnBfX3AwLjE6QHZabzJqYXFyREUhQ20sPlBZT0JWcVQ1QUJPU3woPjlFKWksVzooP0V1JGN+YShSY3llS3QxKmZqeTpFaGIrM0YvdTxUU0BebEZhRXpFdj1NZFtRfEY3JTY4Y3JEXnt3Jnx4Mm9oXiMzbytxPiZHfDlXXVkwVVA5V1AgPmItXlB9a2k6amtiLj8qREJxVSxoI0dJPW5TWDheIDZWMlFyLkxJUSVdXmE7TChnVTgkUy5TJXsjZ0w1OmF0T2xWdUpWeyN+a0BJUiVIJGhXPDVlTnVDXmJIdSwwWnBQdVQhXXBRTFIye3xBbTMoZ142PCliNmR9MXRVTVYvOChFP1NYOVZha11FWmZFfmNRWTc9fHNKMT1USCo7THRNQVJKdV8uVHQ0eGopQ3tWRzYzLTFscFYoU3BaO2lxUSFtQSpmVSFsdCl+dEpPe1RKcHJuc11qOypWdXBafj58SD9+aklHb0xsOTJ9UmhUNzYzSTxIQkopIDdnbmYuPjZoZkRAfHhUP1oxKHtHQ0F3KjRocSEkMXJwNWVhayFdS3ZyaG9dVyohPmx0b0RqbGVqWH4xUUlYOjxmPkBaLFVBKypveGJ2VkBuP1FTNW9fT3Z0LTxjaytuZkUgKjliQTV3Nigscj9QUnBPWGV2MSU/WGg0RGh1NSwtcUdWdlIoMG53aSMgQHghSDdGUUImKyZKWiVBZ3Q9QUQwbXw2KVpTUFVvIHowMSNhUXAoXU5RXS47Q2BoczJJZzErQ2BHJi4kN0JhaTF+MGdTZDY0XyYxVHhJZTpgRi5MMStWcGNEXltkJEtEY15+b0RxQzEsOE51NnZBIT1xKD4zL056bmFpezs/cn5PTG1SQWhFLi1VTy5TQGZPdVJmLHh8Q3tsXyR4S2s/QnN0MzUqXyghKVVqSW5aKmlJIDdnXlsvaXVbITFhdEFbNjxsZmg/fHp5d152TWJBXldEaDQ6QkolVExwKjV1ZERTX1hgVzUjWlQvUmFqOWk1ZCEsfWBsQS1oOVV7T0Nde2h0OUBVMXUhP204K1JXPUMmXi1afS1zU1pvPks8eEchYXxLWGdNLERdPWBfNjwgOHFdKHEpQCt0MypwNmo+OV9LK0tRcFRUaCVlODh9dHByVlR+dD9BNzJHU2NWSCVmRDFhRUpwa05tNmtgUTlMRFAzNG9dKTpBO090T25mP0t8akUrO2ZYV3k6KGN2Ymptc2p8W0xvKjM4VG5YPXxiako7a1V1TUVFbD8qaHhzJi07NUktd1BwfClPaVc5MHolZGBHN1t3JSlLI3Zxe3wvOl1RYE1TL1BlZTxnUzUxfih9eVhNekpjaTdqZnBrc0E7Zlp8d2lQezMubUA0diV5Nn14T00sVVtsQXp3JUtnK0RfbCQoL25GQG1Ce3ZWfWkgaSF6eUp+NEs6Kmx8NEshN0tuMyxAelZnfmZCQT1KV2VeeGRdMWhXWUc1QEBsfFNnOFVyI3RRPSQ6d2dyZXN2RT5bU109M0pyYExpWTFHKDpocUNkYkxBWCloWDVrJEZmKUEsTDN7SF9dQWB2S2k8QjRWJSx3WExkLSB3aHlHbm17SWVrQ0daLkgyTEo1fUdlRHVIYVR9djV0PlhdI0VeMUJZMk48N3E4Pj9TdFMocTEqXjVAd3JsRn5xaywwaytYOiF2XiRqQHogIDxpQnxsQjFVSl4wMDx9RVdDcTFVe1J4W2shKjNmSEhWek0qZV07MWhMckxRYEF7LzJSaD5pVmxWcjBFPixaIC9dfnVSRTshV1ctSGRsYEBIVCM6I0c2YTxWOjNNO3wlRypOQS0kcWpJQHVKaXZfWW52V25hfWg/M0ohPEpAKkJQPWRfSktLPDE2aDpPfWBSayVuIXJFPHdbL3AjMjAgP19NLndsdnRtaV1IMkR1ZVkqNGg8MSRmQDReVFZ9cHA9WT01JiMsLEUrOXlYJFVITHgtbEVCeyVgVSR9OmBkXXZGQiQ4MTlGVExMPTJSJX4rZnpdeyReMXp4RjlofSo5aEIjcH0mPj1gUGxiU3xTa101dkU0LSYpb31PWH5NV1k1dWVYZnpAPl9nbmpsRXsyMWwyMXN6b35+cWtdfmh0KGEpcGwgLHsvTWFzb3AvaWtYL2RoQVtSYmRqWVUuaXwzfVVfUW0tVXEuR2ArRDNvWEkxXXhVXl8gKlFBYSEpUH5Na2JgdU17PSUpTVJZRkNGalk/OjJERXVqKi4xalklRCV8fTBebz5uT1kpT0I0fVBrTj5UR0dMciA2L0UtNmcmfG0pO2QyZS1pL1JzLm90QGtPRU1TbiBKXjM1QyR4Vm9pXnYpaTBuPH1GfEBPTjltPjkuP0VvJmJtPDpZTksvR1NLZ35nJGZMLk87R3d0c00udW4wMm19X3Y+U3JobDx9c3hWX017b0A2VjhkLjRBbFE9RmR4UCZLb0Fdd34rZTU3QHkvJVJPNn1XRmE3PUwhZ3dyMlI+STFaQVlsIC9vTlBmTGVXOTNuWUpJWTNAVUB3KDNhKWc1akM3OHMheHFYbntSL3lQUUREKXBSMzVQRyE/TWxHNEc+K00jTGV2X1hqfGJGNHolcm1dSCxqKkk5KTVXNVI8cl0xJkstRVFSSGQwZD9QLjokMHl8XTppJiF3MkMpU1QjdS5IVDVARGMjTkpddHJfT2h5SEdfcGc4WSNPcHlbel0qP2U9TmtvZjhbIXs1NzBtOzFTNE0/bGI1YytRbUtxVHpzPklxJisyM2UzTkF9dj0+VC9mUU1XUlFgKVI+W15yI0BHVkpudm8kJCpXe19qJjFGKmpdVmZlS35TUXpXNGI7',
    'a=&&&e=OTc2Q0ZGMTcxNjNDMkREQzY4OTNCQTdDQ0FDMjQ5Rjl+WUFBUUpJQVFBaFhrdFZTUUFRQUE4d2ZqVmhoYkdtektMdyttOXl1UkttYXNReGszUi9GZmRNUmFLc2Jqak1QWXd2YnNRSGMvaVZScXF0MWUrNS9EelU0OTFHb3FDVUxRT3l6VzhnYlBwQk1ZdWxDamYybUtDWUVyeHllR2JhWm1jWkJIZk9MbDZwQ0hVdU9ZcjdheUlwZkNrcGs2OGJxSzU0RnlDZFl3TFVxSGV2VXBadTlDS2JPUlQ5MjgydXg4d21ML2YrZDFwbFZQaXBnUjNvR2Vwb3dhZ3VmTzNMTWp0bzB0S3M4RFUrL0VQUzZoTVZlUUN0OVhBUGt2VHM4NkVDMTZJWUtqVlNlUkt1NkRUY3FhMGV3OVljaVZJMG82TkdvdU5aYTVPQjkrS3ZQRUVlM3NMWWxCamY3aUYrdE50NlpyWmpSWkN6KzR6dHZFT3pMVk0vb3Z2OEwrUUpqSzI1aHJaOUlrQzhIaGZISGtVd3A4eURVdkVZMElITEt1c2NIdXV6MmhLSGdST3Z5MTljTUZHSUUwSzFLeWtjTmRzYXNzSGNuMEhJNkxCMEZBdkdzRUF3ditSbG5iZnlwcytWWT1+MzQ4NzAzMH4zMTU5NjAz&&&sensor_data=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',
    'a=&&&e=OTc2Q0ZGMTcxNjNDMkREQzY4OTNCQTdDQ0FDMjQ5Rjl+WUFBUUpJQVFBaFhrdFZTUUFRQUE4d2ZqVmhoYkdtektMdyttOXl1UkttYXNReGszUi9GZmRNUmFLc2Jqak1QWXd2YnNRSGMvaVZScXF0MWUrNS9EelU0OTFHb3FDVUxRT3l6VzhnYlBwQk1ZdWxDamYybUtDWUVyeHllR2JhWm1jWkJIZk9MbDZwQ0hVdU9ZcjdheUlwZkNrcGs2OGJxSzU0RnlDZFl3TFVxSGV2VXBadTlDS2JPUlQ5MjgydXg4d21ML2YrZDFwbFZQaXBnUjNvR2Vwb3dhZ3VmTzNMTWp0bzB0S3M4RFUrL0VQUzZoTVZlUUN0OVhBUGt2VHM4NkVDMTZJWUtqVlNlUkt1NkRUY3FhMGV3OVljaVZJMG82TkdvdU5aYTVPQjkrS3ZQRUVlM3NMWWxCamY3aUYrdE50NlpyWmpSWkN6KzR6dHZFT3pMVk0vb3Z2OEwrUUpqSzI1aHJaOUlrQzhIaGZISGtVd3A4eURVdkVZMElITEt1c2NIdXV6MmhLSGdST3Z5MTljTUZHSUUwSzFLeWtjTmRzYXNzSGNuMEhJNkxCMEZBdkdzRUF3ditSbG5iZnlwcytWWT1+MzQ4NzAzMH4zMTU5NjAz&&&sensor_data=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',
    'a=&&&e=OTc2Q0ZGMTcxNjNDMkREQzY4OTNCQTdDQ0FDMjQ5Rjl+WUFBUUpJQVFBaFhrdFZTUUFRQUE4d2ZqVmhoYkdtektMdyttOXl1UkttYXNReGszUi9GZmRNUmFLc2Jqak1QWXd2YnNRSGMvaVZScXF0MWUrNS9EelU0OTFHb3FDVUxRT3l6VzhnYlBwQk1ZdWxDamYybUtDWUVyeHllR2JhWm1jWkJIZk9MbDZwQ0hVdU9ZcjdheUlwZkNrcGs2OGJxSzU0RnlDZFl3TFVxSGV2VXBadTlDS2JPUlQ5MjgydXg4d21ML2YrZDFwbFZQaXBnUjNvR2Vwb3dhZ3VmTzNMTWp0bzB0S3M4RFUrL0VQUzZoTVZlUUN0OVhBUGt2VHM4NkVDMTZJWUtqVlNlUkt1NkRUY3FhMGV3OVljaVZJMG82TkdvdU5aYTVPQjkrS3ZQRUVlM3NMWWxCamY3aUYrdE50NlpyWmpSWkN6KzR6dHZFT3pMVk0vb3Z2OEwrUUpqSzI1aHJaOUlrQzhIaGZISGtVd3A4eURVdkVZMElITEt1c2NIdXV6MmhLSGdST3Z5MTljTUZHSUUwSzFLeWtjTmRzYXNzSGNuMEhJNkxCMEZBdkdzRUF3ditSbG5iZnlwcytWWT1+MzQ4NzAzMH4zMTU5NjAz&&&sensor_data=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',
    'a=&&&e=QjFGQzYyMTM4OTVEMEI2NTU2MUI3M0RCMkIwRjdENER+WUFBUUpJQVFBcC8zdFZTUUFRQUFDK2J0VmhnVExZVTZ0Y3JWeHZYUm1QQS81SlFRMEdUQWRhdmQzWXBLY0NZSnFZQ1NKZktWUlRrWFVHWXVINTV6Q0tzWXRQb1MrYTd0R2FhaTNwWnZDbDhmWXJRTm1KV0x2ODVSSkU2RXNrY2JyVjZSZ3lOdEwwTjh6eWh1VFlPN1lCcnJPbWhDM3hYT252MFN4bFBqa29wRkhibW05OXJoUVd1aFVaVisweGJSSGo2c1RYWGk5NiszYzg0dS9sVU9WRmhMeXhqa0Nwb2xGRlZTZEs0TURPRVFhTFo2NkxJa1JlNDFhaURoWFAwdmF4aGNLdDJ4V3haNEh5QzFIRHpmOWFFV1EvTE8rZFlLRjBKSXRXM1puSVFFdHNtdGxrQmg4ZXVuSEozeURRV2V2d0NITndXQ3FyZ0xZQVVlZlNtbGV2TzFUWGxHZEM4M01JZFRFRkxZRmV1SzM3ZFdlTzZVSVA1MjkzOFlHdm1iam5BcWtyS2k5YmtyN3kwaWY2ZW53MXZtfjQyNzI0MzR+MzYxODYyNQ==&&&sensor_data=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',
    'a=&&&e=QjFGQzYyMTM4OTVEMEI2NTU2MUI3M0RCMkIwRjdENER+WUFBUUpJQVFBcC8zdFZTUUFRQUFDK2J0VmhnVExZVTZ0Y3JWeHZYUm1QQS81SlFRMEdUQWRhdmQzWXBLY0NZSnFZQ1NKZktWUlRrWFVHWXVINTV6Q0tzWXRQb1MrYTd0R2FhaTNwWnZDbDhmWXJRTm1KV0x2ODVSSkU2RXNrY2JyVjZSZ3lOdEwwTjh6eWh1VFlPN1lCcnJPbWhDM3hYT252MFN4bFBqa29wRkhibW05OXJoUVd1aFVaVisweGJSSGo2c1RYWGk5NiszYzg0dS9sVU9WRmhMeXhqa0Nwb2xGRlZTZEs0TURPRVFhTFo2NkxJa1JlNDFhaURoWFAwdmF4aGNLdDJ4V3haNEh5QzFIRHpmOWFFV1EvTE8rZFlLRjBKSXRXM1puSVFFdHNtdGxrQmg4ZXVuSEozeURRV2V2d0NITndXQ3FyZ0xZQVVlZlNtbGV2TzFUWGxHZEM4M01JZFRFRkxZRmV1SzM3ZFdlTzZVSVA1MjkzOFlHdm1iam5BcWtyS2k5YmtyN3kwaWY2ZW53MXZtfjQyNzI0MzR+MzYxODYyNQ==&&&sensor_data=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',
    'a=&&&e=QjFGQzYyMTM4OTVEMEI2NTU2MUI3M0RCMkIwRjdENER+WUFBUUpJQVFBcC8zdFZTUUFRQUFDK2J0VmhnVExZVTZ0Y3JWeHZYUm1QQS81SlFRMEdUQWRhdmQzWXBLY0NZSnFZQ1NKZktWUlRrWFVHWXVINTV6Q0tzWXRQb1MrYTd0R2FhaTNwWnZDbDhmWXJRTm1KV0x2ODVSSkU2RXNrY2JyVjZSZ3lOdEwwTjh6eWh1VFlPN1lCcnJPbWhDM3hYT252MFN4bFBqa29wRkhibW05OXJoUVd1aFVaVisweGJSSGo2c1RYWGk5NiszYzg0dS9sVU9WRmhMeXhqa0Nwb2xGRlZTZEs0TURPRVFhTFo2NkxJa1JlNDFhaURoWFAwdmF4aGNLdDJ4V3haNEh5QzFIRHpmOWFFV1EvTE8rZFlLRjBKSXRXM1puSVFFdHNtdGxrQmg4ZXVuSEozeURRV2V2d0NITndXQ3FyZ0xZQVVlZlNtbGV2TzFUWGxHZEM4M01JZFRFRkxZRmV1SzM3ZFdlTzZVSVA1MjkzOFlHdm1iam5BcWtyS2k5YmtyN3kwaWY2ZW53MXZtfjQyNzI0MzR+MzYxODYyNQ==&&&sensor_data=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',
    'a=&&&e=QjFGQzYyMTM4OTVEMEI2NTU2MUI3M0RCMkIwRjdENER+WUFBUUpJQVFBakVMdGxTUUFRQUFnbUg1VmhnbS9wdzR3d2VBOFJCN2w4MENPakI3aFB2dGlJM1M3Q0ZSNmJNTHd5RkRheDh5RXlJQ25sQk8yMXo0WGsyUjRsaDE3b2JoOHFPNWtleUdGUmNWSC9lTDd1eEd1Z2RpWUtESDBJRGZGYjJzVGwzSTJJYzF3SnlLckcvQTNzWm5jY1hTS29KWW1kOExqVU40R0d1MEN5bHBJaUJlWWNBUVJZYVpOYW9LYm5VUFBXTlY4UnRsMDRXeHZGcG03bjh2eFJBMU5Obm5MellBVDZMRWFQa1JlbkluVUtqYkhGbkdWZjhBK3prc2YxQXgwQjBFYkw0QXJ4ZlBZMEh2U3BZZ3orZnQwbXorSVFING05b1V2clVlcU4xOWE2VUtEMnJvMVlBSm1Ub1hwMXhHR0NPNXFka1lnR3Q2dkxULzFQWUIvNVQ4WXFyVDNJcUlLSkw5RzZDOG9VTHF1TjRVVVpqOWxqUloxWTJxckJWcUV5alpaRXArVzNxRHBFSUZ4dlRPbzE1MTBzV0V0YkEwaXRQRERnUjFLSTV2Ukd2SDZXSTI1NmxyK1AvSjVRPT1+NDI3MjQzNH4zNjE4NjI1&&&sensor_data=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',
    'a=&&&e=QjFGQzYyMTM4OTVEMEI2NTU2MUI3M0RCMkIwRjdENER+WUFBUUpJQVFBakVMdGxTUUFRQUFnbUg1VmhnbS9wdzR3d2VBOFJCN2w4MENPakI3aFB2dGlJM1M3Q0ZSNmJNTHd5RkRheDh5RXlJQ25sQk8yMXo0WGsyUjRsaDE3b2JoOHFPNWtleUdGUmNWSC9lTDd1eEd1Z2RpWUtESDBJRGZGYjJzVGwzSTJJYzF3SnlLckcvQTNzWm5jY1hTS29KWW1kOExqVU40R0d1MEN5bHBJaUJlWWNBUVJZYVpOYW9LYm5VUFBXTlY4UnRsMDRXeHZGcG03bjh2eFJBMU5Obm5MellBVDZMRWFQa1JlbkluVUtqYkhGbkdWZjhBK3prc2YxQXgwQjBFYkw0QXJ4ZlBZMEh2U3BZZ3orZnQwbXorSVFING05b1V2clVlcU4xOWE2VUtEMnJvMVlBSm1Ub1hwMXhHR0NPNXFka1lnR3Q2dkxULzFQWUIvNVQ4WXFyVDNJcUlLSkw5RzZDOG9VTHF1TjRVVVpqOWxqUloxWTJxckJWcUV5alpaRXArVzNxRHBFSUZ4dlRPbzE1MTBzV0V0YkEwaXRQRERnUjFLSTV2Ukd2SDZXSTI1NmxyK1AvSjVRPT1+NDI3MjQzNH4zNjE4NjI1&&&sensor_data=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',
]


class _TelemetryFactory():
    def __init__(self):
        self.used_indices = []

    def get_data(self):
        """Return telemetry data.

        Ensure to return different data on each call until the list of data is exhausted, and
        apply some unpredictability as to what data is returned.
        """
        data_len = len(telemetry_data)
        new_idx = int(random.random() * (data_len - 1))
        while new_idx in self.used_indices:
            new_idx += 1
            if new_idx >= data_len:
                new_idx = 0
        self.used_indices.append(new_idx)
        if len(self.used_indices) >= data_len:
            self.used_indices.clear()
        return telemetry_data[new_idx]


telemetry_factory = _TelemetryFactory()