/*
 * Copyright (C) 2000-2025 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include "xitk.h"

typedef enum {
  PLAYLIST_LOAD = 0,
  PLAYLIST_SAVE,
  PLAYLIST_CLEAR,
  PLAYLIST_CURR_REMOVE,
  PLAYLIST_CURR_UP,
  PLAYLIST_CURR_DOWN,
  PLAYLIST_CURR_PLAY,
  PLAYLIST_CURR_EDIT,
  PLAYLIST_CURR_SCAN,
  PLAYLIST_SCAN,
  PLAYLIST_LAST
} playlist_action_t;

int playlist_action (gGui_t *gui, playlist_action_t action);

/** open/toggle/close playlist editor window (XUI_W_*). */
void playlist_main (xitk_widget_t *mode, void *gui);

void playlist_change_skins (gGui_t *gui, int synth);
void playlist_get_input_focus (gGui_t *gui);

/** return selected index or -1. safe even without xitk lock. */
int playlist_update_playlist (gGui_t *gui);

void playlist_delete_entry (gGui_t *gui, int j);

void playlist_scan_input_w (xitk_widget_t *w, void *gui, int state, unsigned int modifier);
void playlist_scan_input_s (gGui_t *gui, const char *name);
#endif
