/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CHANGEUSERPWD_H
#define CHANGEUSERPWD_H

#include <QDialog>
#include <QTimer>

#include "pwdcheckthread.h"
#include "passwdcheckutil.h"

#ifdef ENABLEPQ
extern "C" {

#include <pwquality.h>

}

#define PWCONF "/etc/security/pwquality.conf"
#define RFLAG 0x1
#define CFLAG 0x2

#endif

class QHBoxLayout;
class QVBoxLayout;
class QLabel;
class QLineEdit;
class QPushButton;
class QMouseEvent;
class QKeyEvent;

class ChangeUserPwd : public QDialog
{
    Q_OBJECT

public:
    explicit ChangeUserPwd(QString n, QWidget *parent = nullptr);
    ~ChangeUserPwd();

public:
    void initUI();
    void setupConnect();
    void setupStatus(QString n);

    void makeSurePwqualityEnabled();

    void updateTipLableInfo(QLabel *label, QString info);
    void refreshConfirmBtnStatus();
    void refreshCloseBtnStatus();
public:
    QVBoxLayout * mainVerLayout;
    QVBoxLayout * contentVerLayout;
    QHBoxLayout * currentPwdHorLayout;
    QHBoxLayout * newPwdHorLayout;
    QHBoxLayout * tipHorLayout;
    QVBoxLayout * surePwdWithTipVerLayout;
    QHBoxLayout * surePwdHorLayout;
    QHBoxLayout * bottomBtnsHorLayout;
    QHBoxLayout *curTipHorLayout;
    QHBoxLayout *newTipHorLayout;
    QHBoxLayout *sureTipHorLayout;

    QPushButton * cancelBtn;
    QPushButton * confirmBtn;

    QLabel *currentPwdLabel;
    QLabel *curTipLabel;
    QLabel *newPwdLabel;
    QLabel *newTipLabel;
    QLabel *surePwdLabel;
    QLabel *tipLabel;

    QLineEdit * currentPwdLineEdit;
    QLineEdit * newPwdLineEdit;
    QLineEdit * surePwdLineEdit;

    QPushButton *currentPwdEyeBtn;
    QPushButton *newPwdEyeBtn;
    QPushButton *surePwdEyeBtn;

protected:
    void keyPressEvent(QKeyEvent *);
    bool eventFilter(QObject *target, QEvent *event);
private:
    QString name;
    QString curPwdTip;
    QString newPwdTip;
    QString surePwdTip;
    QPixmap m_waitingPixmap;
    QTimer *m_timer = nullptr;

    bool isCurrentUser;
    bool isChecking;
    bool enablePwdQuality;

    PwdCheckThread * thread1ForCheckPwd;

#ifdef ENABLEPQ
    pwquality_settings_t *settings;
#endif

private:
    bool setTextDynamicInPwd(QLabel * label, QString string);

    void checkPwdLegality();
    bool isContainLegitimacyChar(QString word);
    int isDomainUser(const char* username);

private slots:
    void test();
    void updatePixmap();

signals:
    void changeOtherUserPwd(QString pwd);

};

#endif // CHANGEUSERPWD_H
