C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=IMOBIL,SSI=0
C
                        SUBROUTINE IMOBIL
C                       *****************
C
     * (CTYP,VV,NVV,NBMOBS,NDIM,NPOINS,NMOBIL,NREFS,IREF,NB,COORDS)
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   INITIALISATION POUR LES SOLIDES EN ROTATION             *
C                                                                      *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! CTYP   !   C  ! D  ! TYPE DE TRANSFORMATION  (T,R,TR ou RT)      !
C   ! VV     !  TR  ! D  ! DONNEES DU MOUVEMENT                        !
C   ! NVV    !   E  ! D  ! TAILLE DU TABLEAU VV (IE : NBRE DE DONNEES) !
C   ! NBMOBS !   E  ! D  ! NBRE DE NOEUDS EN MOUVEMENT                 !
C   ! NDIM   !   E  ! D  ! DIMENSION DU PROBLEME                       !
C   ! NPOINS !   E  ! D  ! NOMBRE DE NOEUDS SOLIDES                    !
C   ! NMOBIL !  TE  ! M  ! NUMERO GLOB DES NOEUDS MOBILES ET NUMERO DU !
C   !        !      !    ! SOLIDE AUXQUEL ILS APPARTIENNENT            !
C   ! COORDS !  TR  ! D  ! COORDONNEES DES NOEUDS                      !
C   ! IREF   !  TE  ! D  ! REFERENCES IMPLIQUEES                       !
C   ! NB     !   E  ! D  ! NOMBRE DE REFERENCES IMPLIQUEES             !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/NLOFES/!      ! D  !                                             !
C   !/XREFER/!      ! D  !                                             !
C   !/MOBIL/ !      ! M  !                                             !
C   !__________________________________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : LECLIM
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "mobil.h"
#include "nlofes.h"
#include "xrefer.h"
C
C**********************************************************************
C
C..Variables externes
      CHARACTER*1 CTYP
      INTEGER NVV,NDIM,NPOINS,NBMOBS,NB
      INTEGER IREF(NRFMAX),NMOBIL(NBMOBS,2),NREFS(NPOINS)
      DOUBLE PRECISION VV(NVV),COORDS(NPOINS,NDIM)
C
C..Variables internes
      INTEGER N,N1,M,NR,NBRE,NUMGLO,NUMREF
      LOGICAL LVERIF
C
C**********************************************************************
C
C     0- Initialisations
C     ------------------
      LVERIF = .FALSE.
      NBRE = 0
C
      NBRMOB = NBRMOB +1
C
C     1- Cas ou la condition s'applique sur tous les noeuds
C     -----------------------------------------------------
C
      IF (IREF(1) .EQ. -1 ) THEN
C
        NBRMOB = 1
C
        DO 110 N=1,NBMOBS
           NMOBIL(N,2) = 1
           NBRE = NBRE + 1
  110  CONTINUE
C
        DO 120 N=1,9
          DEFMOB(1,N+1) = VV(N)
  120   CONTINUE
C
C     2- Application de la condition aux references citees
C     ----------------------------------------------------
      ELSE
C
       DO 200 N1=1,NB
C
         NR = IREF(N1)
C
         DO 210 N=1,NBMOBS
C
           NUMGLO = NMOBIL(N,1)
           NUMREF = NREFS(NUMGLO)
C
           IF (NUMREF .EQ. NR) THEN
              NMOBIL(N,2) = NBRMOB
              NBRE = NBRE + 1
           ENDIF
C
          DO 220 M=1,9
            DEFMOB(NBRMOB,M+1) = VV(M)
  220     CONTINUE
C
  210   CONTINUE
  200  CONTINUE 
C
      ENDIF
CC
C
C
C
C--------
C FORMATS
C--------
C----
C FIN
C----
C
      RETURN
      END
