/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SCLVI_H
#define _SC_SCLVI_H

// sc
#include "ScLviVisitor.h"
#include "util/Id.h"
class ProjectLvi;

// qt
#include <QtGui/QListView>

/**
 * \brief the base class for ListViewItems in the ProjectFoldersWidget.
 */
class ScLvi : public QListViewItem
{
  typedef QListViewItem super;

public:
  ScLvi( QListView* parent, QString string );
  ScLvi( QListViewItem* parent, QString string );
  virtual ~ScLvi();

  virtual void onItem();
  virtual void expanded();
  virtual void collapsed();
  virtual void pressed(bool refresh);
  virtual void clicked();
  virtual void doubleClicked();
  virtual void selectionChanged();
  virtual void rightButtonClicked( const QPoint& pos );
  virtual void returnPressed();
  virtual void contextMenuRequest( const QPoint& p, int col );
  virtual void renamed( const QString& text );

  void setSelected( bool b );
  void clear();

  virtual long getSortPos() const = 0;

  /**
   * Enable/Disable QActions.
   */
  // \active 
  // @{
  virtual void enableActions();
  virtual void disableActions();
  // @}

  /**
   * get the event target id for running commands.
   */
  ID getTid() const;

  /**
   * get the event target object fur posting events.
   */
  QObject* getTidObj() const;

  /**
   * call dropped.
   */
  void dropEvent( QDropEvent* e );

  /**
   * drag and drop handling (sorting).
   */
  bool acceptDrop( const QMimeSource* mime ) const = 0;
  void dropped( QDropEvent* e ) = 0;
  virtual QDragObject* dragObject() = 0;

  /**
   * return ProjectLvi.
   */
  ProjectLvi* getProjectLvi();

  void okRename( int col );
  bool isRename() const;

  /**
   * return unique item id.
   */
  long getId() const;

  /**
   *
   */
  virtual bool isSelectable( QListViewItem* prev ) const;

  /**
   * visitor.
   */
  virtual void accept( ScLviVisitor* ) = 0;

private:
  void initId();

private:
  long _id;          ///< unique lvi identifier.
  bool _inRename;    ///< in place rename running.
};


template<typename T> inline ScLvi* ScLvi_cast(T *p)
{
  return dynamic_cast<ScLvi*>(p);
}


#endif //  _SC_SCLVI_H
