/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [hpat.h]              Template / Pattern Evaluation                      */
/*                                                                          */
/* Copyright (c) 1999 by D\olle, Manns, Steffen                             */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef hpat_INCL
#define hpat_INCL


#include "standard.h"
#include "scn_base.h"
#include "symbols.h"
#include "otab.h"
#include "gls.h"
#include "hpat_int.h"


#ifdef __cplusplus
extern "C" {
#endif


/* 
  <p>The module [hpat] provides some functionality for the evaluation of
  template files based on the context-free grammar [hpat.sty].
  <p>It is used by the <a href="cmd_stydoc.htm">STYX reference generator</a>.
  <br>
*/

/* ------------------------- Types & Macros ----------------------------- */

/*  <p><b>Pattern types</b> */

#define HPAT_REF_LIST   0 // pattern list
#define HPAT_REF_PAT    1 // pattern
#define HPAT_REF_PAR    2 // pattern parameter

AbstractType(HPat_T); // Abstract template type

/*  <p><b>Callback function types</b> */

// pattern reference evaluation function
typedef c_bool (*PFN_Pat)(HPat_T pHPat);

// print function
typedef void (*PFN_PatPrint)(HPat_T pHPat, c_string szTxt);

// replacement specification pattern load function
typedef StdCPtr (*PFN_PatLoad)(GLS_Lst(hpatContent) pLst);
// replacement specification apply function
typedef c_string (*PFN_PatOpr)(c_string szTxt, StdCPtr pData);
// replacement specification free function
typedef void (*PFN_PatFree)(StdCPtr pData);

/* -------------------------- Special Functions -------------------------- */

c_string HP_pat_to_txt(GLS_Lst(hpatContent) pLst)
/* template term list 'pLst' to string; allocs memory */
;


/* ------------------------- Init & Quit -------------------------------- */

void HP_init(void);               /* initializes template evaluation module */
void HP_quit(void);               /* terminates template evaluation module  */

/* ------------------------- Create & Dispose --------------------------- */

HPat_T HP_create(void);           /* creates a template evaluation object   */
void   HP_drop(HPat_T pHP);       /* frees template evaluation object 'pHP' */

/* ------------------------- Get & Set ---------------------------------- */

void HP_setContext(HPat_T pHP, Abs_T pDocCtx)
/* sets evaluation context 'pDocCtx' in template object 'pHP' */
;

Abs_T HP_getContext(HPat_T pHP)
/* evaluation context of template object 'pHP' */
;

void HP_setPrintFun(HPat_T pHP, PFN_PatPrint pPrint)
/* sets print function 'pPrint' in template object 'pHP' */
;

PFN_PatPrint HP_getPrintFun(HPat_T pHP)
/* print function of template object 'pHP' */
;

void HP_setRefAlias(HPat_T pHP, symbol pRefAlias)
/* sets reference alias 'pRefAlias' in template object 'pHP'
*/
;

symbol HP_getRefAlias(HPat_T pHP)
/* reference alias of template object 'pHP' */
;

void HP_addPatSpec
     (
       HPat_T pHP, symbol pPat, PFN_Pat pPatFun, long lPatTyp
     )
/* adds/overwrites evaluation function 'pPatFun'
   for pattern 'pPat' of type 'lPatTyp'
   to template object 'pHP'
*/
;

PFN_Pat HP_getPatFun(HPat_T pHP, symbol pPat)
/* evaluation function for pattern 'pPat'
   in template object 'pHP'
*/
;

ROW(symbol) HP_getListPatRow(HPat_T pHP, symbol pListPat)
/* member patterns of pattern list 'pListPat'
   in template object 'pHP'
*/
;

void HP_setScanner(HPat_T pHP, Scn_T pScn)
/* sets external scanner 'pScn' in template object 'pHP'
   ( will be removed by HP_drop )
*/
;

Scn_T HP_getScanner(HPat_T pHP)
/* pattern scanner of template object 'pHP' */
;

symbol HP_getPatRef(GLS_Tok pPatRef)
/* symbol of pattern refernce token 'pPatRef' */
;

c_bool HP_addSpecialFun
       (
         symbol      pPatSym,
         PFN_PatLoad pPatLoad,
         PFN_PatOpr  pPatOpr,
         PFN_PatFree pPatFree
       )
/* adds special evaluation functions for
   replacement specification pattern 'pPatSym'
   'pPatLoad': loads replacement specification
   'pPatOpr' : applies replacement specification
   'pPatFree': frees replacement specification
   ( RC = ok/error )
*/
;


/* ------------------------- Load & Check ------------------------------- */

c_bool HP_load
       (
         HPat_T pHP, Scn_Stream pStream, symbol pSrcId,
         symbol pRootPat, c_bool bRecursive
       )
/* loads template pattern from scan stream 'pStream'
   into template object 'pHP'
   'pSrcId'    : optional source identifier
   'pRootPat'  : root pattern for evaluation
   'bRecursive': recursive evaluation
   ( RC = ok/error )
*/
;

c_bool HP_check(HPat_T pHP)
/* checks loaded template pattern in template object 'pHP'
   ( RC = ok/error )
*/
;


/* ------------------------- Output Generation -------------------------- */

void HP_gendoc_ref(HPat_T pHP, GLS_Tok pPatRef)
/* evaluates and prints reference token 'pPatRef'
   according template object 'pHP'
*/
;

c_bool HP_fun_defined(HPat_T pHP, symbol pRefSym)
/* whether template object 'pHP' contains a
   replacement specification for pattern 'pRefSym'
*/
;

c_string HP_fun_apply(HPat_T pHP, symbol pRefSym, c_string szTxt)
/* applies the replacement specification for pattern 'pRefSym'
   in template object 'pHP' to text 'szText'
   RC = szTxt, if no functions defined, else result text
*/
;

void HP_gendoc_pat(HPat_T pHP, symbol pPatSym)
/* evaluates and prints pattern 'pPatSym'
   according template object 'pHP'
*/
;

void HP_gendoc_src(HPat_T pHP, symbol pSrcId)
/* evaluates and prints template 'pSrcId'
   according template object 'pHP'
*/
;



#ifdef __cplusplus
}
#endif

#endif
