PLUGIN_FIND_INCLUDE (UTIL util.h)
PLUGIN_FIND_INCLUDE (LIBUTIL libutil.h)
PLUGIN_FIND_LIBRARY (UTIL util)
PLUGIN_FIND_INCLUDE (PTY pty.h)
PLUGIN_FIND_INCLUDE (STROPTS stropts.h)

CHECK_FUNCTION_EXISTS (openpty OPENPTY)

IF (OPENPTY)
  SET (HAVE_OPENPTY 1)
ENDIF ()

IF (NOT HAVE_OPENPTY AND HAVE_LIBUTIL)
  CHECK_LIBRARY_EXISTS (util openpty "" UTIL_OPENPTY)
  IF (UTIL_OPENPTY)
    PLUGIN_LINK_LIBRARIES (util)
    SET (HAVE_OPENPTY 1)
  ENDIF ()
ENDIF ()

IF (NOT HAVE_OPENPTY AND EXISTS /dev/ptmx)
  CHECK_FUNCTION_EXISTS (grantpt HAVE_UNIX98_PTYS)
  IF (NOT HAVE_UNIX98_PTYS)
    PLUGIN_DISABLE ()
  ENDIF (NOT HAVE_UNIX98_PTYS)
ENDIF (NOT HAVE_OPENPTY AND EXISTS /dev/ptmx)

PLUGIN_INCLUDE_DIRECTORIES (${unix}/plugins/AsynchFilePlugin)

CONFIG_DEFINE (HAVE_UTIL_H)
CONFIG_DEFINE (HAVE_LIBUTIL_H)
CONFIG_DEFINE (HAVE_PTY_H)
CONFIG_DEFINE (HAVE_STROPTS_H)

CONFIG_DEFINE (HAVE_OPENPTY)
CONFIG_DEFINE (HAVE_UNIX98_PTYS)
