# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** html advertising component, build here, mockup

** Author: Ralph Amissah
  <ralph@amissah.com>
  <ralph.amissah@gmail.com>

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see <http://www.gnu.org/licenses/>.

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  <http://www.fsf.org/licensing/licenses/gpl.html>
  <http://www.gnu.org/licenses/gpl.html>

  <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  <http://www.jus.uio.no/sisu>
  <http://www.sisudoc.org>

** Git
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/html_promo.rb;hb=HEAD>

=end
module SiSU_HTML_Promo
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  class Ad
    def initialize(md)
      @md=md
      @env=SiSU_Env::InfoEnv.new(@md.fns,@md)
      @rc=SiSU_Env::GetInit.new.sisu_yaml.rc
      @ad=SiSU_Env::GetInit.new.ads
      @flag=@env.widget.promo?
      @make=SiSU_Env::ProcessingSettings.new(@md)
    end
    def div
      def major
        (@make.build.html_right_pane? \
         && @flag[:ad]) \
        ? '<div id="pane_major">'
        : ''
      end
      def minor
        (@make.build.html_right_pane? \
         && @flag[:ad]) \
        ? '<div id="pane_minor">'
        : ''
      end
      def close
        (@make.build.html_right_pane? \
         && @flag[:ad]) \
        ? '</div>'
        : ''
      end
      self
    end
    def display
      ads_array,promo_array=[],[]
      if @make.build.html_right_pane? \
      && @flag[:ad]
        ads=if @md.promo && @md.promo.length > 0           #promo set in document
          promo_array=@md.promo
        elsif @flag[:rc]                                   #promo set in rc file
          promo_array=if @rc['html']['promo'].is_a?(String)
            @rc['html']['promo'].split(/[,;]\s*/)
          else @rc['html']['promo']
          end
        else advert_extract_all
        end
        ads=if promo_array.length > 0
          promo_array.each do |x|
            ads_array << advert_extract_subject(x)
          end
          ads_array
        end
        adverts(ads.join)
      end
    end
    def cell(prod,id)
      @prod,@id=prod,id
      def title
        @prod['title'] ? %{<b>#{@prod['title']}</b>} : ''
      end
      def subtitle
        @prod['subtitle'] ? %{ - #{@prod['subtitle']}} : ''
      end
      def author
        @prod['author'] ? %{<p class="pane">#{@prod['author']}</p>} : ''
      end
      def editor
        @prod['editor'] ? %{<p class="pane">#{@prod['editor']}</p>} : ''
      end
      def year
        @prod['year'] ? %{<p class="pane">#{@prod['year']}</p>} : ''
      end
      def date
        @prod['date'] ? %{<p class="pane">On: #{@prod['date']}</p>} : ''
      end
      def location
        @prod['at'] ? %{<p class="pane">At: #{@prod['at']}</p>} : ''
      end
      def pages
        @prod['pages'] ? %{<p class="pane">Pages: #{@prod['pages']} pages</p>} : ''
      end
      def form
        @prod['form'] ? %{<p class="pane">#{@prod['form']}</p>} : ''
      end
      def nick
        @prod['nick'] ? %{(#{@prod['nick']})<br>} : ''
      end
      def update
        @prod['update'] ? %{<p class="pane">Updated: #{@prod['update']}</p>} : ''
      end
      def issn
        @prod['issn'] ? %{<p class="pane">issn: #{@prod['issn']}</p>} : ''
      end
      def blurb
        @prod['blurb'] ? %{<p class="pane_blurb">#{@prod['blurb']}</p>} : ''
      end
      def search_form_sisu(table=true)
        db=if @prod['db']=~/\S+/
          (@prod['db']=~/^#{Db[:name_prefix]}\S+/) ? @prod['db'] : "#{Db[:name_prefix]}#{@prod['db']}"
        elsif defined? @rc['search']['sisu']['db'] \
        and @rc['search']['sisu']['db'] =~/\S+/
          (@rc['search']['sisu']['db']=~/^#{Db[:name_prefix]}\S+/) \
          ? @prod['search']['sisu']['db']
          : "#{Db[:name_prefix]}#{@prod['db']}"
        else nil
        end
        action=if @prod['action']=~/^https?:\/\//
          @prod['action']
        elsif defined? @rc['search']['sisu']['action'] \
        and @rc['search']['sisu']['action'] =~/^https?:\/\//
          @rc['search']['sisu']['action']
        else nil
        end
        if action \
        and db
          @env.widget.search_form('sisusearch',action,db,table)
        else ''
        end
      end
      def search_form_hyperestraier(table=true)
        action=if defined? @rc['search']['hyperestraier']['action'] \
        and @rc['search']['hyperestraier']['action'] =~/^https?:\/\//
          @rc['search']['hyperestraier']['action']
        else nil
        end
        form=if action
          '<br>' + @env.widget.search_form('hyperestraier',action,'',table)
        else ''
        end
        form
      end
      def links
        if @prod['links'] #and @prod['links']==Array
          links_a=[]
          @prod['links'].each do |x|
            if x \
            and x['url'] \
            and x['title']
              subtitle=x['subtitle'] ? %{ - #{x['subtitle']}} : ''
              url_=(x['url'] =~/https?:/) ? x['url'] : "../#{x['url']}"
              links_a << %{<p class="pane_link"><a href="#{url_}">#{x['title']}#{subtitle}</a></p>\n}
            end
          end
          links_a.join
        else ''
        end
      end
      def image
        @prod['image'] ? %{<img border="0" src="../_sisu/image/#{@prod['image']}" /><br>} : ''
      end
      def url_link
        @url_=if @prod['url'] =~/https?:/
          "#{@prod['url']}"
        else "../#{@prod['url']}" # "#{@env.url.root}/#{@prod['url']}"
        end
        def show
          @prod['url'] ? %{<p class="pane_link"><a href="#{@url_}">#{@url_}</a></p>} : ''
        end
        def url
          @prod['url'] ? %{<a href="#{@url_}">} : ''
        end
        def url_relative
          @prod['url'] ? %{<a href="../#{@prod['url']}/toc.html">} : ''
        end
        self
      end
      def flyer
        if @prod['flyer']
          %{<p class="pane"><a href="../man/pdf/#{@id}.pdf"><img border="0" height="18" width="15" src="../_sisu/image/b_pdf.png">&nbsp;PDF&nbsp;flyer</a></p>}
        else ''
        end
      end
      def price
        def gbp
          if defined? @prod['price']['gbp'] \
          and @prod['price']['gbp']
            " &nbsp;&pound;&nbsp;#{@prod['price']['gbp']}&nbsp;(GBP)&nbsp;"
          else ''
          end
        end
        def euro
          if defined? @prod['price']['euro'] \
          and @prod['price']['euro']
            " &nbsp;&euro;&nbsp;#{@prod['price']['euro']}&nbsp;(Euro)&nbsp;"
          else ''
          end
        end
        def usd
          if defined? @prod['price']['usd'] \
          and @prod['price']['usd']
            " &nbsp;$&nbsp;#{@prod['price']['usd']}&nbsp;(USD)&nbsp;"
          else ''
          end
        end
        %{<p class="pane">Price:#{gbp}#{euro}#{usd}</p>}
      end
      def adsense #draw content from a configuration file
        def column_right
          if defined? @ad[:promo]['ad']['adsense']['column_right']
            @ad[:promo]['ad']['adsense']['column_right'].join("\n")
          else ''
          end
        end
        def line_single
          if defined? @ad[:promo]['ad']['adsense']['line_single']
            @ad[:promo]['ad']['adsense']['line_single'].join("\n")
          else ''
          end
        end
        self
      end
      def site_link #Work area
        if url_link.url
           <<-WOK
<p class="pane">
#{url_link.url}
#{image}
#{title}
#{subtitle}
</a>#{nick}</p>
          WOK
        else
         <<-WOK
<p class="pane">
#{image}
#{title}
#{subtitle}
</p>
          WOK
        end
      end
      self
    end
    def output_form_sponsor(type,id)
      cell=cell(@ad[:promo][type][id],prod_id)
      <<-WOK
<br>
#{cell.site_link}
#{cell.blurb}
#{cell.links}
      WOK
    end
    def output_form_link(type,id)
      prod_id=id.gsub(/id_/,'')
      cell=cell(@ad[:promo][type][id],prod_id)
       <<WOK
<br>
#{cell.site_link}
#{cell.author}
#{cell.year}
#{cell.blurb}
#{cell.links}
WOK
    end
    def output_form_search_sisu(type,id)
      prod_id=id.gsub(/id_/,'')
      cell=cell(@ad[:promo][type][id],prod_id)
      cell.search_form_sisu(false)
    end
    def output_form_search_hyperestraier(type,id)
      prod_id=id.gsub(/id_/,'')
      cell=cell(@ad[:promo][type][id],prod_id)
      cell.search_form_hyperestraier(false)
    end
    def output_form_book(type,id)
      prod_id=id.gsub(/id_/,'')
      cell=cell(@ad[:promo][type][id],prod_id)
      prod_type=((id=~/id_(?:[0-9x]){10,13}/i) ? 'isbn' : 'id')
      id_detail=%{<p class="pane">#{prod_type}: #{prod_id}</p>}
       <<WOK
<br>
#{cell.site_link}
#{cell.author}
#{cell.year}
#{id_detail}
#{cell.pages}#{cell.form}
#{cell.price}
#{cell.flyer}
#{cell.blurb}
#{cell.links}
WOK
    end
    def output_form_journal(type,id)
      prod_id=id.gsub(/id_/,'')
      cell=cell(@ad[:promo][type][id],prod_id)
       <<WOK
<br>
#{cell.site_link}
#{cell.editor}
#{cell.issn}
#{cell.update}
#{cell.form}
#{cell.price.gsub(/Price:/,'Subscription:')}
#{cell.flyer}
#{cell.blurb}
#{cell.links}
WOK
    end
    def output_form_conference(type,id)
      prod_id=id.gsub(/id_/,'')
      cell=cell(@ad[:promo][type][id],prod_id)
#translate date (dd month yyyy) from 2007-03-04 and ruby conversion
       <<WOK
<br>
#{cell.site_link}
#{cell.date}
#{cell.location}
#{cell.price}
#{cell.flyer}
#{cell.blurb}
#{cell.links}
WOK
    end
    def output_form_select(type,id)
      case type
      when /site/
        output_form_link(type,id)
      when /sponsor/
        output_form_sponsor(type,id)
      when /search/
        if id=~/hyperestraier/
          output_form_search_hyperestraier(type,id)
        else output_form_search_sisu(type,id)
        end
      when /book/
        output_form_book(type,id)
      when /journal/
        output_form_journal(type,id)
      when /conference/
        output_form_conference(type,id)
      end
    end
    def advert_extract_subject(category) #extracts products from category/subject list
      adverts=[]
      if defined? @ad[:promo_list][category] \
      and @ad[:promo_list][category]
        @ad[:promo_list][category].keys.each do |type|
          @ad[:promo_list][category][type].each do |i|
            if i
              id=((i.inspect =~/^\d/) ? "id_#{i.to_s.strip}" : i.to_s.strip) #watch remove .to_s ?
              if defined? @ad[:promo][type][id] \
              and not @ad[:promo][type][id].nil?
                adverts << output_form_select(type,id)
              else
                if defined? @ad[:promo][category][type][id] \
                and @ad[:promo][category][type][id].is_a?(Array) \
                and @ad[:promo][category][type][id].length > 0
                  adverts << @ad[:promo][category][type][id].join("\n")
                end
              end
            end
          end
        end
      else
        SiSU_Screen::Ansi.new(
          @md.opt.act[:color_state][:set],
          "*WARN* category not found: #{category}"
        ).warn unless @md.opt.act[:quiet][:set]==:on
      end
      adverts.join
    end
    def advert_extract_all #extracts all products from list (which is broken down into categories)
      adverts=[]
      @ad[:promo_list].keys.each do |category|
        adverts << advert_extract_subject(category)
      end
      adverts.flatten
    end
    def adverts(ads)
      <<WOK
#{div.minor}
#{ads}
#{div.close}
WOK
    end
    def no_adverts
      <<WOK
#{div.minor}
#{div.close}
WOK
    end
  end
end
__END__
