#include "common.h"
#include "defines.h"

#define DQT0 0 // �ʎq���e�[�u���ԍ��F�O
#define DQT1 1 // �ʎq���e�[�u���ԍ��F�P
#define DQT2 2 // �ʎq���e�[�u���ԍ��F�Q
#define DQT3 3 // �ʎq���e�[�u���ԍ��F�R
#define DQT4 4 // �ʎq���e�[�u���ԍ��F�S
#define DQT5 5 // �ʎq���e�[�u���ԍ��F�T
#define DQT6 6 // �ʎq���e�[�u���ԍ��F�U
#define DQT7 7 // �ʎq���e�[�u���ԍ��F�V

#define DHTDC1 1 // DC�n�t�}���e�[�u���ԍ��F�P
#define DHTAC1 1 // AC�n�t�}���e�[�u���ԍ��F�P
#define DHTAC2 2 // AC�n�t�}���e�[�u���ԍ��F�Q

namespace hinode
{
    const unsigned char DQT_Pattern0[128] = // �ʎq���e�[�u����`�O
        {
            0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
            0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
            0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
            0x00, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
            0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03,
            0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03,
            0x00, 0x03, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x04, 0x00, 0x05,
            0x00, 0x05, 0x00, 0x04, 0x00, 0x04, 0x00, 0x05, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04};

    const unsigned char DQT_Pattern1[128] = // �ʎq���e�[�u����`�P
        {
            0x00, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03,
            0x00, 0x03, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04, 0x00, 0x06,
            0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x06, 0x00, 0x0A, 0x00, 0x09, 0x00, 0x08,
            0x00, 0x06, 0x00, 0x08, 0x00, 0x09, 0x00, 0x0A, 0x00, 0x0D, 0x00, 0x0C, 0x00, 0x0B, 0x00, 0x0B,
            0x00, 0x0B, 0x00, 0x0B, 0x00, 0x0C, 0x00, 0x0D, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0E,
            0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x11, 0x00, 0x13, 0x00, 0x13, 0x00, 0x11,
            0x00, 0x0F, 0x00, 0x10, 0x00, 0x15, 0x00, 0x15, 0x00, 0x15, 0x00, 0x10, 0x00, 0x13, 0x00, 0x17,
            0x00, 0x17, 0x00, 0x13, 0x00, 0x13, 0x00, 0x18, 0x00, 0x13, 0x00, 0x14, 0x00, 0x14, 0x00, 0x14};

    const unsigned char DQT_Pattern2[128] = // �ʎq���e�[�u����`�Q
        {
            0x00, 0x08, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x08, 0x00, 0x07,
            0x00, 0x07, 0x00, 0x08, 0x00, 0x0B, 0x00, 0x09, 0x00, 0x08, 0x00, 0x09, 0x00, 0x0B, 0x00, 0x10,
            0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x10, 0x00, 0x19, 0x00, 0x17, 0x00, 0x13,
            0x00, 0x0F, 0x00, 0x13, 0x00, 0x17, 0x00, 0x19, 0x00, 0x21, 0x00, 0x1F, 0x00, 0x1C, 0x00, 0x1B,
            0x00, 0x1B, 0x00, 0x1C, 0x00, 0x1F, 0x00, 0x21, 0x00, 0x25, 0x00, 0x25, 0x00, 0x26, 0x00, 0x22,
            0x00, 0x26, 0x00, 0x25, 0x00, 0x25, 0x00, 0x26, 0x00, 0x2A, 0x00, 0x30, 0x00, 0x30, 0x00, 0x2A,
            0x00, 0x26, 0x00, 0x28, 0x00, 0x34, 0x00, 0x34, 0x00, 0x34, 0x00, 0x28, 0x00, 0x2F, 0x00, 0x3B,
            0x00, 0x3B, 0x00, 0x2F, 0x00, 0x30, 0x00, 0x3C, 0x00, 0x30, 0x00, 0x33, 0x00, 0x33, 0x00, 0x32};

    const unsigned char DQT_Pattern3[128] = // �ʎq���e�[�u����`�R
        {
            0x00, 0x10, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0F, 0x00, 0x0E,
            0x00, 0x0E, 0x00, 0x0F, 0x00, 0x15, 0x00, 0x12, 0x00, 0x10, 0x00, 0x12, 0x00, 0x15, 0x00, 0x20,
            0x00, 0x18, 0x00, 0x17, 0x00, 0x17, 0x00, 0x18, 0x00, 0x20, 0x00, 0x32, 0x00, 0x2E, 0x00, 0x26,
            0x00, 0x1D, 0x00, 0x26, 0x00, 0x2E, 0x00, 0x32, 0x00, 0x42, 0x00, 0x3E, 0x00, 0x38, 0x00, 0x36,
            0x00, 0x36, 0x00, 0x38, 0x00, 0x3E, 0x00, 0x42, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4C, 0x00, 0x44,
            0x00, 0x4C, 0x00, 0x4A, 0x00, 0x4A, 0x00, 0x4C, 0x00, 0x54, 0x00, 0x5F, 0x00, 0x5F, 0x00, 0x54,
            0x00, 0x4C, 0x00, 0x50, 0x00, 0x67, 0x00, 0x68, 0x00, 0x67, 0x00, 0x50, 0x00, 0x5E, 0x00, 0x75,
            0x00, 0x75, 0x00, 0x5E, 0x00, 0x60, 0x00, 0x78, 0x00, 0x60, 0x00, 0x66, 0x00, 0x66, 0x00, 0x63};

    const unsigned char DQT_Pattern4[128] = // �ʎq���e�[�u����`�S
        {
            0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01,
            0x00, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x03,
            0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x03, 0x00, 0x05, 0x00, 0x05, 0x00, 0x04,
            0x00, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00, 0x05, 0x00, 0x07, 0x00, 0x06, 0x00, 0x06, 0x00, 0x05,
            0x00, 0x05, 0x00, 0x06, 0x00, 0x06, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x08, 0x00, 0x07,
            0x00, 0x08, 0x00, 0x07, 0x00, 0x07, 0x00, 0x08, 0x00, 0x08, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x08,
            0x00, 0x08, 0x00, 0x08, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x08, 0x00, 0x09, 0x00, 0x0C,
            0x00, 0x0C, 0x00, 0x09, 0x00, 0x0A, 0x00, 0x0C, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0A};

    const unsigned char DQT_Pattern5[128] = // �ʎq���e�[�u����`�T
        {

            0x00, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
            0x00, 0x02, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x05,
            0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x05, 0x00, 0x08, 0x00, 0x07, 0x00, 0x06,
            0x00, 0x05, 0x00, 0x06, 0x00, 0x07, 0x00, 0x08, 0x00, 0x0B, 0x00, 0x0A, 0x00, 0x09, 0x00, 0x09,
            0x00, 0x09, 0x00, 0x09, 0x00, 0x0A, 0x00, 0x0B, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0B,
            0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0D, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x0D,
            0x00, 0x0C, 0x00, 0x0D, 0x00, 0x10, 0x00, 0x11, 0x00, 0x10, 0x00, 0x0D, 0x00, 0x0F, 0x00, 0x13,
            0x00, 0x13, 0x00, 0x0F, 0x00, 0x0F, 0x00, 0x13, 0x00, 0x0F, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10};

    const unsigned char DQT_Pattern6[128] = // �ʎq���e�[�u����`�U
        {
            0x00, 0x05, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x05, 0x00, 0x04,
            0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x06, 0x00, 0x0A,
            0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x0A, 0x00, 0x0F, 0x00, 0x0E, 0x00, 0x0B,
            0x00, 0x09, 0x00, 0x0B, 0x00, 0x0E, 0x00, 0x0F, 0x00, 0x14, 0x00, 0x13, 0x00, 0x11, 0x00, 0x10,
            0x00, 0x10, 0x00, 0x11, 0x00, 0x13, 0x00, 0x14, 0x00, 0x16, 0x00, 0x16, 0x00, 0x17, 0x00, 0x14,
            0x00, 0x17, 0x00, 0x16, 0x00, 0x16, 0x00, 0x17, 0x00, 0x19, 0x00, 0x1D, 0x00, 0x1D, 0x00, 0x19,
            0x00, 0x17, 0x00, 0x18, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x18, 0x00, 0x1C, 0x00, 0x23,
            0x00, 0x23, 0x00, 0x1C, 0x00, 0x1D, 0x00, 0x24, 0x00, 0x1D, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x1E};

    const unsigned char DQT_Pattern7[128] = // �ʎq���e�[�u����`�V
        {
            0x00, 0x0B, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x0B, 0x00, 0x0A,
            0x00, 0x0A, 0x00, 0x0B, 0x00, 0x0F, 0x00, 0x0D, 0x00, 0x0B, 0x00, 0x0D, 0x00, 0x0F, 0x00, 0x16,
            0x00, 0x11, 0x00, 0x10, 0x00, 0x10, 0x00, 0x11, 0x00, 0x16, 0x00, 0x23, 0x00, 0x20, 0x00, 0x1B,
            0x00, 0x14, 0x00, 0x1B, 0x00, 0x20, 0x00, 0x23, 0x00, 0x2E, 0x00, 0x2B, 0x00, 0x27, 0x00, 0x26,
            0x00, 0x26, 0x00, 0x27, 0x00, 0x2B, 0x00, 0x2E, 0x00, 0x34, 0x00, 0x34, 0x00, 0x35, 0x00, 0x30,
            0x00, 0x35, 0x00, 0x34, 0x00, 0x34, 0x00, 0x35, 0x00, 0x3B, 0x00, 0x43, 0x00, 0x43, 0x00, 0x3B,
            0x00, 0x35, 0x00, 0x38, 0x00, 0x48, 0x00, 0x49, 0x00, 0x48, 0x00, 0x38, 0x00, 0x42, 0x00, 0x52,
            0x00, 0x52, 0x00, 0x42, 0x00, 0x43, 0x00, 0x54, 0x00, 0x43, 0x00, 0x47, 0x00, 0x47, 0x00, 0x45};

    const unsigned char DHTDC_Pattern[32] = // �n�t�}���e�[�u����`�i�c�b�����jNo.0
        {
            0x00, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F};

    const unsigned char DHTAC_Pattern1[258] = // �n�t�}���e�[�u����`�i�`�b�����jNo.1
        {
            0x00, 0x02, 0x01, 0x02, 0x04, 0x03, 0x06, 0x03, 0x04, 0x07, 0x02, 0x03, 0x00, 0x00, 0x02, 0xCB,
            0x01, 0x02, 0x03, 0x04, 0x11, 0x00, 0x05, 0x06, 0x21, 0x07, 0x12, 0x31, 0x08, 0x13, 0x22, 0x41,
            0x51, 0x61, 0x09, 0x71, 0x81, 0x14, 0x32, 0x91, 0xA1, 0x0A, 0x15, 0x23, 0x42, 0xB1, 0xC1, 0xF0,
            0xD1, 0xE1, 0x16, 0x24, 0x33, 0x52, 0x72, 0xF1, 0x17, 0x43, 0x62, 0x82, 0x92, 0xA2, 0xB2, 0x18,
            0x19, 0x25, 0x34, 0x53, 0x54, 0x73, 0x83, 0x93, 0x26, 0x27, 0x36, 0x44, 0x55, 0x63, 0xC2, 0xD2,
            0x35, 0x45, 0x64, 0x76, 0x84, 0x94, 0xA3, 0xB3, 0x29, 0x65, 0x74, 0xD3, 0xE2, 0x0B, 0x0C, 0x0D,
            0x0E, 0x0F, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x28, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x37,
            0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D,
            0x4E, 0x4F, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x66, 0x67, 0x68, 0x69,
            0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x75, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
            0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x95, 0x96, 0x97, 0x98, 0x99,
            0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD,
            0xAE, 0xAF, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC3, 0xC4,
            0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8,
            0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB,
            0xEC, 0xED, 0xEE, 0xEF, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD,
            0xFE, 0xFF};

    const unsigned char DHTAC_Pattern2[258] = // �n�t�}���e�[�u����`�i�`�b�����jNo.2
        {
            0x00, 0x01, 0x02, 0x04, 0x03, 0x02, 0x07, 0x05, 0x07, 0x08, 0x09, 0x09, 0xB9, 0x00, 0x00, 0x00,
            0x01, 0x02, 0x11, 0x00, 0x03, 0x04, 0x21, 0x05, 0x12, 0x31, 0x22, 0x41, 0x06, 0x13, 0x51, 0x61,
            0x71, 0x81, 0x91, 0x14, 0x32, 0xA1, 0xB1, 0xF0, 0x07, 0x23, 0x42, 0x72, 0x92, 0x93, 0xC1, 0x15,
            0x52, 0x62, 0x82, 0xA2, 0xB2, 0xD1, 0xE1, 0x16, 0x24, 0x33, 0x43, 0x44, 0x53, 0x83, 0xA3, 0xF1,
            0x08, 0x17, 0x26, 0x34, 0x54, 0x63, 0x73, 0x84, 0xB3, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
            0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x25, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
            0x2E, 0x2F, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x45, 0x46, 0x47,
            0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C,
            0x5D, 0x5E, 0x5F, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x74,
            0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x85, 0x86, 0x87, 0x88, 0x89,
            0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D,
            0x9E, 0x9F, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xB4, 0xB5,
            0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
            0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9,
            0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB,
            0xEC, 0xED, 0xEE, 0xEF, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD,
            0xFE, 0xFF};

    void HinodeDepacketizer::insert_dct_header()
    {
        unsigned char *start = &buffer[0];
        unsigned char *p = start, tmp = 0;
        int i;

        *p++ = 0xFF; // SOI�Z�O�����g
        *p++ = 0xD8;
        *p++ = 0xFF; // DQT�Z�O�����g
        *p++ = 0xDB;
        *p++ = 0x00;
        *p++ = 0x83;
        switch (sci_hdr.QTNo)
        {
        case DQT0:
            tmp = 0x10;
            break;
        case DQT1:
            tmp = 0x11;
            break;
        case DQT2:
            tmp = 0x12;
            break;
        case DQT3:
            tmp = 0x13;
            break;
        case DQT4:
            tmp = 0x14;
            break;
        case DQT5:
            tmp = 0x15;
            break;
        case DQT6:
            tmp = 0x16;
            break;
        case DQT7:
            tmp = 0x17;
        }
        *p++ = tmp;
        for (i = 0; i < 128; i++)
        {
            switch (sci_hdr.QTNo)
            {
            case DQT0:
                tmp = DQT_Pattern0[i];
                break;
            case DQT1:
                tmp = DQT_Pattern1[i];
                break;
            case DQT2:
                tmp = DQT_Pattern2[i];
                break;
            case DQT3:
                tmp = DQT_Pattern3[i];
                break;
            case DQT4:
                tmp = DQT_Pattern4[i];
                break;
            case DQT5:
                tmp = DQT_Pattern5[i];
                break;
            case DQT6:
                tmp = DQT_Pattern6[i];
                break;
            case DQT7:
                tmp = DQT_Pattern7[i];
            }
            *p++ = tmp;
        }
        *p++ = 0xFF; // DRI�Z�O�����g
        *p++ = 0xDD;
        *p++ = 0x00;
        *p++ = 0x04;
        *p++ = 0x00;
        *p++ = 0x40;
        *p++ = 0xFF; // SOF�Z�O�����g
        *p++ = 0xC1;
        *p++ = 0x00; // SOF_SIZE
        *p++ = 0x0B;
        *p++ = 0x0C;                                 // ������
        *p++ = (sci_hdr.PartImageSizeY >> 8) & 0xFF; // ImageSizeX
        *p++ = sci_hdr.PartImageSizeY & 0xFF;        // ImageSizeX
        *p++ = (sci_hdr.PartImageSizeX >> 8) & 0xFF; // ImageSizeY
        *p++ = sci_hdr.PartImageSizeX & 0xFF;        // ImageSizeY
        *p++ = 0x01;                                 // ������
        *p++ = 0x01;                                 // ����ID
        *p++ = 0x11;                                 // �����E�����T���v�����O�l
        *p++ = sci_hdr.QTNo;                         // �ʎq���e�[�u���ԍ�
        *p++ = 0xFF;                                 // DHT�Z�O�����g
        *p++ = 0xC4;
        *p++ = 0x01; // DHT_SIZE
        *p++ = 0x26;
        *p++ = 0x01;
        for (i = 0; i < 32; i++)
        {
            *p++ = DHTDC_Pattern[i];
        }
        switch (sci_hdr.HTACNo)
        {
        case DHTAC1:
            tmp = 0x11;
            break;
        case DHTAC2:
            tmp = 0x12;
        }
        *p++ = tmp;
        for (i = 0; i < 258; i++)
        {
            switch (sci_hdr.HTACNo)
            {
            case DHTAC1:
                tmp = DHTAC_Pattern1[i];
                break;
            case DHTAC2:
                tmp = DHTAC_Pattern2[i];
                break;
            }
            *p++ = tmp;
        }
        *p++ = 0xFF; // SOS�Z�O�����g
        *p++ = 0xDA;
        *p++ = 0x00; // SOS_SIZE
        *p++ = 0x08;
        *p++ = 0x01;                                     // ������
        *p++ = 0x01;                                     // ����ID
        *p++ = (sci_hdr.HTDCNo << 4) | (sci_hdr.HTACNo); // DC�����n�t�}���e�[�u���ԍ�
        *p++ = 0x00;                                     // �ʎq���W���J�n�ԍ�
        *p++ = 0x3F;                                     // �ʎq���W���I���ԍ�
        *p++ = 0x00;                                     // ��ʂS�r�b�g�F�O��̃X�L�����̌W���l�����V�t�g�ʁi�ŏ��̃X�L�����͂O�j
        // ���ʂS�r�b�g�F�W���l�����V�t�g��
        buff_pos = p - start; // �o�b�t�@���͈ʒu
    }

    void HinodeDepacketizer::insert_dpcm_header()
    {
        const int restart_pixel = sci_hdr.restart_pixel;

        unsigned char *start = &buffer[0];
        unsigned char *p = start;
        int i;

        *p++ = 0xFF; // SOI�Z�O�����g
        *p++ = 0xD8;
        *p++ = 0xFF; // DRI�Z�O�����g
        *p++ = 0xDD;
        *p++ = 0x00;
        *p++ = 0x04;
        *p++ = (restart_pixel >> 8) & 0xFF;
        *p++ = restart_pixel & 0xFF;
        *p++ = 0xFF; // SOF�Z�O�����g�i���X���X�����j
        *p++ = 0xC3;
        *p++ = 0x00; // �Z�O�����g��
        *p++ = 0x0B;
        *p++ = 0x0C;                                 // ������
        *p++ = (sci_hdr.PartImageSizeY >> 8) & 0xFF; // ImageSizeY
        *p++ = sci_hdr.PartImageSizeY & 0xFF;        // ImageSizeY
        *p++ = (sci_hdr.PartImageSizeX >> 8) & 0xFF; // ImageSizeX
        *p++ = sci_hdr.PartImageSizeX & 0xFF;        // ImageSizeX
        *p++ = 0x01;                                 // ������
        *p++ = 0x01;                                 // ����ID
        *p++ = 0x11;                                 // �����E�����T���v�����O�l
        *p++ = sci_hdr.QTNo;                         // �ʎq���e�[�u���ԍ�
        *p++ = 0xFF;                                 // DHT�Z�O�����g
        *p++ = 0xC4;
        *p++ = 0x00; // �Z�O�����g��
        *p++ = 0x23;
        *p++ = 0x01;
        for (i = 0; i < 32; i++)
        { // DC�����n�t�}���e�[�u������
            *p++ = DHTDC_Pattern[i];
        }
        *p++ = 0xFF; // SOS�Z�O�����g
        *p++ = 0xDA;
        *p++ = 0x00;
        *p++ = 0x08;
        *p++ = 0x01; // ������
        *p++ = 0x01; // ����ID
        *p++ = 0x10; // DC�����n�t�}���e�[�u���ԍ�
        *p++ = 0x01; // �ʎq���W���J�n�ԍ�
        *p++ = 0x00; // �ʎq���W���I���ԍ�
        *p++ = 0x00; // ��ʂS�r�b�g�F�O��̃X�L�����̌W���l�����V�t�g�ʁi�ŏ��̃X�L�����͂O�j
        // ���ʂS�r�b�g�F�W���l�����V�t�g��
        buff_pos = p - start; // �o�b�t�@���͈ʒu
    }
}