/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : SnapDlg.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/20
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __SNAPDLG_H__
#define __SNAPDLG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

/* 
 *	  図形要素	 1 : 点
 *				 2 : 線
 *				 4 : 円弧
 *				 8 : 円
 *				15 : 全図形
 *	
 *	  寸法図形	16 : 始点・終点
 *				32 : 四半点
 *				64 : 中心点
 *			   128 : 任意点 (optional point)
 *			   256 : 寸法図形
 *			   512 : ポリライン
 *			  1024 : ブロック
 * 			  2048 : 楕円 (ellipse)
 */
struct _SNAP_DLG
{
	gint value;		// ok/1   cancel/0   chain/2   chain2/4   color/8
	gint mask;		// 設定できるものを入れておく (3 なら点と線しか操作できない)
	gint snap;

	GtkWidget *point_check_button;
	GtkWidget *line_check_button;
	GtkWidget *arc_check_button;
	GtkWidget *circle_check_button;

	GtkWidget *polyline_check_button;
	GtkWidget *dimension_check_button;
	GtkWidget *block_check_button;
	GtkWidget *ellipse_check_button;

	GtkWidget *start_end_check_button;
	GtkWidget *half_4_point_check_button;
	GtkWidget *center_check_button;
	GtkWidget *any_check_button;

	GtkWidget *chain_check_button;
	GtkWidget *chain2_check_button;
	GtkWidget *color_check_button;

	GtkWidget *parent;
	GtkWidget *dialog;
};
typedef struct _SNAP_DLG SNAP_DLG;



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _SNAPDLG_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _SNAPDLG_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
gint SnapDialog(SNAP_DLG *snap_dlg);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __SNAPDLG_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : SnapDlg.h
 * ====================================================================
 */
